/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.spawns;

import com.google.common.collect.EvictingQueue;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.marketplace.MarketplaceManager;
import com.twitchliveloadout.marketplace.MarketplaceRandomizers;
import com.twitchliveloadout.marketplace.products.EbsModelPlacement;
import com.twitchliveloadout.marketplace.products.EbsRandomRange;
import com.twitchliveloadout.marketplace.spawns.SpawnPoint;
import com.twitchliveloadout.marketplace.spawns.SpawnedObject;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.runelite.api.Client;
import net.runelite.api.CollisionData;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Scene;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpawnManager {
    private static final Logger log = LoggerFactory.getLogger(SpawnManager.class);
    private final TwitchLiveLoadoutPlugin plugin;
    private final Client client;
    private final ConcurrentHashMap<WorldPoint, CopyOnWriteArrayList<SpawnedObject>> objectPlacements = new ConcurrentHashMap();
    private EvictingQueue<WorldPoint> playerLocationHistory = EvictingQueue.create((int)10);

    public SpawnManager(TwitchLiveLoadoutPlugin plugin, Client client) {
        this.plugin = plugin;
        this.client = client;
    }

    public void respawnRequested() {
        ArrayList respawnQueue = new ArrayList();
        this.handleAllSpawnedObjects(spawnedObject -> {
            if (spawnedObject.isRespawnRequired() && spawnedObject.isInRegion()) {
                respawnQueue.add(spawnedObject);
                spawnedObject.setRespawnRequired(false);
            }
        });
        if (respawnQueue.size() <= 0) {
            return;
        }
        this.plugin.runOnClientThread(() -> {
            for (SpawnedObject spawnedObject : respawnQueue) {
                spawnedObject.respawn();
            }
        });
    }

    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState newGameState = gameStateChanged.getGameState();
        if (newGameState == GameState.LOADING) {
            this.registerDespawn();
        }
    }

    private void registerDespawn() {
        this.handleAllSpawnedObjects(spawnedObject -> spawnedObject.setRespawnRequired(true));
    }

    public void recordPlayerLocation() {
        LocalPoint currentLocalPoint = this.client.getLocalPlayer().getLocalLocation();
        WorldPoint currentWorldPoint = WorldPoint.fromLocal((Client)this.client, (LocalPoint)currentLocalPoint);
        if (currentWorldPoint.equals((Object)this.getCurrentPlayerLocation())) {
            return;
        }
        this.playerLocationHistory.add((Object)currentWorldPoint);
    }

    public WorldPoint getCurrentPlayerLocation() {
        return this.getPlayerLocationByHistoryOffset(0);
    }

    public WorldPoint getPreviousPlayerLocation() {
        return this.getPlayerLocationByHistoryOffset(1);
    }

    private WorldPoint getPlayerLocationByHistoryOffset(int offset) {
        int size = this.playerLocationHistory.size();
        int requestedIndex = size - 1 - offset;
        if (requestedIndex < 0 || requestedIndex >= size) {
            return null;
        }
        WorldPoint requestedWorldPoint = ((WorldPoint[])this.playerLocationHistory.toArray((Object[])new WorldPoint[size]))[requestedIndex];
        return requestedWorldPoint;
    }

    public void registerSpawnedObjectPlacement(SpawnedObject spawnedObject) {
        WorldPoint worldPoint = spawnedObject.getSpawnPoint().getWorldPoint();
        if (this.objectPlacements.containsKey(worldPoint)) {
            CopyOnWriteArrayList<SpawnedObject> existingObjects = this.objectPlacements.get(worldPoint);
            existingObjects.add(spawnedObject);
        } else {
            CopyOnWriteArrayList<SpawnedObject> existingObjects = new CopyOnWriteArrayList<SpawnedObject>();
            existingObjects.add(spawnedObject);
            this.objectPlacements.put(worldPoint, existingObjects);
        }
    }

    public void deregisterSpawnedObjectPlacement(SpawnedObject spawnedObject) {
        WorldPoint worldPoint = spawnedObject.getSpawnPoint().getWorldPoint();
        if (!this.objectPlacements.containsKey(worldPoint)) {
            return;
        }
        CopyOnWriteArrayList<SpawnedObject> existingObjects = this.objectPlacements.get(worldPoint);
        existingObjects.remove(spawnedObject);
        if (existingObjects.size() <= 0) {
            this.objectPlacements.remove(worldPoint);
        }
    }

    public void moveSpawnedObject(SpawnedObject spawnedObject, SpawnPoint newSpawnPoint) {
        SpawnPoint previousSpawnPoint = spawnedObject.getSpawnPoint();
        if (previousSpawnPoint.getWorldPoint().equals((Object)newSpawnPoint.getWorldPoint())) {
            return;
        }
        this.deregisterSpawnedObjectPlacement(spawnedObject);
        spawnedObject.setSpawnPoint(newSpawnPoint);
        this.registerSpawnedObjectPlacement(spawnedObject);
        spawnedObject.respawn();
    }

    public void handleAllSpawnedObjects(MarketplaceManager.SpawnedObjectHandler handler) {
        for (CopyOnWriteArrayList<SpawnedObject> spawnedObjects : this.objectPlacements.values()) {
            for (SpawnedObject spawnedObject : spawnedObjects) {
                handler.execute(spawnedObject);
            }
        }
    }

    public SpawnPoint getOutwardSpawnPoint(int minRadius, int maxRadius, int radiusStepSize, boolean inLineOfSight, boolean avoidExistingSpawns, boolean avoidPlayerLocation, boolean avoidInvalidOverlay, WorldPoint referenceWorldPoint) {
        for (int radius = minRadius; radius <= maxRadius; ++radius) {
            int randomizedRadius = radius + (int)Math.round(Math.random() * (double)radiusStepSize);
            int usedRadius = Math.min(randomizedRadius, maxRadius);
            SpawnPoint candidateSpawnPoint = this.getSpawnPoint(usedRadius, usedRadius, inLineOfSight, avoidExistingSpawns, avoidPlayerLocation, avoidInvalidOverlay, referenceWorldPoint);
            if (candidateSpawnPoint == null) continue;
            return candidateSpawnPoint;
        }
        return null;
    }

    public SpawnPoint getSpawnPoint(EbsModelPlacement placement, WorldPoint modelWorldPoint) {
        EbsRandomRange radiusRange;
        if (placement == null) {
            placement = new EbsModelPlacement();
        }
        int minRadius = (int)((radiusRange = placement.radiusRange) == null ? 1.0 : radiusRange.min);
        int maxRadius = (int)MarketplaceRandomizers.getValidRandomNumberByRange(radiusRange, 1.0, 15.0, 0.0, 64.0);
        int radiusStepSize = placement.radiusStepSize;
        String radiusType = placement.radiusType;
        String locationType = placement.locationType;
        Boolean inLineOfSight = placement.inLineOfSight;
        Boolean avoidExistingSpawns = placement.avoidExistingSpawns;
        Boolean avoidPlayerLocation = placement.avoidPlayerLocation;
        Boolean avoidInvalidOverlay = placement.avoidInvalidOverlay;
        WorldPoint referenceWorldPoint = this.client.getLocalPlayer().getWorldLocation();
        if ("previous-tile".equals(locationType) && (referenceWorldPoint = this.getPreviousPlayerLocation()) == null) {
            return null;
        }
        if ("model-tile".equals(locationType) && modelWorldPoint != null) {
            referenceWorldPoint = modelWorldPoint;
        }
        if ("no-radius".equals(radiusType)) {
            return new SpawnPoint(referenceWorldPoint);
        }
        if ("outward-radius".equals(radiusType)) {
            return this.getOutwardSpawnPoint(minRadius, maxRadius, radiusStepSize, inLineOfSight, avoidExistingSpawns, avoidPlayerLocation, avoidInvalidOverlay, referenceWorldPoint);
        }
        return this.getSpawnPoint(minRadius, maxRadius, inLineOfSight, avoidExistingSpawns, avoidPlayerLocation, avoidInvalidOverlay, referenceWorldPoint);
    }

    public SpawnPoint getSpawnPoint(int minRadius, int maxRadius, boolean inLineOfSight, boolean avoidExistingSpawns, boolean avoidPlayerLocation, boolean avoidInvalidOverlay, WorldPoint referenceWorldPoint) {
        LocalPoint referenceLocalPoint;
        ArrayList<SpawnPoint> candidateSpawnPoints = new ArrayList<SpawnPoint>();
        int[][] collisionFlags = this.getSceneCollisionFlags();
        Player player = this.client.getLocalPlayer();
        WorldArea playerArea = player.getWorldArea();
        WorldPoint playerWorldPoint = player.getWorldLocation();
        if (referenceWorldPoint == null) {
            referenceWorldPoint = playerWorldPoint;
        }
        if (maxRadius < minRadius) {
            maxRadius = minRadius;
        }
        if ((referenceLocalPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)referenceWorldPoint)) == null) {
            referenceLocalPoint = this.client.getLocalPlayer().getLocalLocation();
        }
        int plane = referenceWorldPoint.getPlane();
        Scene scene = this.client.getScene();
        short[][][] overlayIds = scene.getOverlayIds();
        short[][][] underlayIds = scene.getUnderlayIds();
        int sceneX = referenceLocalPoint.getSceneX();
        int sceneY = referenceLocalPoint.getSceneY();
        for (int deltaX = -1 * maxRadius; deltaX <= maxRadius; ++deltaX) {
            for (int deltaY = -1 * maxRadius; deltaY <= maxRadius; ++deltaY) {
                boolean isBlackOnMinimap;
                int sceneAttemptX = sceneX + deltaX;
                int sceneAttemptY = sceneY + deltaY;
                double deltaDiagonal = Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0));
                if (Math.abs(deltaX) < minRadius && Math.abs(deltaY) < minRadius && deltaDiagonal < (double)minRadius || sceneAttemptX < 0 || sceneAttemptX >= collisionFlags.length || sceneAttemptY < 0 || sceneAttemptY >= collisionFlags[sceneAttemptX].length) continue;
                int flagData = collisionFlags[sceneAttemptX][sceneAttemptY];
                int blockedFlags = 2359552;
                boolean isWalkable = (flagData & blockedFlags) == 0;
                int underlayOverlayIdOffset = 40;
                int underlayOverlayAttemptX = sceneAttemptX + underlayOverlayIdOffset;
                int underlayOverlayAttemptY = sceneAttemptY + underlayOverlayIdOffset;
                short underlayId = underlayIds[plane][underlayOverlayAttemptX][underlayOverlayAttemptY];
                short overlayId = overlayIds[plane][underlayOverlayAttemptX][underlayOverlayAttemptY];
                boolean bl = isBlackOnMinimap = avoidInvalidOverlay && underlayId == 0 && overlayId == 0;
                if (!isWalkable || isBlackOnMinimap) continue;
                LocalPoint localPoint = LocalPoint.fromScene((int)sceneAttemptX, (int)sceneAttemptY);
                WorldPoint worldPoint = WorldPoint.fromLocal((Client)this.client, (LocalPoint)localPoint);
                if (avoidExistingSpawns && this.objectPlacements.containsKey(worldPoint) || avoidPlayerLocation && worldPoint.equals((Object)playerWorldPoint) || inLineOfSight && !playerArea.hasLineOfSightTo(this.client, worldPoint)) continue;
                candidateSpawnPoints.add(new SpawnPoint(worldPoint));
            }
        }
        if (candidateSpawnPoints.size() <= 0) {
            return null;
        }
        Random spawnPointSelector = new Random();
        int spawnPointIndex = spawnPointSelector.nextInt(candidateSpawnPoints.size());
        SpawnPoint spawnPoint = (SpawnPoint)candidateSpawnPoints.get(spawnPointIndex);
        return spawnPoint;
    }

    private int[][] getSceneCollisionFlags() {
        CollisionData[] collisionMaps = this.client.getCollisionMaps();
        int[][] collisionFlags = new int[104][104];
        if (collisionMaps != null) {
            collisionFlags = collisionMaps[this.client.getPlane()].getFlags();
        }
        return collisionFlags;
    }
}

