/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.spawns;

import com.twitchliveloadout.marketplace.MarketplaceColors;
import com.twitchliveloadout.marketplace.MarketplaceEffect;
import com.twitchliveloadout.marketplace.MarketplaceMessages;
import com.twitchliveloadout.marketplace.products.EbsModelOverheadFrame;
import com.twitchliveloadout.marketplace.products.MarketplaceProduct;
import com.twitchliveloadout.marketplace.spawns.SpawnedObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.concurrent.CopyOnWriteArrayList;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverheadTextOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(OverheadTextOverlay.class);
    private final Client client;
    private final CopyOnWriteArrayList<MarketplaceEffect<EbsModelOverheadFrame>> activeEffects = new CopyOnWriteArrayList();

    public OverheadTextOverlay(Client client) {
        this.client = client;
        this.setMovable(false);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Dimension render(Graphics2D graphics) {
        for (MarketplaceEffect<EbsModelOverheadFrame> effect : this.activeEffects) {
            EbsModelOverheadFrame frame = effect.getFrame();
            String text = frame.text;
            Integer textHeight = frame.textHeight;
            Integer textColorHex = frame.textColorHex;
            SpawnedObject spawnedObject = effect.getSpawnedObject();
            MarketplaceProduct marketplaceProduct = effect.getMarketplaceProduct();
            if (!effect.isActive() || text == null || text.isEmpty() || textHeight == null || textColorHex == null || spawnedObject == null) continue;
            String formattedText = MarketplaceMessages.formatMessage(text, marketplaceProduct, effect);
            LocalPoint localPoint = spawnedObject.getSpawnPoint().getLocalPoint(this.client);
            if (localPoint == null) continue;
            Point textLocation = Perspective.localToCanvas((Client)this.client, (LocalPoint)localPoint, (int)this.client.getPlane(), (int)textHeight);
            Color textColor = MarketplaceColors.getColorByHex(textColorHex);
            if (textLocation == null) continue;
            Font chatFont = FontManager.getRunescapeBoldFont();
            FontMetrics metrics = graphics.getFontMetrics(chatFont);
            Point centeredTextLocation = new Point(textLocation.getX() - (metrics.stringWidth(formattedText) >>> 1), textLocation.getY());
            if (centeredTextLocation == null) continue;
            graphics.setFont(chatFont);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)centeredTextLocation, (String)formattedText, (Color)textColor);
        }
        return null;
    }

    public void addEffect(MarketplaceEffect<EbsModelOverheadFrame> effect) {
        this.activeEffects.add(effect);
    }

    public void removeEffect(MarketplaceEffect<EbsModelOverheadFrame> effect) {
        this.activeEffects.remove(effect);
    }
}

