/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.sounds;

import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import net.runelite.api.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundManager {
    private static final Logger log = LoggerFactory.getLogger(SoundManager.class);
    private final Client client;
    private final TwitchLiveLoadoutConfig config;
    private Instant globalLastPlayedAt;
    private ConcurrentHashMap<Integer, Instant> uniqueLastPlayedAtLookup = new ConcurrentHashMap();

    public SoundManager(Client client, TwitchLiveLoadoutConfig config) {
        this.client = client;
        this.config = config;
    }

    public void playSound(Integer soundId) {
        boolean hasGlobalBeenPlayedRecently;
        if (!this.config.marketplaceSoundsEnabled()) {
            return;
        }
        if (soundId == null || soundId < 0) {
            return;
        }
        Instant now = Instant.now();
        Instant uniqueLastPlayedAt = this.uniqueLastPlayedAtLookup.get(soundId);
        boolean hasUniqueBeenPlayedRecently = uniqueLastPlayedAt != null && now.minusMillis(100L).isBefore(uniqueLastPlayedAt);
        boolean bl = hasGlobalBeenPlayedRecently = this.globalLastPlayedAt != null && now.minusMillis(0L).isBefore(this.globalLastPlayedAt);
        if (hasUniqueBeenPlayedRecently || hasGlobalBeenPlayedRecently) {
            log.debug("Skipping sound " + soundId + ", because it has been played recently. Unique: " + hasUniqueBeenPlayedRecently + ", global: " + hasGlobalBeenPlayedRecently);
            return;
        }
        this.globalLastPlayedAt = now;
        this.uniqueLastPlayedAtLookup.put(soundId, now);
        this.client.playSoundEffect(soundId.intValue());
    }
}

