/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.products;

import com.twitchliveloadout.marketplace.LambdaIterator;
import com.twitchliveloadout.marketplace.MarketplaceEffect;
import com.twitchliveloadout.marketplace.MarketplaceManager;
import com.twitchliveloadout.marketplace.MarketplaceRandomizers;
import com.twitchliveloadout.marketplace.animations.AnimationManager;
import com.twitchliveloadout.marketplace.interfaces.MenuManager;
import com.twitchliveloadout.marketplace.interfaces.WidgetManager;
import com.twitchliveloadout.marketplace.products.EbsAnimationFrame;
import com.twitchliveloadout.marketplace.products.EbsBehaviour;
import com.twitchliveloadout.marketplace.products.EbsCondition;
import com.twitchliveloadout.marketplace.products.EbsEffect;
import com.twitchliveloadout.marketplace.products.EbsEffectFrame;
import com.twitchliveloadout.marketplace.products.EbsEquipmentFrame;
import com.twitchliveloadout.marketplace.products.EbsGraphicFrame;
import com.twitchliveloadout.marketplace.products.EbsInterfaceWidgetFrame;
import com.twitchliveloadout.marketplace.products.EbsInterval;
import com.twitchliveloadout.marketplace.products.EbsMenuOptionFrame;
import com.twitchliveloadout.marketplace.products.EbsModelOverheadFrame;
import com.twitchliveloadout.marketplace.products.EbsModelPlacement;
import com.twitchliveloadout.marketplace.products.EbsModelSet;
import com.twitchliveloadout.marketplace.products.EbsMovementFrame;
import com.twitchliveloadout.marketplace.products.EbsNotification;
import com.twitchliveloadout.marketplace.products.EbsProduct;
import com.twitchliveloadout.marketplace.products.EbsProjectileFrame;
import com.twitchliveloadout.marketplace.products.EbsRandomRange;
import com.twitchliveloadout.marketplace.products.EbsSoundEffectFrame;
import com.twitchliveloadout.marketplace.products.EbsSpawn;
import com.twitchliveloadout.marketplace.products.EbsSpawnOption;
import com.twitchliveloadout.marketplace.products.EbsStateFrame;
import com.twitchliveloadout.marketplace.products.StreamerProduct;
import com.twitchliveloadout.marketplace.products.TwitchProduct;
import com.twitchliveloadout.marketplace.spawns.SpawnManager;
import com.twitchliveloadout.marketplace.spawns.SpawnOverheadManager;
import com.twitchliveloadout.marketplace.spawns.SpawnPoint;
import com.twitchliveloadout.marketplace.spawns.SpawnedObject;
import com.twitchliveloadout.marketplace.transactions.TwitchTransaction;
import com.twitchliveloadout.marketplace.transmogs.TransmogManager;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Projectile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplaceProduct {
    private static final Logger log = LoggerFactory.getLogger(MarketplaceProduct.class);
    private final MarketplaceManager manager;
    private final TwitchTransaction transaction;
    private final EbsProduct ebsProduct;
    private final StreamerProduct streamerProduct;
    private final TwitchProduct twitchProduct;
    private boolean isActive = false;
    private boolean isPaused = false;
    private Instant lastSpawnBehaviourAt;
    private int spawnBehaviourCounter = 0;
    private Instant lastEffectBehaviourAt;
    private int effectBehaviourCounter = 0;
    private final Instant startedAt;
    private Instant expiredAt;
    private final Instant loadedAt;
    private final Instant transactionAt;
    private final CopyOnWriteArrayList<SpawnedObject> spawnedObjects = new CopyOnWriteArrayList();
    private int spawnAmount = 0;
    private final ConcurrentHashMap<String, String> stateFrameValues = new ConcurrentHashMap();

    public MarketplaceProduct(MarketplaceManager manager, TwitchTransaction transaction, EbsProduct ebsProduct, StreamerProduct streamerProduct, TwitchProduct twitchProduct) {
        this.manager = manager;
        this.transaction = transaction;
        this.ebsProduct = ebsProduct;
        this.streamerProduct = streamerProduct;
        this.twitchProduct = twitchProduct;
        int duration = streamerProduct.duration;
        this.loadedAt = Instant.now();
        this.transactionAt = Instant.parse(transaction.timestamp);
        int transactionExpiryToleranceS = 30;
        Instant transactionExpiredAt = this.transactionAt.plusSeconds(duration + transactionExpiryToleranceS);
        Instant transactionLoadedAt = Instant.parse(transaction.loaded_at);
        boolean loadedTooLate = transactionLoadedAt.isAfter(transactionExpiredAt);
        this.startedAt = !loadedTooLate && manager.getConfig().marketplaceStartOnLoadedAt() ? this.loadedAt : this.transactionAt;
        this.expiredAt = this.startedAt.plusSeconds(duration).plusMillis(200L);
    }

    public void handleBehaviour() {
        if (!this.isActive || this.ebsProduct == null) {
            return;
        }
        this.handleNewEffects();
        this.handleNewSpawns();
        this.handleSpawnLocations();
        this.handleSpawnRandomEffects();
    }

    public void start() {
        this.play();
        this.triggerEffectsOptions(this.ebsProduct.behaviour.startEffectsOptions, null, 0);
    }

    public void play() {
        if (this.isActive) {
            return;
        }
        this.isPaused = false;
        this.isActive = true;
        this.handleSpawnedObjects(this.spawnedObjects, 0L, SpawnedObject::show);
    }

    public void pause() {
        if (!this.isActive) {
            return;
        }
        this.isPaused = true;
        this.isActive = false;
        this.handleSpawnedObjects(this.spawnedObjects, 0L, SpawnedObject::hide);
    }

    public void stop(boolean force) {
        if (!(this.isActive || this.isPaused || force)) {
            return;
        }
        if (!force) {
            this.triggerEffectsOptions(this.ebsProduct.behaviour.stopEffectsOptions, null, 0);
        }
        this.isPaused = false;
        this.isActive = false;
        if (!this.isExpired()) {
            this.expiredAt = Instant.now();
        }
        this.handleSpawnedObjects(this.spawnedObjects, 0L, spawnedObject -> {
            if (force) {
                spawnedObject.hide();
            } else {
                this.hideSpawnedObject(spawnedObject, 0L);
            }
            this.manager.getSpawnManager().deregisterSpawnedObjectPlacement(spawnedObject);
        });
        this.spawnedObjects.clear();
    }

    public void cleanExpiredSpawnedObjects() {
        this.handleSpawnedObjects(this.spawnedObjects, 0L, spawnedObject -> {
            if (!spawnedObject.isExpired()) {
                return;
            }
            this.hideSpawnedObject(spawnedObject, 0L);
            this.manager.getSpawnManager().deregisterSpawnedObjectPlacement(spawnedObject);
            this.spawnedObjects.remove(spawnedObject);
        });
    }

    public boolean isExpired(int nowDeltaMs) {
        return this.expiredAt == null || Instant.now().plusMillis(nowDeltaMs).isAfter(this.expiredAt);
    }

    public boolean isExpired() {
        return this.isExpired(0);
    }

    public long getExpiresInMs() {
        return this.expiredAt.toEpochMilli() - Instant.now().toEpochMilli();
    }

    public void handleSpawnRotations() {
        if (!this.isActive) {
            return;
        }
        for (SpawnedObject spawnedObject : this.spawnedObjects) {
            EbsModelPlacement modelPlacement = spawnedObject.getSpawn().modelPlacement;
            String rotationType = modelPlacement.rotationType;
            Player player = this.manager.getClient().getLocalPlayer();
            if (rotationType == null || player == null) continue;
            Actor interacting = player.getInteracting();
            switch (rotationType) {
                case "player": {
                    LocalPoint playerLocalLocation = player.getLocalLocation();
                    spawnedObject.rotateTowards(playerLocalLocation);
                    break;
                }
                case "mirror-player": {
                    spawnedObject.setOrientation(player.getCurrentOrientation());
                    break;
                }
                case "interacting": {
                    if (interacting == null) break;
                    LocalPoint interactingLocalLocation = interacting.getLocalLocation();
                    spawnedObject.rotateTowards(interactingLocalLocation);
                    break;
                }
                case "mirror-interacting": {
                    if (interacting == null) break;
                    spawnedObject.setOrientation(interacting.getCurrentOrientation());
                }
            }
        }
    }

    private void handleSpawnLocations() {
        SpawnManager spawnManager = this.manager.getSpawnManager();
        Iterator<SpawnedObject> spawnedObjectIterator = this.spawnedObjects.iterator();
        HashMap<WorldPoint, SpawnPoint> newSpawnPoints = new HashMap<WorldPoint, SpawnPoint>();
        while (spawnedObjectIterator.hasNext()) {
            WorldPoint previousPlayerWorldPoint;
            SpawnedObject spawnedObject = spawnedObjectIterator.next();
            EbsSpawn spawn = spawnedObject.getSpawn();
            WorldPoint worldPoint = spawnedObject.getSpawnPoint().getWorldPoint();
            if (spawn == null) continue;
            EbsModelPlacement modelRespawnPlacement = spawn.modelRespawnPlacement;
            EbsModelPlacement modelPlacement = spawn.modelPlacement;
            if (modelRespawnPlacement != null) {
                modelPlacement = modelRespawnPlacement;
            }
            if (modelPlacement == null) {
                modelPlacement = new EbsModelPlacement();
            }
            String followType = modelPlacement.followType;
            ArrayList<EbsCondition> followConditions = modelPlacement.followConditions;
            String validFollowType = followType == null ? "none" : followType;
            EbsRandomRange radiusRange = modelPlacement.radiusRange;
            int followRadius = 15;
            if (modelPlacement.followRadius != null) {
                followRadius = modelPlacement.followRadius;
            } else if (radiusRange != null && radiusRange.max != null) {
                followRadius = radiusRange.max.intValue();
            }
            if (validFollowType.equals("none") || !this.verifyConditions(followConditions, spawnedObject)) continue;
            if (validFollowType.equals("in-radius")) {
                if (spawnedObject.isInView(followRadius)) continue;
                SpawnPoint newInSceneSpawnPoint = null;
                if (newSpawnPoints.containsKey(worldPoint)) {
                    newInSceneSpawnPoint = (SpawnPoint)newSpawnPoints.get(worldPoint);
                } else {
                    WorldPoint modelWorldPoint = spawnedObject.getSpawnPoint().getWorldPoint();
                    newInSceneSpawnPoint = spawnManager.getSpawnPoint(modelPlacement, modelWorldPoint);
                    newSpawnPoints.put(worldPoint, newInSceneSpawnPoint);
                }
                if (newInSceneSpawnPoint == null) continue;
                spawnManager.moveSpawnedObject(spawnedObject, newInSceneSpawnPoint);
            }
            if (!validFollowType.equals("behind-player") || worldPoint.equals((Object)(previousPlayerWorldPoint = spawnManager.getPreviousPlayerLocation()))) continue;
            SpawnPoint previousPlayerSpawnPoint = new SpawnPoint(previousPlayerWorldPoint);
            spawnManager.moveSpawnedObject(spawnedObject, previousPlayerSpawnPoint);
        }
    }

    private void handleSpawnRandomEffects() {
        if (!this.isActive) {
            return;
        }
        Instant now = Instant.now();
        for (SpawnedObject spawnedObject : this.spawnedObjects) {
            Instant spawnedAt = spawnedObject.getSpawnedAt();
            Instant lastRandomEffectAt = spawnedObject.getLastRandomEffectAt();
            int randomEffectCounter = spawnedObject.getRandomEffectCounter();
            EbsSpawn spawn = spawnedObject.getSpawn();
            EbsInterval randomInterval = spawn.randomEffectsInterval;
            ArrayList<ArrayList<EbsEffect>> randomEffectsOptions = spawn.randomEffectsOptions;
            if (randomInterval == null || randomEffectsOptions == null || randomEffectsOptions.size() <= 0) continue;
            Boolean triggerOnStart = randomInterval.triggerOnStart;
            Double chance = randomInterval.chance;
            ArrayList<EbsCondition> conditions = randomInterval.conditions;
            if (!this.verifyIntervalDelay(randomInterval, lastRandomEffectAt, spawnedAt, randomEffectCounter) || !spawnedObject.isInRegion() || !this.verifyConditions(conditions, spawnedObject) || !MarketplaceRandomizers.rollChance(chance) && (lastRandomEffectAt != null || !triggerOnStart.booleanValue())) continue;
            ArrayList<EbsEffect> randomEffects = MarketplaceRandomizers.getRandomEntryFromList(randomEffectsOptions);
            this.triggerEffects(randomEffects, 0, spawnedObject, null, false, null);
            spawnedObject.registerRandomEffect();
        }
    }

    private void handleNewEffects() {
        EbsBehaviour behaviour = this.ebsProduct.behaviour;
        ArrayList<ArrayList<EbsEffect>> effectOptions = behaviour.effectsOptions;
        if (effectOptions == null) {
            return;
        }
        String transactionId = this.transaction.id;
        String productId = this.ebsProduct.id;
        EbsInterval effectsInterval = behaviour.effectsInterval;
        if (effectsInterval == null) {
            effectsInterval = new EbsInterval();
            effectsInterval.repeatAmount = 1;
        }
        ArrayList<EbsCondition> conditions = effectsInterval.conditions;
        int afterTriggerDelayMs = effectsInterval.afterTriggerDelayMs;
        if (!this.verifyIntervalDelay(effectsInterval, this.lastEffectBehaviourAt, this.startedAt, this.effectBehaviourCounter)) {
            return;
        }
        if (!this.verifyConditions(conditions)) {
            this.lastEffectBehaviourAt = Instant.now();
            return;
        }
        ArrayList<EbsEffect> effectsOption = MarketplaceRandomizers.getRandomEntryFromList(effectOptions);
        if (effectsOption == null) {
            log.warn("Could not find valid effect behaviour option for product (" + productId + ")");
            return;
        }
        this.lastEffectBehaviourAt = Instant.now().plusMillis(afterTriggerDelayMs);
        ++this.effectBehaviourCounter;
        this.triggerEffects(effectsOption, 0, null, null, false, null);
    }

    private void handleNewSpawns() {
        boolean hasSpawnedAtLeastOnce;
        Instant now = Instant.now();
        EbsBehaviour behaviour = this.ebsProduct.behaviour;
        ArrayList<EbsSpawnOption> startSpawnOptions = behaviour.startSpawnOptions;
        ArrayList<EbsSpawnOption> spawnOptions = behaviour.spawnOptions;
        EbsInterval spawnInterval = behaviour.spawnInterval;
        boolean bl = hasSpawnedAtLeastOnce = this.lastSpawnBehaviourAt != null;
        if (!hasSpawnedAtLeastOnce && startSpawnOptions != null) {
            spawnOptions = startSpawnOptions;
        }
        if (spawnOptions == null) {
            return;
        }
        if (spawnInterval == null) {
            spawnInterval = new EbsInterval();
            spawnInterval.repeatAmount = 1;
        }
        int afterTriggerDelayMs = spawnInterval.afterTriggerDelayMs;
        ArrayList<EbsCondition> conditions = spawnInterval.conditions;
        if (!this.verifyIntervalDelay(spawnInterval, this.lastSpawnBehaviourAt, this.startedAt, this.spawnBehaviourCounter)) {
            return;
        }
        if (!this.verifyConditions(conditions)) {
            return;
        }
        this.lastSpawnBehaviourAt = now.plusMillis(afterTriggerDelayMs);
        ++this.spawnBehaviourCounter;
        this.triggerSpawnOptions(null, spawnOptions);
    }

    private void triggerSpawnOptions(SpawnedObject spawnedObject, ArrayList<EbsSpawnOption> spawnOptions) {
        WorldPoint worldPoint = null;
        if (spawnedObject != null) {
            worldPoint = spawnedObject.getSpawnPoint().getWorldPoint();
        }
        this.triggerSpawnOptionsAtWorldPoint(worldPoint, spawnOptions);
    }

    private void triggerSpawnOptionsAtWorldPoint(WorldPoint modelWorldPoint, ArrayList<EbsSpawnOption> spawnOptions) {
        if (spawnOptions == null || spawnOptions.size() <= 0) {
            return;
        }
        SpawnManager spawnManager = this.manager.getSpawnManager();
        String transactionId = this.transaction.id;
        String productId = this.ebsProduct.id;
        EbsSpawnOption spawnOption = MarketplaceRandomizers.getSpawnBehaviourByChance(spawnOptions);
        if (spawnOption == null) {
            log.warn("Could not find valid spawn behaviour option for product (" + productId + ")");
            return;
        }
        int spawnGroupAmount = (int)MarketplaceRandomizers.getValidRandomNumberByRange(spawnOption.spawnAmount, 1.0, 1.0, 0.0, 500.0);
        ArrayList<EbsSpawn> spawns = spawnOption.spawns;
        String spawnPointType = spawnOption.spawnPointType;
        if (spawns == null) {
            log.warn("Could not find valid spawn behaviours for product (" + productId + ")");
            return;
        }
        log.debug("Executing spawn behaviours for product (" + productId + ") and transaction (" + transactionId + ")");
        if (!this.verifyConditions(spawnOption.conditions, null)) {
            return;
        }
        this.manager.getPlugin().runOnClientThread(() -> {
            for (int spawnGroupIndex = 0; spawnGroupIndex < spawnGroupAmount; ++spawnGroupIndex) {
                SpawnPoint spawnPoint = null;
                for (EbsSpawn spawn : spawns) {
                    int spawnAmount = (int)MarketplaceRandomizers.getValidRandomNumberByRange(spawn.spawnAmount, 1.0, 1.0, 0.0, 500.0);
                    for (int spawnIndex = 0; spawnIndex < spawnAmount; ++spawnIndex) {
                        int spawnDelayMs = (int)MarketplaceRandomizers.getValidRandomNumberByRange(spawnOption.spawnDelayMs, 0.0, 0.0);
                        EbsModelPlacement placement = spawn.modelPlacement;
                        if (spawnPoint == null || "individual".equals(spawnPointType)) {
                            spawnPoint = spawnManager.getSpawnPoint(placement, modelWorldPoint);
                        }
                        this.triggerSpawn(spawn, spawnPoint, spawnDelayMs);
                    }
                }
            }
        });
    }

    private void triggerSpawn(EbsSpawn spawn, SpawnPoint spawnPoint, int spawnDelayMs) {
        if (spawn == null) {
            log.error("An invalid spawn object was passed when triggering spawn!");
            return;
        }
        SpawnManager spawnManager = this.manager.getSpawnManager();
        Client client = this.manager.getClient();
        if (spawnPoint == null) {
            log.debug("Could not find valid spawn point when triggering spawn behaviour!");
            return;
        }
        EbsModelSet modelSet = MarketplaceRandomizers.getRandomEntryFromList(spawn.modelSetOptions);
        EbsRandomRange durationMs = spawn.durationMs;
        int randomDurationMs = -1;
        Instant spawnedObjectExpiredAt = null;
        if (modelSet == null || modelSet.ids == null) {
            log.warn("Could not find valid model set when triggering spawn behaviour!");
            return;
        }
        if (durationMs != null) {
            randomDurationMs = (int)MarketplaceRandomizers.getValidRandomNumberByRange(durationMs, 0.0, 0.0);
            spawnedObjectExpiredAt = Instant.now().plusMillis(randomDurationMs);
        }
        SpawnedObject spawnedObject = new SpawnedObject(this, client, spawnPoint, spawn, modelSet, spawnedObjectExpiredAt);
        this.showSpawnedObject(spawnedObject, spawnDelayMs);
        if (randomDurationMs >= 0) {
            this.hideSpawnedObject(spawnedObject, spawnDelayMs + randomDurationMs);
        }
        this.spawnedObjects.add(spawnedObject);
        ++this.spawnAmount;
        spawnManager.registerSpawnedObjectPlacement(spawnedObject);
    }

    public void triggerEffects(ArrayList<EbsEffect> effects, int startDelayMs, SpawnedObject spawnedObject, MarketplaceEffect marketplaceEffect, boolean forceModelAnimation, ResetEffectHandler resetModelAnimationHandler) {
        if (effects == null) {
            return;
        }
        Iterator<EbsEffect> effectIterator = effects.iterator();
        this.triggerEffect(effectIterator, startDelayMs, spawnedObject, marketplaceEffect, forceModelAnimation, resetModelAnimationHandler);
    }

    public void triggerEffect(Iterator<EbsEffect> effectIterator, int frameDelayMs, SpawnedObject spawnedObject, MarketplaceEffect marketplaceEffect, boolean forceModelAnimation, ResetEffectHandler resetModelAnimationHandler) {
        if (effectIterator == null || !effectIterator.hasNext()) {
            return;
        }
        EbsEffect effect = effectIterator.next();
        boolean isLast = !effectIterator.hasNext();
        int durationMs = (int)MarketplaceRandomizers.getValidRandomNumberByRange(effect.durationMs, 0.0, 0.0);
        ArrayList<EbsCondition> conditions = effect.conditions;
        boolean blockingConditions = effect.blockingConditions;
        boolean breakOnInvalidConditions = effect.breakOnInvalidConditions != false || blockingConditions;
        boolean breakOnValidConditions = effect.breakOnValidConditions;
        this.manager.getPlugin().scheduleOnClientThread(() -> {
            boolean satisfiedValidBreak;
            int nextFrameDelayMs = durationMs;
            int innerDelayMs = 0;
            boolean conditionsVerified = this.verifyConditions(conditions, spawnedObject);
            boolean satisfiedInvalidBreak = conditionsVerified || !breakOnInvalidConditions;
            boolean bl = satisfiedValidBreak = !conditionsVerified || !breakOnValidConditions;
            if (satisfiedInvalidBreak && satisfiedValidBreak) {
                this.triggerEffect(effectIterator, nextFrameDelayMs, spawnedObject, marketplaceEffect, forceModelAnimation, resetModelAnimationHandler);
            }
            if (!conditionsVerified) {
                if (isLast && resetModelAnimationHandler != null) {
                    resetModelAnimationHandler.execute(innerDelayMs);
                }
                return;
            }
            this.triggerSpawnOptions(spawnedObject, effect.spawnOptions);
            this.triggerModelExpired(spawnedObject, effect.modelExpired);
            this.triggerProductExpired(effect.productExpired);
            this.triggerModelAnimation(spawnedObject, effect.modelAnimation, effect.modelAnimation == null ? nextFrameDelayMs + innerDelayMs : innerDelayMs, forceModelAnimation, isLast ? resetModelAnimationHandler : null);
            this.triggerModelOverhead(spawnedObject, effect.modelOverhead, innerDelayMs);
            this.triggerModelSetUpdate(spawnedObject, effect.modelSet);
            this.triggerPlayerGraphic(effect.playerGraphic, innerDelayMs);
            this.triggerPlayerAnimation(effect.playerAnimation, innerDelayMs);
            this.triggerPlayerEquipment(effect.playerEquipment, innerDelayMs);
            this.triggerPlayerMovement(effect.playerMovement, innerDelayMs);
            this.triggerInterfaceWidgets(effect.interfaceWidgets, innerDelayMs);
            this.triggerMenuOptions(effect.menuOptions, innerDelayMs);
            this.triggerSoundEffect(effect.soundEffect, innerDelayMs);
            this.triggerStateChange(spawnedObject, effect.stateChange, innerDelayMs);
            this.triggerNotifications(marketplaceEffect, effect.notifications, innerDelayMs);
            this.triggerProjectiles(spawnedObject, effect.projectiles, innerDelayMs);
            this.triggerEffectsOptions(effect.effectsOptions, spawnedObject, innerDelayMs);
        }, frameDelayMs);
    }

    public void triggerEffectsOptions(ArrayList<ArrayList<EbsEffect>> effectsOptions, SpawnedObject spawnedObject, int startDelayMs) {
        ArrayList<EbsEffect> effects = MarketplaceRandomizers.getRandomEntryFromList(effectsOptions);
        this.triggerEffects(effects, spawnedObject, startDelayMs);
    }

    public void triggerEffects(ArrayList<EbsEffect> effects, SpawnedObject spawnedObject, int startDelayMs) {
        this.triggerEffects(effects, startDelayMs, spawnedObject, null, false, null);
    }

    private boolean verifyIntervalDelay(EbsInterval interval, Instant lastTriggeredAt, Instant startedAt, int triggeredAmount) {
        boolean hasTriggeredAtLeastOnce;
        Instant now = Instant.now();
        boolean triggerOnStart = interval.triggerOnStart;
        int repeatAmount = interval.repeatAmount;
        int startDelayMs = interval.startDelayMs;
        int delayMs = interval.delayMs;
        Instant delayReferenceTime = lastTriggeredAt == null ? startedAt : lastTriggeredAt;
        boolean bl = hasTriggeredAtLeastOnce = lastTriggeredAt != null;
        if (repeatAmount >= 0 && triggeredAmount >= repeatAmount) {
            return false;
        }
        if (delayReferenceTime != null && delayReferenceTime.plusMillis(delayMs).isAfter(now) && (hasTriggeredAtLeastOnce || !triggerOnStart)) {
            return false;
        }
        return startDelayMs <= 0 || !startedAt.plusMillis(startDelayMs).isAfter(now);
    }

    private boolean verifyConditions(ArrayList<EbsCondition> conditions) {
        return this.verifyConditions(conditions, null);
    }

    private boolean verifyConditions(ArrayList<EbsCondition> conditions, SpawnedObject spawnedObject) {
        if (conditions == null) {
            return true;
        }
        for (EbsCondition condition : conditions) {
            boolean conditionVerified = this.verifyCondition(condition, spawnedObject);
            if (conditionVerified) continue;
            return false;
        }
        return true;
    }

    private boolean verifyCondition(EbsCondition condition, SpawnedObject spawnedObject) {
        if (condition == null) {
            return true;
        }
        Integer varbitId = condition.varbitId;
        Integer varbitValue = condition.varbitValue;
        Integer minTimeMs = condition.minTimeMs;
        Integer maxTimeMs = condition.maxTimeMs;
        Double minTimePercentage = condition.minTimePercentage;
        Double maxTimePercentage = condition.maxTimePercentage;
        Integer maxSpawnsInView = condition.maxSpawnsInView;
        Integer maxSpawnsInViewRadius = condition.maxSpawnsInViewRadius;
        Integer minSpawnsInView = condition.minSpawnsInView;
        Integer minSpawnsInViewRadius = condition.minSpawnsInViewRadius;
        Integer spawnInViewRadius = condition.spawnInViewRadius;
        String stateType = condition.stateType;
        String stateFormat = condition.stateFormat;
        String stateComparator = condition.stateComparator;
        String stateKey = condition.stateKey;
        String stateValue = condition.stateValue;
        Double chance = condition.chance;
        ArrayList<EbsCondition> orConditions = condition.or;
        ArrayList<EbsCondition> andConditions = condition.and;
        boolean orConditionsVerified = false;
        if (!MarketplaceRandomizers.rollChance(chance)) {
            return false;
        }
        if (!this.verifyStateValue(stateType, stateFormat, stateComparator, stateKey, stateValue, spawnedObject)) {
            return false;
        }
        if (!this.verifyTimePassedMs(minTimeMs, maxTimeMs)) {
            return false;
        }
        if (!this.verifyTimePassedPercentage(minTimePercentage, maxTimePercentage)) {
            return false;
        }
        if (varbitId >= 0 && this.manager.getClient().getVarbitValue(varbitId.intValue()) != varbitValue.intValue()) {
            return false;
        }
        if (maxSpawnsInView > 0 && this.countSpawnedObjectsInView(maxSpawnsInViewRadius) > maxSpawnsInView) {
            return false;
        }
        if (minSpawnsInView > 0 && this.countSpawnedObjectsInView(minSpawnsInViewRadius) < minSpawnsInView) {
            return false;
        }
        if (spawnedObject != null && spawnInViewRadius >= 0 && !spawnedObject.isInView(spawnInViewRadius)) {
            return false;
        }
        if (andConditions != null) {
            for (EbsCondition andCondition : andConditions) {
                if (this.verifyCondition(andCondition, spawnedObject)) continue;
                return false;
            }
        }
        if (orConditions != null) {
            for (EbsCondition orCondition : orConditions) {
                if (!this.verifyCondition(orCondition, spawnedObject)) continue;
                orConditionsVerified = true;
                break;
            }
            if (!orConditionsVerified) {
                return false;
            }
        }
        return true;
    }

    private boolean verifyStateValue(String stateType, String stateFormat, String stateComparator, String stateKey, String comparedStateValue, SpawnedObject spawnedObject) {
        if (stateType == null || stateKey == null) {
            return true;
        }
        String currentStateValue = null;
        if ("product".equals(stateType)) {
            currentStateValue = this.stateFrameValues.get(stateKey);
        } else if ("object".equals(stateType) && spawnedObject != null) {
            currentStateValue = spawnedObject.getStateFrameValue(stateKey);
        }
        if (currentStateValue == null) {
            return comparedStateValue == null;
        }
        try {
            if ("integer".equals(stateFormat)) {
                int currentValue = currentStateValue == null ? 0 : Integer.parseInt(currentStateValue);
                int comparedValue = comparedStateValue == null ? 0 : Integer.parseInt(comparedStateValue);
                switch (stateComparator) {
                    case "equal": {
                        return currentValue == comparedValue;
                    }
                    case "larger-equal-than": {
                        return currentValue >= comparedValue;
                    }
                    case "larger-than": {
                        return currentValue > comparedValue;
                    }
                    case "smaller-equal-than": {
                        return currentValue <= comparedValue;
                    }
                    case "smaller-than": {
                        return currentValue < comparedValue;
                    }
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return currentStateValue.equals(comparedStateValue);
    }

    private boolean verifyTimePassedMs(int minMs, int maxMs) {
        if (minMs < 0 || maxMs < 0) {
            return true;
        }
        if (minMs == 0 && maxMs == Integer.MAX_VALUE) {
            return true;
        }
        long passedMs = this.getDurationPassed().toMillis();
        return passedMs >= (long)minMs && passedMs <= (long)maxMs;
    }

    private boolean verifyTimePassedPercentage(double minPercentage, double maxPercentage) {
        if (minPercentage < 0.0 || maxPercentage < 0.0 || maxPercentage > 1.0 || minPercentage > 1.0) {
            return true;
        }
        if (minPercentage == 0.0 && maxPercentage == 1.0) {
            return true;
        }
        long durationMs = this.getDuration().toMillis();
        if (durationMs <= 0L) {
            return false;
        }
        long passedMs = this.getDurationPassed().toMillis();
        double passedTimePercentage = (double)passedMs / (double)durationMs;
        return !(passedTimePercentage < minPercentage) && !(passedTimePercentage > maxPercentage);
    }

    private void triggerModelSetUpdate(SpawnedObject spawnedObject, EbsModelSet modelSet) {
        if (spawnedObject == null || modelSet == null) {
            return;
        }
        spawnedObject.setModelSet(modelSet);
        spawnedObject.updateModelSet(true);
    }

    private void triggerModelExpired(SpawnedObject spawnedObject, Boolean modelExpired) {
        if (spawnedObject == null || modelExpired == null || !modelExpired.booleanValue()) {
            return;
        }
        spawnedObject.expireNow();
    }

    private void triggerProductExpired(Boolean productExpired) {
        if (productExpired == null || !productExpired.booleanValue()) {
            return;
        }
        this.stop(false);
    }

    private void triggerModelAnimation(SpawnedObject spawnedObject, EbsAnimationFrame animation, int baseDelayMs, boolean force, ResetEffectHandler resetAnimationHandler) {
        if (spawnedObject == null || animation == null) {
            if (resetAnimationHandler != null) {
                resetAnimationHandler.execute(baseDelayMs);
            }
            return;
        }
        if (resetAnimationHandler == null) {
            resetAnimationHandler = resetDelayMs -> this.resetAnimation(spawnedObject, resetDelayMs);
        }
        if (!force && spawnedObject.isAnimationLocked()) {
            return;
        }
        spawnedObject.lockAnimationUntil(animation.durationMs.intValue());
        this.handleEffectFrame(animation, baseDelayMs, startDelayMs -> this.setAnimation(spawnedObject, animation.id, animation.shouldLoop, startDelayMs), resetAnimationHandler);
    }

    private void triggerPlayerGraphic(EbsGraphicFrame graphicFrame, int delayMs) {
        AnimationManager animationManager = this.manager.getAnimationManager();
        int graphicKey = this.hashCode() + this.manager.getClient().getGameCycle();
        this.handleEffectFrame(graphicFrame, delayMs, startDelayMs -> animationManager.setPlayerGraphic(graphicKey, graphicFrame.id, graphicFrame.height, startDelayMs, graphicFrame.durationMs.intValue()), resetDelayMs -> animationManager.resetPlayerGraphic(graphicKey, resetDelayMs));
    }

    private void triggerPlayerAnimation(EbsAnimationFrame animationFrame, int delayMs) {
        AnimationManager animationManager = this.manager.getAnimationManager();
        this.handleEffectFrame(animationFrame, delayMs, startDelayMs -> animationManager.setPlayerAnimation(animationFrame.id, startDelayMs, animationFrame.durationMs.intValue()), animationManager::resetPlayerAnimation);
    }

    private void triggerPlayerEquipment(EbsEquipmentFrame equipmentFrame, int baseDelayMs) {
        TransmogManager transmogManager = this.manager.getTransmogManager();
        if (equipmentFrame == null) {
            return;
        }
        int delayMs = (int)MarketplaceRandomizers.getValidRandomNumberByRange(equipmentFrame.delayMs, 0.0, 0.0);
        this.manager.getPlugin().scheduleOnClientThread(() -> transmogManager.addEffect(this, equipmentFrame, null), baseDelayMs + delayMs);
    }

    private void triggerPlayerMovement(EbsMovementFrame movementFrame, int baseDelayMs) {
        AnimationManager animationManager = this.manager.getAnimationManager();
        if (movementFrame == null) {
            return;
        }
        int delayMs = (int)MarketplaceRandomizers.getValidRandomNumberByRange(movementFrame.delayMs, 0.0, 0.0);
        this.manager.getPlugin().scheduleOnClientThread(() -> animationManager.addEffect(this, movementFrame, null), baseDelayMs + delayMs);
    }

    private void triggerModelOverhead(SpawnedObject spawnedObject, EbsModelOverheadFrame overheadFrame, int baseDelayMs) {
        SpawnOverheadManager spawnOverheadManager = this.manager.getSpawnOverheadManager();
        if (overheadFrame == null) {
            return;
        }
        int delayMs = (int)MarketplaceRandomizers.getValidRandomNumberByRange(overheadFrame.delayMs, 0.0, 0.0);
        this.manager.getPlugin().scheduleOnClientThread(() -> spawnOverheadManager.addEffect(this, overheadFrame, spawnedObject), baseDelayMs + delayMs);
    }

    private void triggerInterfaceWidgets(ArrayList<EbsInterfaceWidgetFrame> interfaceWidgetFrames, int delayMs) {
        WidgetManager widgetManager = this.manager.getWidgetManager();
        if (interfaceWidgetFrames == null) {
            return;
        }
        this.manager.getPlugin().scheduleOnClientThread(() -> {
            for (EbsInterfaceWidgetFrame interfaceWidgetFrame : interfaceWidgetFrames) {
                widgetManager.addEffect(this, interfaceWidgetFrame, null);
            }
        }, delayMs);
    }

    private void triggerMenuOptions(ArrayList<EbsMenuOptionFrame> menuOptionFrames, int delayMs) {
        MenuManager menuManager = this.manager.getMenuManager();
        if (menuOptionFrames == null) {
            return;
        }
        this.manager.getPlugin().scheduleOnClientThread(() -> {
            for (EbsMenuOptionFrame menuOptionFrame : menuOptionFrames) {
                menuManager.addEffect(this, menuOptionFrame, null);
            }
        }, delayMs);
    }

    private void triggerSoundEffect(EbsSoundEffectFrame soundEffect, int baseDelayMs) {
        if (soundEffect == null) {
            return;
        }
        Integer soundEffectId = soundEffect.id;
        int delayMs = (int)MarketplaceRandomizers.getValidRandomNumberByRange(soundEffect.delayMs, 0.0, 0.0);
        if (soundEffectId <= 0) {
            return;
        }
        this.manager.getPlugin().scheduleOnClientThread(() -> this.manager.getSoundManager().playSound(soundEffectId), baseDelayMs + delayMs);
    }

    private void triggerStateChange(SpawnedObject spawnedObject, EbsStateFrame stateFrame, int baseDelayMs) {
        if (stateFrame == null) {
            return;
        }
        String stateType = stateFrame.type;
        String stateKey = stateFrame.key;
        Integer delayMs = stateFrame.delayMs;
        if (stateType == null || stateKey == null || delayMs == null) {
            return;
        }
        this.manager.getPlugin().scheduleOnClientThread(() -> {
            if ("product".equals(stateType)) {
                String currentStateValue = this.stateFrameValues.get(stateKey);
                String newStateValue = this.calculateNewStateValue(currentStateValue, stateFrame);
                this.stateFrameValues.put(stateKey, newStateValue);
            } else if ("object".equals(stateType) && spawnedObject != null) {
                String currentStateValue = spawnedObject.getStateFrameValue(stateKey);
                String newStateValue = this.calculateNewStateValue(currentStateValue, stateFrame);
                spawnedObject.setStateFrameValue(stateKey, newStateValue);
            }
        }, baseDelayMs + delayMs);
    }

    private String calculateNewStateValue(String currentStateValue, EbsStateFrame stateFrame) {
        String stateDeltaValue;
        if (stateFrame == null) {
            return null;
        }
        String stateFormat = stateFrame.format;
        String stateOperation = stateFrame.operation;
        String newStateValue = stateDeltaValue = stateFrame.value;
        try {
            if ("integer".equals(stateFormat)) {
                int deltaValue;
                int currentValue = currentStateValue == null ? 0 : Integer.parseInt(currentStateValue);
                int newValue = deltaValue = stateDeltaValue == null ? 0 : Integer.parseInt(stateDeltaValue);
                switch (stateOperation) {
                    case "set": {
                        break;
                    }
                    case "add": {
                        newValue = currentValue + deltaValue;
                        break;
                    }
                    case "subtract": {
                        newValue = currentValue - deltaValue;
                        break;
                    }
                    case "divide": {
                        newValue = currentValue / deltaValue;
                        break;
                    }
                    case "multiply": {
                        newValue = currentValue * deltaValue;
                    }
                }
                newStateValue = String.valueOf(newValue);
            }
        }
        catch (Exception exception) {
            log.error("Could not calculate new state value because of error:", (Throwable)exception);
            return currentStateValue;
        }
        return newStateValue;
    }

    private void triggerNotifications(MarketplaceEffect marketplaceEffect, ArrayList<EbsNotification> notifications, int delayMs) {
        if (notifications == null || notifications.size() <= 0) {
            return;
        }
        this.manager.getPlugin().scheduleOnClientThread(() -> {
            boolean isExpired;
            boolean bl = isExpired = !this.isActive && !this.isExpired() || this.isExpired(-7000);
            if (isExpired) {
                log.debug("Skipping notifications because product is expired by time: " + this.getExpiresInMs());
                return;
            }
            this.manager.getNotificationManager().handleEbsNotifications(this, marketplaceEffect, notifications);
        }, delayMs);
    }

    private void triggerProjectiles(SpawnedObject spawnedObject, ArrayList<EbsProjectileFrame> projectiles, int delayMs) {
        if (projectiles == null) {
            return;
        }
        Iterator<EbsProjectileFrame> projectileFrameIterator = projectiles.iterator();
        Client client = this.manager.getClient();
        while (projectileFrameIterator.hasNext()) {
            EbsProjectileFrame projectileFrame = projectileFrameIterator.next();
            int projectileDelayMs = (int)MarketplaceRandomizers.getValidRandomNumberByRange(projectileFrame.delayMs, 0.0, 0.0, 0.0, 2.147483647E9);
            this.manager.getPlugin().scheduleOnClientThread(() -> {
                Integer projectileId = projectileFrame.id;
                String startLocationType = projectileFrame.startLocationType;
                String endLocationType = projectileFrame.endLocationType;
                Boolean followEndLocation = projectileFrame.followEndLocation;
                Boolean inLineOfSight = projectileFrame.inLineOfSight;
                Boolean avoidExistingSpawns = projectileFrame.avoidExistingSpawns;
                Boolean avoidPlayerLocation = projectileFrame.avoidPlayerLocation;
                Boolean avoidInvalidOverlay = projectileFrame.avoidInvalidOverlay;
                Actor endActor = followEndLocation != false ? this.getActorByLocationType(endLocationType) : null;
                LocalPoint startReferenceLocation = this.getLocalPointByLocationType(startLocationType, spawnedObject);
                LocalPoint endReferenceLocation = this.getLocalPointByLocationType(endLocationType, spawnedObject);
                LocalPoint startLocation = this.offsetLocalPointByRadius(startReferenceLocation, inLineOfSight, avoidExistingSpawns, avoidPlayerLocation, avoidInvalidOverlay, projectileFrame.startLocationRadiusRange);
                LocalPoint endLocation = this.offsetLocalPointByRadius(endReferenceLocation, inLineOfSight, avoidExistingSpawns, avoidPlayerLocation, avoidInvalidOverlay, projectileFrame.endLocationRadiusRange);
                WorldPoint startWorldLocation = WorldPoint.fromLocal((Client)client, (LocalPoint)startLocation);
                WorldPoint endWorldLocation = WorldPoint.fromLocal((Client)client, (LocalPoint)endLocation);
                int startZ = projectileFrame.startZ;
                int slope = projectileFrame.slope;
                int startHeight = projectileFrame.startHeight;
                int endHeight = projectileFrame.endHeight;
                int durationMs = projectileFrame.durationMs;
                int durationCycles = durationMs / 20;
                int plane = client.getPlane();
                int sceneX = startLocation.getSceneX();
                int sceneY = startLocation.getSceneY();
                int tileHeight = client.getTileHeights()[plane][sceneX][sceneY];
                int correctedStartZ = tileHeight + startZ;
                int startCycle = client.getGameCycle();
                int endCycle = startCycle + durationCycles;
                if (projectileId == null || durationCycles <= 0 || startLocation == null || endLocation == null) {
                    return;
                }
                this.triggerSpawnOptionsAtWorldPoint(startWorldLocation, projectileFrame.startSpawnOptions);
                Projectile projectile = client.createProjectile(projectileId.intValue(), client.getPlane(), startLocation.getX(), startLocation.getY(), correctedStartZ, startCycle, endCycle, slope, startHeight, endHeight, endActor, endLocation.getX(), endLocation.getY());
                client.getProjectiles().addLast((Object)projectile);
                this.manager.getPlugin().scheduleOnClientThread(() -> this.triggerSpawnOptionsAtWorldPoint(endWorldLocation, projectileFrame.endSpawnOptions), durationMs);
            }, delayMs + projectileDelayMs);
        }
    }

    @Nullable
    private Actor getActorByLocationType(String locationType) {
        Player localPlayer = this.manager.getClient().getLocalPlayer();
        Actor interactingActor = localPlayer.getInteracting();
        switch (locationType) {
            case "current-tile": 
            case "previous-tile": {
                return localPlayer;
            }
            case "model-tile": {
                return null;
            }
            case "interacting-tile": {
                return interactingActor;
            }
        }
        return null;
    }

    @Nullable
    private LocalPoint getLocalPointByLocationType(String locationType, SpawnedObject spawnedObject) {
        Client client = this.manager.getClient();
        Actor actor = this.getActorByLocationType(locationType);
        LocalPoint actorLocation = null;
        if (actor != null) {
            actorLocation = actor.getLocalLocation();
        }
        switch (locationType) {
            case "current-tile": 
            case "interacting-tile": {
                return actorLocation;
            }
            case "previous-tile": {
                WorldPoint previousLocation = this.manager.getSpawnManager().getPreviousPlayerLocation();
                if (previousLocation == null) {
                    return actorLocation;
                }
                return LocalPoint.fromWorld((Client)client, (WorldPoint)previousLocation);
            }
            case "model-tile": {
                return spawnedObject.getSpawnPoint().getLocalPoint(client);
            }
        }
        return null;
    }

    private LocalPoint offsetLocalPointByRadius(LocalPoint localPoint, boolean inLineOfSight, boolean avoidExistingSpawns, boolean avoidPlayerLocation, boolean avoidInvalidOverlay, EbsRandomRange radiusRange) {
        if (localPoint == null || radiusRange == null) {
            return localPoint;
        }
        Client client = this.manager.getClient();
        WorldPoint worldPoint = WorldPoint.fromLocal((Client)client, (LocalPoint)localPoint);
        int minRadius = radiusRange.min.intValue();
        int maxRadius = radiusRange.max.intValue();
        SpawnPoint spawnPoint = this.manager.getSpawnManager().getSpawnPoint(minRadius, maxRadius, inLineOfSight, avoidExistingSpawns, avoidPlayerLocation, avoidInvalidOverlay, worldPoint);
        if (spawnPoint == null) {
            return localPoint;
        }
        return spawnPoint.getLocalPoint(client);
    }

    private void handleEffectFrame(EbsEffectFrame effect, int baseDelayMs, StartEffectHandler startHandler, ResetEffectHandler resetHandler) {
        if (effect == null) {
            return;
        }
        int effectId = effect.id;
        if (effectId < 0) {
            return;
        }
        EbsRandomRange delayMsRange = effect.delayMs;
        int delayMs = (int)MarketplaceRandomizers.getValidRandomNumberByRange(delayMsRange, 0.0, 0.0);
        int durationMs = effect.durationMs;
        int startDelayMs = baseDelayMs + delayMs;
        startHandler.execute(startDelayMs);
        if (durationMs >= 0) {
            int resetDelayMs = startDelayMs + durationMs;
            resetHandler.execute(resetDelayMs);
        }
    }

    private void showSpawnedObject(SpawnedObject spawnedObject, long delayMs) {
        this.handleSpawnedObject(spawnedObject, delayMs, () -> {
            ArrayList<EbsEffect> showEffects = spawnedObject.getSpawn().showEffects;
            this.triggerEffects(showEffects, 0, spawnedObject, null, true, null);
            spawnedObject.show();
        });
    }

    private void hideSpawnedObject(SpawnedObject spawnedObject, long delayMs) {
        this.handleSpawnedObject(spawnedObject, delayMs, () -> {
            ArrayList<EbsEffect> hideEffects = spawnedObject.getSpawn().hideEffects;
            if (hideEffects == null || hideEffects.size() <= 0) {
                spawnedObject.hide();
                this.manager.getSpawnManager().deregisterSpawnedObjectPlacement(spawnedObject);
                return;
            }
            this.triggerEffects(hideEffects, 0, spawnedObject, null, true, resetDelayMs -> this.handleSpawnedObject(spawnedObject, resetDelayMs, () -> {
                spawnedObject.hide();
                this.manager.getSpawnManager().deregisterSpawnedObjectPlacement(spawnedObject);
            }));
        });
    }

    private void setAnimation(SpawnedObject spawnedObject, int animationId, boolean shouldLoop, long delayMs) {
        this.handleSpawnedObject(spawnedObject, delayMs, () -> spawnedObject.setAnimation(animationId, shouldLoop));
    }

    private void resetAnimation(SpawnedObject spawnedObject, long delayMs) {
        this.handleSpawnedObject(spawnedObject, delayMs, () -> {
            if (!this.isActive && !this.isPaused) {
                return;
            }
            spawnedObject.resetAnimation();
        });
    }

    private int countSpawnedObjectsInView(int radius) {
        AtomicInteger inViewAmount = new AtomicInteger();
        LambdaIterator.handleAll(this.spawnedObjects, spawnedObject -> {
            if (spawnedObject.isInView(radius)) {
                inViewAmount.addAndGet(1);
            }
        });
        return inViewAmount.get();
    }

    private void handleSpawnedObjects(CopyOnWriteArrayList<SpawnedObject> spawnedObjects, long delayMs, MarketplaceManager.SpawnedObjectHandler handler) {
        if (spawnedObjects == null || spawnedObjects.size() <= 0) {
            return;
        }
        Iterator<SpawnedObject> iterator = spawnedObjects.iterator();
        this.manager.getPlugin().scheduleOnClientThread(() -> {
            while (iterator.hasNext()) {
                SpawnedObject spawnedObject = (SpawnedObject)iterator.next();
                handler.execute(spawnedObject);
            }
        }, delayMs);
    }

    private void handleSpawnedObject(SpawnedObject spawnedObject, long delayMs, MarketplaceManager.EmptyHandler handler) {
        if (spawnedObject == null) {
            return;
        }
        this.manager.getPlugin().scheduleOnClientThread(() -> handler.execute(), delayMs);
    }

    public Duration getDuration() {
        return Duration.between(this.startedAt, this.expiredAt);
    }

    public Duration getDurationLeft() {
        Instant now = Instant.now();
        return Duration.between(now, this.expiredAt);
    }

    public Duration getDurationPassed() {
        Instant now = Instant.now();
        return Duration.between(this.startedAt, now);
    }

    public boolean isDangerous() {
        return this.ebsProduct.dangerous;
    }

    public TwitchTransaction getTransaction() {
        return this.transaction;
    }

    public EbsProduct getEbsProduct() {
        return this.ebsProduct;
    }

    public StreamerProduct getStreamerProduct() {
        return this.streamerProduct;
    }

    public TwitchProduct getTwitchProduct() {
        return this.twitchProduct;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public Instant getStartedAt() {
        return this.startedAt;
    }

    public Instant getExpiredAt() {
        return this.expiredAt;
    }

    public Instant getLoadedAt() {
        return this.loadedAt;
    }

    public Instant getTransactionAt() {
        return this.transactionAt;
    }

    public CopyOnWriteArrayList<SpawnedObject> getSpawnedObjects() {
        return this.spawnedObjects;
    }

    public int getSpawnAmount() {
        return this.spawnAmount;
    }

    private static interface ResetEffectHandler {
        public void execute(int var1);
    }

    private static interface StartEffectHandler {
        public void execute(int var1);
    }
}

