/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.notifications;

import com.google.common.collect.EvictingQueue;
import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.marketplace.MarketplaceEffect;
import com.twitchliveloadout.marketplace.MarketplaceManager;
import com.twitchliveloadout.marketplace.MarketplaceMessages;
import com.twitchliveloadout.marketplace.notifications.Notification;
import com.twitchliveloadout.marketplace.products.EbsNotification;
import com.twitchliveloadout.marketplace.products.MarketplaceProduct;
import com.twitchliveloadout.marketplace.products.TwitchProduct;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationManager {
    private static final Logger log = LoggerFactory.getLogger(NotificationManager.class);
    private final TwitchLiveLoadoutPlugin plugin;
    private final TwitchLiveLoadoutConfig config;
    private final ChatMessageManager chatMessageManager;
    private final Client client;
    private final MarketplaceManager manager;
    private Instant notificationsLockedUntil;
    private ScheduledFuture overheadResetTask;
    private final EvictingQueue<ArrayList<Notification>> notificationGroupQueue = EvictingQueue.create((int)200);

    public NotificationManager(TwitchLiveLoadoutPlugin plugin, TwitchLiveLoadoutConfig config, ChatMessageManager chatMessageManager, Client client, MarketplaceManager manager) {
        this.plugin = plugin;
        this.config = config;
        this.chatMessageManager = chatMessageManager;
        this.client = client;
        this.manager = manager;
    }

    public void onGameTick() {
        this.handleNotificationsQueue();
    }

    public void handleEbsNotifications(MarketplaceProduct marketplaceProduct, MarketplaceEffect marketplaceEffect, ArrayList<EbsNotification> ebsNotifications) {
        if (ebsNotifications == null) {
            return;
        }
        ArrayList<Notification> notificationGroup = new ArrayList<Notification>();
        for (EbsNotification ebsNotification : ebsNotifications) {
            Notification notification = new Notification(marketplaceProduct, marketplaceEffect, ebsNotification);
            if (!ebsNotification.queue.booleanValue()) {
                log.debug("Sending a notification instantly: " + notification.ebsNotification.message);
                this.sendNotification(notification);
                continue;
            }
            log.debug("Queueing a notification: " + notification.ebsNotification.message);
            notificationGroup.add(notification);
        }
        if (notificationGroup.size() <= 0) {
            return;
        }
        this.notificationGroupQueue.add(notificationGroup);
    }

    private void handleNotificationsQueue() {
        if (!this.manager.isActive()) {
            return;
        }
        if (!this.canSendNotification()) {
            return;
        }
        ArrayList notificationGroup = (ArrayList)this.notificationGroupQueue.poll();
        if (notificationGroup == null) {
            return;
        }
        for (Notification notification : notificationGroup) {
            this.sendNotification(notification);
        }
    }

    private void sendNotification(Notification notification) {
        EbsNotification ebsNotification = notification.ebsNotification;
        String messageType = ebsNotification.messageType;
        log.debug("Sending notification: " + notification.ebsNotification.message);
        if ("chat".equals(messageType)) {
            this.sendChatNotification(notification);
        } else if ("overhead".equals(messageType)) {
            this.sendOverheadNotification(notification);
        }
    }

    private void sendChatNotification(Notification notification) {
        String message = this.getMessage(notification);
        ChatMessageBuilder chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message).append(ChatColorType.NORMAL);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(chatMessage.build()).build());
        this.lockNotificationsUntil(1000);
    }

    private void sendOverheadNotification(Notification notification) {
        Player player = this.client.getLocalPlayer();
        String message = this.getMessage(notification);
        int overheadTextDurationMs = this.config.marketplaceOverheadTextDurationS() * 1000;
        if (player == null) {
            return;
        }
        if (this.overheadResetTask != null && !this.overheadResetTask.isDone()) {
            this.overheadResetTask.cancel(false);
        }
        this.plugin.runOnClientThread(() -> player.setOverheadText(message));
        this.overheadResetTask = this.plugin.scheduleOnClientThread(() -> player.setOverheadText(""), overheadTextDurationMs);
        this.lockNotificationsUntil(overheadTextDurationMs + 1000);
    }

    public void forceHideOverheadText() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        if (this.overheadResetTask == null || this.overheadResetTask.isDone()) {
            return;
        }
        this.plugin.runOnClientThread(() -> player.setOverheadText(""));
    }

    private String getMessage(Notification notification) {
        String message = notification.ebsNotification.message;
        MarketplaceProduct marketplaceProduct = notification.marketplaceProduct;
        MarketplaceEffect marketplaceEffect = notification.marketplaceEffect;
        if (marketplaceProduct == null) {
            return message == null ? "Thank you for the donation!" : message;
        }
        TwitchProduct twitchProduct = marketplaceProduct.getTwitchProduct();
        if (message == null) {
            message = twitchProduct == null ? "Thank you {viewerName} for your donation!" : this.config.marketplaceDefaultDonationMessage();
        }
        String formattedMessage = MarketplaceMessages.formatMessage(message, marketplaceProduct, marketplaceEffect);
        return formattedMessage;
    }

    private boolean canSendNotification() {
        return this.notificationsLockedUntil == null || Instant.now().isAfter(this.notificationsLockedUntil);
    }

    private void lockNotificationsUntil(int durationMs) {
        Instant newLockedUntil = Instant.now().plusMillis(durationMs);
        if (this.notificationsLockedUntil != null && newLockedUntil.isBefore(this.notificationsLockedUntil)) {
            return;
        }
        this.notificationsLockedUntil = newLockedUntil;
    }
}

