/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.interfaces;

import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.marketplace.LambdaIterator;
import com.twitchliveloadout.marketplace.MarketplaceEffect;
import com.twitchliveloadout.marketplace.MarketplaceEffectManager;
import com.twitchliveloadout.marketplace.interfaces.CoveringOverlayType;
import com.twitchliveloadout.marketplace.interfaces.OriginalWidget;
import com.twitchliveloadout.marketplace.products.EbsInterfaceWidgetFrame;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetManager
extends MarketplaceEffectManager<EbsInterfaceWidgetFrame> {
    private static final Logger log = LoggerFactory.getLogger(WidgetManager.class);
    private final TwitchLiveLoadoutPlugin plugin;
    private final Client client;
    private final ConcurrentHashMap<Widget, Widget> coveringOverlays = new ConcurrentHashMap();
    private final ConcurrentHashMap<Widget, OriginalWidget> originalWidgets = new ConcurrentHashMap();

    public WidgetManager(TwitchLiveLoadoutPlugin plugin, Client client) {
        super(100);
        this.plugin = plugin;
        this.client = client;
    }

    public void onGameTick() {
        this.ensureCoveringOverlays();
    }

    public void hideCoveringOverlays() {
        LambdaIterator.handleAllValues(this.coveringOverlays, coveringOverlay -> coveringOverlay.setHidden(true));
    }

    private void ensureCoveringOverlays() {
        this.plugin.runOnClientThread(() -> {
            boolean isResized = this.client.isResized();
            if (isResized) {
                this.ensureCoveringOverlay(CoveringOverlayType.RESIZED_CLASSIC);
                this.ensureCoveringOverlay(CoveringOverlayType.RESIZED_MODERN);
            } else {
                this.ensureCoveringOverlay(CoveringOverlayType.FIXED);
            }
        });
    }

    private void ensureCoveringOverlay(CoveringOverlayType overlayType) {
        this.plugin.runOnClientThread(() -> {
            Widget parent = this.client.getWidget(overlayType.getWidgetGroupId(), overlayType.getWidgetChildId());
            if (parent == null) {
                return;
            }
            Widget coveringOverlay = this.coveringOverlays.get(parent);
            if (coveringOverlay != null) {
                if (coveringOverlay.isHidden()) {
                    this.initializeCoveringOverlay(coveringOverlay);
                }
                return;
            }
            coveringOverlay = parent.createChild(3);
            this.coveringOverlays.put(parent, coveringOverlay);
            this.initializeCoveringOverlay(coveringOverlay);
        });
    }

    private void initializeCoveringOverlay(Widget coveringOverlay) {
        if (coveringOverlay == null) {
            return;
        }
        coveringOverlay.setHidden(false);
        coveringOverlay.setFilled(true);
        coveringOverlay.setType(3);
        coveringOverlay.setOpacity(255);
        coveringOverlay.setWidthMode(1);
        coveringOverlay.setHeightMode(1);
        coveringOverlay.setXPositionMode(1);
        coveringOverlay.setYPositionMode(1);
        coveringOverlay.setModelType(1);
        coveringOverlay.setModelId(-1);
        coveringOverlay.setAnimationId(-1);
        coveringOverlay.setModelZoom(1);
        coveringOverlay.revalidate();
    }

    @Override
    protected void applyEffect(MarketplaceEffect<EbsInterfaceWidgetFrame> effect) {
        EbsInterfaceWidgetFrame widgetFrame = effect.getFrame();
        ArrayList<Widget> widgets = this.getWidgets(widgetFrame);
        if (widgets.size() <= 0) {
            return;
        }
        LambdaIterator.handleAll(widgets, widget -> {
            this.registerOriginalWidget((Widget)widget);
            String effectType = widgetFrame.effectType;
            Integer widgetType = widgetFrame.widgetType;
            Integer contentType = widgetFrame.contentType;
            String text = widgetFrame.text;
            Integer textColor = widgetFrame.textColor;
            Integer opacity = widgetFrame.opacity;
            Integer itemId = widgetFrame.itemId;
            Integer itemQuantity = widgetFrame.itemQuantity;
            String name = widgetFrame.name;
            Integer spriteId = widgetFrame.spriteId;
            Integer modelId = widgetFrame.modelId;
            Integer modelZoom = widgetFrame.modelZoom;
            Integer animationId = widgetFrame.animationId;
            this.plugin.runOnClientThread(() -> {
                if ("disable".equals(effectType)) {
                    widget.setHidden(true);
                    return;
                }
                if (widgetType != null) {
                    widget.setType(widgetType.intValue());
                }
                if (contentType != null) {
                    widget.setContentType(contentType.intValue());
                }
                if (text != null) {
                    widget.setText(text);
                }
                if (textColor != null) {
                    widget.setTextColor(textColor.intValue());
                }
                if (opacity != null) {
                    widget.setOpacity(opacity.intValue());
                }
                if (itemId != null) {
                    widget.setItemId(itemId.intValue());
                }
                if (itemQuantity != null) {
                    widget.setItemQuantity(itemQuantity.intValue());
                }
                if (name != null) {
                    widget.setName(name);
                }
                if (spriteId != null) {
                    widget.setSpriteId(spriteId.intValue());
                }
                if (modelId != null) {
                    widget.setModelId(modelId.intValue());
                }
                if (modelZoom != null) {
                    widget.setModelZoom(modelZoom.intValue());
                }
                if (animationId != null) {
                    widget.setAnimationId(animationId.intValue());
                }
            });
        });
    }

    @Override
    protected void restoreEffect(MarketplaceEffect<EbsInterfaceWidgetFrame> effect) {
        EbsInterfaceWidgetFrame widgetFrame = effect.getFrame();
        ArrayList<Widget> widgets = this.getWidgets(widgetFrame);
        LambdaIterator.handleAll(widgets, widget -> {
            if (widget == null || !this.originalWidgets.containsKey(widget)) {
                return;
            }
            OriginalWidget originalWidget = this.originalWidgets.get(widget);
            widget.setHidden(originalWidget.getHidden().booleanValue());
            widget.setType(originalWidget.getType().intValue());
            widget.setContentType(originalWidget.getContentType().intValue());
            widget.setText(originalWidget.getText());
            widget.setTextColor(originalWidget.getTextColor().intValue());
            widget.setOpacity(originalWidget.getOpacity().intValue());
            widget.setItemId(originalWidget.getItemId().intValue());
            widget.setItemQuantity(originalWidget.getItemQuantity().intValue());
            widget.setName(originalWidget.getName());
            widget.setSpriteId(originalWidget.getSpriteId().intValue());
            widget.setModelId(originalWidget.getModelId().intValue());
            widget.setModelZoom(originalWidget.getModelZoom().intValue());
            widget.setAnimationId(originalWidget.getAnimationId().intValue());
        });
    }

    private void registerOriginalWidget(Widget widget) {
        if (widget == null || this.originalWidgets.containsKey(widget)) {
            return;
        }
        OriginalWidget originalWidget = new OriginalWidget(widget);
        this.originalWidgets.put(widget, originalWidget);
    }

    private ArrayList<Widget> getWidgets(EbsInterfaceWidgetFrame widgetFrame) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        String effectType = widgetFrame.effectType;
        if ("overlay".equals(effectType)) {
            widgets.addAll(this.coveringOverlays.values());
        } else {
            Integer parentId = widgetFrame.parentId;
            Integer childId = widgetFrame.childId;
            Integer listIndex = widgetFrame.listIndex;
            Widget widget = this.getWidget(parentId, childId, listIndex);
            if (widget != null) {
                widgets.add(widget);
            }
        }
        return widgets;
    }

    private Widget getWidget(Integer parentId, Integer childId, Integer listIndex) {
        try {
            if (parentId < 0 || childId < 0) {
                return null;
            }
            Widget widget = this.client.getWidget(parentId.intValue(), childId.intValue());
            if (listIndex < 0) {
                return widget;
            }
            return widget.getChild(listIndex.intValue());
        }
        catch (Exception exception) {
            this.plugin.logSupport("Could not get a widget by widget frame, due to the following error:", exception);
            return null;
        }
    }

    @Override
    protected void onAddEffect(MarketplaceEffect<EbsInterfaceWidgetFrame> effect) {
    }

    @Override
    protected void onDeleteEffect(MarketplaceEffect<EbsInterfaceWidgetFrame> effect) {
    }
}

