/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.interfaces;

import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import com.twitchliveloadout.marketplace.MarketplaceEffect;
import com.twitchliveloadout.marketplace.MarketplaceEffectManager;
import com.twitchliveloadout.marketplace.products.EbsMenuOptionFrame;
import com.twitchliveloadout.marketplace.products.MarketplaceProduct;
import java.util.ArrayList;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuManager
extends MarketplaceEffectManager<EbsMenuOptionFrame> {
    private static final Logger log = LoggerFactory.getLogger(MenuManager.class);
    private final TwitchLiveLoadoutConfig config;

    public MenuManager(TwitchLiveLoadoutConfig config) {
        super(100);
        this.config = config;
    }

    public void onGameTick() {
        this.updateEffects();
    }

    public void onMenuOptionClicked(MenuOptionClicked event) {
        MenuEntry menuEntry = event.getMenuEntry();
        String clickedOption = event.getMenuOption();
        String clickedTarget = event.getMenuTarget();
        String clickedEntityType = "";
        if (menuEntry != null) {
            if (menuEntry.getItemId() >= 0) {
                clickedEntityType = "item";
            } else if (menuEntry.getWidget() != null) {
                clickedEntityType = "widget";
            } else if (menuEntry.getNpc() != null) {
                clickedEntityType = "npc";
            } else if (menuEntry.getPlayer() != null) {
                clickedEntityType = "player";
            }
        }
        if (this.config.debugMenuOptionClicks()) {
            // empty if block
        }
        for (MarketplaceEffect effect : this.effects) {
            if (!effect.isActive()) continue;
            MarketplaceProduct marketplaceProduct = effect.getMarketplaceProduct();
            EbsMenuOptionFrame menuOptionFrame = (EbsMenuOptionFrame)effect.getFrame();
            boolean satisfiesOptions = this.verifyPropertyMatch(clickedOption, menuOptionFrame.matchedOptions);
            boolean satisfiesTargets = this.verifyPropertyMatch(clickedTarget, menuOptionFrame.matchedTargets);
            boolean satisfiesEntityTypes = this.verifyPropertyMatch(clickedEntityType, menuOptionFrame.matchedEntityTypes);
            if (!satisfiesOptions || !satisfiesTargets || !satisfiesEntityTypes) continue;
            if ("disable".equals(menuOptionFrame.type)) {
                event.consume();
            }
            marketplaceProduct.triggerEffects(menuOptionFrame.onClickEffects, 0, null, effect, false, null);
        }
    }

    private boolean verifyPropertyMatch(String property, ArrayList<String> candidates) {
        if (candidates == null) {
            return true;
        }
        if (property == null) {
            return false;
        }
        String formattedProperty = Text.removeTags((String)property.toLowerCase().trim());
        for (String candidate : candidates) {
            String formattedCandidate;
            if (candidate == null || !formattedProperty.matches(formattedCandidate = candidate.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onAddEffect(MarketplaceEffect<EbsMenuOptionFrame> effect) {
    }

    @Override
    protected void onDeleteEffect(MarketplaceEffect<EbsMenuOptionFrame> effect) {
    }

    @Override
    protected void restoreEffect(MarketplaceEffect<EbsMenuOptionFrame> effect) {
    }

    @Override
    protected void applyEffect(MarketplaceEffect<EbsMenuOptionFrame> effect) {
    }
}

