/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.animations;

import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.marketplace.MarketplaceEffect;
import com.twitchliveloadout.marketplace.MarketplaceEffectManager;
import com.twitchliveloadout.marketplace.MarketplaceManager;
import com.twitchliveloadout.marketplace.animations.ActorAnimation;
import com.twitchliveloadout.marketplace.products.EbsMovementFrame;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.PlayerChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationManager
extends MarketplaceEffectManager<EbsMovementFrame> {
    private static final Logger log = LoggerFactory.getLogger(AnimationManager.class);
    private final TwitchLiveLoadoutPlugin plugin;
    private final Client client;
    private final ConcurrentHashMap<ActorAnimation, Integer> originalMovementAnimations = new ConcurrentHashMap();
    private Instant animationLockedUntil;
    private Instant graphicLockedUntil;

    public AnimationManager(TwitchLiveLoadoutPlugin plugin, Client client) {
        super(100);
        this.plugin = plugin;
        this.client = client;
    }

    public void onGameTick() {
        this.cleanInactiveEffects();
    }

    public void onPlayerChanged(PlayerChanged playerChanged) {
        boolean isLocalPlayer;
        Player player = playerChanged.getPlayer();
        Player localPlayer = this.client.getLocalPlayer();
        boolean bl = isLocalPlayer = localPlayer == player;
        if (!isLocalPlayer) {
            return;
        }
        this.recordOriginalMovementAnimations();
        this.applyActiveEffects();
    }

    @Override
    protected void applyEffect(MarketplaceEffect<EbsMovementFrame> effect) {
        Player player = this.client.getLocalPlayer();
        EbsMovementFrame movementFrame = effect.getFrame();
        this.plugin.runOnClientThread(() -> {
            for (ActorAnimation animation : ActorAnimation.values()) {
                Integer animationId = this.getCurrentMovementAnimation(animation, movementFrame);
                if (animationId == null || animationId < 0) {
                    return;
                }
                animation.setAnimation((Actor)player, animationId);
            }
        });
    }

    @Override
    protected void restoreEffect(MarketplaceEffect<EbsMovementFrame> effect) {
        Player player = this.client.getLocalPlayer();
        this.plugin.runOnClientThread(() -> {
            for (ActorAnimation animation : ActorAnimation.values()) {
                if (!this.originalMovementAnimations.containsKey((Object)animation)) continue;
                int originalAnimationId = this.originalMovementAnimations.get((Object)animation);
                animation.setAnimation((Actor)player, originalAnimationId);
            }
        });
        this.applyActiveEffects();
    }

    @Override
    protected void onAddEffect(MarketplaceEffect<EbsMovementFrame> effect) {
        this.applyActiveEffects();
        if (this.originalMovementAnimations.size() <= 0) {
            this.recordOriginalMovementAnimations();
        }
    }

    @Override
    protected void onDeleteEffect(MarketplaceEffect<EbsMovementFrame> effect) {
    }

    private void recordOriginalMovementAnimations() {
        Player player = this.client.getLocalPlayer();
        this.originalMovementAnimations.clear();
        for (ActorAnimation animation : ActorAnimation.values()) {
            this.originalMovementAnimations.put(animation, animation.getAnimation((Actor)player));
        }
    }

    public void setPlayerGraphic(int graphicKey, int graphicId, int graphicHeight, long delayMs, long durationMs) {
        this.handleLockedPlayerEffect(delayMs, durationMs, () -> this.graphicLockedUntil, () -> {}, player -> player.createSpotAnim(graphicKey, graphicId, graphicHeight, 0));
    }

    public void resetPlayerGraphic(int graphicKey, int delayMs) {
        this.handleLocalPlayer(player -> this.plugin.scheduleOnClientThread(() -> player.removeSpotAnim(graphicKey), delayMs));
    }

    public void setPlayerAnimation(int animationId, long delayMs, long durationMs) {
        this.handleLockedPlayerEffect(delayMs, durationMs, () -> this.animationLockedUntil, () -> {
            this.animationLockedUntil = Instant.now().plusMillis(durationMs);
        }, player -> {
            player.setAnimationFrame(0);
            player.setAnimation(animationId);
        });
    }

    public void resetPlayerAnimation(int delayMs) {
        this.handleLocalPlayer(player -> this.plugin.scheduleOnClientThread(() -> {
            player.setAnimation(-1);
            player.setAnimationFrame(0);
        }, delayMs));
    }

    private void handleLockedPlayerEffect(long delayMs, long durationMs, MarketplaceManager.GetTimeHandler getLockedUntil, MarketplaceManager.EmptyHandler updateLockHandler, MarketplaceManager.PlayerHandler playerHandler) {
        this.handleLocalPlayer(player -> this.plugin.scheduleOnClientThread(() -> {
            boolean isLocked;
            Instant lockedUntil = getLockedUntil.execute();
            boolean bl = isLocked = lockedUntil != null && Instant.now().isBefore(lockedUntil);
            if (isLocked) {
                return;
            }
            updateLockHandler.execute();
            playerHandler.execute(player);
        }, delayMs));
    }

    private void handleLocalPlayer(MarketplaceManager.PlayerHandler playerHandler) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        playerHandler.execute(player);
    }

    public int getCurrentMovementAnimation(ActorAnimation animation, EbsMovementFrame movementFrame) {
        int animationId = -1;
        int fallbackAnimationId = -1;
        if (movementFrame == null) {
            return animationId;
        }
        switch (animation) {
            case RUN: {
                animationId = movementFrame.run;
                fallbackAnimationId = movementFrame.walk;
                break;
            }
            case IDLE: {
                animationId = movementFrame.idle;
                break;
            }
            case IDLE_ROTATE_LEFT: {
                animationId = movementFrame.idleRotateLeft;
                fallbackAnimationId = movementFrame.idle;
                break;
            }
            case IDLE_ROTATE_RIGHT: {
                animationId = movementFrame.idleRotateRight;
                fallbackAnimationId = movementFrame.idle;
                break;
            }
            case WALK: {
                animationId = movementFrame.walk;
                break;
            }
            case WALK_ROTATE_180: {
                animationId = movementFrame.walkRotate180;
                fallbackAnimationId = movementFrame.walk;
                break;
            }
            case WALK_ROTATE_LEFT: {
                animationId = movementFrame.walkRotateLeft;
                fallbackAnimationId = movementFrame.walk;
                break;
            }
            case WALK_ROTATE_RIGHT: {
                animationId = movementFrame.walkRotateRight;
                fallbackAnimationId = movementFrame.walk;
            }
        }
        if (animationId < 0 && fallbackAnimationId >= 0) {
            return fallbackAnimationId;
        }
        return animationId;
    }
}

