/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace.animations;

import net.runelite.api.Actor;

public enum ActorAnimation {
    IDLE(Actor::getIdlePoseAnimation, Actor::setIdlePoseAnimation),
    IDLE_ROTATE_LEFT(Actor::getIdleRotateLeft, Actor::setIdleRotateLeft),
    IDLE_ROTATE_RIGHT(Actor::getIdleRotateRight, Actor::setIdleRotateRight),
    WALK(Actor::getWalkAnimation, Actor::setWalkAnimation),
    WALK_ROTATE_180(Actor::getWalkRotate180, Actor::setWalkRotate180),
    WALK_ROTATE_LEFT(Actor::getWalkRotateLeft, Actor::setWalkRotateLeft),
    WALK_ROTATE_RIGHT(Actor::getWalkRotateRight, Actor::setWalkRotateRight),
    RUN(Actor::getRunAnimation, Actor::setRunAnimation);

    private final AnimationGetter animationGetter;
    private final AnimationSetter animationSetter;

    private ActorAnimation(AnimationGetter animationGetter, AnimationSetter animationSetter) {
        this.animationGetter = animationGetter;
        this.animationSetter = animationSetter;
    }

    public int getAnimation(Actor actor) {
        if (actor == null) {
            return -1;
        }
        return this.animationGetter.getAnimation(actor);
    }

    public void setAnimation(Actor actor, int animationId) {
        this.animationSetter.setAnimation(actor, animationId);
    }

    public AnimationGetter getAnimationGetter() {
        return this.animationGetter;
    }

    static interface AnimationSetter {
        public void setAnimation(Actor var1, int var2);
    }

    static interface AnimationGetter {
        public int getAnimation(Actor var1);
    }
}

