/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.marketplace.LambdaIterator;
import com.twitchliveloadout.marketplace.MarketplaceRandomizers;
import com.twitchliveloadout.marketplace.MarketplaceTimer;
import com.twitchliveloadout.marketplace.animations.AnimationManager;
import com.twitchliveloadout.marketplace.interfaces.MenuManager;
import com.twitchliveloadout.marketplace.interfaces.WidgetManager;
import com.twitchliveloadout.marketplace.notifications.NotificationManager;
import com.twitchliveloadout.marketplace.products.EbsModelPlacement;
import com.twitchliveloadout.marketplace.products.EbsProduct;
import com.twitchliveloadout.marketplace.products.MarketplaceProduct;
import com.twitchliveloadout.marketplace.products.StreamerProduct;
import com.twitchliveloadout.marketplace.products.TwitchProduct;
import com.twitchliveloadout.marketplace.sounds.SoundManager;
import com.twitchliveloadout.marketplace.spawns.SpawnManager;
import com.twitchliveloadout.marketplace.spawns.SpawnOverheadManager;
import com.twitchliveloadout.marketplace.spawns.SpawnPoint;
import com.twitchliveloadout.marketplace.spawns.SpawnedObject;
import com.twitchliveloadout.marketplace.transactions.TwitchTransaction;
import com.twitchliveloadout.marketplace.transmogs.TransmogManager;
import com.twitchliveloadout.twitch.TwitchApi;
import com.twitchliveloadout.twitch.TwitchSegmentType;
import com.twitchliveloadout.twitch.TwitchState;
import com.twitchliveloadout.twitch.TwitchStateEntry;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PlayerChanged;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplaceManager {
    private static final Logger log = LoggerFactory.getLogger(MarketplaceManager.class);
    private final TwitchLiveLoadoutPlugin plugin;
    private final TwitchApi twitchApi;
    private final TwitchState twitchState;
    private final Client client;
    private final TwitchLiveLoadoutConfig config;
    private final SpawnManager spawnManager;
    private final SpawnOverheadManager spawnOverheadManager;
    private final AnimationManager animationManager;
    private final TransmogManager transmogManager;
    private final WidgetManager widgetManager;
    private final MenuManager menuManager;
    private final NotificationManager notificationManager;
    private final SoundManager soundManager;
    private final Gson gson;
    private final CopyOnWriteArrayList<MarketplaceProduct> activeProducts = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<StreamerProduct> streamerProducts = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<EbsProduct> ebsProducts = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TwitchTransaction> queuedTransactions = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TwitchTransaction> archivedTransactions = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<String> handledTransactionIds = new CopyOnWriteArrayList();
    private String lastTransactionId = null;
    private final ConcurrentHashMap<String, Instant> timerLastTriggeredAt = new ConcurrentHashMap();
    private boolean isActive = true;
    private boolean isFetchingEbsTransactions = false;
    private boolean isFetchingEbsProducts = false;
    private boolean fetchingEbsTransactionsErrored = false;
    private final ConcurrentHashMap<String, Instant> streamerProductCooldownUntil = new ConcurrentHashMap();
    private Instant sharedCooldownUntil;
    private int currentTestEbsProductIndex = 0;
    private Instant lastEbsProductTestedAt;

    public MarketplaceManager(TwitchLiveLoadoutPlugin plugin, TwitchApi twitchApi, TwitchState twitchState, Client client, TwitchLiveLoadoutConfig config, ChatMessageManager chatMessageManager, ItemManager itemManager, OverlayManager overlayManager, Gson gson) {
        this.plugin = plugin;
        this.twitchApi = twitchApi;
        this.twitchState = twitchState;
        this.client = client;
        this.config = config;
        this.gson = gson;
        this.spawnManager = new SpawnManager(plugin, client);
        this.spawnOverheadManager = new SpawnOverheadManager(client, overlayManager);
        this.animationManager = new AnimationManager(plugin, client);
        this.transmogManager = new TransmogManager(plugin, client, itemManager);
        this.notificationManager = new NotificationManager(plugin, config, chatMessageManager, client, this);
        this.widgetManager = new WidgetManager(plugin, client);
        this.menuManager = new MenuManager(config);
        this.soundManager = new SoundManager(client, config);
    }

    public void fetchAsyncNewEbsTransactions() {
        if (this.isFetchingEbsTransactions) {
            return;
        }
        if (this.streamerProducts.size() <= 0 || this.ebsProducts.size() <= 0) {
            return;
        }
        try {
            this.isFetchingEbsTransactions = true;
            this.twitchApi.fetchAsyncEbsTransactions(this.lastTransactionId, response -> {
                this.isFetchingEbsTransactions = false;
                this.fetchingEbsTransactionsErrored = false;
                JsonObject result = new JsonParser().parse(response.body().string()).getAsJsonObject();
                boolean status = result.get("status").getAsBoolean();
                String message = result.get("message").getAsString();
                JsonArray newTransactionsJson = result.getAsJsonArray("transactions");
                ArrayList newTransactions = new ArrayList();
                AtomicBoolean updatedLastTransactionId = new AtomicBoolean(false);
                if (!status) {
                    this.plugin.logSupport("Could not fetch EBS transactions from Twitch as the status is invalid with message: " + message);
                    this.fetchingEbsTransactionsErrored = true;
                    return;
                }
                newTransactionsJson.forEach(element -> {
                    try {
                        TwitchTransaction twitchTransaction = (TwitchTransaction)this.gson.fromJson(element, TwitchTransaction.class);
                        String transactionId = twitchTransaction.id;
                        if (!updatedLastTransactionId.get()) {
                            this.lastTransactionId = transactionId;
                            updatedLastTransactionId.set(true);
                        }
                        if (this.handledTransactionIds.contains(transactionId)) {
                            log.info("Skipping Twitch transaction because it was already handled: " + transactionId);
                            return;
                        }
                        this.handledTransactionIds.add(transactionId);
                        newTransactions.add(twitchTransaction);
                        log.info("Queued a new Twitch transaction with ID: " + transactionId);
                    }
                    catch (Exception exception) {
                        log.error("Could not parse Twitch Extension transaction due to the following error: ", (Throwable)exception);
                    }
                });
                if (newTransactions.size() <= 0) {
                    return;
                }
                this.archivedTransactions.addAll(0, newTransactions);
                Collections.reverse(newTransactions);
                this.queuedTransactions.addAll(newTransactions);
                this.updateMarketplacePanel();
                while (this.archivedTransactions.size() > this.config.marketplaceTransactionHistoryAmount()) {
                    this.archivedTransactions.remove(this.archivedTransactions.size() - 1);
                }
            }, exception -> {
                this.isFetchingEbsTransactions = false;
                this.fetchingEbsTransactionsErrored = true;
            });
        }
        catch (Exception exception2) {
            // empty catch block
        }
        this.isFetchingEbsTransactions = false;
    }

    public void applyQueuedTransactions() {
        if (!this.plugin.isLoggedIn()) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        for (TwitchTransaction transaction : this.queuedTransactions) {
            int activeProductAmount = this.activeProducts.size();
            if (activeProductAmount >= this.config.marketplaceMaxActiveProducts()) break;
            try {
                SpawnPoint spawnPoint;
                EbsModelPlacement requiredModelPlacement;
                boolean isValidEbsProduct;
                TwitchProduct twitchProduct = this.getTwitchProductByTransaction(transaction);
                StreamerProduct streamerProduct = this.getStreamerProductByTransaction(transaction);
                if (twitchProduct == null || streamerProduct == null) continue;
                String streamerProductId = streamerProduct.id;
                String ebsProductId = streamerProduct.ebsProductId;
                Instant now = Instant.now();
                Instant cooldownUntil = this.streamerProductCooldownUntil.get(streamerProductId);
                EbsProduct ebsProduct = this.getEbsProductById(ebsProductId);
                boolean isProductCoolingDown = cooldownUntil != null && now.isBefore(cooldownUntil);
                boolean isSharedCoolingDown = this.sharedCooldownUntil != null && now.isBefore(this.sharedCooldownUntil);
                boolean bl = isValidEbsProduct = ebsProduct != null && ebsProduct.enabled != false && ebsProduct.behaviour != null;
                if (isProductCoolingDown || isSharedCoolingDown || !isValidEbsProduct || (requiredModelPlacement = ebsProduct.behaviour.requiredModelPlacement) != null && (spawnPoint = this.spawnManager.getSpawnPoint(requiredModelPlacement, null)) == null) continue;
                log.info("Found a valid transaction that we can start: " + transaction.id);
                log.info("Twitch product SKU: " + streamerProduct.twitchProductSku);
                log.info("Streamer product name: " + streamerProduct.name);
                log.info("Ebs product ID: " + ebsProduct.id);
                this.queuedTransactions.remove(transaction);
                if (ebsProduct.version != 1) {
                    log.info("Skipping transaction the version number of the EBS product (" + ebsProduct.version + ") is not compatible. Transaction ID: " + transaction.id);
                    continue;
                }
                if (ebsProduct.dangerous.booleanValue() && !this.plugin.canPerformDangerousEffects()) {
                    log.info("Skipping transaction because it is deemed dangerous and protection is on: " + transaction.id);
                    continue;
                }
                MarketplaceProduct newProduct = new MarketplaceProduct(this, transaction, ebsProduct, streamerProduct, twitchProduct);
                log.info("The marketplace product is configured for the time-frame:");
                log.info("It starts at: " + newProduct.getStartedAt());
                if (newProduct.isExpired()) {
                    if (!newProduct.isExpired(-30000)) {
                        transaction.timestamp = Instant.now().toString();
                        log.info("Transaction falls within the clock tolerance settings and is therefore requeued with a new timestamp: " + transaction.timestamp);
                        this.queuedTransactions.add(transaction);
                    }
                    log.info("It is skipped, because it has already expired at: " + newProduct.getExpiredAt());
                    continue;
                }
                log.info("It expires at: " + newProduct.getExpiredAt() + ", which is in " + newProduct.getExpiresInMs() + "ms");
                newProduct.start();
                this.updateCooldown(streamerProduct);
                this.activeProducts.add(newProduct);
                this.updateMarketplacePanel();
            }
            catch (Exception exception) {
                this.queuedTransactions.remove(transaction);
                log.error("Could not handle transaction due to the following error, it is being skipped: ", (Throwable)exception);
                log.error("The ID of the skipped transaction was: " + transaction.id);
            }
        }
    }

    public void rerunTransaction(TwitchTransaction transaction) {
        if (transaction == null) {
            return;
        }
        String transactionId = transaction.id;
        for (MarketplaceProduct marketplaceProduct : this.activeProducts) {
            if (!marketplaceProduct.getTransaction().id.equals(transactionId)) continue;
            return;
        }
        log.info("A transaction is going to be rerun, transaction ID: " + transactionId);
        transaction.timestamp = Instant.now().toString();
        this.handledTransactionIds.remove(transactionId);
        this.queuedTransactions.add(transaction);
    }

    public void testNextEbsProduct() {
        Instant now = Instant.now();
        if (this.lastEbsProductTestedAt != null && this.lastEbsProductTestedAt.plusSeconds(this.config.testRandomEventsDelay()).isAfter(now)) {
            return;
        }
        if (this.ebsProducts.size() <= 0) {
            return;
        }
        if (this.currentTestEbsProductIndex >= this.ebsProducts.size() || this.currentTestEbsProductIndex < 0) {
            this.currentTestEbsProductIndex = 0;
        }
        EbsProduct ebsProduct = this.ebsProducts.get(this.currentTestEbsProductIndex);
        if (this.config.testRandomEventsRandomly()) {
            ArrayList<EbsProduct> newEbsProducts = new ArrayList<EbsProduct>();
            newEbsProducts.addAll(this.ebsProducts);
            ebsProduct = (EbsProduct)MarketplaceRandomizers.getRandomEntryFromList(newEbsProducts);
        }
        this.testEbsProduct(ebsProduct);
        ++this.currentTestEbsProductIndex;
        this.lastEbsProductTestedAt = now;
    }

    private void testEbsProduct(EbsProduct ebsProduct) {
    }

    private String generateRandomTestId() {
        return "test_" + UUID.randomUUID();
    }

    private void updateCooldown(StreamerProduct streamerProduct) {
        if (streamerProduct == null) {
            return;
        }
        Instant now = Instant.now();
        String streamerProductId = streamerProduct.id;
        Integer productCooldownSeconds = streamerProduct.cooldown;
        Integer sharedCooldownSeconds = this.config.marketplaceSharedCooldownS();
        if (sharedCooldownSeconds > 0) {
            this.sharedCooldownUntil = now.plusSeconds(sharedCooldownSeconds.intValue());
            this.twitchState.setCurrentSharedCooldown(this.sharedCooldownUntil);
        }
        if (productCooldownSeconds > 0) {
            Instant cooldownUntil = now.plusSeconds(productCooldownSeconds.intValue());
            this.streamerProductCooldownUntil.put(streamerProductId, cooldownUntil);
            this.twitchState.setCurrentProductCooldowns(this.streamerProductCooldownUntil);
        }
    }

    public void cleanExpiredProducts() {
        this.handleActiveProducts(marketplaceProduct -> {
            boolean skipDangerous;
            boolean bl = skipDangerous = marketplaceProduct.isDangerous() && !this.plugin.canPerformDangerousEffects();
            if (!marketplaceProduct.isExpired() && !skipDangerous) {
                return;
            }
            marketplaceProduct.stop(false);
            this.activeProducts.remove(marketplaceProduct);
            this.updateMarketplacePanel();
            String transactionId = marketplaceProduct.getTransaction().id;
            String ebsProductId = marketplaceProduct.getEbsProduct().id;
            int spawnAmount = marketplaceProduct.getSpawnAmount();
            log.info("Cleaned an expired marketplace product (EBS ID: " + ebsProductId + ", spawn amount: " + spawnAmount + ") for transaction: " + transactionId);
        });
        this.spawnManager.handleAllSpawnedObjects(spawnedObject -> {
            boolean hasExpiry;
            MarketplaceProduct product = spawnedObject.getProduct();
            boolean bl = hasExpiry = spawnedObject.getExpiredAt() != null;
            if (hasExpiry && !spawnedObject.isExpired() || this.activeProducts.contains(product)) {
                return;
            }
            spawnedObject.hide();
            this.spawnManager.deregisterSpawnedObjectPlacement(spawnedObject);
        });
    }

    public void updateStreamerProducts() {
        JsonObject segmentContent = this.twitchApi.getConfigurationSegmentContent(TwitchSegmentType.BROADCASTER);
        if (segmentContent == null) {
            return;
        }
        try {
            JsonArray rawStreamerProducts = segmentContent.getAsJsonArray(TwitchStateEntry.STREAMER_PRODUCTS.getKey());
            if (rawStreamerProducts == null) {
                return;
            }
            CopyOnWriteArrayList newStreamerProducts = new CopyOnWriteArrayList();
            rawStreamerProducts.forEach(element -> {
                try {
                    JsonObject rawStreamerProduct = element.getAsJsonObject();
                    StreamerProduct streamerProduct = (StreamerProduct)this.gson.fromJson((JsonElement)rawStreamerProduct, StreamerProduct.class);
                    newStreamerProducts.add(streamerProduct);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.streamerProducts = newStreamerProducts;
        }
        catch (Exception exception) {
            this.plugin.logSupport("Could not parse the raw streamer products to a valid set of products:", exception);
        }
    }

    public void updateAsyncEbsProducts() {
        if (this.isFetchingEbsProducts) {
            return;
        }
        if (this.streamerProducts.size() <= 0 && this.ebsProducts.size() > 0) {
            return;
        }
        try {
            this.isFetchingEbsProducts = true;
            this.twitchApi.fetchAsyncEbsProducts(response -> {
                this.isFetchingEbsProducts = false;
                JsonObject result = new JsonParser().parse(response.body().string()).getAsJsonObject();
                boolean status = result.get("status").getAsBoolean();
                String message = result.get("message").getAsString();
                JsonArray products = result.getAsJsonArray("products");
                if (!status) {
                    this.plugin.logSupport("Could not fetch EBS products from Twitch as the status is invalid with message: " + message);
                    return;
                }
                CopyOnWriteArrayList newEbsProducts = new CopyOnWriteArrayList();
                products.forEach(element -> {
                    try {
                        EbsProduct ebsProduct = (EbsProduct)this.gson.fromJson(element, EbsProduct.class);
                        newEbsProducts.add(ebsProduct);
                    }
                    catch (Exception exception) {
                        this.plugin.logSupport("Could not parse the raw EBS product to a valid product: ", exception);
                    }
                });
                this.ebsProducts = newEbsProducts;
            }, exception -> {
                this.isFetchingEbsProducts = false;
            });
        }
        catch (Exception exception2) {
            this.plugin.logSupport("Could not fetch the new EBS products due to the following error: ", exception2);
        }
    }

    private void updateMarketplacePanel() {
        this.plugin.getPluginPanel().getMarketplacePanel().requestRebuild();
    }

    public CopyOnWriteArrayList<MarketplaceProduct> getActiveProducts() {
        return new CopyOnWriteArrayList<MarketplaceProduct>(this.activeProducts);
    }

    public CopyOnWriteArrayList<StreamerProduct> getStreamerProducts() {
        return new CopyOnWriteArrayList<StreamerProduct>(this.streamerProducts);
    }

    public CopyOnWriteArrayList<TwitchTransaction> getQueuedTransactions() {
        return new CopyOnWriteArrayList<TwitchTransaction>(this.queuedTransactions);
    }

    public CopyOnWriteArrayList<TwitchTransaction> getArchivedTransactions() {
        return new CopyOnWriteArrayList<TwitchTransaction>(this.archivedTransactions);
    }

    public void onPlayerChanged(PlayerChanged playerChanged) {
        if (!this.plugin.isLoggedIn()) {
            return;
        }
        this.transmogManager.onPlayerChanged(playerChanged);
        this.animationManager.onPlayerChanged(playerChanged);
    }

    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        this.spawnManager.onGameStateChanged(gameStateChanged);
        this.animationManager.onGameStateChanged(gameStateChanged);
        this.transmogManager.onGameStateChanged(gameStateChanged);
    }

    public void onClientTick() {
        Instant now = Instant.now();
        if (!this.plugin.isLoggedIn()) {
            return;
        }
        if (this.passTimerOnce(MarketplaceTimer.RESPAWNS, now)) {
            this.spawnManager.respawnRequested();
        }
        if (this.passTimerOnce(MarketplaceTimer.RECORD_LOCATION, now)) {
            this.spawnManager.recordPlayerLocation();
        }
        if (this.passTimerOnce(MarketplaceTimer.WIDGETS, now)) {
            this.widgetManager.updateEffects();
        }
        if (this.passTimerOnce(MarketplaceTimer.PRODUCT_BEHAVIOURS, now)) {
            this.handleActiveProducts(marketplaceProduct -> marketplaceProduct.handleBehaviour());
        }
        if (this.passTimerOnce(MarketplaceTimer.PRODUCT_EXPIRED_SPAWNS, now)) {
            this.handleActiveProducts(marketplaceProduct -> marketplaceProduct.cleanExpiredSpawnedObjects());
        }
        if (this.passTimerOnce(MarketplaceTimer.PRODUCT_SPAWN_ROTATIONS, now)) {
            this.handleActiveProducts(marketplaceProduct -> marketplaceProduct.handleSpawnRotations());
        }
    }

    public void onGameTick() {
        this.notificationManager.onGameTick();
        this.menuManager.onGameTick();
        this.widgetManager.onGameTick();
        this.transmogManager.onGameTick();
        this.animationManager.onGameTick();
        this.spawnOverheadManager.onGameTick();
    }

    public void onMenuOptionClicked(MenuOptionClicked event) {
        this.menuManager.onMenuOptionClicked(event);
    }

    private boolean passTimerOnce(MarketplaceTimer timer, Instant now) {
        boolean isPassed;
        if (timer == null) {
            return false;
        }
        String name = timer.getName();
        int delayMs = timer.getDelayMs();
        Instant lastTriggeredAt = this.timerLastTriggeredAt.get(name);
        boolean bl = isPassed = lastTriggeredAt == null || now.isAfter(lastTriggeredAt.plusMillis(delayMs));
        if (isPassed) {
            this.timerLastTriggeredAt.put(name, now);
        }
        return isPassed;
    }

    public StreamerProduct getStreamerProductByTransaction(TwitchTransaction transaction) {
        TwitchProduct twitchProduct = this.getTwitchProductByTransaction(transaction);
        if (twitchProduct == null) {
            return null;
        }
        String twitchProductSku = twitchProduct.sku;
        StreamerProduct streamerProduct = this.getStreamerProductBySku(twitchProductSku);
        return streamerProduct;
    }

    public TwitchProduct getTwitchProductByTransaction(TwitchTransaction transaction) {
        if (transaction == null) {
            return null;
        }
        TwitchProduct twitchProduct = transaction.product_data;
        return twitchProduct;
    }

    private StreamerProduct getStreamerProductBySku(String twitchProductSku) {
        for (StreamerProduct candidateStreamerProduct : this.streamerProducts) {
            if (!twitchProductSku.equals(candidateStreamerProduct.twitchProductSku)) continue;
            return candidateStreamerProduct;
        }
        return null;
    }

    private EbsProduct getEbsProductById(String ebsProductId) {
        for (EbsProduct candidateEbsProduct : this.ebsProducts) {
            if (!ebsProductId.equals(candidateEbsProduct.id)) continue;
            return candidateEbsProduct;
        }
        return null;
    }

    public void forceStopActiveProducts() {
        this.handleActiveProducts(product -> product.stop(true));
    }

    public void pauseActiveProducts() {
        this.handleActiveProducts(MarketplaceProduct::pause);
        this.isActive = false;
    }

    public void playActiveProducts() {
        this.isActive = true;
        this.handleActiveProducts(MarketplaceProduct::play);
        this.transmogManager.applyActiveEffects();
        this.animationManager.applyActiveEffects();
    }

    public void handleActiveProducts(LambdaIterator.ValueHandler<MarketplaceProduct> handler) {
        LambdaIterator.handleAll(this.activeProducts, handler);
    }

    public void disable() {
        this.forceStopActiveProducts();
        this.animationManager.forceCleanAllEffects();
        this.transmogManager.forceCleanAllEffects();
        this.menuManager.forceCleanAllEffects();
        this.widgetManager.forceCleanAllEffects();
        this.widgetManager.hideCoveringOverlays();
        this.notificationManager.forceHideOverheadText();
        this.spawnOverheadManager.forceCleanAllEffects();
    }

    public void shutDown() {
        this.disable();
        this.spawnOverheadManager.removeOverlay();
    }

    public TwitchLiveLoadoutPlugin getPlugin() {
        return this.plugin;
    }

    public Client getClient() {
        return this.client;
    }

    public TwitchLiveLoadoutConfig getConfig() {
        return this.config;
    }

    public SpawnManager getSpawnManager() {
        return this.spawnManager;
    }

    public SpawnOverheadManager getSpawnOverheadManager() {
        return this.spawnOverheadManager;
    }

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    public TransmogManager getTransmogManager() {
        return this.transmogManager;
    }

    public WidgetManager getWidgetManager() {
        return this.widgetManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public Gson getGson() {
        return this.gson;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isFetchingEbsTransactionsErrored() {
        return this.fetchingEbsTransactionsErrored;
    }

    public static interface PlayerHandler {
        public void execute(Player var1);
    }

    public static interface SpawnedObjectHandler {
        public void execute(SpawnedObject var1);
    }

    public static interface GetTimeHandler {
        public Instant execute();
    }

    public static interface EmptyHandler {
        public void execute();
    }
}

