/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace;

import com.twitchliveloadout.marketplace.MarketplaceEffect;
import com.twitchliveloadout.marketplace.products.EbsEffectFrame;
import com.twitchliveloadout.marketplace.products.MarketplaceProduct;
import com.twitchliveloadout.marketplace.spawns.SpawnedObject;
import java.time.Instant;
import java.util.concurrent.CopyOnWriteArrayList;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarketplaceEffectManager<FrameType extends EbsEffectFrame> {
    private static final Logger log = LoggerFactory.getLogger(MarketplaceEffectManager.class);
    private final int maxEffectAmount;
    protected final CopyOnWriteArrayList<MarketplaceEffect<FrameType>> effects = new CopyOnWriteArrayList();

    public MarketplaceEffectManager(int maxEffectAmount) {
        this.maxEffectAmount = maxEffectAmount;
    }

    public void updateEffects() {
        this.cleanInactiveEffects();
        this.applyActiveEffects();
    }

    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState newGameState = gameStateChanged.getGameState();
        if (newGameState == GameState.LOGGED_IN) {
            this.applyActiveEffects();
        }
    }

    public void addEffect(MarketplaceProduct product, FrameType frame, SpawnedObject spawnedObject) {
        if (this.effects.size() >= this.maxEffectAmount) {
            return;
        }
        if (product == null || frame == null) {
            return;
        }
        Integer durationMs = ((EbsEffectFrame)frame).durationMs;
        Double durationPercentage = ((EbsEffectFrame)frame).durationPercentage;
        long productExpiresInMs = product.getExpiresInMs();
        Instant expiresAt = Instant.now().plusMillis(productExpiresInMs);
        if (durationMs != null && durationMs >= 0) {
            expiresAt = Instant.now().plusMillis(durationMs.intValue());
        } else if (durationPercentage != null && durationPercentage >= 0.0) {
            long durationMsFromPercentage = (long)((double)productExpiresInMs * durationPercentage);
            expiresAt = Instant.now().plusMillis(durationMsFromPercentage);
        }
        MarketplaceEffect<FrameType> effect = new MarketplaceEffect<FrameType>(product, frame, spawnedObject, expiresAt);
        this.effects.add(effect);
        this.onAddEffect(effect);
    }

    protected void cleanInactiveEffects() {
        this.cleanEffects(false);
    }

    public void forceCleanAllEffects() {
        this.cleanEffects(true);
    }

    private void cleanEffects(boolean forceStop) {
        for (MarketplaceEffect<FrameType> effect : this.effects) {
            MarketplaceProduct marketplaceProduct = effect.getMarketplaceProduct();
            boolean isExpired = effect.isExpired() || marketplaceProduct.isExpired();
            boolean isActive = marketplaceProduct.isActive();
            boolean isPaused = marketplaceProduct.isPaused();
            boolean isApplied = effect.isApplied();
            if (isExpired || forceStop) {
                this.effects.remove(effect);
                this.onDeleteEffect(effect);
                this.restoreEffect(effect);
                effect.setApplied(false);
                continue;
            }
            if (isActive || !isApplied && isPaused) continue;
            this.restoreEffect(effect);
            effect.setApplied(false);
        }
    }

    protected void applyActiveEffects() {
        for (MarketplaceEffect<FrameType> effect : this.effects) {
            MarketplaceProduct marketplaceProduct = effect.getMarketplaceProduct();
            boolean isActive = marketplaceProduct.isActive();
            if (!isActive) continue;
            this.applyEffect(effect);
            effect.setApplied(true);
        }
    }

    protected abstract void onAddEffect(MarketplaceEffect<FrameType> var1);

    protected abstract void onDeleteEffect(MarketplaceEffect<FrameType> var1);

    protected abstract void restoreEffect(MarketplaceEffect<FrameType> var1);

    protected abstract void applyEffect(MarketplaceEffect<FrameType> var1);
}

