/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.marketplace;

import com.twitchliveloadout.marketplace.products.EbsEffectFrame;
import com.twitchliveloadout.marketplace.products.MarketplaceProduct;
import com.twitchliveloadout.marketplace.spawns.SpawnedObject;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;

public class MarketplaceEffect<K extends EbsEffectFrame> {
    private final MarketplaceProduct marketplaceProduct;
    private final K frame;
    @Nullable
    private final SpawnedObject spawnedObject;
    private final Instant startedAt;
    private final Instant expiresAt;
    private boolean isApplied = false;

    public MarketplaceEffect(MarketplaceProduct marketplaceProduct, K frame, SpawnedObject spawnedObject, Instant expiresAt) {
        this.marketplaceProduct = marketplaceProduct;
        this.frame = frame;
        this.spawnedObject = spawnedObject;
        this.startedAt = Instant.now();
        this.expiresAt = expiresAt;
    }

    public boolean isActive() {
        return !this.isExpired() && this.marketplaceProduct.isActive();
    }

    public boolean isExpired() {
        return Instant.now().isAfter(this.expiresAt) || this.marketplaceProduct.isExpired();
    }

    public Duration getDuration() {
        return Duration.between(this.startedAt, this.expiresAt);
    }

    public Duration getDurationLeft() {
        Instant now = Instant.now();
        return Duration.between(now, this.expiresAt);
    }

    public MarketplaceProduct getMarketplaceProduct() {
        return this.marketplaceProduct;
    }

    public K getFrame() {
        return this.frame;
    }

    @Nullable
    public SpawnedObject getSpawnedObject() {
        return this.spawnedObject;
    }

    public boolean isApplied() {
        return this.isApplied;
    }

    public void setApplied(boolean isApplied) {
        this.isApplied = isApplied;
    }
}

