/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.items;

import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.items.ItemPriceSorter;
import com.twitchliveloadout.items.ItemSlotIdSorter;
import com.twitchliveloadout.items.PricedItem;
import com.twitchliveloadout.twitch.TwitchState;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.game.ItemManager;

public class ItemStateManager {
    public static final int MAX_BANK_ITEMS = 5000;
    public static final int LOOTING_BAG_CONTAINER_ID = 516;
    private final TwitchLiveLoadoutPlugin plugin;
    private final TwitchState twitchState;
    private final Client client;
    private final ItemManager itemManager;
    private final TwitchLiveLoadoutConfig config;
    private static final List<Integer> BANK_TAB_VARBITS = Arrays.asList(4171, 4172, 4173, 4174, 4175, 4176, 4177, 4178, 4179);

    public ItemStateManager(TwitchLiveLoadoutPlugin plugin, TwitchState twitchState, Client client, ItemManager itemManager, TwitchLiveLoadoutConfig config) {
        this.plugin = plugin;
        this.twitchState = twitchState;
        this.client = client;
        this.itemManager = itemManager;
        this.config = config;
    }

    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer container = event.getItemContainer();
        boolean isInventory = this.isItemContainer(event, InventoryID.INVENTORY);
        boolean isEquipment = this.isItemContainer(event, InventoryID.EQUIPMENT);
        boolean isBank = this.isItemContainer(event, InventoryID.BANK);
        boolean isLootingBag = this.isItemContainer(event, 516);
        if (!(isInventory || isEquipment || isBank || isLootingBag)) {
            return;
        }
        Item[] items = container.getItems();
        long totalPrice = this.getTotalPrice(items);
        if (this.config.inventoryEnabled() && isInventory) {
            this.twitchState.setInventoryItems(items, totalPrice);
        } else if (this.config.equipmentEnabled() && isEquipment) {
            this.twitchState.setEquipmentItems(items, totalPrice);
        } else if (this.config.bankEnabled() && isBank) {
            this.setSlicedBankItems(items, totalPrice);
        } else if (this.config.lootingBagEnabled() && isLootingBag) {
            this.twitchState.setLootingBagItems(items, totalPrice);
        }
        if (this.config.weightEnabled() && (isInventory || isEquipment)) {
            int weight = this.client.getWeight();
            this.twitchState.setWeight(weight);
        }
    }

    public int[] getBankTabAmounts() {
        int tabAmount = BANK_TAB_VARBITS.size();
        int[] amounts = new int[tabAmount];
        for (int tabIndex = 0; tabIndex < tabAmount; ++tabIndex) {
            int itemAmount;
            amounts[tabIndex] = itemAmount = this.client.getVarbitValue(BANK_TAB_VARBITS.get(tabIndex).intValue());
        }
        return amounts;
    }

    public boolean isItemContainer(ItemContainerChanged event, InventoryID container) {
        return this.isItemContainer(event, container.getId());
    }

    public boolean isItemContainer(ItemContainerChanged event, int containerId) {
        int eventContainerId = event.getContainerId();
        return eventContainerId == containerId;
    }

    public void setSlicedBankItems(Item[] items, long totalPrice) {
        int[] tabAmounts = this.getBankTabAmounts();
        int maxItemAmount = this.getMaxBankItemAmount();
        List<PricedItem> highestPricedItems = this.getHighestPricedItems(items, tabAmounts, maxItemAmount);
        Item[] selectedItems = new Item[highestPricedItems.size()];
        int[] selectedTabAmounts = new int[tabAmounts.length];
        for (int pricedItemIndex = 0; pricedItemIndex < highestPricedItems.size(); ++pricedItemIndex) {
            PricedItem pricedItem = highestPricedItems.get(pricedItemIndex);
            Item selectedItem = pricedItem.getItem();
            int tabId = pricedItem.getTabId();
            selectedItems[pricedItemIndex] = selectedItem;
            if (tabId < 0) continue;
            int n = tabId;
            selectedTabAmounts[n] = selectedTabAmounts[n] + 1;
        }
        this.twitchState.setBankItems(selectedItems, selectedTabAmounts);
        this.twitchState.setBankItemsPrice(totalPrice);
    }

    public CopyOnWriteArrayList<PricedItem> getPricedItems(Item[] items) {
        return this.getPricedItems(items, new int[0]);
    }

    public CopyOnWriteArrayList<PricedItem> getPricedItems(Item[] items, int[] tabAmounts) {
        CopyOnWriteArrayList<PricedItem> pricedItems = new CopyOnWriteArrayList<PricedItem>();
        for (int slotId = 0; slotId < items.length; ++slotId) {
            Item item = items[slotId];
            int itemId = item.getId();
            int itemQuantity = item.getQuantity();
            if (this.isPlaceholderItem(itemId)) {
                itemId = this.itemManager.getItemComposition(itemId).getPlaceholderId();
                itemQuantity = 0;
                item = new Item(itemId, itemQuantity);
            }
            long itemPrice = (long)this.itemManager.getItemPrice(itemId) * (long)itemQuantity;
            int tabId = this.getItemTabId(slotId, tabAmounts);
            PricedItem pricedItem = new PricedItem(item, itemPrice, slotId, tabId);
            pricedItems.add(pricedItem);
        }
        return pricedItems;
    }

    public boolean isPlaceholderItem(int itemId) {
        return this.itemManager.getItemComposition(itemId).getPlaceholderTemplateId() != -1;
    }

    public int getItemTabId(int slotId, int[] tabAmounts) {
        int totalAmount = 0;
        int remainingTabId = -1;
        for (int tabId = 0; tabId < tabAmounts.length; ++tabId) {
            int tabAmount = tabAmounts[tabId];
            if (slotId >= (totalAmount += tabAmount)) continue;
            return tabId;
        }
        return remainingTabId;
    }

    public long getTotalPrice(Item[] items) {
        long totalPrice = 0L;
        CopyOnWriteArrayList<PricedItem> pricedItems = this.getPricedItems(items);
        for (PricedItem pricedItem : pricedItems) {
            totalPrice += pricedItem.getPrice();
        }
        return totalPrice;
    }

    public List<PricedItem> getHighestPricedItems(Item[] items, int[] tabAmounts, int maxAmount) {
        CopyOnWriteArrayList<PricedItem> pricedItems = this.getPricedItems(items, tabAmounts);
        pricedItems.sort(new ItemPriceSorter());
        int itemAmount = pricedItems.size();
        if (maxAmount > itemAmount) {
            maxAmount = itemAmount;
        }
        List<PricedItem> highestPricedItems = pricedItems.subList(0, maxAmount);
        highestPricedItems.sort(new ItemSlotIdSorter());
        return highestPricedItems;
    }

    public int getMaxBankItemAmount() {
        int maxAmount = this.config.bankItemsAmount();
        if (maxAmount > 5000) {
            maxAmount = 5000;
        }
        if (maxAmount < 0) {
            maxAmount = 0;
        }
        return maxAmount;
    }
}

