/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.items;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.twitchliveloadout.TwitchLiveLoadoutPlugin;
import com.twitchliveloadout.items.CollectionLogItem;
import com.twitchliveloadout.twitch.TwitchState;
import java.util.concurrent.CopyOnWriteArrayList;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.events.NpcLootReceived;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionLogManager {
    private static final Logger log = LoggerFactory.getLogger(CollectionLogManager.class);
    private final TwitchLiveLoadoutPlugin plugin;
    private final TwitchState twitchState;
    private final Client client;
    private static final int COLLECTION_LOG_TITLE = 1;
    private static final int COLLECTION_LOG_BOSSES_TAB = 4;
    private static final int COLLECTION_LOG_RAIDS_TAB = 5;
    private static final int COLLECTION_LOG_CLUES_TAB = 6;
    private static final int COLLECTION_LOG_MINIGAMES_TAB = 7;
    private static final int COLLECTION_LOG_TAB_TEXT_INDEX = 3;
    private static final int COLLECTION_LOG_TAB_INACTIVE_COLOR = 16750623;
    private static final int COLLECTION_LOG_TAB_ACTIVE_COLOR = 16754735;
    private static final int COLLECTION_LOG_OTHER_TAB = 8;
    private static final int COLLECTION_LOG_CATEGORY_LIST = 12;
    private static final int COLLECTION_LOG_DRAW_LIST_SCRIPT_ID = 2730;
    private static final int[] COLLECTION_LOG_CATEGORY_VARBIT_IDS = new int[]{6905, 6906};
    private static final int[] COLLECTION_LOG_TABS = new int[]{4, 5, 6, 7, 8};
    public static final String COUNTERS_KEY_NAME = "c";
    public static final String ITEMS_KEY_NAME = "i";

    public CollectionLogManager(TwitchLiveLoadoutPlugin plugin, TwitchState twitchState, Client client) {
        this.plugin = plugin;
        this.twitchState = twitchState;
        this.client = client;
    }

    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 2730) {
            this.plugin.runOnClientThread(this::updateCurrentCategory);
        }
    }

    public void onVarbitChanged(VarbitChanged varbitChanged) {
        int varbitId = varbitChanged.getVarbitId();
        boolean matchFound = false;
        for (int candidateVarbitId : COLLECTION_LOG_CATEGORY_VARBIT_IDS) {
            if (candidateVarbitId != varbitId) continue;
            matchFound = true;
        }
        if (matchFound) {
            this.plugin.runOnClientThread(this::updateCurrentCategory);
        }
    }

    public void onNpcLootReceived(NpcLootReceived event) {
    }

    private Widget getCategoryHead() {
        Widget categoryHead = this.client.getWidget(WidgetInfo.COLLECTION_LOG_ENTRY_HEADER);
        return categoryHead;
    }

    private String getCategoryTitle() {
        Widget categoryHead = this.getCategoryHead();
        if (categoryHead == null) {
            return null;
        }
        Widget[] children = categoryHead.getDynamicChildren();
        if (children == null || children.length <= 0) {
            return null;
        }
        String categoryTitle = children[0].getText();
        return categoryTitle;
    }

    private String getTabTitle() {
        for (int tabId : COLLECTION_LOG_TABS) {
            Widget[] children;
            Widget tabWidget = this.client.getWidget(621, tabId);
            if (tabWidget == null || (children = tabWidget.getDynamicChildren()) == null || 3 >= children.length) continue;
            Widget titleWidget = children[3];
            String title = titleWidget.getText();
            int color = titleWidget.getTextColor();
            if (color != 16754735) continue;
            return title;
        }
        return null;
    }

    private void updateCurrentCategory() {
        try {
            CopyOnWriteArrayList<CollectionLogItem> items = this.getCurrentItems();
            JsonObject counters = this.getCurrentCounters();
            String categoryTitle = this.getCategoryTitle();
            String tabTitle = this.getTabTitle();
            JsonObject collectionLog = this.twitchState.getCollectionLog();
            if (collectionLog == null) {
                collectionLog = new JsonObject();
            }
            if (items == null || categoryTitle == null || tabTitle == null) {
                return;
            }
            if (!collectionLog.has(tabTitle)) {
                collectionLog.add(tabTitle, (JsonElement)new JsonObject());
            }
            JsonObject tabLog = collectionLog.getAsJsonObject(tabTitle);
            JsonObject categoryLog = new JsonObject();
            JsonArray serializedItems = new JsonArray();
            for (CollectionLogItem item : items) {
                JsonArray serializedItem = new JsonArray();
                serializedItem.add((Number)item.getId());
                serializedItem.add((Number)item.getQuantity());
                serializedItems.add((JsonElement)serializedItem);
            }
            categoryLog.add(COUNTERS_KEY_NAME, (JsonElement)counters);
            categoryLog.add(ITEMS_KEY_NAME, (JsonElement)serializedItems);
            tabLog.add(categoryTitle, (JsonElement)categoryLog);
            this.twitchState.setCollectionLog(collectionLog);
        }
        catch (Exception exception) {
            log.warn("Could not update the collection log due to the following error: ", (Throwable)exception);
        }
    }

    private CopyOnWriteArrayList<CollectionLogItem> getCurrentItems() {
        Widget itemsContainer = this.client.getWidget(WidgetInfo.COLLECTION_LOG_ENTRY_ITEMS);
        if (itemsContainer == null) {
            return null;
        }
        Widget[] widgetItems = itemsContainer.getDynamicChildren();
        CopyOnWriteArrayList<CollectionLogItem> items = new CopyOnWriteArrayList<CollectionLogItem>();
        for (Widget widgetItem : widgetItems) {
            items.add(new CollectionLogItem(widgetItem));
        }
        return items;
    }

    private JsonObject getCurrentCounters() {
        JsonObject counters = new JsonObject();
        Widget categoryHead = this.getCategoryHead();
        if (categoryHead == null) {
            return counters;
        }
        Widget[] children = categoryHead.getDynamicChildren();
        if (children == null || children.length < 3) {
            return counters;
        }
        for (int childIndex = 2; childIndex < children.length; ++childIndex) {
            String rawCounter = children[childIndex].getText();
            String[] counterPieces = rawCounter.split(": ");
            if (counterPieces.length <= 1) continue;
            String counterTitle = counterPieces[0];
            String counterAmount = counterPieces[1].split(">")[1].split("<")[0].replace(",", "");
            try {
                counters.addProperty(counterTitle, (Number)Integer.parseInt(counterAmount));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return counters;
    }
}

