/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.fights;

import com.twitchliveloadout.fights.FightSession;
import com.twitchliveloadout.fights.FightStatisticProperty;
import java.time.Instant;

public class FightStatistic {
    private final FightSession session;
    private Instant firstUpdate;
    private Instant lastUpdate;
    private long hitDamage = 0L;
    private long missDamage = 0L;
    private long hitCounter = 0L;
    private long missCounter = 0L;

    public FightStatistic(FightSession session) {
        this.session = session;
    }

    public void registerHit(int damage) {
        this.hitDamage += (long)damage;
        ++this.hitCounter;
        this.registerUpdate();
    }

    public void registerMiss(int damage) {
        this.missDamage += (long)damage;
        ++this.missCounter;
        this.registerUpdate();
    }

    public void addStatistic(FightStatistic statistic) {
        Instant candidateFirstUpdate = statistic.getFirstUpdate();
        Instant candidateLastUpdate = statistic.getLastUpdate();
        this.hitDamage += statistic.getHitDamage();
        this.hitCounter += statistic.getHitCounter();
        this.missDamage += statistic.getMissDamage();
        this.missCounter += statistic.getMissCounter();
        if (this.firstUpdate == null || candidateFirstUpdate != null && candidateFirstUpdate.isBefore(this.firstUpdate)) {
            this.firstUpdate = candidateFirstUpdate;
        }
        if (this.lastUpdate == null || candidateLastUpdate != null && candidateLastUpdate.isAfter(this.lastUpdate)) {
            this.lastUpdate = candidateLastUpdate;
        }
    }

    public void registerUpdate() {
        Instant now = Instant.now();
        if (this.firstUpdate == null) {
            this.firstUpdate = now;
        }
        this.lastUpdate = now;
        this.session.handleStatisticUpdate();
    }

    public long getDurationSeconds() {
        Instant lastUpdate = this.getLastUpdate();
        Instant firstUpdate = this.getFirstUpdate();
        if (lastUpdate == null || firstUpdate == null) {
            return 0L;
        }
        return this.getLastUpdate().getEpochSecond() - this.getFirstUpdate().getEpochSecond();
    }

    public long getHitDamage() {
        return this.hitDamage;
    }

    public long getMissDamage() {
        return this.missDamage;
    }

    public long getHitCounter() {
        return this.hitCounter;
    }

    public long getMissCounter() {
        return this.missCounter;
    }

    public Instant getLastUpdate() {
        return this.lastUpdate;
    }

    public Instant getFirstUpdate() {
        return this.firstUpdate;
    }

    public boolean isEverUpdated() {
        return this.lastUpdate != null || this.firstUpdate != null;
    }

    public long getValueByProperty(FightStatisticProperty property) {
        String key = property.getKey();
        if (key.equals(FightStatisticProperty.HIT_DAMAGES.getKey())) {
            return this.getHitDamage();
        }
        if (key.equals(FightStatisticProperty.HIT_COUNTERS.getKey())) {
            return this.getHitCounter();
        }
        if (key.equals(FightStatisticProperty.MISS_DAMAGES.getKey())) {
            return this.getMissDamage();
        }
        if (key.equals(FightStatisticProperty.MISS_COUNTERS.getKey())) {
            return this.getMissCounter();
        }
        if (key.equals(FightStatisticProperty.DURATION_SECONDS.getKey())) {
            return this.getDurationSeconds();
        }
        return 0L;
    }

    public void reset() {
        this.hitDamage = 0L;
        this.missDamage = 0L;
        this.hitCounter = 0L;
        this.missCounter = 0L;
        this.firstUpdate = null;
        this.lastUpdate = null;
    }
}

