/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.fights;

import com.twitchliveloadout.fights.Fight;
import com.twitchliveloadout.fights.FightStatistic;
import com.twitchliveloadout.fights.FightStatisticEntry;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FightSession {
    private final Fight fight;
    private ConcurrentHashMap<FightStatisticEntry, FightStatistic> statistics = new ConcurrentHashMap();
    private long interactingTickCounter = 0L;
    private long idleTickCounter = 0L;
    private long idleQueuedTickCounter = 0L;
    private boolean finished = false;

    public FightSession(Fight fight) {
        this.fight = fight;
        for (FightStatisticEntry statisticEntry : FightStatisticEntry.values()) {
            this.statistics.put(statisticEntry, new FightStatistic(this));
        }
    }

    public FightStatistic getStatistic(FightStatisticEntry statisticEntry) {
        return this.statistics.get((Object)statisticEntry);
    }

    public void handleStatisticUpdate() {
        this.registerQueuedIdleTicks();
        this.fight.handleStatisticUpdate();
    }

    public void addInteractingTicks(long amount) {
        this.interactingTickCounter += amount;
    }

    public void addIdleTicks(long amount) {
        this.idleTickCounter += amount;
    }

    public void queueIdleTicks(long amount) {
        this.idleQueuedTickCounter += amount;
    }

    public void registerQueuedIdleTicks() {
        this.idleTickCounter += this.idleQueuedTickCounter;
        this.idleQueuedTickCounter = 0L;
    }

    public long getInteractingTickCounter() {
        return this.interactingTickCounter;
    }

    public long getIdleTickCounter() {
        return this.idleTickCounter;
    }

    public long getIdleDuration() {
        return (long)((float)this.idleTickCounter * 0.6f);
    }

    public long getDurationSeconds() {
        Instant lastUpdate = this.getLastUpdate();
        Instant firstUpdate = this.getFirstUpdate();
        if (lastUpdate == null || firstUpdate == null) {
            return 0L;
        }
        return this.getLastUpdate().getEpochSecond() - this.getFirstUpdate().getEpochSecond() - this.getIdleDuration();
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Instant getFirstUpdate() {
        Instant minFirstUpdate = null;
        for (Map.Entry<FightStatisticEntry, FightStatistic> entry : this.statistics.entrySet()) {
            FightStatisticEntry statisticEntry = entry.getKey();
            FightStatistic statistic = entry.getValue();
            Instant firstUpdate = statistic.getFirstUpdate();
            if (!statisticEntry.isDurationInfluencer() || firstUpdate == null || minFirstUpdate != null && !firstUpdate.isBefore(minFirstUpdate)) continue;
            minFirstUpdate = firstUpdate;
        }
        return minFirstUpdate;
    }

    public Instant getLastUpdate() {
        return this.getLastUpdate(false);
    }

    public Instant getLastUpdate(boolean updatedAtInfluencerOnly) {
        Instant maxLastUpdate = null;
        for (Map.Entry<FightStatisticEntry, FightStatistic> entry : this.statistics.entrySet()) {
            FightStatisticEntry statisticEntry = entry.getKey();
            FightStatistic statistic = entry.getValue();
            Instant lastUpdate = statistic.getLastUpdate();
            if (!statisticEntry.isDurationInfluencer() || lastUpdate == null || !statisticEntry.isUpdatedAtInfluencer() && updatedAtInfluencerOnly || maxLastUpdate != null && !lastUpdate.isAfter(maxLastUpdate)) continue;
            maxLastUpdate = lastUpdate;
        }
        return maxLastUpdate;
    }
}

