/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.fights;

import com.twitchliveloadout.fights.FightStatisticEntry;
import com.twitchliveloadout.fights.FightStatisticProperty;
import java.time.Instant;
import net.runelite.api.Actor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FightQueuedStatistic {
    private static final Logger log = LoggerFactory.getLogger(FightQueuedStatistic.class);
    private final Instant createdAt = Instant.now();
    private final Actor actor;
    private final FightStatisticEntry entry;
    private final FightStatisticProperty property;
    private final int expiryTimeMs;
    private boolean isRegistered = false;

    FightQueuedStatistic(Actor actor, FightStatisticEntry entry, FightStatisticProperty property, int expiryTimeMs) {
        this.actor = actor;
        this.entry = entry;
        this.property = property;
        this.expiryTimeMs = expiryTimeMs;
    }

    public boolean isValid() {
        Instant now = Instant.now();
        Instant expiredAt = this.createdAt.plusMillis(this.expiryTimeMs);
        log.debug("Queued statistic time until expiry: {}", (Object)(expiredAt.toEpochMilli() - now.toEpochMilli()));
        return !this.isRegistered && !now.isAfter(expiredAt);
    }

    public void register() {
        this.isRegistered = true;
    }

    public Actor getActor() {
        return this.actor;
    }

    public FightStatisticEntry getEntry() {
        return this.entry;
    }

    public FightStatisticProperty getProperty() {
        return this.property;
    }
}

