/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout.fights;

import com.twitchliveloadout.fights.FightQueuedStatistic;
import com.twitchliveloadout.fights.FightSession;
import com.twitchliveloadout.fights.FightStateManager;
import com.twitchliveloadout.fights.FightStatistic;
import com.twitchliveloadout.fights.FightStatisticEntry;
import com.twitchliveloadout.fights.FightStatisticProperty;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.runelite.api.Actor;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fight {
    private static final Logger log = LoggerFactory.getLogger(Fight.class);
    private final String actorName;
    private final int actorId;
    private final FightStateManager.ActorType actorType;
    private final int actorCombatLevel;
    private final CopyOnWriteArrayList<FightQueuedStatistic> queuedStatistics = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<Actor, FightSession> sessions = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<FightSession> finishedSessions = new CopyOnWriteArrayList();
    private int sessionCounter = 0;
    private long idleTickCounter = 0L;
    private long idleQueuedTickCounter = 0L;
    private Actor lastActor;
    private FightSession lastSession;

    public Fight(Actor actor, String actorName, boolean isLocalPlayer) {
        this.lastActor = actor;
        this.actorName = actorName;
        this.lastSession = this.ensureSession(actor);
        this.actorCombatLevel = actor.getCombatLevel();
        if (actor instanceof NPC) {
            this.actorId = ((NPC)actor).getId();
            this.actorType = FightStateManager.ActorType.NPC;
        } else if (actor instanceof GameObject) {
            this.actorId = ((GameObject)actor).getId();
            this.actorType = FightStateManager.ActorType.GAME_OBJECT;
        } else if (isLocalPlayer) {
            this.actorId = -1;
            this.actorType = FightStateManager.ActorType.LOCAL_PLAYER;
        } else {
            this.actorId = -1;
            this.actorType = FightStateManager.ActorType.PLAYER;
        }
    }

    public void queueStatistic(Actor actor, FightStatisticEntry entry, FightStatisticProperty property, int expiryTimeMs) {
        log.debug("Adding queued statistic: {} - {} - {} - {}", new Object[]{actor.getName(), entry.getKey(), property.getKey(), expiryTimeMs});
        FightQueuedStatistic queuedStatistic = new FightQueuedStatistic(actor, entry, property, expiryTimeMs);
        this.queuedStatistics.add(queuedStatistic);
        this.cleanQueuedStatistics();
    }

    public void registerQueuedStatistics(Actor actor, int hitsplatAmount) {
        log.debug("Checking queue statistics, queued size {} for hitsplat {}", (Object)this.queuedStatistics.size(), (Object)hitsplatAmount);
        for (FightQueuedStatistic queuedStatistic : this.queuedStatistics) {
            Actor queuedActor = queuedStatistic.getActor();
            FightStatisticEntry entry = queuedStatistic.getEntry();
            FightStatisticProperty property = queuedStatistic.getProperty();
            log.debug("Attempt register queued statistic {} - {}", (Object)entry.getKey(), (Object)property.getKey());
            if (actor != queuedActor) {
                log.debug("Skipping queued statistic because of wrong actor.");
                continue;
            }
            if (!queuedStatistic.isValid()) {
                log.debug("Skipping queued statistic because of invalid.");
                continue;
            }
            FightStatistic statistic = this.ensureStatistic(actor, entry);
            if (property == FightStatisticProperty.MISS_DAMAGES || property == FightStatisticProperty.MISS_COUNTERS) {
                log.debug("Register queued statistic miss: {}", (Object)hitsplatAmount);
                statistic.registerMiss(hitsplatAmount);
            } else if (property == FightStatisticProperty.HIT_DAMAGES || property == FightStatisticProperty.HIT_COUNTERS) {
                log.debug("Register queued statistic hit: {}", (Object)hitsplatAmount);
                statistic.registerHit(hitsplatAmount);
            }
            queuedStatistic.register();
        }
    }

    private void cleanQueuedStatistics() {
        for (FightQueuedStatistic queuedStatistic : this.queuedStatistics) {
            if (queuedStatistic.isValid()) continue;
            log.debug("Remove queued statistic {}", (Object)queuedStatistic.getEntry().getKey());
            this.queuedStatistics.remove(queuedStatistic);
        }
    }

    public FightStatistic ensureStatistic(Actor actor, FightStatisticEntry statisticEntry) {
        if (!this.sessions.containsKey(actor)) {
            this.ensureSession(actor);
        }
        FightSession session = this.sessions.get(actor);
        return session.getStatistic(statisticEntry);
    }

    public void handleStatisticUpdate() {
        this.registerQueuedIdleTicks();
    }

    public void queueIdleTicks(long amount) {
        this.idleQueuedTickCounter += amount;
    }

    public void registerQueuedIdleTicks() {
        this.idleTickCounter += this.idleQueuedTickCounter;
        this.idleQueuedTickCounter = 0L;
    }

    public long getIdleTickCounter() {
        return this.idleTickCounter;
    }

    public boolean hasSession(Actor actor) {
        return this.sessions.containsKey(actor);
    }

    public FightSession getSession(Actor actor) {
        return this.sessions.get(actor);
    }

    public FightSession ensureSession(Actor actor) {
        if (this.sessions.containsKey(actor)) {
            return this.sessions.get(actor);
        }
        FightSession session = new FightSession(this);
        this.sessions.put(actor, session);
        return session;
    }

    public Instant getLastUpdate() {
        return this.getLastUpdate(false);
    }

    public Instant getLastUpdate(boolean updatedAtInfluencerOnly) {
        Instant maxLastUpdate = null;
        CopyOnWriteArrayList<FightSession> allSessions = this.getAllSessions();
        for (FightSession session : allSessions) {
            Instant lastUpdate = session.getLastUpdate(updatedAtInfluencerOnly);
            if (lastUpdate == null || maxLastUpdate != null && !lastUpdate.isAfter(maxLastUpdate)) continue;
            maxLastUpdate = lastUpdate;
        }
        return maxLastUpdate;
    }

    public FightSession calculateTotalSession() {
        FightSession totalSession = new FightSession(this);
        CopyOnWriteArrayList<FightSession> allSessions = this.getAllSessions();
        Iterator<FightSession> allSessionIterator = allSessions.iterator();
        totalSession.addIdleTicks(this.idleTickCounter);
        while (allSessionIterator.hasNext()) {
            FightSession session = allSessionIterator.next();
            totalSession.addInteractingTicks(session.getInteractingTickCounter());
            for (FightStatisticEntry statisticEntry : FightStatisticEntry.values()) {
                FightStatistic totalStatistic = totalSession.getStatistic(statisticEntry);
                FightStatistic statistic = session.getStatistic(statisticEntry);
                totalStatistic.addStatistic(statistic);
            }
        }
        return totalSession;
    }

    public FightSession getLastSession() {
        return this.lastSession;
    }

    public boolean isIdling(CopyOnWriteArrayList<String> actorNames) {
        for (String actorName : actorNames) {
            if (!this.actorName.equals(actorName)) continue;
            return false;
        }
        return true;
    }

    public void setLastActor(Actor actor) {
        this.lastActor = actor;
        this.lastSession = this.ensureSession(actor);
    }

    public void finishSession(Actor actor) {
        if (!this.hasSession(actor)) {
            return;
        }
        FightSession session = this.getSession(actor);
        session.finish();
        this.sessions.remove(actor);
        this.finishedSessions.add(session);
        if (this.finishedSessions.size() > 1000) {
            log.debug("Removing a finished session due to maximum amount reached...");
            this.finishedSessions.remove(0);
        }
    }

    public void increaseSessionCounter() {
        ++this.sessionCounter;
    }

    public FightStateManager.ActorType getActorType() {
        return this.actorType;
    }

    public Actor getLastActor() {
        return this.lastActor;
    }

    public int getActorId() {
        return this.actorId;
    }

    public String getActorName() {
        return this.actorName;
    }

    public int getActorCombatLevel() {
        return this.actorCombatLevel;
    }

    public int getSessionCounter() {
        return this.sessionCounter;
    }

    public Collection<FightSession> getOngoingSessions() {
        return this.sessions.values();
    }

    public CopyOnWriteArrayList<FightSession> getAllSessions() {
        CopyOnWriteArrayList<FightSession> allSessions = new CopyOnWriteArrayList<FightSession>();
        Iterator<FightSession> finishedSessionIterator = this.finishedSessions.iterator();
        Iterator<FightSession> sessionIterator = this.sessions.values().iterator();
        while (finishedSessionIterator.hasNext()) {
            allSessions.add(finishedSessionIterator.next());
        }
        while (sessionIterator.hasNext()) {
            allSessions.add(sessionIterator.next());
        }
        return allSessions;
    }
}

