/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import com.twitchliveloadout.TwitchLiveLoadoutConfig;
import com.twitchliveloadout.fights.FightStateManager;
import com.twitchliveloadout.items.CollectionLogManager;
import com.twitchliveloadout.items.ItemStateManager;
import com.twitchliveloadout.marketplace.MarketplaceManager;
import com.twitchliveloadout.minimap.MinimapManager;
import com.twitchliveloadout.quests.QuestManager;
import com.twitchliveloadout.raids.InvocationsManager;
import com.twitchliveloadout.skills.SkillStateManager;
import com.twitchliveloadout.twitch.TwitchApi;
import com.twitchliveloadout.twitch.TwitchSegmentType;
import com.twitchliveloadout.twitch.TwitchState;
import com.twitchliveloadout.twitch.TwitchStateEntry;
import com.twitchliveloadout.ui.CanvasListener;
import com.twitchliveloadout.ui.TwitchLiveLoadoutPanel;
import com.twitchliveloadout.utilities.AccountType;
import java.awt.image.BufferedImage;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.AccountHashChanged;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.FakeXpDrop;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.PlayerChanged;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Twitch Live Loadout", description="Show Twitch viewers your collection log, bank, inventory, combat statistics, equipment, skills and more.", enabledByDefault=true)
public class TwitchLiveLoadoutPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TwitchLiveLoadoutPlugin.class);
    public static final boolean IN_DEVELOPMENT = false;
    @Inject
    private TwitchLiveLoadoutConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OkHttpClient httpClient;
    @Inject
    private Gson gson;
    private ScheduledThreadPoolExecutor scheduledExecutor;
    private static final String ICON_FILE = "/panel_icon.png";
    private TwitchLiveLoadoutPanel pluginPanel;
    private NavigationButton navigationButton;
    private TwitchState twitchState;
    private TwitchApi twitchApi;
    private FightStateManager fightStateManager;
    private ItemStateManager itemStateManager;
    private SkillStateManager skillStateManager;
    private CollectionLogManager collectionLogManager;
    private MarketplaceManager marketplaceManager;
    private MinimapManager minimapManager;
    private InvocationsManager invocationsManager;
    private QuestManager questManager;
    private String lastPlayerName = null;
    private CanvasListener canvasListener = null;
    private static final boolean ENABLE_MINIMAP = false;

    protected void startUp() throws Exception {
        super.startUp();
        this.initializeExecutors();
        this.initializeCanvasListeners();
        this.initializeTwitch();
        this.initializeManagers();
        this.initializePanel();
        this.updateMarketplaceStreamerProducts();
        this.updateMarketplaceEbsProducts();
        this.skillStateManager.updateSkills();
        this.syncPlayerInfo();
        log.info("Twitch Live Loadout has started!");
    }

    private void initializeExecutors() {
        try {
            this.scheduledExecutor = new ScheduledThreadPoolExecutor(1);
        }
        catch (Exception exception) {
            log.warn("An error occurred when initializing the executors: ", (Throwable)exception);
        }
    }

    private void initializeTwitch() {
        try {
            this.twitchState = new TwitchState(this, this.config, this.canvasListener, this.gson);
            this.twitchApi = new TwitchApi(this, this.client, this.config, this.chatMessageManager, this.httpClient);
        }
        catch (Exception exception) {
            log.warn("An error occurred when initializing Twitch: ", (Throwable)exception);
        }
    }

    private void initializeManagers() {
        try {
            this.fightStateManager = new FightStateManager(this, this.config, this.client);
            this.itemStateManager = new ItemStateManager(this, this.twitchState, this.client, this.itemManager, this.config);
            this.skillStateManager = new SkillStateManager(this.twitchState, this.client);
            this.collectionLogManager = new CollectionLogManager(this, this.twitchState, this.client);
            this.marketplaceManager = new MarketplaceManager(this, this.twitchApi, this.twitchState, this.client, this.config, this.chatMessageManager, this.itemManager, this.overlayManager, this.gson);
            this.minimapManager = new MinimapManager(this, this.twitchState, this.client);
            this.invocationsManager = new InvocationsManager(this, this.twitchState, this.client);
            this.questManager = new QuestManager(this, this.twitchState, this.client);
        }
        catch (Exception exception) {
            log.warn("An error occurred when initializing the managers: ", (Throwable)exception);
        }
    }

    private void initializePanel() {
        try {
            this.pluginPanel = new TwitchLiveLoadoutPanel(this, this.twitchApi, this.twitchState, this.fightStateManager, this.marketplaceManager, this.canvasListener, this.config);
            this.pluginPanel.rebuild();
            BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)ICON_FILE);
            this.navigationButton = NavigationButton.builder().tooltip("Twitch Live Loadout Status").icon(icon).priority(99).panel((PluginPanel)this.pluginPanel).build();
            this.clientToolbar.addNavigation(this.navigationButton);
        }
        catch (Exception exception) {
            log.warn("An error occurred when initializing the UI panels: ", (Throwable)exception);
        }
    }

    private void initializeCanvasListeners() {
        try {
            this.canvasListener = new CanvasListener(this.config);
        }
        catch (Exception exception) {
            log.warn("An error occurred when initializing the canvas listeners: ", (Throwable)exception);
        }
    }

    protected void shutDown() throws Exception {
        super.shutDown();
        this.shutDownPanels();
        this.shutDownManagers();
        this.shutDownTwitch();
        this.shutDownCanvasListeners();
        this.shutDownSchedulers();
        log.info("Twitch Live Loadout has stopped!");
    }

    private void shutDownCanvasListeners() {
        try {
            this.client.getCanvas().removeFocusListener(this.canvasListener);
        }
        catch (Exception exception) {
            log.warn("An error occurred when removing the canvas listeners: ", (Throwable)exception);
        }
    }

    private void shutDownTwitch() {
        try {
            this.twitchApi.shutDown();
        }
        catch (Exception exception) {
            log.warn("An error occurred when shutting down Twitch: ", (Throwable)exception);
        }
    }

    private void shutDownManagers() {
        try {
            this.fightStateManager.shutDown();
            this.marketplaceManager.shutDown();
        }
        catch (Exception exception) {
            log.warn("An error occurred when shutting down the managers: ", (Throwable)exception);
        }
    }

    private void shutDownPanels() {
        try {
            this.clientToolbar.removeNavigation(this.navigationButton);
        }
        catch (Exception exception) {
            log.warn("An error occurred when shutting down the UI panels: ", (Throwable)exception);
        }
    }

    private void shutDownSchedulers() {
        this.scheduledExecutor.getQueue().clear();
        this.scheduledExecutor.shutdown();
    }

    @Schedule(period=500L, unit=ChronoUnit.MILLIS, asynchronous=false)
    public void syncState() {
        try {
            if (!this.twitchApi.canScheduleState()) {
                return;
            }
            JsonObject filteredState = this.twitchState.getFilteredState();
            String filteredStateString = filteredState.toString();
            String newFilteredStateString = this.twitchState.getFilteredState().toString();
            this.twitchApi.scheduleBroadcasterState(filteredState);
            if (!filteredStateString.equals(newFilteredStateString)) {
                return;
            }
            this.twitchState.nextCyclicState();
        }
        catch (Exception exception) {
            this.logSupport("Could not sync the current state to Twitch due to the following error: ", exception);
        }
    }

    @Schedule(period=2L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void syncFightStatisticsState() {
        try {
            if (this.shouldTrackFightStatistics()) {
                JsonObject fightStatistics = this.fightStateManager.getFightStatisticsState();
                this.twitchState.setFightStatistics(fightStatistics);
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not update the fight statistics due to the following error: ", exception);
        }
    }

    @Schedule(period=30L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void updateQuests() {
        try {
            if (this.config.questsEnabled()) {
                this.runOnClientThread(() -> this.questManager.updateQuests());
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not sync quests due to the following error: ", exception);
        }
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS, asynchronous=false)
    public void syncPlayerInfo() {
        try {
            this.runOnClientThread(() -> {
                long accountHash = this.client.getAccountHash();
                AccountType accountType = this.getAccountType();
                String playerName = this.getPlayerName();
                if (playerName != null && !playerName.equals(this.lastPlayerName)) {
                    if (this.config.playerInfoEnabled()) {
                        this.twitchState.setPlayerName(playerName);
                    }
                    this.twitchState.onPlayerNameChanged(playerName);
                    this.lastPlayerName = playerName;
                }
                this.twitchState.setAccountHash(accountHash);
                this.twitchState.setAccountType(accountType);
            });
        }
        catch (Exception exception) {
            this.logSupport("Could not sync player info to state due to the following error: ", exception);
        }
    }

    @Schedule(period=2L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void syncMiniMap() {
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void updateMarketplaceStreamerProducts() {
        try {
            if (this.config.syncEnabled()) {
                this.twitchApi.fetchAsyncConfigurationSegment(TwitchSegmentType.BROADCASTER);
            }
            if (this.config.marketplaceEnabled()) {
                this.marketplaceManager.updateStreamerProducts();
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not update the configuration segments due to the following error: ", exception);
        }
    }

    @Schedule(period=300L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void updateMarketplaceEbsProducts() {
        try {
            if (this.config.marketplaceEnabled()) {
                this.marketplaceManager.updateAsyncEbsProducts();
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not update the EBS products due to the following error: ", exception);
        }
    }

    @Schedule(period=4L, unit=ChronoUnit.SECONDS, asynchronous=false)
    public void fetchMarketplaceTransactions() {
        try {
            if (this.config.marketplaceEnabled()) {
                this.marketplaceManager.fetchAsyncNewEbsTransactions();
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not update the extension transactions due to the following error: ", exception);
        }
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS, asynchronous=false)
    public void applyMarketplaceTransactions() {
        try {
            if (this.config.marketplaceEnabled()) {
                this.runOnClientThread(() -> {
                    this.marketplaceManager.applyQueuedTransactions();
                    this.marketplaceManager.cleanExpiredProducts();
                });
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not apply and clean the extension transactions: ", exception);
        }
    }

    @Schedule(period=5L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void checkIfInToA() {
        try {
            if (this.config.invocationsEnabled() && this.config.autoDetectInToaRaidEnabled()) {
                this.invocationsManager.checkIfInToA();
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not check if in ToA: ", exception);
        }
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void testMarketplaceProducts() {
    }

    @Schedule(period=600L, unit=ChronoUnit.MILLIS, asynchronous=true)
    public void onLobbyGameTick() {
        try {
            if (this.client.getGameState() != GameState.LOGIN_SCREEN) {
                return;
            }
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onGameTick();
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not handle lobby game tick event: ", exception);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        try {
            this.itemStateManager.onItemContainerChanged(event);
        }
        catch (Exception exception) {
            log.warn("Could not handle item container change event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        try {
            if (this.config.skillsEnabled()) {
                this.skillStateManager.updateSkills();
            }
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onStatChanged(event);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle stat change event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onFakeXpDrop(FakeXpDrop event) {
        try {
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onFakeXpDrop(event);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle fake XP drop event: ", (Throwable)exception);
        }
    }

    public void onNpcLootReceived(NpcLootReceived event) {
        try {
            if (this.config.collectionLogEnabled()) {
                this.collectionLogManager.onNpcLootReceived(event);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle on NPC loot received event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        try {
            boolean isFocused = event.isFocused();
            if (isFocused) {
                this.canvasListener.enableFocus();
            } else {
                this.canvasListener.disableFocus();
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle on focus change event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        try {
            this.canvasListener.enableFocus();
            if (this.config.marketplaceEnabled()) {
                this.marketplaceManager.onMenuOptionClicked(event);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle menu option clicked event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        try {
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onAnimationChanged(event);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle animation change event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        try {
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onGraphicChanged(event);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle graphic change event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        try {
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onHitsplatApplied(event);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle hitsplat event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        try {
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onNpcDespawned(npcDespawned);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle NPC despawned event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned playerDespawned) {
        try {
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onPlayerDespawned(playerDespawned);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle player despawned event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged interactingChanged) {
        try {
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onInteractingChanged(interactingChanged);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle interacting change event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        try {
            if (this.config.marketplaceEnabled()) {
                this.marketplaceManager.onGameTick();
            }
            if (this.shouldTrackFightStatistics()) {
                this.fightStateManager.onGameTick();
            }
            this.pluginPanel.onGameTick();
        }
        catch (Exception exception) {
            this.logSupport("Could not handle game tick event: ", exception);
        }
    }

    @Subscribe
    public void onClientTick(ClientTick tick) {
        try {
            if (this.config.marketplaceEnabled()) {
                this.marketplaceManager.onClientTick();
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not handle client tick event: ", exception);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        try {
            if (this.config.marketplaceEnabled()) {
                this.marketplaceManager.onGameStateChanged(gameStateChanged);
            }
            this.twitchState.setAccountHash(this.client.getAccountHash());
            this.twitchState.setAccountType(this.getAccountType());
            if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
                this.updateQuests();
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle game state event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onAccountHashChanged(AccountHashChanged accountHashChanged) {
        try {
            this.twitchState.setAccountHash(this.client.getAccountHash());
        }
        catch (Exception exception) {
            log.warn("Could not handle account hash event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onPlayerChanged(PlayerChanged playerChanged) {
        try {
            if (this.config.marketplaceEnabled()) {
                this.marketplaceManager.onPlayerChanged(playerChanged);
            }
        }
        catch (Exception exception) {
            log.warn("Could not handle player changed event: ", (Throwable)exception);
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        try {
            if (this.config.collectionLogEnabled()) {
                this.collectionLogManager.onScriptPostFired(scriptPostFired);
            }
            if (this.config.invocationsEnabled()) {
                this.invocationsManager.onScriptPostFired(scriptPostFired);
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not handle script post fired event:", exception);
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        try {
            if (this.config.collectionLogEnabled()) {
                this.collectionLogManager.onVarbitChanged(varbitChanged);
            }
        }
        catch (Exception exception) {
            this.logSupport("Could not handle varbit change event: ", exception);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        try {
            String key;
            switch (key = configChanged.getKey()) {
                case "syncDelay": {
                    this.twitchApi.clearScheduledBroadcasterStates();
                    break;
                }
                case "overlayTopPosition": {
                    this.twitchState.setOverlayTopPosition(this.config.overlayTopPosition());
                    break;
                }
                case "virtualLevelsEnabled": {
                    this.twitchState.setVirtualLevelsEnabled(this.config.virtualLevelsEnabled());
                    break;
                }
                case "twitchTheme": {
                    this.twitchState.setTwitchTheme(this.config.twitchTheme());
                    break;
                }
                case "marketplaceEnabled": {
                    this.pluginPanel.getMarketplacePanel().updateTexts();
                    if (this.config.marketplaceEnabled()) break;
                    this.marketplaceManager.disable();
                }
            }
            this.canvasListener.enableFocus();
        }
        catch (Exception exception) {
            log.warn("Could not handle config change event: ", (Throwable)exception);
        }
    }

    @Schedule(period=2L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void updateConnectivityPanel() {
        try {
            if (!this.hasValidPanels()) {
                return;
            }
            this.pluginPanel.getConnectivityPanel().rebuild();
        }
        catch (Exception exception) {
            this.logSupport("Could not update the connectivity panel due to the following error: ", exception);
        }
    }

    @Schedule(period=3L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void updateMarketplaceActiveProductsPanel() {
        try {
            if (!this.hasValidPanels()) {
                return;
            }
            this.pluginPanel.getMarketplacePanel().rebuildProductPanels();
            this.pluginPanel.getMarketplacePanel().updateTexts();
        }
        catch (Exception exception) {
            this.logSupport("Could not update the marketplace panel due to the following error: ", exception);
        }
    }

    public boolean hasValidPanels() {
        return this.pluginPanel != null;
    }

    public void runOnClientThread(final ClientThreadAction action) {
        try {
            this.clientThread.invoke(new Runnable(){

                @Override
                public void run() {
                    try {
                        action.execute();
                    }
                    catch (Exception exception) {
                        TwitchLiveLoadoutPlugin.this.logSupport("Could not execute action on client thread: ", exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            this.logSupport("Could not invoke an action later on client thread: ", exception);
        }
    }

    public ScheduledFuture scheduleOnClientThread(ClientThreadAction action, long delayMs) {
        if (delayMs <= 0L) {
            try {
                this.runOnClientThread(action);
            }
            catch (Exception exception) {
                this.logSupport("Could not run an action on the client thread immediately: ", exception);
            }
            return null;
        }
        return this.scheduleOnPoolThread(() -> this.runOnClientThread(action), delayMs);
    }

    public ScheduledFuture runOnPoolThread(ClientThreadAction action) {
        return this.scheduleOnPoolThread(action, 0L);
    }

    public ScheduledFuture scheduleOnPoolThread(final ClientThreadAction action, long delayMs) {
        try {
            return this.scheduledExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        action.execute();
                    }
                    catch (Exception exception) {
                        TwitchLiveLoadoutPlugin.this.logSupport("Could not execute an action: ", exception);
                    }
                }
            }, delayMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            this.logSupport("Could not schedule an action (delay: " + delayMs + "): ", exception);
            return null;
        }
    }

    public void setConfiguration(String configKey, Object payload) {
        try {
            String accountHash = Long.toString(this.client.getAccountHash());
            String scopedConfigKey = this.getScopedConfigKey(accountHash, configKey);
            this.configManager.setConfiguration("twitch-live-loadout", scopedConfigKey, payload);
        }
        catch (Exception exception) {
            log.warn("Could not set the configuration due to the following error: ", (Throwable)exception);
        }
    }

    public String getConfiguration(String configKey) {
        try {
            boolean configurationIsEmpty;
            String playerName = this.getPlayerName();
            String accountHash = Long.toString(this.client.getAccountHash());
            if (playerName == null) {
                playerName = "unknown";
            }
            String scopedConfigKey = this.getScopedConfigKey(accountHash, configKey);
            String configuration = this.configManager.getConfiguration("twitch-live-loadout", scopedConfigKey);
            String oldNameScopedConfigKey = this.getScopedConfigKey(playerName, configKey);
            String oldNameConfiguration = this.configManager.getConfiguration("twitch-live-loadout", oldNameScopedConfigKey);
            boolean oldConfigurationIsEmpty = oldNameConfiguration == null || oldNameConfiguration.trim().equals("");
            boolean bl = configurationIsEmpty = configuration == null || configuration.trim().equals("");
            if (!oldConfigurationIsEmpty && configurationIsEmpty) {
                this.configManager.setConfiguration("twitch-live-loadout", scopedConfigKey, oldNameConfiguration);
                this.configManager.setConfiguration("twitch-live-loadout", oldNameScopedConfigKey, "");
                configuration = oldNameConfiguration;
                log.info("Migration of config is completed. Moved: " + oldNameScopedConfigKey + ", to: " + scopedConfigKey);
            }
            return configuration;
        }
        catch (Exception exception) {
            log.warn("Could not get the configuration due to the following error: ", (Throwable)exception);
            return null;
        }
    }

    private String getScopedConfigKey(String accountIdentifier, String configKey) {
        try {
            String accountIdentifierPrefix = accountIdentifier.replaceAll("\\s+", "_").trim();
            String scopedConfigKey = accountIdentifierPrefix + "-" + configKey;
            return scopedConfigKey;
        }
        catch (Exception exception) {
            log.warn("Could not get the scoped config key due to the following error: ", (Throwable)exception);
            return null;
        }
    }

    public String getPlayerName() {
        try {
            if (!this.isLoggedIn()) {
                return null;
            }
            return this.client.getLocalPlayer().getName();
        }
        catch (Exception exception) {
            log.warn("Could not get the player name due to the following error: ", (Throwable)exception);
            return null;
        }
    }

    public boolean isDangerousAccountType() {
        JsonElement accountTypeRaw = this.twitchState.getState().get(TwitchStateEntry.ACCOUNT_TYPE.getKey());
        if (accountTypeRaw == null) {
            return false;
        }
        String accountType = accountTypeRaw.getAsString();
        if (accountType == null) {
            return false;
        }
        return accountType.equals(AccountType.HARDCORE_IRONMAN.getKey()) || accountType.equals(AccountType.HARDCORE_GROUP_IRONMAN.getKey());
    }

    public boolean shouldTrackFightStatistics() {
        boolean isDisabledGeneral = !this.config.fightStatisticsEnabled();
        boolean isDisabledDangerous = this.config.fightStatisticsProtectionEnabled() && this.isDangerousAccountType();
        return !isDisabledGeneral && !isDisabledDangerous;
    }

    public boolean canPerformDangerousEffects() {
        boolean isDisabledGeneral = !this.config.marketplaceEnabled();
        boolean isDisabledDangerous = this.config.marketplaceProtectionEnabled() && this.isDangerousAccountType();
        return !isDisabledGeneral && !isDisabledDangerous;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn(false);
    }

    public boolean isLoggedIn(boolean considerTwitchReviewMode) {
        boolean forceIsLoggedIn;
        if (!considerTwitchReviewMode || this.config.twitchReviewModeEnabled()) {
            // empty if block
        }
        if (forceIsLoggedIn = false) {
            return true;
        }
        try {
            if (this.client.getGameState() != GameState.LOGGED_IN) {
                return false;
            }
            return this.client.getLocalPlayer() != null;
        }
        catch (Exception exception) {
            log.warn("Could not get the whether the player is logged in due to the following error: ", (Throwable)exception);
            return false;
        }
    }

    public AccountType getAccountType() {
        Integer accountTypeId = this.client.getVarbitValue(1777);
        for (AccountType accountType : AccountType.values()) {
            if (accountTypeId.intValue() != accountType.getId()) continue;
            return accountType;
        }
        return AccountType.NORMAL;
    }

    public void logSupport(String message) {
        this.logSupport(message, null);
    }

    public void logSupport(String message, Exception exception) {
        if (!this.config.supportDebugEnabled()) {
            return;
        }
        log.info("[SUPPORT] " + message, (Throwable)exception);
    }

    @Provides
    TwitchLiveLoadoutConfig provideConfig(ConfigManager configManager) {
        return (TwitchLiveLoadoutConfig)configManager.getConfig(TwitchLiveLoadoutConfig.class);
    }

    public TwitchLiveLoadoutPanel getPluginPanel() {
        return this.pluginPanel;
    }

    public MarketplaceManager getMarketplaceManager() {
        return this.marketplaceManager;
    }

    public static interface ClientThreadAction {
        public void execute();
    }
}

