/*
 * Decompiled with CFR 0.152.
 */
package com.twitchliveloadout;

import com.twitchliveloadout.twitch.TwitchThemeEntry;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="twitchstreamer")
public interface TwitchLiveLoadoutConfig
extends Config {
    public static final String PLUGIN_CONFIG_GROUP = "twitch-live-loadout";
    public static final String COLLECTION_LOG_CONFIG_KEY = "collection-log";
    public static final String LOOTING_BAG_ITEMS_CONFIG_KEY = "looting-bag-items";
    public static final String LOOTING_BAG_PRICE_CONFIG_KEY = "looting-bag-price";
    public static final String BANK_TABBED_ITEMS_CONFIG_KEY = "bank-items";
    public static final String BANK_PRICE_CONFIG_KEY = "bank-price";
    public static final String INVOCATIONS_CONFIG_KEY = "invocations";
    public static final String INVOCATIONS_RAID_LEVEL_CONFIG_KEY = "invocations-raid-level";
    public static final String QUESTS_CONFIG_KEY = "quests";
    public static final int MIN_OVERLAY_TOP_POSITION = 25;
    public static final int MAX_OVERLAY_TOP_POSITION = 75;
    @ConfigSection(name="Twitch Extension & Token", description="Authentication and extension configuration.", position=0)
    public static final String twitchSection = "twitch";
    @ConfigSection(name="Data Syncing", description="Syncing conditions and multi-account settings", position=2)
    public static final String syncingSection = "syncing";
    @ConfigSection(name="Items", description="Syncing of items in inventory, equipment and bank.", position=5)
    public static final String itemsSection = "items";
    @ConfigSection(name="Combat", description="Syncing of weapon damage, smite drains, poison damage, etc. per enemy.", position=6)
    public static final String combatSection = "combat";
    @ConfigSection(name="Raids", description="Syncing of invocations", position=7)
    public static final String raidsSection = "raids";
    @ConfigSection(name="Skills", description="Syncing of skill experience, virtual levels, etc.", position=8)
    public static final String skillsSection = "skills";
    @ConfigSection(name="Quests", description="Syncing of quests and their status.", position=8)
    public static final String questsSection = "quests";
    @ConfigSection(name="General info", description="Syncing of display name, player weight, etc.", position=10)
    public static final String generalInfoSection = "general-info";
    @ConfigSection(name="Random Event Donations", description="Settings for the Random Event triggered by donations", position=3)
    public static final String marketplaceSection = "donations";
    @ConfigSection(name="Advanced", description="Settings for advanced usage", position=99)
    public static final String advancedSection = "advanced";

    @ConfigItem(keyName="twitchToken", name="Your copied Twitch Extension Token", description="Your token can be found when configuring the Twitch Extension.", secret=true, position=2, section="twitch")
    default public String twitchToken() {
        return "";
    }

    @Range(min=25, max=75)
    @ConfigItem(keyName="overlayTopPosition", name="Overlay top position", description="The position from the top left of the overlay in % of the screen height. Should be between 25 and 75.", position=4, section="twitch")
    @Units(value="%")
    default public int overlayTopPosition() {
        return 35;
    }

    @ConfigItem(keyName="twitchTheme", name="Twitch Extension Theme", description="The theme of the Twitch Extension interface for viewers", position=6, section="twitch")
    default public TwitchThemeEntry twitchTheme() {
        return TwitchThemeEntry.LIGHT;
    }

    @ConfigItem(keyName="syncEnabled", name="Enable syncing", description="Toggle off to disable all syncing, hide extension to viewers and clear data.", position=0, section="syncing")
    default public boolean syncEnabled() {
        return true;
    }

    @Range(min=0, max=120)
    @ConfigItem(keyName="syncDelay", name="Stream delay", description="The amount of seconds to delay the sending of data to match your stream delay.", position=2, section="syncing")
    @Units(value="s")
    default public int syncDelay() {
        return 0;
    }

    @ConfigItem(keyName="inventoryEnabled", name="Sync inventory items", description="Synchronize all inventory items.", position=2, section="items")
    default public boolean inventoryEnabled() {
        return true;
    }

    @ConfigItem(keyName="equipmentEnabled", name="Sync equipment items", description="Synchronize all equipment items.", position=4, section="items")
    default public boolean equipmentEnabled() {
        return true;
    }

    @ConfigItem(keyName="lootingBagEnabled", name="Sync looting bag items", description="Synchronize all looting bag items.", position=5, section="items")
    default public boolean lootingBagEnabled() {
        return true;
    }

    @ConfigItem(keyName="bankEnabled", name="Sync bank items", description="Synchronize bank value and top items based on GE value and configured maximum amount.", position=6, section="items")
    default public boolean bankEnabled() {
        return true;
    }

    @Range(min=0, max=5000)
    @ConfigItem(keyName="bankItemsAmount", name="Max bank items", description="Maximum amount of items chosen by stack value.", position=10, section="items")
    default public int bankItemsAmount() {
        return 5000;
    }

    @ConfigItem(keyName="bankPriceEnabled", name="Sync bank value", description="Synchronize bank value of all items.", position=11, section="items")
    default public boolean bankPriceEnabled() {
        return true;
    }

    @ConfigItem(keyName="collectionLogEnabled", name="Sync collection log", description="Synchronize the collection log quantities and kill counts.", position=12, section="items")
    default public boolean collectionLogEnabled() {
        return true;
    }

    @ConfigItem(keyName="collectionLogFilter", name="Collection log filter (comma separated)", description="Only include entry titles that include one of the keywords separated with a comma (e.g. 'abyssal, raids')", position=14, section="items")
    default public String collectionLogFilter() {
        return "";
    }

    @ConfigItem(keyName="fightStatisticsEnabled", name="Sync combat statistics", description="Synchronize statistics about PvM and PvP, such as DPS, freezes, splashes, etc.", position=2, section="combat")
    default public boolean fightStatisticsEnabled() {
        return true;
    }

    @ConfigItem(keyName="fightStatisticsSpellsEnabled", name="Track magic spells", description="Enable tracking of freezes, entangles, blood spells and splashes.", position=4, section="combat")
    default public boolean fightStatisticsSpellsEnabled() {
        return true;
    }

    @ConfigItem(keyName="fightStatisticsOthersEnabled", name="Track damage by others", description="Enable tracking of hitsplats of other players.", position=6, section="combat")
    default public boolean fightStatisticsOthersEnabled() {
        return true;
    }

    @ConfigItem(keyName="fightStatisticsUnattackedEnabled", name="Track un-attacked enemies", description="Enable tracking of hitsplats on enemies you have not attacked, recommended in team settings such as Cox and ToB.", position=8, section="combat")
    default public boolean fightStatisticsUnattackedEnabled() {
        return false;
    }

    @Range(min=0, max=10)
    @ConfigItem(keyName="fightStatisticsMaxFightAmount", name="Max combat fights", description="Maximum amount of tracked fights with fixed upper limit of 10.", position=10, section="combat")
    default public int fightStatisticsMaxFightAmount() {
        return 10;
    }

    @Range(min=0, max=1440)
    @ConfigItem(keyName="fightStatisticsExpiryTime", name="Fight expiry time", description="Reset a fight after the configured minutes of inactivity.", position=12, section="combat")
    @Units(value=" mins")
    default public int fightStatisticsExpiryTime() {
        return 180;
    }

    @ConfigItem(keyName="fightStatisticsAutoIdling", name="Auto idling of fight timer", description="Stop fight timer when logged out or enemy is not visible.", position=14, section="combat")
    default public boolean fightStatisticsAutoIdling() {
        return true;
    }

    @ConfigItem(keyName="fightStatisticsProtectionEnabled", name="Disable tracking on Hardcores", description="Disable tracking of fight stats on Hardcore Ironmen to interfere as little as possible with combat.", position=16, section="combat", warning="Are you sure you want to toggle fight stats to be tracked on Hardcore Ironmen?")
    default public boolean fightStatisticsProtectionEnabled() {
        return true;
    }

    @ConfigItem(keyName="invocationsEnabled", name="Sync ToA Invocations", description="Synchronize Tombs of Amascut raids invocations.", position=2, section="raids")
    default public boolean invocationsEnabled() {
        return true;
    }

    @ConfigItem(keyName="invocationsRaidLevelEnabled", name="Sync ToA Raid Level", description="Synchronize Tombs of Amascut raids level.", position=4, section="raids")
    default public boolean invocationsRaidLevelEnabled() {
        return true;
    }

    @ConfigItem(keyName="autoDetectInToaRaidEnabled", name="Only Sync in ToA Raid", description="Only synchronize invocations when in the ToA raid.", position=6, section="raids")
    default public boolean autoDetectInToaRaidEnabled() {
        return true;
    }

    @ConfigItem(keyName="skillsEnabled", name="Sync skill levels", description="Synchronize skill experience, level boosts and combat level.", position=2, section="skills")
    default public boolean skillsEnabled() {
        return true;
    }

    @ConfigItem(keyName="virtualLevelsEnabled", name="Virtual levels", description="Use maximum level of 126 instead of 99.", position=4, section="skills")
    default public boolean virtualLevelsEnabled() {
        return true;
    }

    @ConfigItem(keyName="questsEnabled", name="Sync quests", description="Synchronize quests and their completion status.", position=2, section="quests")
    default public boolean questsEnabled() {
        return true;
    }

    @ConfigItem(keyName="playerInfoEnabled", name="Sync display name", description="Synchronize basic player info such as display name.", position=2, section="general-info")
    default public boolean playerInfoEnabled() {
        return true;
    }

    @ConfigItem(keyName="weightEnabled", name="Sync weight of carried items", description="Synchronize the weight of the equipment and inventory items, including weight reduction.", position=4, section="general-info")
    default public boolean weightEnabled() {
        return true;
    }

    @ConfigItem(keyName="itemGoalsEnabled", name="Sync item goals", description="Synchronize the configured item wanted items, progress is automatic from inventory, gear and bank items.", position=14, hidden=true, section="items")
    default public boolean itemGoalsEnabled() {
        return false;
    }

    @ConfigItem(keyName="marketplaceEnabled", name="Enable Random Event donations", description="Enable viewers to make donations to trigger in-game Random Events (requires Twitch Extension configuration!).", position=4, hidden=false, section="donations")
    default public boolean marketplaceEnabled() {
        return true;
    }

    @ConfigItem(keyName="marketplaceProtectionEnabled", name="Enable Hardcore protection", description="Automatically disable random events that could be dangerous for Hardcore Ironmen.", position=6, hidden=false, section="donations", warning="Disabling this allows Random Events that are potentially dangerous in terms of gameplay to be activated by viewers when you have them configured. Are you sure?")
    default public boolean marketplaceProtectionEnabled() {
        return true;
    }

    @ConfigItem(keyName="marketplaceSoundsEnabled", name="Enable sounds", description="Disable to not play any sounds triggered by the random event effects.", position=8, hidden=false, section="donations")
    default public boolean marketplaceSoundsEnabled() {
        return true;
    }

    @ConfigItem(keyName="marketplaceStartOnLoadedAt", name="Correct transaction delay", description="Base the expiry of the effects when it is received and not the transaction time, which can have delays.", position=10, hidden=false, section="donations")
    default public boolean marketplaceStartOnLoadedAt() {
        return true;
    }

    @Range(min=1, max=50)
    @ConfigItem(keyName="marketplaceMaxActiveProducts", name="Max active amount", description="How many random events can be active at once. New ones are queued when maximum is exceeded.", position=12, hidden=false, section="donations")
    default public int marketplaceMaxActiveProducts() {
        return 25;
    }

    @Range(min=0, max=1800)
    @ConfigItem(keyName="marketplaceSharedCooldownS", name="Shared cooldown", description="Cooldown time shared between all random events. This works together with the cooldown time per random event configured in Twitch.", position=14, hidden=false, section="donations")
    @Units(value="s")
    default public int marketplaceSharedCooldownS() {
        return 0;
    }

    @Range(min=1, max=50)
    @ConfigItem(keyName="marketplaceTransactionHistoryAmount", name="Transaction history amount", description="How many transactions are shown in the 'recent donations' panel.", position=16, hidden=false, section="donations")
    default public int marketplaceTransactionHistoryAmount() {
        return 50;
    }

    @Range(min=1, max=10)
    @ConfigItem(keyName="marketplaceOverheadTextDurationS", name="Overhead text duration", description="How long overhead notifications, such as thank you's are shown above the player.", position=18, hidden=false, section="donations")
    @Units(value="s")
    default public int marketplaceOverheadTextDurationS() {
        return 2;
    }

    @ConfigItem(keyName="marketplaceDefaultDonationMessage", name="Default donation message", description="Message shown when random event enabled notifications. Use '{viewerName}', '{currencyAmount}' and '{currencyType}' to replace with values from the transaction.", position=20, hidden=false, section="donations")
    default public String marketplaceDefaultDonationMessage() {
        return "Thank you {viewerName} for donating {currencyAmount} {currencyType}!";
    }

    @ConfigItem(keyName="supportDebugEnabled", name="Support debug mode", description="Enable more extensive logging for support purposes.", position=0, section="advanced")
    default public boolean supportDebugEnabled() {
        return false;
    }

    @ConfigItem(keyName="twitchReviewModeEnabled", name="Twitch review mode", description="Force syncing of data while being logged out, meant for the Twitch review process.", position=2, hidden=true, section="advanced")
    default public boolean twitchReviewModeEnabled() {
        return false;
    }

    @ConfigItem(keyName="debugMenuOptionClicks", name="Debug menu clicks", description="Debug menu option click events.", position=4, hidden=true, section="advanced")
    default public boolean debugMenuOptionClicks() {
        return false;
    }

    @ConfigItem(keyName="testRandomEvents", name="Test Random Events", description="Periodically spawn a random event and move to the next one.", position=6, hidden=true, section="advanced")
    default public boolean testRandomEventsEnabled() {
        return false;
    }

    @ConfigItem(keyName="testRandomEventsRandomly", name="Test Randomly", description="True when selecting randomly instead of cyclic.", position=8, hidden=true, section="advanced")
    default public boolean testRandomEventsRandomly() {
        return false;
    }

    @ConfigItem(keyName="testRandomEventsDuration", name="Test Duration", description="Duration of a single Random Event while testing.", position=10, hidden=true, section="advanced")
    @Units(value="s")
    default public int testRandomEventsDuration() {
        return 10;
    }

    @ConfigItem(keyName="testRandomEventsDelay", name="Test Delay", description="The amount of time before the next Random Event is tested.", position=12, hidden=true, section="advanced")
    @Units(value="s")
    default public int testRandomEventsDelay() {
        return 5;
    }
}

