/*
 * Decompiled with CFR 0.152.
 */
package com.nievive;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Nievive")
public class NievivePlugin
extends Plugin {
    @Inject
    protected Client client;
    @Inject
    protected ClientThread clientThread;
    private static final int STEVE_VARBIT_ID = 5037;
    protected int realSteveVarbitValue = -1;
    protected boolean varbitReplaced = false;

    protected void shutDown() {
        this.resetVarbit();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.resetVarbit();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        if (this.realSteveVarbitValue == -1) {
            this.realSteveVarbitValue = this.client.getVarbitValue(5037);
        }
        if (this.realSteveVarbitValue == 1 && !this.varbitReplaced) {
            this.varbitReplaced = true;
            this.clientThread.invokeLater(() -> this.client.setVarbit(5037, 0));
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (varbitChanged.getVarbitId() != 5037) {
            return;
        }
        if (!this.varbitReplaced) {
            this.realSteveVarbitValue = varbitChanged.getValue();
            return;
        }
        if (varbitChanged.getValue() == this.realSteveVarbitValue) {
            this.varbitReplaced = false;
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (!this.varbitReplaced) {
            Widget npcChatHead = this.client.getWidget(WidgetInfo.DIALOG_NPC_HEAD_MODEL);
            if (npcChatHead != null && npcChatHead.getModelId() == 6797) {
                npcChatHead.setModelId(6798);
            }
            return;
        }
        if (event.getGroupId() == 75) {
            Widget steveHead = this.client.getWidget(75, 32);
            Widget steveLabel = this.client.getWidget(75, 33);
            this.clientThread.invokeLater(() -> {
                if (steveHead == null || steveLabel == null) {
                    return;
                }
                steveLabel.setText("Nieve");
                steveHead.setModelId(16282);
            });
        }
        if (event.getGroupId() == 231) {
            Widget npcChatName = this.client.getWidget(WidgetInfo.DIALOG_NPC_NAME);
            Widget npcChatHead = this.client.getWidget(WidgetInfo.DIALOG_NPC_HEAD_MODEL);
            this.clientThread.invokeLater(() -> {
                if (npcChatHead == null || npcChatName == null) {
                    return;
                }
                if (npcChatName.getText().equals("Steve")) {
                    npcChatName.setText("Nieve");
                }
                if (npcChatHead.getModelId() == 6798) {
                    npcChatHead.setModelId(6797);
                }
            });
        }
        if (event.getGroupId() == 221) {
            Widget nieveGraveHeaderTitle = this.client.getWidget(221, 2);
            nieveGraveHeaderTitle.setText("Steve");
            Widget nieveGraveHeaderOne = this.client.getWidget(221, 4);
            nieveGraveHeaderOne.setText("Once, this place was a monument to Nieve");
            Widget nieveGraveHeaderTwo = this.client.getWidget(221, 5);
            nieveGraveHeaderTwo.setText("Now, this is where we remember Steve");
            Widget nieveGraveHeaderThree = this.client.getWidget(221, 4);
            nieveGraveHeaderThree.setText("Once, this place was a monument to Nieve");
            Widget nieveGraveHonour = this.client.getWidget(221, 12);
            nieveGraveHonour.setText(nieveGraveHonour.getText().replace("Nieve's honour", "Steve's absence"));
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded menuEntryAdded) {
        if (!this.varbitReplaced) {
            return;
        }
        if (menuEntryAdded.getOption().equals("Steve")) {
            menuEntryAdded.getMenuEntry().setOption("Nieve");
        }
    }

    @Subscribe
    protected void onChatMessage(ChatMessage event) {
        MessageNode messageNode;
        if (!this.varbitReplaced) {
            return;
        }
        if (event.getMessage().equals("In memory of Nieve, she looks rich and dead.")) {
            messageNode = event.getMessageNode();
            messageNode.setRuneLiteFormatMessage("In memory of Steve, he's in a different place now.");
            this.client.refreshChat();
        }
        if (event.getMessage().equals("Steve wants you to stick to your Slayer assignments.")) {
            messageNode = event.getMessageNode();
            messageNode.setRuneLiteFormatMessage("Nieve wants you to stick to your Slayer assignments.");
            this.client.refreshChat();
        }
    }

    protected void resetVarbit() {
        if (!this.varbitReplaced) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            this.client.setVarbit(5037, this.realSteveVarbitValue);
            this.realSteveVarbitValue = -1;
            this.varbitReplaced = false;
        });
    }
}

