/*
 * Decompiled with CFR 0.152.
 */
package RHUD.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.runelite.client.ui.overlay.RenderableEntity;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;

public class TextComponentWithAlpha
implements RenderableEntity {
    int alphaOverride = 255;
    private static final String COL_TAG_REGEX = "(<col=([0-9a-fA-F]){2,8}>)";
    private static final Pattern COL_TAG_PATTERN_W_LOOKAHEAD = Pattern.compile("(?=(<col=([0-9a-fA-F]){2,8}>))");
    String text;
    Point position = new Point();
    Color color = Color.WHITE;
    Background background = Background.SHADOW;
    @Nullable
    Font font;

    public void setOutline(boolean b) {
    }

    private static int calculateAlpha(String colorString, int _defaultAlpha) {
        int alpha = _defaultAlpha;
        if (colorString.length() > 6) {
            try {
                alpha = Math.min(Integer.decode("#" + colorString.substring(0, 2)), alpha);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return alpha;
    }

    public Dimension render(Graphics2D graphics) {
        Font originalFont = null;
        if (this.font != null) {
            originalFont = graphics.getFont();
            graphics.setFont(this.font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (COL_TAG_PATTERN_W_LOOKAHEAD.matcher(this.text).find()) {
            String[] parts = COL_TAG_PATTERN_W_LOOKAHEAD.split(this.text);
            int x = this.position.x;
            for (String textSplitOnCol : parts) {
                String textWithoutCol = Text.removeTags((String)textSplitOnCol);
                String argbString = textSplitOnCol.substring(textSplitOnCol.indexOf("=") + 1, textSplitOnCol.indexOf(">"));
                String rgbString = argbString.length() > 6 ? argbString.substring(2) : argbString;
                int alpha = TextComponentWithAlpha.calculateAlpha(argbString, this.alphaOverride);
                graphics.setColor(ColorUtil.colorWithAlpha((Color)Color.BLACK, (int)alpha));
                switch (this.background) {
                    case OUTLINE: {
                        graphics.drawString(textWithoutCol, x, this.position.y + 1);
                        graphics.drawString(textWithoutCol, x, this.position.y - 1);
                        graphics.drawString(textWithoutCol, x + 1, this.position.y);
                        graphics.drawString(textWithoutCol, x - 1, this.position.y);
                        break;
                    }
                    case SHADOW: {
                        graphics.drawString(textWithoutCol, x + 1, this.position.y + 1);
                        break;
                    }
                }
                graphics.setColor(ColorUtil.colorWithAlpha((Color)Color.decode("#" + rgbString), (int)alpha));
                graphics.drawString(textWithoutCol, x, this.position.y);
                x += fontMetrics.stringWidth(textWithoutCol);
            }
        } else {
            graphics.setColor(ColorUtil.colorWithAlpha((Color)Color.BLACK, (int)this.alphaOverride));
            switch (this.background) {
                case OUTLINE: {
                    graphics.drawString(this.text, this.position.x, this.position.y + 1);
                    graphics.drawString(this.text, this.position.x, this.position.y - 1);
                    graphics.drawString(this.text, this.position.x + 1, this.position.y);
                    graphics.drawString(this.text, this.position.x - 1, this.position.y);
                    break;
                }
                case SHADOW: {
                    graphics.drawString(this.text, this.position.x + 1, this.position.y + 1);
                    break;
                }
            }
            graphics.setColor(ColorUtil.colorWithAlpha((Color)this.color, (int)this.alphaOverride));
            graphics.drawString(this.text, this.position.x, this.position.y);
        }
        int width = fontMetrics.stringWidth(this.text);
        int height = fontMetrics.getHeight();
        if (originalFont != null) {
            graphics.setFont(originalFont);
        }
        return new Dimension(width, height);
    }

    public void setAlphaOverride(int alphaOverride) {
        this.alphaOverride = alphaOverride;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void setFont(@Nullable Font font) {
        this.font = font;
    }

    public static enum Background {
        SHADOW,
        OUTLINE;

    }
}

