/*
 * Decompiled with CFR 0.152.
 */
package RHUD.helpers;

import RHUD.RHUD_Config;
import RHUD.helpers.OverlayManager;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import net.runelite.client.ui.FontManager;

public class FontHandler {
    private String lastFont = "";
    private int lastFontSize = 0;
    private boolean useRunescapeFont = true;
    private RHUD_Config.FontStyle lastFontStyle = RHUD_Config.FontStyle.DEFAULT;
    private Font font = null;

    public void handleFont(Graphics2D graphics) {
        if (this.font != null) {
            graphics.setFont(this.font);
            if (this.useRunescapeFont) {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
    }

    public void updateFont(String fontName, int fontSize, RHUD_Config.FontStyle fontStyle) {
        if (!this.lastFont.equals(fontName) || this.lastFontSize != fontSize || this.lastFontStyle != fontStyle) {
            this.lastFont = fontName;
            this.lastFontSize = fontSize;
            this.lastFontStyle = fontStyle;
            int style = fontStyle.getStyle();
            if ("".equals(fontName)) {
                if (fontSize < 16) {
                    this.font = FontManager.getRunescapeSmallFont();
                }
                if (fontStyle == RHUD_Config.FontStyle.BOLD || fontStyle == RHUD_Config.FontStyle.BOLD_ITALICS) {
                    this.font = OverlayManager.RUNESCAPE_BOLD_FONT;
                    style ^= 1;
                } else {
                    this.font = FontManager.getRunescapeFont();
                }
                this.font = this.font.deriveFont(style);
                this.useRunescapeFont = true;
                return;
            }
            this.font = new Font(fontName, style, fontSize);
            this.useRunescapeFont = false;
        }
    }
}

