/*
 * Decompiled with CFR 0.152.
 */
package RHUD;

import RHUD.RHUD_Config;
import RHUD.helpers.BarTextMode;
import RHUD.helpers.FontHandler;
import RHUD.helpers.TextComponentWithAlpha;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.util.function.Supplier;

class RHUD_StatusRender {
    private static final Color BACKGROUND = new Color(30, 30, 30, 150);
    private static final Color OVERHEAL_COLOR = new Color(216, 255, 139, 150);
    private static final int SKILL_ICON_HEIGHT = 24;
    private static final int BORDER_SIZE = 1;
    private static final int MIN_ICON_AND_COUNTER_WIDTH = 16;
    static final int DEFAULT_WIDTH = 20;
    static final int DEFAULT_HEIGHT = 20;
    static final int MIN_WIDTH = 60;
    static final int MAX_WIDTH = 500;
    private final Supplier<Integer> maxValueSupplier;
    private final Supplier<Integer> currentValueSupplier;
    private final Supplier<Integer> healSupplier;
    private final Supplier<Color> colorSupplier;
    private final Supplier<Color> healColorSupplier;
    private final Supplier<Image> iconSupplier;
    private int maxValue;
    private int currentValue;
    private final FontHandler FontHandler = new FontHandler();

    private void refreshSkills() {
        this.maxValue = this.maxValueSupplier.get();
        this.currentValue = this.currentValueSupplier.get();
    }

    public void renderBar(RHUD_Config config, Graphics2D graphics, int x, int y, int width) {
        int filledHeight = RHUD_StatusRender.getBarHeight(this.maxValue, this.currentValue, config.barWidth());
        int filledWidth = RHUD_StatusRender.getBarHeight(this.maxValue, this.currentValue, 250);
        Color fill = this.colorSupplier.get();
        this.refreshSkills();
        int adjustedY = y;
        int adjustedX = x;
        graphics.setColor(BACKGROUND);
        if (config.vertBars()) {
            graphics.drawRect(adjustedX, adjustedY, width - 1, config.barWidth() - 1);
            graphics.fillRect(adjustedX, adjustedY, width, config.barWidth());
        } else if (config.SidebySide()) {
            graphics.drawRect(adjustedX, adjustedY, 249, width - 1);
            graphics.fillRect(adjustedX, adjustedY, 250, width);
        } else {
            graphics.drawRect(adjustedX, adjustedY, config.barWidth() - 1, width - 1);
            graphics.fillRect(adjustedX, adjustedY, config.barWidth(), width);
        }
        graphics.setColor(fill);
        if (config.vertBars()) {
            graphics.fillRect(adjustedX + 1, adjustedY + 1 + (config.barWidth() - filledHeight), width - 2, filledHeight - 2);
        } else if (config.SidebySide()) {
            graphics.fillRect(adjustedX + 1, adjustedY + 1, filledWidth - 2, width - 2);
        } else {
            graphics.fillRect(adjustedX + 1, adjustedY + 1, filledHeight - 2, width - 2);
        }
        if (config.enableRestorationBars()) {
            this.renderRestore(config, graphics, adjustedX, adjustedY, width);
        }
        if (config.enableSkillIcon() || config.enableCounter()) {
            this.renderIconsAndCounters(config, graphics, adjustedX, adjustedY, width);
        }
    }

    private void renderIconsAndCounters(RHUD_Config config, Graphics2D graphics, int x, int y, int width) {
        if (width < 16) {
            return;
        }
        boolean skillIconEnabled = config.enableSkillIcon();
        if (skillIconEnabled) {
            Image icon = this.iconSupplier.get();
            int xDraw = x + width / 2 - icon.getWidth(null) / 2;
            if (config.vertBars()) {
                if (config.textMode() == BarTextMode.Icon_top_Text_bottom) {
                    graphics.drawImage(icon, xDraw, y + 4, null);
                } else if (config.textMode() == BarTextMode.Both_Bottom) {
                    graphics.drawImage(icon, xDraw, config.barWidth() - 21, null);
                } else if (config.textMode() == BarTextMode.Text_top_Icon_bottom) {
                    graphics.drawImage(icon, xDraw, config.barWidth() - 21, null);
                } else if (config.textMode() == BarTextMode.Both_Top) {
                    graphics.drawImage(icon, xDraw, y + 4, null);
                }
            } else {
                graphics.drawImage(icon, xDraw, y + 2, null);
            }
        }
        if (config.enableCounter()) {
            this.FontHandler.updateFont(config.fontName(), config.fontSize(), config.fontStyle());
            this.FontHandler.handleFont(graphics);
            String counterText = Integer.toString(this.currentValue);
            int widthOfCounter = graphics.getFontMetrics().stringWidth(counterText);
            int centerText = width / 2 - widthOfCounter / 2;
            int xOffset = skillIconEnabled ? 36 : 21;
            int hOffset = skillIconEnabled ? 24 : 8;
            int yOffset = skillIconEnabled ? config.barWidth() - 27 : config.barWidth() - 10;
            int eOffset = config.barWidth() - 10;
            TextComponentWithAlpha textComponent = new TextComponentWithAlpha();
            textComponent.setColor(config.counterColor());
            textComponent.setOutline(true);
            textComponent.setText(counterText);
            if (config.vertBars()) {
                if (config.textMode() == BarTextMode.Icon_top_Text_bottom) {
                    textComponent.setPosition(new Point(x + centerText, y + eOffset));
                } else if (config.textMode() == BarTextMode.Both_Bottom) {
                    textComponent.setPosition(new Point(x + centerText, y + yOffset));
                } else if (config.textMode() == BarTextMode.Text_top_Icon_bottom) {
                    textComponent.setPosition(new Point(x + centerText, y + 17));
                } else if (config.textMode() == BarTextMode.Both_Top) {
                    textComponent.setPosition(new Point(x + centerText, y + xOffset));
                }
            } else {
                textComponent.setPosition(new Point(x + hOffset + centerText, y + 15));
            }
            textComponent.render(graphics);
        }
    }

    private void renderRestore(RHUD_Config config, Graphics2D graphics, int x, int y, int width) {
        Color color = this.healColorSupplier.get();
        int heal = this.healSupplier.get();
        if (heal <= 0) {
            return;
        }
        int filledCurrentHeight = RHUD_StatusRender.getBarHeight(this.maxValue, this.currentValue, config.barWidth());
        int filledHealHeight = RHUD_StatusRender.getBarHeight(this.maxValue, heal, config.barWidth());
        int filledCurrentWidth = RHUD_StatusRender.getBarWidth(this.maxValue, this.currentValue, config.barWidth());
        int filledHealWidth = RHUD_StatusRender.getBarHeight(this.maxValue, heal, config.barWidth());
        int filledCurrentLeft = RHUD_StatusRender.getBarWidth(this.maxValue, this.currentValue, 250);
        int filledHealLeft = RHUD_StatusRender.getBarHeight(this.maxValue, heal, 250);
        graphics.setColor(color);
        if (!config.vertBars() && !config.SidebySide()) {
            int fillWidth;
            int fillX;
            if (filledHealWidth + filledCurrentWidth > config.barWidth()) {
                graphics.setColor(OVERHEAL_COLOR);
                fillX = x - 1 + filledCurrentWidth;
                fillWidth = config.barWidth() - filledCurrentWidth - 1;
            } else {
                fillX = x - 1 + (filledCurrentWidth - filledHealWidth) + filledHealWidth;
                fillWidth = filledHealWidth;
            }
            graphics.fillRect(fillX, y + 1, fillWidth, width - 2);
        }
        if (config.SidebySide()) {
            int fillLeft;
            int fillH;
            if (filledHealLeft + filledCurrentLeft > 250) {
                graphics.setColor(OVERHEAL_COLOR);
                fillH = x - 1 + filledCurrentLeft;
                fillLeft = 250 - filledCurrentLeft - 1;
            } else {
                fillH = x - 1 + (filledCurrentLeft - filledHealLeft) + filledHealLeft;
                fillLeft = filledHealLeft;
            }
            graphics.fillRect(fillH, y + 1, fillLeft, width - 2);
        }
        if (config.vertBars()) {
            int fillHeight;
            int fillY;
            if (filledHealHeight + filledCurrentHeight > config.barWidth()) {
                graphics.setColor(OVERHEAL_COLOR);
                fillY = y + 1;
                fillHeight = config.barWidth() - filledCurrentHeight + 1;
            } else {
                fillY = y + 1 + config.barWidth() - (filledCurrentHeight + filledHealHeight * 2) + filledHealHeight;
                fillHeight = filledHealHeight;
            }
            graphics.fillRect(x + 1, fillY, width - 2, fillHeight);
        }
    }

    private static int getBarHeight(int base, int current, int size) {
        double ratio = (double)current / (double)base;
        if (ratio >= 1.0) {
            return size;
        }
        return (int)Math.round(ratio * (double)size);
    }

    private static int getBarWidth(int base, int current, int size) {
        double ratio = (double)current / (double)base;
        if (ratio >= 1.0) {
            return size;
        }
        return (int)Math.round(ratio * (double)size);
    }

    public RHUD_StatusRender(Supplier<Integer> maxValueSupplier, Supplier<Integer> currentValueSupplier, Supplier<Integer> healSupplier, Supplier<Color> colorSupplier, Supplier<Color> healColorSupplier, Supplier<Image> iconSupplier) {
        this.maxValueSupplier = maxValueSupplier;
        this.currentValueSupplier = currentValueSupplier;
        this.healSupplier = healSupplier;
        this.colorSupplier = colorSupplier;
        this.healColorSupplier = healColorSupplier;
        this.iconSupplier = iconSupplier;
    }
}

