/*
 * Decompiled with CFR 0.152.
 */
package RHUD;

import RHUD.RHUD_Config;
import RHUD.RHUD_Overlay;
import com.google.inject.Provides;
import java.util.EnumMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependencies;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.itemstats.ItemStatPlugin;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.ArrayUtils;

@PluginDescriptor(name="RHUD", description="Experience and Status bar hud for combat and skilling.", tags={"exp", "xp", "tracker", "status", "bar"})
@PluginDependencies(value={@PluginDependency(value=XpTrackerPlugin.class), @PluginDependency(value=ItemStatPlugin.class)})
public class RHUD_Plugin
extends Plugin {
    @Inject
    private RHUD_Overlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private RHUD_Config config;
    @Inject
    private ClientThread clientThread;
    private boolean barsDisplayed;
    public Skill currentSkill;
    private final Map<Skill, Integer> skillList = new EnumMap<Skill, Integer>(Skill.class);
    private int lastCombatActionTickCount;

    protected void startUp() {
        this.clientThread.invokeLater(this::checkStatusBars);
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.barsDisplayed = false;
    }

    @Provides
    RHUD_Config provideConfig(ConfigManager configManager) {
        return (RHUD_Config)configManager.getConfig(RHUD_Config.class);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.checkStatusBars();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("SB".equals(event.getGroup()) && event.getKey().equals("hideAfterCombatDelay")) {
            this.clientThread.invokeLater(this::checkStatusBars);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Integer lastXP = this.skillList.put(statChanged.getSkill(), statChanged.getXp());
        if (lastXP != null && lastXP.intValue() != statChanged.getXp()) {
            this.currentSkill = statChanged.getSkill();
        }
    }

    public void checkStatusBars() {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return;
        }
        Actor interacting = localPlayer.getInteracting();
        if (this.config.hideAfterCombatDelay() == 0) {
            this.barsDisplayed = true;
        } else if (interacting instanceof NPC && ArrayUtils.contains((Object[])((NPC)interacting).getComposition().getActions(), (Object)"Attack") || interacting instanceof Player && this.client.getVarbitValue(8121) == 1) {
            this.lastCombatActionTickCount = this.client.getTickCount();
            this.barsDisplayed = true;
        } else if (this.client.getTickCount() - this.lastCombatActionTickCount >= this.config.hideAfterCombatDelay()) {
            this.barsDisplayed = false;
        }
    }

    boolean isBarsDisplayed() {
        return this.barsDisplayed;
    }

    Skill getCurrentSkill() {
        return this.currentSkill;
    }
}

