/*
 * Decompiled with CFR 0.152.
 */
package RHUD;

import RHUD.RHUD_Config;
import RHUD.RHUD_Plugin;
import RHUD.RHUD_StatusRender;
import RHUD.helpers.FontHandler;
import RHUD.helpers.ModeSet;
import RHUD.helpers.OverlayManager;
import RHUD.helpers.VertTrackerPlacement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.MenuEntry;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.AlternateSprites;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.itemstats.Effect;
import net.runelite.client.plugins.itemstats.ItemStatChangesService;
import net.runelite.client.plugins.itemstats.StatChange;
import net.runelite.client.plugins.xptracker.XpActionType;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.ImageUtil;

public class RHUD_Overlay
extends OverlayPanel {
    private static final Color ACTIVE_PRAYER_COLOR = new Color(43, 234, 159, 255);
    private static final Color POISONED_COLOR = new Color(0, 145, 0, 255);
    private static final Color VENOMED_COLOR = new Color(0, 65, 0, 255);
    private static final Color HEAL_COLOR = new Color(255, 112, 6, 150);
    private static final Color PRAYER_HEAL_COLOR = new Color(57, 255, 186, 75);
    private static final Color ENERGY_HEAL_COLOR = new Color(199, 118, 0, 218);
    private static final Color RUN_STAMINA_COLOR = new Color(168, 124, 62, 255);
    private static final Color SPECIAL_ACTIVE = new Color(4, 173, 1, 255);
    private static final Color RUN_ACTIVE = new Color(185, 187, 0, 255);
    private static final Color DISEASE_COLOR = new Color(176, 134, 53, 255);
    private static final Color PARASITE_COLOR = new Color(196, 62, 109, 255);
    private static final Color BACKGROUND = new Color(0, 0, 0, 120);
    private static final int BORDER_SIZE = 1;
    private static final int IMAGE_SIZE = 17;
    private static final Dimension ICON_DIMENSIONS = new Dimension(18, 17);
    private static final int MAX_SPECIAL_ATTACK_VALUE = 100;
    private static final int MAX_RUN_ENERGY_VALUE = 100;
    private final Client client;
    private final RHUD_Plugin plugin;
    private final RHUD_Config config;
    private final ItemStatChangesService itemStatService;
    private final SpriteManager spriteManager;
    private final Image prayerIcon;
    private final Image heartDisease;
    private final Image heartPoison;
    private final Image heartVenom;
    private Image heartIcon;
    private Image specialIcon;
    private Image energyIcon;
    private final XpTrackerService xpTrackerService;
    private int currentXP;
    private int currentLevel;
    private int nextLevelXP;
    private final Map<ModeSet, RHUD_StatusRender> modeSet = new EnumMap<ModeSet, RHUD_StatusRender>(ModeSet.class);
    private final FontHandler FontHandler = new FontHandler();

    @Inject
    private RHUD_Overlay(Client client, RHUD_Plugin plugin, RHUD_Config config, SkillIconManager skillIconManager, ItemStatChangesService itemstatservice, SpriteManager spriteManager, OverlayManager overlayManager, XpTrackerService xpTrackerService) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.itemStatService = itemstatservice;
        this.spriteManager = spriteManager;
        this.xpTrackerService = xpTrackerService;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.prayerIcon = ImageUtil.resizeCanvas((BufferedImage)ImageUtil.resizeImage((BufferedImage)skillIconManager.getSkillImage(Skill.PRAYER, true), (int)17, (int)17), (int)RHUD_Overlay.ICON_DIMENSIONS.width, (int)RHUD_Overlay.ICON_DIMENSIONS.height);
        this.heartDisease = ImageUtil.resizeCanvas((BufferedImage)ImageUtil.loadImageResource(AlternateSprites.class, (String)"1067-DISEASE.png"), (int)RHUD_Overlay.ICON_DIMENSIONS.width, (int)RHUD_Overlay.ICON_DIMENSIONS.height);
        this.heartPoison = ImageUtil.resizeCanvas((BufferedImage)ImageUtil.loadImageResource(AlternateSprites.class, (String)"1067-POISON.png"), (int)RHUD_Overlay.ICON_DIMENSIONS.width, (int)RHUD_Overlay.ICON_DIMENSIONS.height);
        this.heartVenom = ImageUtil.resizeCanvas((BufferedImage)ImageUtil.loadImageResource(AlternateSprites.class, (String)"1067-VENOM.png"), (int)RHUD_Overlay.ICON_DIMENSIONS.width, (int)RHUD_Overlay.ICON_DIMENSIONS.height);
        this.initModes();
    }

    private void initModes() {
        this.modeSet.put(ModeSet.DISABLED, null);
        this.modeSet.put(ModeSet.HITPOINTS, new RHUD_StatusRender(() -> this.inLms() ? 99 : this.client.getRealSkillLevel(Skill.HITPOINTS), () -> this.client.getBoostedSkillLevel(Skill.HITPOINTS), () -> this.getRestoreValue(Skill.HITPOINTS.getName()), () -> {
            int poisonState = this.client.getVarpValue(102);
            if (poisonState >= 1000000) {
                return VENOMED_COLOR;
            }
            if (poisonState > 0) {
                return POISONED_COLOR;
            }
            if (this.client.getVarpValue(456) > 0) {
                return DISEASE_COLOR;
            }
            if (this.client.getVarbitValue(10151) >= 1) {
                return PARASITE_COLOR;
            }
            return this.config.colorHealthBar();
        }, () -> HEAL_COLOR, () -> {
            int poisonState = this.client.getVarpValue(102);
            if (poisonState > 0 && poisonState < 50) {
                return this.heartPoison;
            }
            if (poisonState >= 1000000) {
                return this.heartVenom;
            }
            if (this.client.getVarpValue(456) > 0) {
                return this.heartDisease;
            }
            return this.heartIcon;
        }));
        this.modeSet.put(ModeSet.PRAYER, new RHUD_StatusRender(() -> this.inLms() ? 99 : this.client.getRealSkillLevel(Skill.PRAYER), () -> this.client.getBoostedSkillLevel(Skill.PRAYER), () -> this.getRestoreValue(Skill.PRAYER.getName()), () -> {
            Color prayerColor = this.config.colorPrayBar();
            for (Prayer pray : Prayer.values()) {
                if (!this.client.isPrayerActive(pray)) continue;
                prayerColor = ACTIVE_PRAYER_COLOR;
                break;
            }
            return prayerColor;
        }, () -> PRAYER_HEAL_COLOR, () -> this.prayerIcon));
        this.modeSet.put(ModeSet.RUN_ENERGY, new RHUD_StatusRender(() -> 100, () -> this.client.getEnergy() / 100, () -> this.getRestoreValue("Run Energy"), () -> {
            if (this.client.getVarbitValue(25) != 0) {
                return RUN_STAMINA_COLOR;
            }
            if (this.client.getVarpValue(173) == 1) {
                return RUN_ACTIVE;
            }
            return this.config.colorRunBar();
        }, () -> ENERGY_HEAL_COLOR, () -> this.energyIcon));
        this.modeSet.put(ModeSet.SPECIAL_ATTACK, new RHUD_StatusRender(() -> 100, () -> this.client.getVarpValue(300) / 10, () -> 0, () -> {
            if (this.client.getVarpValue(301) == 1) {
                return SPECIAL_ACTIVE;
            }
            return this.config.colorSpecialBar();
        }, this.config::colorSpecialBar, () -> this.specialIcon));
    }

    public Dimension render(Graphics2D graphics) {
        Dimension dimension = null;
        Widget bankContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_INVENTORY_CONTAINER);
        if (bankContainer == null || bankContainer.isHidden()) {
            int width = 20;
            int adjustedX = 0;
            int adjustedY = 0;
            int height = 20;
            if (this.config.XPtracker()) {
                if (this.config.mostRecentSkill()) {
                    this.renderBar(graphics);
                }
                if (!this.config.mostRecentSkill()) {
                    this.renderBarRecent(graphics);
                }
            }
            if (this.config.enableTip()) {
                this.renderTrackerOverlay(graphics);
                this.renderTrackerIcons(this.config, graphics, width, height, new SkillIconManager());
            }
            dimension = !this.config.vertBars() && !this.config.SidebySide() ? new Dimension(this.config.barWidth(), width) : (this.config.vertBars() ? new Dimension(width, this.config.barWidth()) : new Dimension(500, width));
            if (!this.plugin.isBarsDisplayed()) {
                return null;
            }
            this.FontHandler.updateFont(this.config.fontName(), this.config.fontSize(), this.config.fontStyle());
            this.FontHandler.handleFont(graphics);
            this.buildIcons();
            RHUD_StatusRender Bar1 = this.modeSet.get((Object)this.config.bar1BarMode());
            RHUD_StatusRender Bar2 = this.modeSet.get((Object)this.config.bar2BarMode());
            RHUD_StatusRender Bar3 = this.modeSet.get((Object)this.config.bar3BarMode());
            RHUD_StatusRender Bar4 = this.modeSet.get((Object)this.config.bar4BarMode());
            if (Bar1 != null) {
                if (this.config.vertBars()) {
                    Bar1.renderBar(this.config, graphics, adjustedX + 11, adjustedY, width);
                    dimension = new Dimension(width + 11, this.config.barWidth());
                } else if (this.config.SidebySide()) {
                    Bar1.renderBar(this.config, graphics, adjustedX, adjustedY + 20, width);
                    dimension = new Dimension(500, width + 20);
                } else {
                    Bar1.renderBar(this.config, graphics, adjustedX, adjustedY + 20, width);
                    dimension = new Dimension(this.config.barWidth(), width + 20);
                }
            }
            if (Bar2 != null) {
                if (this.config.vertBars()) {
                    Bar2.renderBar(this.config, graphics, adjustedX + 31, adjustedY, width);
                    dimension = new Dimension(width + 31, this.config.barWidth());
                } else if (this.config.SidebySide()) {
                    Bar2.renderBar(this.config, graphics, adjustedX + 250, adjustedY + 20, width);
                    dimension = new Dimension(500, width + 20);
                } else {
                    Bar2.renderBar(this.config, graphics, adjustedX, adjustedY + 40, width);
                    dimension = new Dimension(this.config.barWidth(), width + 40);
                }
            }
            if (Bar3 != null) {
                if (this.config.vertBars()) {
                    Bar3.renderBar(this.config, graphics, adjustedX + 51, adjustedY, width);
                    dimension = new Dimension(width + 51, this.config.barWidth());
                } else if (this.config.SidebySide()) {
                    Bar3.renderBar(this.config, graphics, adjustedX, adjustedY + 40, width);
                    dimension = new Dimension(500, width + 40);
                } else {
                    Bar3.renderBar(this.config, graphics, adjustedX, adjustedY + 60, width);
                    dimension = new Dimension(this.config.barWidth(), width + 60);
                }
            }
            if (Bar4 != null) {
                if (this.config.vertBars()) {
                    Bar4.renderBar(this.config, graphics, adjustedX + 71, adjustedY, width);
                    dimension = new Dimension(width + 71, this.config.barWidth());
                } else if (this.config.SidebySide()) {
                    Bar4.renderBar(this.config, graphics, adjustedX + 250, adjustedY + 40, width);
                    dimension = new Dimension(500, width + 40);
                } else {
                    Bar4.renderBar(this.config, graphics, adjustedX, adjustedY + 80, width);
                    dimension = new Dimension(this.config.barWidth(), width + 80);
                }
            }
        }
        return dimension;
    }

    private int getRestoreValue(String skill) {
        Effect change;
        MenuEntry[] menu = this.client.getMenuEntries();
        int menuSize = menu.length;
        if (menuSize == 0) {
            return 0;
        }
        MenuEntry entry = menu[menuSize - 1];
        Widget widget = entry.getWidget();
        int restoreValue = 0;
        if (widget != null && widget.getId() == WidgetInfo.INVENTORY.getId() && (change = this.itemStatService.getItemStatChanges(widget.getItemId())) != null) {
            for (StatChange c : change.calculate(this.client).getStatChanges()) {
                int value = c.getTheoretical();
                if (value == 0 || !c.getStat().getName().equals(skill)) continue;
                restoreValue = value;
            }
        }
        return restoreValue;
    }

    private void buildIcons() {
        if (this.heartIcon == null) {
            this.heartIcon = this.loadAndResize(1067);
        }
        if (this.energyIcon == null) {
            this.energyIcon = this.loadAndResize(1069);
        }
        if (this.specialIcon == null) {
            this.specialIcon = this.loadAndResize(1610);
        }
    }

    private BufferedImage loadAndResize(int spriteId) {
        BufferedImage image = this.spriteManager.getSprite(spriteId, 0);
        if (image == null) {
            return null;
        }
        return ImageUtil.resizeCanvas((BufferedImage)image, (int)15, (int)RHUD_Overlay.ICON_DIMENSIONS.height);
    }

    private boolean inLms() {
        return this.client.getWidget(WidgetInfo.LMS_KDA) != null;
    }

    private void renderBar(Graphics2D graphics) {
        if (this.config.mostRecentSkill()) {
            Skill skill = this.plugin.getCurrentSkill() == null ? this.config.skill() : this.plugin.getCurrentSkill();
            this.currentXP = this.client.getSkillExperience(skill);
            this.currentLevel = Experience.getLevelForXp((int)this.currentXP);
            this.nextLevelXP = Experience.getXpForLevel((int)(this.currentLevel + 1));
            int currentLevelXP = Experience.getXpForLevel((int)this.currentLevel);
            int adjustedY = 8;
            int adjustedWidth = this.config.SidebySide() && !this.config.vertBars() ? 500 : this.config.barWidth();
            int filledHeight = RHUD_Overlay.getBarHeight(this.nextLevelXP - currentLevelXP, this.currentXP - currentLevelXP, adjustedWidth);
            Color barColor = this.config.colorXP();
            Widget bankContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
            if (bankContainer == null || bankContainer.isHidden()) {
                this.drawBarLarge(graphics, 0, adjustedY, adjustedWidth, filledHeight, barColor, this.config.colorXPNotches());
            }
        }
    }

    private void drawBarLarge(Graphics graphics, int adjustedX, int adjustedY, int adjustedWidth, int fill, Color barColor, Color notchColor) {
        if (this.config.mostRecentSkill()) {
            Skill skill = this.plugin.getCurrentSkill() == null ? this.config.skill() : this.plugin.getCurrentSkill();
            this.currentXP = this.client.getSkillExperience(skill);
        }
        this.currentLevel = Experience.getLevelForXp((int)this.currentXP);
        this.nextLevelXP = Experience.getXpForLevel((int)(this.currentLevel + 1));
        int currentLevelXP = Experience.getXpForLevel((int)this.currentLevel);
        int filledWidth = RHUD_Overlay.getBarHeight(this.nextLevelXP - currentLevelXP, this.currentXP - currentLevelXP, adjustedWidth);
        int adjustedHeight = this.config.SidebySide() && !this.config.vertBars() ? 500 : this.config.barWidth();
        graphics.setColor(BACKGROUND);
        if (this.config.vertBars()) {
            graphics.drawRect(adjustedX, adjustedY - 8, 11, adjustedWidth - 1);
            graphics.fillRect(adjustedX, adjustedY - 8, 12, adjustedWidth);
        } else {
            graphics.drawRect(adjustedX, adjustedY, adjustedWidth - 1, 11);
            graphics.fillRect(adjustedX, adjustedY, adjustedWidth, 12);
        }
        graphics.setColor(barColor);
        if (this.config.vertBars()) {
            graphics.fillRect(adjustedX + 1, adjustedY + 1 + (this.config.barWidth() - filledWidth) - 8, 10, filledWidth - 2);
        } else {
            graphics.fillRect(adjustedX + 1, adjustedY + 1, filledWidth - 2, 10);
        }
        graphics.setColor(notchColor);
        if (!this.config.vertBars()) {
            graphics.fillRect(adjustedX + adjustedHeight / 10, adjustedY + 1, 1, 10);
            graphics.fillRect(adjustedX + 2 * (adjustedHeight / 10), adjustedY + 1, 1, 10);
            graphics.fillRect(adjustedX + 3 * (adjustedHeight / 10), adjustedY + 1, 1, 10);
            graphics.fillRect(adjustedX + 4 * (adjustedHeight / 10), adjustedY + 1, 1, 10);
            graphics.fillRect(adjustedX + 5 * (adjustedHeight / 10), adjustedY + 1, 1, 10);
            graphics.fillRect(adjustedX + 6 * (adjustedHeight / 10), adjustedY + 1, 1, 10);
            graphics.fillRect(adjustedX + 7 * (adjustedHeight / 10), adjustedY + 1, 1, 10);
            graphics.fillRect(adjustedX + 8 * (adjustedHeight / 10), adjustedY + 1, 1, 10);
            graphics.fillRect(adjustedX + 9 * (adjustedHeight / 10), adjustedY + 1, 1, 10);
        } else {
            graphics.fillRect(adjustedX + 1, adjustedY + adjustedHeight / 10 - 8, 10, 1);
            graphics.fillRect(adjustedX + 1, adjustedY + 2 * (adjustedHeight / 10) - 8, 10, 1);
            graphics.fillRect(adjustedX + 1, adjustedY + 3 * (adjustedHeight / 10) - 8, 10, 1);
            graphics.fillRect(adjustedX + 1, adjustedY + 4 * (adjustedHeight / 10) - 8, 10, 1);
            graphics.fillRect(adjustedX + 1, adjustedY + 5 * (adjustedHeight / 10) - 8, 10, 1);
            graphics.fillRect(adjustedX + 1, adjustedY + 6 * (adjustedHeight / 10) - 8, 10, 1);
            graphics.fillRect(adjustedX + 1, adjustedY + 7 * (adjustedHeight / 10) - 8, 10, 1);
            graphics.fillRect(adjustedX + 1, adjustedY + 8 * (adjustedHeight / 10) - 8, 10, 1);
            graphics.fillRect(adjustedX + 1, adjustedY + 9 * (adjustedHeight / 10) - 8, 10, 1);
        }
    }

    private void renderBarRecent(Graphics2D graphics) {
        Skill skill = this.config.skill();
        this.currentXP = this.client.getSkillExperience(skill);
        this.currentLevel = Experience.getLevelForXp((int)this.currentXP);
        this.nextLevelXP = Experience.getXpForLevel((int)(this.currentLevel + 1));
        int currentLevelXP = Experience.getXpForLevel((int)this.currentLevel);
        int adjustedX = 0;
        int adjustedY = 8;
        int adjustedWidth = this.config.SidebySide() && !this.config.vertBars() ? 500 : this.config.barWidth();
        int filledWidth = RHUD_Overlay.getBarWidth(this.nextLevelXP - currentLevelXP, this.currentXP - currentLevelXP, adjustedWidth);
        Color barColor = this.config.colorXP();
        Widget bankContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (bankContainer == null || bankContainer.isHidden()) {
            this.drawBarLarge(graphics, adjustedX, adjustedY, adjustedWidth, filledWidth, barColor, this.config.colorXPNotches());
        }
    }

    private void renderTrackerOverlay(Graphics2D graphics) {
        String name;
        Skill skill;
        if (this.config.mostRecentSkill() && this.plugin.getCurrentSkill() == null || !this.config.mostRecentSkill()) {
            skill = this.config.skill();
            name = this.config.skill().getName();
        } else if (this.config.mostRecentSkill()) {
            skill = this.plugin.getCurrentSkill();
            name = this.plugin.getCurrentSkill().getName();
        } else {
            skill = this.plugin.getCurrentSkill();
            name = this.plugin.getCurrentSkill().getName();
        }
        this.currentXP = this.client.getSkillExperience(skill);
        this.currentLevel = Experience.getLevelForXp((int)this.currentXP);
        this.nextLevelXP = Experience.getXpForLevel((int)(this.currentLevel + 1));
        int counterLevel = this.client.getBoostedSkillLevel(skill);
        String counterLevelText = Integer.toString(counterLevel);
        int startXp = this.xpTrackerService.getStartGoalXp(skill);
        int goalXp = this.xpTrackerService.getEndGoalXp(skill);
        int xpNeeded = this.nextLevelXP - this.currentXP;
        NumberFormat f = NumberFormat.getNumberInstance(Locale.US);
        String skillCurrentXp = f.format(this.currentXP);
        Color BODY_COLOUR = null;
        switch (name) {
            case "Cooking": {
                BODY_COLOUR = new Color(5973610);
                break;
            }
            case "Attack": {
                BODY_COLOUR = new Color(12715012);
                break;
            }
            case "Strength": {
                BODY_COLOUR = new Color(880714);
                break;
            }
            case "Defence": {
                BODY_COLOUR = new Color(6847160);
                break;
            }
            case "Ranged": {
                BODY_COLOUR = new Color(6125085);
                break;
            }
            case "Prayer": {
                BODY_COLOUR = new Color(0xFFFFFF);
                break;
            }
            case "Magic": {
                BODY_COLOUR = new Color(3422097);
                break;
            }
            case "Runecraft": {
                BODY_COLOUR = new Color(13797173);
                break;
            }
            case "Construction": {
                BODY_COLOUR = new Color(10721154);
                break;
            }
            case "Hitpoints": {
                BODY_COLOUR = new Color(13618889);
                break;
            }
            case "Agility": {
                BODY_COLOUR = new Color(2763892);
                break;
            }
            case "Herblore": {
                BODY_COLOUR = new Color(1154623);
                break;
            }
            case "Thieving": {
                BODY_COLOUR = new Color(7553377);
                break;
            }
            case "Crafting": {
                BODY_COLOUR = new Color(10056000);
                break;
            }
            case "Fletching": {
                BODY_COLOUR = new Color(609357);
                break;
            }
            case "Slayer": {
                BODY_COLOUR = new Color(6230281);
                break;
            }
            case "Hunter": {
                BODY_COLOUR = new Color(7301451);
                break;
            }
            case "Mining": {
                BODY_COLOUR = new Color(7716577);
                break;
            }
            case "Smithing": {
                BODY_COLOUR = new Color(8816252);
                break;
            }
            case "Fishing": {
                BODY_COLOUR = new Color(7507882);
                break;
            }
            case "Woodcutting": {
                BODY_COLOUR = new Color(4546103);
                break;
            }
            case "Firemaking": {
                BODY_COLOUR = new Color(13725466);
                break;
            }
            case "Farming": {
                BODY_COLOUR = new Color(0x2A5A2A);
            }
        }
        Color LEFT_TEXT = new Color(16768002);
        this.FontHandler.updateFont(this.config.fontName(), 14, this.config.fontStyle());
        this.FontHandler.handleFont(graphics);
        this.panelComponent.setPreferredSize(new Dimension(this.config.trackerWidth(), 100));
        this.panelComponent.getChildren().clear();
        if (this.config.placement() == VertTrackerPlacement.Tracker_Bottom && this.config.vertBars()) {
            this.panelComponent.setPreferredLocation(new Point(0, this.config.barWidth() + 4));
        } else if (this.config.placement() == VertTrackerPlacement.Tracker_Top && this.config.vertBars()) {
            this.panelComponent.setPreferredLocation(new Point(0, -140));
        } else if (this.config.SidebySide()) {
            this.panelComponent.setPreferredLocation(new Point(504, 8));
        } else {
            this.panelComponent.setPreferredLocation(new Point(this.config.barWidth() + 4, 8));
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Xp Tracking").color(BODY_COLOUR).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left(name).leftColor(BODY_COLOUR).right(counterLevelText).rightColor(Color.GREEN).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Current XP:").leftColor(LEFT_TEXT).right(skillCurrentXp).build());
        if (this.config.xpNeeded()) {
            String skillXpToLevel = f.format(xpNeeded);
            this.panelComponent.getChildren().add(LineComponent.builder().left("Exp Needed:").leftColor(LEFT_TEXT).right(skillXpToLevel).build());
        }
        if (goalXp > this.currentXP) {
            int xpHr;
            int actionsLeft;
            XpActionType xpActionType = this.xpTrackerService.getActionType(skill);
            if (this.config.actionsNeeded() && (actionsLeft = this.xpTrackerService.getActionsLeft(skill)) != Integer.MAX_VALUE) {
                String actionsLeftString = f.format(actionsLeft);
                this.panelComponent.getChildren().add(LineComponent.builder().left(xpActionType.getLabel() + " Needed:").leftColor(LEFT_TEXT).right(actionsLeftString).build());
            }
            if (this.config.xpHour() && (xpHr = this.xpTrackerService.getXpHr(skill)) != 0) {
                String xpHrString = f.format(xpHr);
                this.panelComponent.getChildren().add(LineComponent.builder().left("Exp Per/h:").leftColor(LEFT_TEXT).right(xpHrString).build());
            }
            if (this.config.showTTG()) {
                String timeLeft = this.xpTrackerService.getTimeTilGoal(skill);
                this.panelComponent.getChildren().add(LineComponent.builder().left("Time till lvl:").leftColor(LEFT_TEXT).right(timeLeft).build());
            }
            if (this.config.showPercent()) {
                String progress = (int)this.getSkillProgress(startXp, this.currentXP, goalXp) + "%";
                this.panelComponent.getChildren().add(LineComponent.builder().left("Percent:").leftColor(LEFT_TEXT).right(progress).build());
            }
        }
        this.panelComponent.render(graphics);
    }

    private void renderTrackerIcons(RHUD_Config config, Graphics2D graphics, int width, int height, SkillIconManager skillIconManager) {
        boolean skillIconEnabled = config.enableTip();
        if (skillIconEnabled) {
            Skill currentSkill = !config.mostRecentSkill() ? config.skill() : (this.plugin.getCurrentSkill() == null ? config.skill() : this.plugin.getCurrentSkill());
            BufferedImage skill = ImageUtil.resizeCanvas((BufferedImage)ImageUtil.resizeImage((BufferedImage)skillIconManager.getSkillImage(currentSkill, true), (int)17, (int)17), (int)RHUD_Overlay.ICON_DIMENSIONS.width, (int)RHUD_Overlay.ICON_DIMENSIONS.height);
            int xDraw = 5 + width / 2 - ((Image)skill).getWidth(null) / 2;
            int yDraw = 5 + width / 2 - ((Image)skill).getWidth(null) / 2 + 504;
            if (config.placement() == VertTrackerPlacement.Tracker_Bottom && config.vertBars()) {
                graphics.drawImage((Image)skill, xDraw, config.barWidth() + 8, null);
            } else if (config.placement() == VertTrackerPlacement.Tracker_Top && config.vertBars()) {
                graphics.drawImage((Image)skill, xDraw, -136, null);
            } else if (config.SidebySide()) {
                graphics.drawImage((Image)skill, yDraw, 12, null);
            } else {
                graphics.drawImage((Image)skill, config.barWidth() + 10, 12, null);
            }
        }
    }

    private double getSkillProgress(int startXp, int currentXp, int goalXp) {
        double xpGained = currentXp - startXp;
        double xpGoal = goalXp - startXp;
        return xpGained / xpGoal * 100.0;
    }

    private static int getBarWidth(int base, int current, int size) {
        double ratio = (double)current / (double)base;
        if (ratio >= 1.0) {
            return size;
        }
        return (int)Math.round(ratio * (double)size);
    }

    private static int getBarHeight(int base, int current, int size) {
        double ratio = (double)current / (double)base;
        if (ratio >= 1.0) {
            return size;
        }
        return (int)Math.round(ratio * (double)size);
    }
}

