/*
 * Decompiled with CFR 0.152.
 */
package RHUD;

import RHUD.helpers.BarTextMode;
import RHUD.helpers.ModeSet;
import RHUD.helpers.VertTrackerPlacement;
import java.awt.Color;
import net.runelite.api.Skill;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="SB")
public interface RHUD_Config
extends Config {
    public static final String GROUP = "SB";
    public static final Color COUNTER_COLOR = new Color(255, 255, 255, 255);
    public static final Color EXP_COLOR = new Color(130, 60, 170, 195);
    public static final Color HEALTH_COLOR = new Color(169, 28, 1, 255);
    public static final Color PRAY_COLOR = new Color(38, 157, 157, 255);
    public static final Color RUN_COLOR = new Color(140, 125, 29, 255);
    public static final Color SPECIAL_COLOR = new Color(73, 143, 71, 255);
    @ConfigSection(name="Experience Options", description="Configure the Experience Bar.", position=97)
    public static final String expSection = "experience";
    @ConfigSection(name="Status Options", description="Configure the Status Bars.", position=98)
    public static final String statusSection = "status";
    @ConfigSection(name="Font and Misc", description="Font options and miscellaneous.", position=99)
    public static final String fontSection = "font";
    @ConfigSection(name="Color Options", description="Status bar color config settings.", position=100)
    public static final String colorSection = "color";

    @ConfigItem(position=1, keyName="expBar", name="Experience Bar", description="Enables the experience bar.", section="experience")
    default public boolean XPtracker() {
        return true;
    }

    @ConfigItem(position=2, keyName="mostRecentSkill", name="Recent Skill", description="Display the most recent skill trained.", section="experience")
    default public boolean mostRecentSkill() {
        return false;
    }

    @ConfigItem(position=3, keyName="skill", name="Active Skill", description="Choose which skill to track when Recent Skill setting is disabled.", section="experience")
    default public Skill skill() {
        return Skill.ATTACK;
    }

    @Alpha
    @ConfigItem(position=4, keyName="xpbarColor", name="Experience Color", description="Configures the color of the Experience bar", section="experience")
    default public Color colorXP() {
        return EXP_COLOR;
    }

    @Alpha
    @ConfigItem(position=5, keyName="xpbarNotchColor", name="Segment Color", description="Configures the color of the experience segments.", section="experience")
    default public Color colorXPNotches() {
        return new Color(0x6C6C6C);
    }

    @ConfigItem(position=6, keyName="trackerWidth", name="XP Tracker Width", description="The width of the xp tracker.", section="experience")
    default public int trackerWidth() {
        return 125;
    }

    @ConfigItem(position=7, keyName="enableTip", name="XP Tracker", description="Displays the experience tracker info panel.", section="experience")
    default public boolean enableTip() {
        return false;
    }

    @ConfigItem(position=8, keyName="actionsNeeded", name="Actions Needed", description="Shows the number of actions needed to level-up.", section="experience")
    default public boolean actionsNeeded() {
        return true;
    }

    @ConfigItem(position=9, keyName="xpNeeded", name="Exp Needed", description="Shows the number of xp needed to level-up.", section="experience")
    default public boolean xpNeeded() {
        return true;
    }

    @ConfigItem(position=10, keyName="xpHour", name="Exp/hr", description="Shows Experience per hour.", section="experience")
    default public boolean xpHour() {
        return true;
    }

    @ConfigItem(position=11, keyName="showTTG", name="Time to Level", description="Shows the amount of time until goal lvl reached.", section="experience")
    default public boolean showTTG() {
        return true;
    }

    @ConfigItem(position=12, keyName="showPercent", name="Percent", description="Shows the percentage leveled.", section="experience")
    default public boolean showPercent() {
        return true;
    }

    @ConfigItem(position=13, keyName="placement", name="Position", description="Sets the position of the tracker when in vertical enabled.", section="experience")
    default public VertTrackerPlacement placement() {
        return VertTrackerPlacement.Tracker_Top;
    }

    @ConfigItem(position=14, keyName="bar1BarMode", name="Bar One", description="Configures the first status bar", section="status")
    default public ModeSet bar1BarMode() {
        return ModeSet.HITPOINTS;
    }

    @ConfigItem(position=15, keyName="bar2BarMode", name="Bar Two", description="Configures the second status bar", section="status")
    default public ModeSet bar2BarMode() {
        return ModeSet.PRAYER;
    }

    @ConfigItem(position=16, keyName="bar3BarMode", name="Bar Three", description="Configures the third status bar", section="status")
    default public ModeSet bar3BarMode() {
        return ModeSet.RUN_ENERGY;
    }

    @ConfigItem(position=17, keyName="bar4BarMode", name="Bar Four", description="Configures the fourth status bar", section="status")
    default public ModeSet bar4BarMode() {
        return ModeSet.SPECIAL_ATTACK;
    }

    @Range(min=60, max=500)
    @ConfigItem(position=18, keyName="barWidth", name="Bar Width", description="The width of the status bars in the modern resizeable layout.", section="status")
    default public int barWidth() {
        return 252;
    }

    @ConfigItem(position=19, keyName="vertBars", name="Vertical Bars", description="Displays vertical bars.", section="status")
    default public boolean vertBars() {
        return false;
    }

    @ConfigItem(position=20, keyName="2x2Bars", name="2x2 Bars", description="Displays bars stacked 2 x 2. By request from T...", section="status")
    default public boolean SidebySide() {
        return false;
    }

    @ConfigItem(position=21, keyName="textMode", name="Icon & Text", description="Sets the position of the text and the icon.", section="status")
    default public BarTextMode textMode() {
        return BarTextMode.Both_Bottom;
    }

    @ConfigItem(position=22, keyName="enableText", name="Show Text", description="Show # value on the status bars.", section="status")
    default public boolean enableCounter() {
        return true;
    }

    @ConfigItem(position=23, keyName="enableSkillIcon", name="Show Icons", description="Adds Icon to the status bars.", section="status")
    default public boolean enableSkillIcon() {
        return true;
    }

    @ConfigItem(position=24, keyName="enableRestorationBars", name="Show Restores", description="Highlights status bar with consumable regen amount.", section="status")
    default public boolean enableRestorationBars() {
        return true;
    }

    @ConfigItem(position=25, keyName="fontName", name="Font", description="Name of the font to use for XP drops. Leave blank to use RuneLite setting.", section="font")
    default public String fontName() {
        return "Impact";
    }

    @ConfigItem(position=26, keyName="fontStyle", name="Font style", description="Style of the font to use for XP drops. Only works with custom font.", section="font")
    default public FontStyle fontStyle() {
        return FontStyle.DEFAULT;
    }

    @ConfigItem(position=27, keyName="fontSize", name="Font size", description="Size of the font to use for XP drops. Only works with custom font.", section="font")
    default public int fontSize() {
        return 12;
    }

    @ConfigItem(position=28, keyName="hideAfterCombatDelay", name="Hide after combat delay", description="Amount of ticks before hiding status bars after no longer in combat. 0 = always show status bars.", section="font")
    @Units(value=" ticks")
    default public int hideAfterCombatDelay() {
        return 0;
    }

    @Alpha
    @ConfigItem(position=29, keyName="counterColor", name="Text Color", description="Configures the color of the counter Text.", section="color")
    default public Color counterColor() {
        return COUNTER_COLOR;
    }

    @Alpha
    @ConfigItem(position=30, keyName="colorHealthBar", name="Health Color", description="Configures the color of the health bar.", section="color")
    default public Color colorHealthBar() {
        return HEALTH_COLOR;
    }

    @Alpha
    @ConfigItem(position=31, keyName="colorPrayBar", name="Pray Color", description="Configures the color of the prayer bar.", section="color")
    default public Color colorPrayBar() {
        return PRAY_COLOR;
    }

    @Alpha
    @ConfigItem(position=32, keyName="colorRunBar", name="Run Color", description="Configures the color of the energy bar.", section="color")
    default public Color colorRunBar() {
        return RUN_COLOR;
    }

    @Alpha
    @ConfigItem(position=33, keyName="colorSpecialBar", name="Special Color", description="Configures the color of the special attack bar.", section="color")
    default public Color colorSpecialBar() {
        return SPECIAL_COLOR;
    }

    public static enum FontStyle {
        BOLD("Bold", 1),
        ITALICS("Italics", 2),
        BOLD_ITALICS("Bold and italics", 3),
        DEFAULT("Default", 0);

        String name;
        private int style;

        private FontStyle(String name, int style) {
            this.style = style;
            this.name = name;
        }

        public int getStyle() {
            return this.style;
        }
    }
}

