/*
 * Decompiled with CFR 0.152.
 */
package com.ywcode.defaultminimapzoom;

import com.google.inject.Provides;
import com.ywcode.defaultminimapzoom.DefaultMinimapZoomConfig;
import java.applet.Applet;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.Keybind;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Default Minimap Zoom", description="Allows the user to set the default minimap zoom.", tags={"minimap,mini,map,zoom,default"})
public class DefaultMinimapZoomPlugin
extends Plugin
implements MouseListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultMinimapZoomPlugin.class);
    private double zoomLevel;
    private boolean zoomWhenStartingClient;
    private boolean zoomWhenLogin;
    private boolean zoomWhenHopping;
    private boolean zoomWhenRightClick;
    private boolean currentlyHopping;
    private boolean loggedInOnce;
    private Area preprocessedMinimapArea;
    private Area processedMinimapArea;
    private static Rectangle previousMinimapBounds;
    private static Keybind dragHotkey;
    private static boolean inOverlayManagingMode;
    private static int gameTickDelay;
    private ComponentListener componentListener;
    @Inject
    private Client client;
    @Inject
    private DefaultMinimapZoomConfig config;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Applet clientApp;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> dragHotkey){

        public void hotkeyPressed() {
            if (DefaultMinimapZoomPlugin.this.zoomWhenRightClick && DefaultMinimapZoomPlugin.this.client.getGameState() != null && DefaultMinimapZoomPlugin.this.client.getGameState() == GameState.LOGGED_IN && DefaultMinimapZoomPlugin.this.client.isMinimapZoom() && DefaultMinimapZoomPlugin.this.client.isResized()) {
                inOverlayManagingMode = true;
            }
        }

        public void hotkeyReleased() {
            if (DefaultMinimapZoomPlugin.this.zoomWhenRightClick && DefaultMinimapZoomPlugin.this.client.getGameState() != null && DefaultMinimapZoomPlugin.this.client.getGameState() == GameState.LOGGED_IN && DefaultMinimapZoomPlugin.this.client.isMinimapZoom() && DefaultMinimapZoomPlugin.this.client.isResized()) {
                inOverlayManagingMode = false;
                DefaultMinimapZoomPlugin.this.checkIfMinimapChanged();
            }
        }
    };

    public void startUp() throws Exception {
        this.updateConfig();
        dragHotkey = (Keybind)this.configManager.getConfiguration("runelite", "dragHotkey", Keybind.class);
        if (this.client.getGameState() != null && this.client.getGameState() == GameState.LOGGED_IN) {
            this.loggedInOnce = true;
            if (this.zoomWhenRightClick) {
                this.getProcessedMinimapArea();
            }
        }
        this.mouseManager.registerMouseListener((MouseListener)this);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.componentListener = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (DefaultMinimapZoomPlugin.this.zoomWhenRightClick && DefaultMinimapZoomPlugin.this.client.getGameState() != null && DefaultMinimapZoomPlugin.this.client.getGameState() == GameState.LOGGED_IN) {
                    DefaultMinimapZoomPlugin.this.checkIfMinimapChanged();
                    gameTickDelay = 0;
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        };
        this.clientApp.addComponentListener(this.componentListener);
    }

    public void shutDown() {
        this.mouseManager.unregisterMouseListener((MouseListener)this);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.clientApp.removeComponentListener(this.componentListener);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("DefaultMinimapZoom")) {
            this.updateConfig();
            if (configChanged.getKey().equals("zoomLevel") && this.client.isMinimapZoom() && this.client.getGameState() != null && this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setMinimapZoom(this.zoomLevel);
            }
            if (this.zoomWhenRightClick && configChanged.getKey().equals("zoomWhenRightClick") && this.client.getGameState() != null && this.client.getGameState() == GameState.LOGGED_IN) {
                this.getProcessedMinimapArea();
            }
        }
        if (configChanged.getGroup().equals("runelite") && configChanged.getKey().equals("dragHotkey")) {
            dragHotkey = (Keybind)this.configManager.getConfiguration("runelite", "dragHotkey", Keybind.class);
        }
    }

    private void updateConfig() {
        this.zoomLevel = this.config.zoomLevel().toZoomLevel();
        this.zoomWhenStartingClient = this.config.zoomWhenStartingClient();
        this.zoomWhenLogin = this.config.zoomWhenLogin();
        this.zoomWhenHopping = this.config.zoomWhenHopping();
        this.zoomWhenRightClick = this.config.zoomWhenRightClick();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.HOPPING) {
            this.currentlyHopping = true;
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            if (this.client.isMinimapZoom() && (this.zoomWhenHopping && this.currentlyHopping || this.zoomWhenLogin && !this.currentlyHopping || this.zoomWhenStartingClient && !this.loggedInOnce)) {
                this.client.setMinimapZoom(this.zoomLevel);
            }
            this.loggedInOnce = true;
            this.currentlyHopping = false;
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (this.zoomWhenRightClick && widgetLoaded.getGroupId() == 160) {
            this.clientThread.invokeLater(() -> this.getProcessedMinimapArea());
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed widgetClosed) {
        if (this.zoomWhenRightClick && widgetClosed.getGroupId() == 378) {
            this.getProcessedMinimapArea();
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (this.zoomWhenRightClick && inOverlayManagingMode && !focusChanged.isFocused() && this.client.getGameState() != null && this.client.getGameState() == GameState.LOGGED_IN && this.client.isMinimapZoom() && this.client.isResized()) {
            inOverlayManagingMode = false;
            this.checkIfMinimapChanged();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (gameTickDelay < 2 && this.zoomWhenRightClick && this.client.getGameState() != null && this.client.getGameState() == GameState.LOGGED_IN && this.client.isMinimapZoom()) {
            this.checkIfMinimapChanged();
        }
        if (gameTickDelay < 2) {
            ++gameTickDelay;
        }
    }

    public MouseEvent mousePressed(MouseEvent mouseEvent) {
        if (this.zoomWhenRightClick && this.client.isMinimapZoom() && mouseEvent.getButton() == 3 && this.client.getGameState() != null && this.client.getGameState() == GameState.LOGGED_IN && this.processedMinimapArea != null && this.processedMinimapArea.contains(mouseEvent.getPoint())) {
            this.client.setMinimapZoom(this.zoomLevel);
            mouseEvent.consume();
        }
        return mouseEvent;
    }

    private Widget getMinimapWidget() {
        if (this.client.isResized()) {
            if (this.client.getVarbitValue(4607) == 1) {
                return this.client.getWidget(10747933);
            }
            return this.client.getWidget(10551325);
        }
        return this.client.getWidget(35913749);
    }

    private void getProcessedMinimapArea() {
        this.clientThread.invokeLater(() -> {
            Widget MinimapWidget = this.getMinimapWidget();
            if (MinimapWidget == null || MinimapWidget.isHidden()) {
                this.processedMinimapArea = null;
            } else {
                Rectangle minimapBounds;
                previousMinimapBounds = minimapBounds = MinimapWidget.getBounds();
                if (!this.client.isResized()) {
                    this.preprocessedMinimapArea = new Area(new Rectangle2D.Double(minimapBounds.getX(), minimapBounds.getY(), minimapBounds.getWidth(), minimapBounds.getHeight()));
                    Widget energyOrbMinimapWidget = this.client.getWidget(10485787);
                    this.removeOrbArea(energyOrbMinimapWidget);
                    Widget specOrbMinimapWidget = this.client.getWidget(160, 36);
                    this.removeOrbArea(specOrbMinimapWidget);
                    Widget specOrbTopMinimapWidget = this.client.getWidget(160, 37);
                    this.removeOrbArea(specOrbTopMinimapWidget);
                    Widget wikiOrbMinimapWidget = this.client.getWidget(10485809).getChild(0);
                    this.removeOrbArea(wikiOrbMinimapWidget);
                    Widget compassMinimapWidget = this.client.getWidget(548, 23);
                    this.removeOrbArea(compassMinimapWidget);
                } else {
                    this.preprocessedMinimapArea = new Area(new Ellipse2D.Double(minimapBounds.getX(), minimapBounds.getY(), minimapBounds.getWidth(), minimapBounds.getHeight()));
                    Widget worldmapOrbMinimapWidget = this.client.getWidget(10485813);
                    this.removeOrbArea(worldmapOrbMinimapWidget);
                }
                this.processedMinimapArea = this.preprocessedMinimapArea;
            }
        });
    }

    private void removeOrbArea(Widget minimapWidget) {
        if (minimapWidget != null && !minimapWidget.isHidden()) {
            Rectangle minimapWidgetBounds = minimapWidget.getBounds();
            Area OrbMinimapArea = new Area(new Rectangle2D.Double(minimapWidgetBounds.getX(), minimapWidgetBounds.getY(), minimapWidgetBounds.getWidth(), minimapWidgetBounds.getHeight()));
            this.preprocessedMinimapArea.subtract(OrbMinimapArea);
        }
    }

    private void checkIfMinimapChanged() {
        this.clientThread.invokeLater(() -> {
            if (this.getMinimapWidget() != null) {
                Rectangle currentMinimapBounds = this.getMinimapWidget().getBounds();
                if (previousMinimapBounds != null && !previousMinimapBounds.equals(currentMinimapBounds)) {
                    this.getProcessedMinimapArea();
                }
            }
        });
    }

    public MouseEvent mouseDragged(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseMoved(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseClicked(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseEntered(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseExited(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseReleased(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    @Provides
    DefaultMinimapZoomConfig provideConfig(ConfigManager configManager) {
        return (DefaultMinimapZoomConfig)configManager.getConfig(DefaultMinimapZoomConfig.class);
    }

    static {
        gameTickDelay = 2;
    }
}

