/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.bankscreenshot;

import com.google.inject.Provides;
import io.ryoung.bankscreenshot.BankScreenshotConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Bank Screenshot")
public class BankScreenshotPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private BankScreenshotConfig config;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ScheduledExecutorService executor;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.hotkey()){

        public void hotkeyPressed() {
            BankScreenshotPlugin.this.clientThread.invoke(() -> BankScreenshotPlugin.this.screenshot());
        }
    };
    private Widget button = null;
    private Map<Integer, Rectangle> overrideBounds = new HashMap<Integer, Rectangle>();

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.clientThread.invokeLater(this::createButton);
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.clientThread.invoke(this::hideButton);
    }

    @Provides
    BankScreenshotConfig provideConfig(ConfigManager configManager) {
        return (BankScreenshotConfig)configManager.getConfig(BankScreenshotConfig.class);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() != 12) {
            return;
        }
        this.createButton();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("bankscreenshot".equals(event.getGroup()) && "button".equals(event.getKey())) {
            if (this.config.button()) {
                this.clientThread.invoke(this::createButton);
            } else {
                this.clientThread.invoke(this::hideButton);
            }
        }
    }

    private void hideButton() {
        if (this.button == null) {
            return;
        }
        this.button.setHidden(true);
        this.button = null;
    }

    private void createButton() {
        if (!this.config.button()) {
            return;
        }
        Widget parent = this.client.getWidget(WidgetInfo.BANK_CONTENT_CONTAINER);
        if (parent == null) {
            return;
        }
        this.hideButton();
        this.button = parent.createChild(-1, 5);
        this.button.setOriginalHeight(20);
        this.button.setOriginalWidth(20);
        this.button.setOriginalX(434);
        this.button.setOriginalY(48);
        this.button.setSpriteId(573);
        this.button.setAction(0, "Screenshot");
        this.button.setOnOpListener(new Object[]{e -> this.clientThread.invokeLater(this::screenshot)});
        this.button.setHasListener(true);
        this.button.revalidate();
        this.button.setOnMouseOverListener(new Object[]{e -> this.button.setSpriteId(570)});
        this.button.setOnMouseLeaveListener(new Object[]{e -> this.button.setSpriteId(573)});
    }

    private void screenshot() {
        Graphics contentGraphics;
        Widget titleBar;
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.overrideBounds.clear();
        this.client.getWidgetSpriteCache().reset();
        Widget container = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        Widget itemContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (container == null || container.isHidden() || itemContainer == null || itemContainer.isHidden()) {
            return;
        }
        int height = 32;
        int y = 0;
        for (Widget item : itemContainer.getDynamicChildren()) {
            if (item.isHidden() || item.getRelativeY() <= y || item.getItemId() == 6512) continue;
            y = item.getRelativeY();
            height = y + 32;
        }
        int width = itemContainer.getWidth();
        if (this.config.info() == BankScreenshotConfig.DisplayMode.FRAME) {
            width = container.getWidth();
            height += 120;
            height = Math.max(height, 335);
        } else {
            height = this.config.info() == BankScreenshotConfig.DisplayMode.TITLE ? (height += 45) : (height += 30);
        }
        BufferedImage screenshot = new BufferedImage(width, height, 2);
        Graphics graphics = screenshot.getGraphics();
        BufferedImage background = this.getSprite(297);
        int x = screenshot.getWidth() / background.getWidth() + 1;
        y = screenshot.getHeight() / background.getHeight() + 1;
        for (int i = 0; i < x; ++i) {
            for (int z = 0; z < y; ++z) {
                graphics.drawImage(background, i * background.getWidth(), z * background.getHeight(), null);
            }
        }
        Widget content = this.client.getWidget(WidgetInfo.BANK_CONTENT_CONTAINER);
        int itemsOffset = 0;
        if (this.config.info() == BankScreenshotConfig.DisplayMode.FRAME) {
            this.drawFrame(graphics, width, height);
            titleBar = this.client.getWidget(WidgetInfo.BANK_TITLE_BAR);
            Graphics titleGraphics = graphics.create(content.getOriginalX(), 0, titleBar.getWidth(), titleBar.getHeight());
            titleGraphics.setClip(0, 0, titleBar.getWidth(), titleBar.getHeight());
            this.drawWidget(titleGraphics, titleBar, 0, 0);
            titleGraphics.dispose();
            contentGraphics = graphics.create(content.getRelativeX(), content.getRelativeY(), content.getWidth(), height - titleBar.getHeight() - 16);
            contentGraphics.setClip(0, 0, content.getWidth(), height - titleBar.getHeight() - 15);
            int bottomBarY = 0;
            int scrollbarY = 0;
            for (int i = WidgetInfo.BANK_ITEM_COUNT_TOP.getChildId(); i < WidgetInfo.BANK_ITEM_COUNT_TOP.getChildId() + 3; ++i) {
                Widget child = this.client.getWidget(12, i);
                this.drawChildren(graphics, child, child.getRelativeX(), child.getRelativeY());
            }
            Widget settingsBtn = this.client.getWidget(WidgetInfo.BANK_SETTINGS_BUTTON);
            this.drawChildren(graphics, settingsBtn, settingsBtn.getRelativeX(), settingsBtn.getRelativeY());
            Widget equipBtn = this.client.getWidget(WidgetInfo.BANK_EQUIPMENT_BUTTON);
            this.drawChildren(graphics, equipBtn, equipBtn.getRelativeX(), equipBtn.getRelativeY());
            Widget tutorialBtn = this.client.getWidget(WidgetInfo.BANK_TUTORIAL_BUTTON);
            this.drawChildren(graphics, tutorialBtn, tutorialBtn.getRelativeX(), tutorialBtn.getRelativeY());
            for (Widget child : content.getStaticChildren()) {
                if (child.getId() == WidgetInfo.BANK_ITEM_CONTAINER.getId()) {
                    itemsOffset = child.getRelativeY();
                    continue;
                }
                if (child.getId() == WidgetInfo.BANK_TAB_CONTAINER.getId()) {
                    this.drawChildren(contentGraphics, child, child.getRelativeX(), child.getRelativeY());
                    continue;
                }
                if (child.getId() == WidgetInfo.BANK_INCINERATOR.getId()) continue;
                if (child.getId() == WidgetInfo.BANK_SCROLLBAR.getId()) {
                    scrollbarY = child.getRelativeY();
                    continue;
                }
                if (child.isHidden()) continue;
                bottomBarY = contentGraphics.getClipBounds().height - child.getHeight();
                this.drawChildren(contentGraphics, child, child.getRelativeX(), contentGraphics.getClipBounds().height - child.getHeight());
            }
            this.drawScrollbar(contentGraphics, content.getWidth() - 17, scrollbarY - 1, 16, bottomBarY - scrollbarY);
        } else if (this.config.info() == BankScreenshotConfig.DisplayMode.TITLE) {
            titleBar = this.client.getWidget(WidgetInfo.BANK_TITLE_BAR);
            Graphics titleGraphics = graphics.create(0, 0, content.getWidth(), titleBar.getHeight());
            this.overrideBounds.put(titleBar.getId() | titleBar.getParentId(), new Rectangle(0, 5, content.getWidth(), titleBar.getHeight()));
            this.drawWidget(titleGraphics, titleBar, 0, 5);
            titleGraphics.dispose();
            itemsOffset = 0;
            contentGraphics = graphics.create(0, titleBar.getHeight() + 16, content.getWidth(), height - titleBar.getHeight() - 16);
        } else {
            itemsOffset = 0;
            contentGraphics = graphics.create(0, 16, content.getWidth(), height - 16);
        }
        Widget items = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        this.overrideBounds.put(items.getId() | items.getParentId(), new Rectangle(items.getRelativeX(), itemsOffset, items.getWidth(), height));
        this.drawChildren(contentGraphics, items, items.getRelativeX(), itemsOffset);
        contentGraphics.dispose();
        this.imageCapture.takeScreenshot(screenshot, "bankscreenshot", "bank", true, ImageUploadStyle.NEITHER);
    }

    private void drawFrame(Graphics graphics, final int width, final int height) {
        Widget frameParent = this.client.getWidget(12, 2);
        Widget[] pieces = frameParent.getDynamicChildren();
        HashMap<Integer, Rectangle> overrides = new HashMap<Integer, Rectangle>(){
            {
                this.put(310, new Rectangle(0, 0, 25, 30));
                this.put(311, new Rectangle(width - 25, 0, 25, 30));
                this.put(312, new Rectangle(0, height - 30, 25, 30));
                this.put(313, new Rectangle(width - 25, height - 30, 25, 30));
                this.put(314, new Rectangle(25, -15, width - 50, 36));
                this.put(2546, new Rectangle(6, 14, width - 12, 26));
                this.put(173, new Rectangle(25, height - 21, width - 50, 36));
                this.put(172, new Rectangle(-15, 30, 36, height - 60));
                this.put(315, new Rectangle(width - 21, 30, 36, height - 60));
                this.put(535, new Rectangle(width - 3 - 26, 6, 26, 23));
            }
        };
        for (Widget piece : pieces) {
            Rectangle bounds = (Rectangle)overrides.get(piece.getSpriteId());
            if (bounds == null) continue;
            SpritePixels sp = this.getPixels(piece.getSpriteId());
            Rectangle clips = graphics.getClipBounds();
            graphics.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
            for (int x = bounds.x; x < bounds.width + bounds.x; x += sp.getMaxWidth()) {
                for (int y = bounds.y; y < bounds.height + bounds.y; y += sp.getMaxHeight()) {
                    graphics.drawImage(sp.toBufferedImage(), x + sp.getOffsetX(), y + sp.getOffsetY(), null);
                }
            }
            graphics.setClip(clips);
        }
    }

    private void drawScrollbar(Graphics graphics, int x, int y, int width, int height) {
        Graphics layer = graphics.create(x, y, width, height);
        layer.setClip(0, 0, width, height);
        BufferedImage sprite = this.getSprite(792);
        layer.drawImage(sprite, 0, 16, width, height - 32, null);
        sprite = this.getSprite(790);
        layer.drawImage(sprite, 0, 16, width, height - 32, null);
        sprite = this.getSprite(789);
        layer.drawImage(sprite, 0, 16, width, 5, null);
        sprite = this.getSprite(791);
        layer.drawImage(sprite, 0, height - 21, width, 5, null);
        sprite = this.getSprite(773);
        layer.drawImage(sprite, 0, 0, 16, 16, null);
        sprite = this.getSprite(788);
        layer.drawImage(sprite, 0, height - 16, 16, 16, null);
        layer.dispose();
    }

    private void drawChildren(Graphics graphics, Widget child, int x, int y) {
        Graphics layer;
        if (child == null || child.isHidden()) {
            return;
        }
        Rectangle bounds = this.overrideBounds.get(child.getId() | child.getParentId());
        if (bounds != null) {
            layer = graphics.create(bounds.x, bounds.y, bounds.width, bounds.height);
            layer.setClip(0, 0, bounds.width, bounds.height);
        } else {
            layer = graphics.create(x, y, child.getWidth(), child.getHeight());
            layer.setClip(0, 0, child.getWidth(), child.getHeight());
        }
        this.drawWidget(graphics, child, child.getRelativeX(), child.getRelativeY());
        if (child.getStaticChildren() != null) {
            for (Widget children : child.getStaticChildren()) {
                this.drawChildren(layer, children, children.getRelativeX(), children.getRelativeY());
            }
        }
        if (child.getDynamicChildren() != null) {
            this.drawDynamicChildren(layer, child, 0, 0);
        }
        layer.dispose();
    }

    private void drawDynamicChildren(Graphics graphics, Widget child, int x, int y) {
        if (child.getDynamicChildren() != null) {
            Widget[] children = child.getDynamicChildren();
            for (int i = 0; i < children.length; ++i) {
                Widget child2 = children[i];
                this.drawWidget(graphics, child2, child2.getRelativeX(), child2.getRelativeY());
            }
        }
    }

    private void drawWidget(Graphics graphics, Widget child, int x, int y) {
        if (child == null || child.isHidden() || child.getType() == 0) {
            return;
        }
        int width = child.getWidth();
        int height = child.getHeight();
        if (child.getSpriteId() > 0) {
            SpritePixels sp = this.getPixels(child.getSpriteId());
            BufferedImage childImage = sp.toBufferedImage();
            if (child.getSpriteTiling()) {
                Rectangle clips = graphics.getClipBounds();
                graphics.setClip(x, y, child.getWidth(), child.getHeight());
                for (int dx = x; dx < child.getWidth() + x; dx += sp.getMaxWidth()) {
                    for (int dy = y; dy < child.getHeight() + y; dy += sp.getMaxHeight()) {
                        this.drawAt(graphics, childImage, dx + sp.getOffsetX(), dy + sp.getOffsetY());
                    }
                }
                graphics.setClip(clips);
            } else if (width == childImage.getWidth() && height == childImage.getHeight()) {
                this.drawAt(graphics, childImage, x, y);
            } else {
                this.drawScaled(graphics, childImage, x, y, width, height);
            }
        } else if (child.getItemId() > 0) {
            Object image;
            ItemComposition composition = this.itemManager.getItemComposition(child.getItemId());
            if (child.getId() == WidgetInfo.BANK_TAB_CONTAINER.getId()) {
                image = this.itemManager.getImage(this.itemManager.canonicalize(child.getItemId()), 1, false);
            } else if (composition.getPlaceholderTemplateId() > 0) {
                image = ImageUtil.alphaOffset((Image)this.itemManager.getImage(child.getItemId(), 0, true), (float)0.5f);
            } else {
                boolean stackable = child.getItemQuantity() > 1 || child.getItemQuantityMode() == 1;
                image = this.itemManager.getImage(child.getItemId(), child.getItemQuantity(), stackable);
            }
            graphics.drawImage((Image)image, child.getRelativeX(), child.getRelativeY(), null);
        } else if (child.getType() == 4) {
            String text = Text.removeTags((String)child.getText());
            Font font = FontManager.getRunescapeFont();
            x = child.getRelativeX();
            y = child.getRelativeY();
            Rectangle bounds = this.overrideBounds.get(child.getId() | child.getParentId());
            if (bounds != null) {
                x = bounds.x;
                y = bounds.y;
                width = bounds.width;
                height = bounds.height;
            }
            Graphics textLayer = graphics.create(x, y, width, height);
            if (child.getFontId() == 494) {
                font = FontManager.getRunescapeSmallFont();
            } else if (child.getFontId() == 764 || child.getFontId() == 645) {
                font = new Font("Times New Roman", 0, 20);
            } else if (child.getFontId() == 496) {
                font = FontManager.getRunescapeBoldFont();
            }
            textLayer.setFont(font);
            int xPos = 0;
            int yPos = 0;
            int textWidth = textLayer.getFontMetrics().stringWidth(text);
            if (child.getXTextAlignment() != 0 && child.getXTextAlignment() == 1) {
                xPos = (width - textWidth) / 2 + 1;
            }
            if (child.getYTextAlignment() == 0) {
                yPos = font.getSize() - 3;
            } else if (child.getYTextAlignment() == 1) {
                yPos = (height + font.getSize()) / 2 - 1;
            } else if (child.getYTextAlignment() == 2) {
                yPos = height;
            }
            if (child.getTextShadowed()) {
                textLayer.setColor(Color.BLACK);
                textLayer.drawString(text, xPos, yPos);
                --xPos;
                --yPos;
            }
            textLayer.setColor(new Color(child.getTextColor()));
            textLayer.drawString(text, xPos, yPos);
            textLayer.dispose();
        } else if (child.getType() == 9) {
            graphics.setColor(new Color(child.getTextColor()));
            graphics.drawLine(child.getRelativeX(), child.getRelativeY(), child.getRelativeX() + child.getWidth(), child.getRelativeY());
        }
    }

    private SpritePixels getPixels(int archive) {
        SpritePixels pixels;
        if (this.config.resourcePack() && (pixels = (SpritePixels)this.client.getSpriteOverrides().get(archive)) != null) {
            return pixels;
        }
        SpritePixels[] sp = this.client.getSprites(this.client.getIndexSprites(), archive, 0);
        if (sp == null) {
            return null;
        }
        return sp[0];
    }

    private BufferedImage getSprite(int id) {
        return this.getPixels(id).toBufferedImage();
    }

    private void drawScaled(Graphics graphics, BufferedImage image, int x, int y, int width, int height) {
        image = ImageUtil.resizeCanvas((BufferedImage)image, (int)width, (int)height);
        graphics.drawImage(image, x, y, null);
    }

    private void drawAt(Graphics graphics, BufferedImage image, int x, int y) {
        graphics.drawImage(image, x, y, null);
    }
}

