/*
 * Decompiled with CFR 0.152.
 */
package com.mitchbarnett.wikibanktagintegration;

import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import com.google.inject.Provides;
import com.mitchbarnett.wikibanktagintegration.AskResponse;
import com.mitchbarnett.wikibanktagintegration.WikiBankTagIntegrationConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.CommandExecuted;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.banktags.BankTagsPlugin;
import net.runelite.client.plugins.banktags.TagManager;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank Tag Generation")
@PluginDependency(value=BankTagsPlugin.class)
public class WikiBankTagIntegrationPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WikiBankTagIntegrationPlugin.class);
    @Inject
    private Client client;
    @Inject
    private WikiBankTagIntegrationConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private TagManager tagManager;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        String[] args = commandExecuted.getArguments();
        if (commandExecuted.getCommand().equals(this.config.categoryChatCommand()) && args.length == 1) {
            this.addTagsFromCategory(args[0]);
        } else if (commandExecuted.getCommand().equals(this.config.dropsChatCommand()) && args.length == 1) {
            this.addTagsFromDrops(args[0]);
        }
    }

    @Provides
    WikiBankTagIntegrationConfig provideConfig(ConfigManager configManager) {
        return (WikiBankTagIntegrationConfig)configManager.getConfig(WikiBankTagIntegrationConfig.class);
    }

    private void addTagsFromDrops(String monster) {
        log.info("attempting to add tags to items dropped by " + monster);
        List<Integer> items = this.getDropIDs(monster);
        this.tagItems(items, monster + " drops");
        if (items.size() == 0) {
            String message = "No drops found for " + monster;
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, "");
        } else {
            String message = "Added " + monster + " drops tag to " + String.valueOf(items.size()) + " items.";
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, "");
            this.createTab(monster + " drops", Collections.min(items));
        }
    }

    private void addTagsFromCategory(String category) {
        log.info("attempting to add tags to items from " + category);
        List<Integer> items = this.getCategoryIDs(category);
        this.tagItems(items, category);
        if (items.size() == 0) {
            String message = "No items found for category " + category;
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, "");
        } else {
            String message = "Added " + category + " tag to " + String.valueOf(items.size()) + " items.";
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, "");
            this.createTab(category, Collections.min(items));
        }
    }

    private void tagItems(List<Integer> items, String tag) {
        for (int itemID : items) {
            this.tagManager.addTag(itemID, tag, false);
        }
    }

    List<String> getAllTabs() {
        return Text.fromCSV((String)((String)MoreObjects.firstNonNull((Object)this.configManager.getConfiguration("banktags", "tagtabs"), (Object)"")));
    }

    private void createTab(String tag, int iconItemId) {
        ArrayList<String> tabs = new ArrayList<String>(this.getAllTabs());
        tabs.add(Text.standardize((String)tag));
        String tags = Text.toCSV(tabs);
        this.configManager.setConfiguration("banktags", "tagtabs", tags);
        this.configManager.setConfiguration("banktags", "icon_" + Text.standardize((String)tag), (Object)iconItemId);
    }

    private List<Integer> getCategoryIDs(String category) {
        try {
            String query = "[[category:" + category + "]]|?All+Item+ID";
            String wikiResponse = this.getWikiResponse(query).body().string();
            return this.getIDsFromJSON(wikiResponse);
        }
        catch (IOException e) {
            String message = "There was an error retrieving data";
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, "");
            log.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    private List<Integer> getDropIDs(String monster) {
        try {
            String query = "[[Drop from::" + monster + "]]|?Dropped item.All+Item+ID";
            String wikiResponse = this.getWikiResponse(query).body().string();
            return this.getIDsFromJSON(wikiResponse);
        }
        catch (IOException e) {
            String message = "There was an error retriving data";
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, "");
            log.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    private Response getWikiResponse(String query) throws IOException {
        Request request = new Request.Builder().url(this.createQueryURL(query)).build();
        return RuneLiteAPI.CLIENT.newCall(request).execute();
    }

    String createQueryURL(String query) {
        return "https://oldschool.runescape.wiki/api.php?action=ask&query=" + query + "|+limit=2000&format=json";
    }

    List<Integer> getIDsFromJSON(String jsonIn) {
        Gson gson = new Gson();
        AskResponse askResponse = (AskResponse)gson.fromJson(jsonIn, AskResponse.class);
        ArrayList<Integer> itemIDs = new ArrayList<Integer>();
        for (Map.Entry<String, AskResponse.Query.Results> entry : askResponse.query.results.entrySet()) {
            for (int itemID : entry.getValue().printouts.allItemID) {
                itemIDs.add(itemID);
            }
        }
        return itemIDs;
    }
}

