/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.wildernessteleports;

import at.nightfirec.wildernessteleports.WildernessTeleportsConfig;
import at.nightfirec.wildernessteleports.WildernessTeleportsOverlay;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Uncharged Glory Warning", description="Warns you if you enter the wilderness with uncharged amulets of glory", tags={"amulet", "glory", "wilderness", "20", "30", "tele", "teleport"})
public class WildernessTeleportsPlugin
extends Plugin {
    private static final List<Integer> CHARGED_GLORY_IDS = ImmutableList.of((Object)19707, (Object)1706, (Object)1708, (Object)1710, (Object)1712, (Object)11976, (Object)11978, (Object)10360, (Object)10358, (Object)10356, (Object)10354, (Object)11966, (Object[])new Integer[]{11964});
    private static final List<Integer> UNCHARGED_GLORY_IDS = ImmutableList.of((Object)1704, (Object)10362, (Object)8283);
    @Inject
    private WildernessTeleportsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private boolean inWilderness;
    private boolean hasOnlyUnchargedGlories;
    private boolean gameStateChangeVarbitRace;

    @Provides
    WildernessTeleportsConfig getConfig(ConfigManager configManager) {
        return (WildernessTeleportsConfig)configManager.getConfig(WildernessTeleportsConfig.class);
    }

    public void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invokeLater(() -> {
                this.checkInWilderness();
                this.checkChargedGlories();
            });
        }
        this.overlayManager.add((Overlay)this.overlay);
    }

    public void shutDown() {
        this.gameStateChangeVarbitRace = false;
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    void onItemContainerChanged(ItemContainerChanged event) {
        int changedContainerId = event.getContainerId();
        if (changedContainerId != InventoryID.INVENTORY.getId() && changedContainerId != InventoryID.EQUIPMENT.getId()) {
            return;
        }
        this.checkChargedGlories();
    }

    @Subscribe
    void onGameStateChanged(GameStateChanged event) {
        GameState state = event.getGameState();
        if (state == GameState.LOADING || state == GameState.LOGGED_IN) {
            this.gameStateChangeVarbitRace = true;
        }
        if (state == GameState.LOGGED_IN) {
            this.checkChargedGlories();
        }
    }

    @Subscribe
    void onVarbitChanged(VarbitChanged event) {
        if (this.gameStateChangeVarbitRace) {
            return;
        }
        this.checkInWilderness();
    }

    @Subscribe
    void onGameTick(GameTick event) {
        this.gameStateChangeVarbitRace = false;
    }

    private void checkInWilderness() {
        this.inWilderness = this.client.getVarbitValue(5963) == 1;
    }

    private void checkChargedGlories() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        boolean hasUnchargedGlory = WildernessTeleportsPlugin.containerHasAnyId(inventory, UNCHARGED_GLORY_IDS) || WildernessTeleportsPlugin.containerHasAnyId(equipment, UNCHARGED_GLORY_IDS);
        boolean hasChargedGlory = WildernessTeleportsPlugin.containerHasAnyId(inventory, CHARGED_GLORY_IDS) || WildernessTeleportsPlugin.containerHasAnyId(equipment, CHARGED_GLORY_IDS);
        this.hasOnlyUnchargedGlories = hasUnchargedGlory && !hasChargedGlory;
    }

    private static boolean containerHasAnyId(@Nullable ItemContainer container, List<Integer> itemIds) {
        if (container == null) {
            return false;
        }
        for (int item : itemIds) {
            if (!container.contains(item)) continue;
            return true;
        }
        return false;
    }

    boolean isInWilderness() {
        return this.inWilderness;
    }

    boolean hasOnlyUnchargedGlories() {
        return this.hasOnlyUnchargedGlories;
    }
}

