/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.wildernessteleports;

import at.nightfirec.wildernessteleports.WildernessTeleportsConfig;
import at.nightfirec.wildernessteleports.WildernessTeleportsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

class WildernessTeleportsOverlay
extends Overlay {
    private static final Color BACKGROUND_COLOR = new Color(150, 0, 0, 150);
    private final PanelComponent imagePanelComponent = new PanelComponent();
    private final WildernessTeleportsPlugin plugin;
    private final WildernessTeleportsConfig config;

    @Inject
    private WildernessTeleportsOverlay(WildernessTeleportsPlugin plugin, WildernessTeleportsConfig config, ItemManager itemManager) {
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.setPriority(OverlayPriority.HIGH);
        this.plugin = plugin;
        this.config = config;
        this.imagePanelComponent.setBackgroundColor(BACKGROUND_COLOR);
        this.imagePanelComponent.getChildren().add(new ImageComponent((BufferedImage)itemManager.getImage(1704)));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.hasOnlyUnchargedGlories() && (this.plugin.isInWilderness() || this.config.unchargeWarningOutsideWilderness())) {
            return this.imagePanelComponent.render(graphics);
        }
        return null;
    }
}

