/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class VanguardInfoBox
extends Overlay {
    private final CoxAdditionsPlugin plugin;
    private final CoxAdditionsConfig config;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    VanguardInfoBox(Client client, CoxAdditionsPlugin plugin, CoxAdditionsConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGH);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInVangs()) {
            return null;
        }
        if (this.plugin.getPanelFont() == null) {
            this.plugin.loadFont(false);
        }
        this.panelComponent.getChildren().clear();
        if (this.config.vangInfobox()) {
            graphics.setFont(this.plugin.getPanelFont());
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Vanguards").color(Color.pink).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Range").right(Integer.toString(this.plugin.getRangeHP())).leftColor(Color.green).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Mage").right(Integer.toString(this.plugin.getMageHP())).leftColor(Color.blue).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Melee").right(Integer.toString(this.plugin.getMeleeHP())).leftColor(Color.red).build());
            return this.panelComponent.render(graphics);
        }
        return null;
    }
}

