/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InstanceTemplates;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class VangPotsOverlay
extends OverlayPanel {
    private final Client client;
    private final CoxAdditionsConfig config;
    private final CoxAdditionsPlugin plugin;

    @Inject
    private VangPotsOverlay(Client client, CoxAdditionsPlugin plugin, CoxAdditionsConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.MED);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getPanelFont() == null) {
            this.plugin.loadFont(false);
        }
        if (this.config.showPanel() && this.plugin.getOverloadsDropped() > 0 && this.plugin.isInRaid() && this.client.getLocalPlayer() != null) {
            boolean overlayRooms;
            boolean bl = overlayRooms = this.plugin.room() == InstanceTemplates.RAIDS_VANGUARDS || this.plugin.isInPrep();
            if (this.plugin.room() != null && overlayRooms) {
                graphics.setFont(this.plugin.getPanelFont());
                this.panelComponent.getChildren().clear();
                this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth("Overloads: ") + 20, 0));
                this.panelComponent.getChildren().add(LineComponent.builder().leftColor(Color.WHITE).left("Overloads: ").right(String.valueOf(this.plugin.getOverloadsDropped())).build());
            }
        }
        return super.render(graphics);
    }
}

