/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import com.coxadditions.RaidsPlayers;
import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ImageUtil;

public class RaidsPotsStatusOverlay
extends Overlay {
    private final Client client;
    private final CoxAdditionsPlugin plugin;
    private final CoxAdditionsConfig config;
    private final ItemManager itemManager;

    @Inject
    public RaidsPotsStatusOverlay(Client client, CoxAdditionsPlugin plugin, CoxAdditionsConfig config, ItemManager itemManager) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.raidsPotsStatusOverlay() && this.plugin.isInRaid()) {
            block0: for (RaidsPlayers raider : this.plugin.getPlayersInParty()) {
                for (Player player : this.client.getPlayers()) {
                    if (player.getName() == null || !player.getName().equals(raider.getPlayer())) continue;
                    boolean offset = false;
                    if (raider.isOvlActive() && raider.getOvlTicks() >= 0) {
                        this.drawTimer(graphics, "OVL", raider.getOvlTicks(), player, false);
                        offset = true;
                    }
                    if (!raider.isEnhActive() || raider.getEnhTicks() < 0) continue block0;
                    this.drawTimer(graphics, "ENH", raider.getEnhTicks(), player, offset);
                    continue block0;
                }
            }
            if (this.client.getLocalPlayer() != null && (this.plugin.getEnhanceTicks() >= 0 || this.plugin.getOverloadTicks() >= 0)) {
                boolean offset = false;
                if (this.plugin.getOverloadTicks() >= 0) {
                    this.drawTimer(graphics, "OVL", this.plugin.getOverloadTicks(), this.client.getLocalPlayer(), false);
                    offset = true;
                }
                if (this.plugin.getEnhanceTicks() >= 0) {
                    this.drawTimer(graphics, "ENH", this.plugin.getEnhanceTicks(), this.client.getLocalPlayer(), offset);
                }
            }
        }
        return null;
    }

    public void drawTimer(Graphics2D graphics, String pot, int ticks, Player player, boolean offset) {
        int size = this.config.raidsPotsIconSize();
        graphics.setFont(new Font("SansSerif", 1, (int)(0.75 * (double)size)));
        int xOffset = 5 - size / 2;
        int yOffset = offset ? -(size + 3) : 0;
        int zOffset = player.getLogicalHeight();
        switch (this.config.raidsPotsHeight()) {
            case CENTER: {
                zOffset = player.getLogicalHeight() / 2;
                break;
            }
            case FEET: {
                zOffset = 0;
                break;
            }
            case HEAD: {
                zOffset = player.getLogicalHeight() + 60;
                break;
            }
            case PRAYER: {
                zOffset = player.getLogicalHeight() + 250;
            }
        }
        Point base = Perspective.localToCanvas((Client)this.client, (LocalPoint)player.getLocalLocation(), (int)this.client.getPlane(), (int)zOffset);
        Object image = pot.equals("OVL") ? this.itemManager.getImage(20996) : this.itemManager.getImage(20964);
        image = ImageUtil.resizeImage((BufferedImage)image, (int)size, (int)size);
        if (base != null) {
            graphics.drawImage((Image)image, base.getX() + xOffset, base.getY() - yOffset, null);
            yOffset -= size;
            String text = String.valueOf(ticks);
            if (!Strings.isNullOrEmpty((String)text)) {
                int delta = ((BufferedImage)image).getWidth() + 3;
                Point textPoint = new Point(base.getX() + xOffset + delta + 1, base.getY() - yOffset);
                this.drawTextBackground(graphics, textPoint, text, pot);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textPoint, (String)text, (Color)(ticks < 25 ? Color.RED : Color.WHITE));
            }
        }
    }

    private void drawTextBackground(Graphics2D graphics, Point textLoc, String text, String pot) {
        Color color = pot.equals("OVL") ? Color.BLACK : (Integer.parseInt(text) < 25 ? Color.BLACK : new Color(132, 67, 186));
        switch (this.config.overlayFontBackground()) {
            case OUTLINE: {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX(), textLoc.getY() + 1), (String)text, (Color)color);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX(), textLoc.getY() - 1), (String)text, (Color)color);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX() + 1, textLoc.getY()), (String)text, (Color)color);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX() - 1, textLoc.getY()), (String)text, (Color)color);
                break;
            }
            case SHADOW: {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX() + 1, textLoc.getY() + 1), (String)text, (Color)color);
                break;
            }
        }
    }
}

