/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.util.ColorUtil;

public class OlmSideOverlay
extends Overlay {
    private final Client client;
    private final CoxAdditionsConfig config;
    private final CoxAdditionsPlugin plugin;

    @Inject
    public OlmSideOverlay(Client client, CoxAdditionsConfig config, CoxAdditionsPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.olmSide() != CoxAdditionsConfig.olmSideMode.OFF && this.plugin.getOlmTile() != null && this.client.getLocalPlayer() != null) {
            Color color = this.config.olmSideColor();
            if (this.config.olmSideColorMode() == CoxAdditionsConfig.olmSideColorMode.PHASE) {
                switch (this.plugin.getOlmPhase()) {
                    case "Crystal": {
                        color = ColorUtil.colorWithAlpha((Color)Color.MAGENTA, (int)this.config.olmSideColor().getAlpha());
                        break;
                    }
                    case "Acid": {
                        color = ColorUtil.colorWithAlpha((Color)Color.GREEN, (int)this.config.olmSideColor().getAlpha());
                        break;
                    }
                    case "Flame": {
                        color = ColorUtil.colorWithAlpha((Color)Color.RED, (int)this.config.olmSideColor().getAlpha());
                    }
                }
            }
            this.drawTile(graphics, this.plugin.getOlmTile(), color);
        }
        return null;
    }

    protected void drawTile(Graphics2D graphics, LocalPoint lp, Color color) {
        if (WorldPoint.fromLocal((Client)this.client, (LocalPoint)lp).distanceTo(this.client.getLocalPlayer().getWorldLocation()) < 32) {
            Polygon poly;
            Polygon polygon = poly = this.config.olmSide() == CoxAdditionsConfig.olmSideMode.CENTER_TILE ? Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp) : Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp, (int)5);
            if (poly != null) {
                graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
                graphics.setStroke(new BasicStroke(1.0f));
                graphics.draw(poly);
                graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 10));
                graphics.fill(poly);
            }
        }
    }
}

