/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class OlmPhasePanel
extends OverlayPanel {
    private final Client client;
    private final CoxAdditionsPlugin plugin;
    private final CoxAdditionsConfig config;

    @Inject
    public OlmPhasePanel(Client client, CoxAdditionsPlugin plugin, CoxAdditionsConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getPanelFont() == null) {
            this.plugin.loadFont(false);
        }
        this.panelComponent.getChildren().clear();
        if (this.config.olmPhasePanel() && this.client.getVarbitValue(5432) == 1 && !this.plugin.getOlmPhase().equals("")) {
            graphics.setFont(this.plugin.getPanelFont());
            Color color = this.plugin.getOlmPhase().equals("Acid") ? Color.GREEN : (this.plugin.getOlmPhase().equals("Flame") ? Color.RED : Color.MAGENTA);
            this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(this.plugin.getOlmPhase()) + 3, 0));
            this.panelComponent.getChildren().add(TitleComponent.builder().color(color).text(this.plugin.getOlmPhase()).build());
        }
        return super.render(graphics);
    }
}

