/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class OlmHpPanelOverlay
extends OverlayPanel {
    private final Client client;
    private final CoxAdditionsPlugin plugin;
    private final CoxAdditionsConfig config;

    @Inject
    private OlmHpPanelOverlay(Client client, CoxAdditionsPlugin plugin, CoxAdditionsConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getPanelFont() == null) {
            this.plugin.loadFont(false);
        }
        if (this.config.olmHandsHealth() == CoxAdditionsConfig.olmHandsHealthMode.INFOBOX && (this.plugin.getMageHand() != null || this.plugin.getMeleeHand() != null)) {
            graphics.setFont(this.plugin.getPanelFont());
            this.panelComponent.getChildren().clear();
            NPC mageHand = this.plugin.getMageHand();
            NPC meleeHand = this.plugin.getMeleeHand();
            this.panelComponent.getChildren().add(TitleComponent.builder().color(Color.PINK).text("Olm Hands HP").build());
            if (this.client.getVarbitValue(5424) == 1) {
                if (mageHand != null && this.plugin.getMageHandHp() >= 0) {
                    String mageText = String.valueOf(this.plugin.getMageHandHp());
                    Color mageColor = Color.WHITE;
                    if (this.plugin.getMageHandHp() < 100) {
                        mageColor = Color.RED;
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().leftColor(Color.CYAN).left("Mage Hand:").rightColor(mageColor).right(mageText).build());
                }
                if (meleeHand != null && this.plugin.getMeleeHandHp() >= 0) {
                    String meleeText = String.valueOf(this.plugin.getMeleeHandHp());
                    Color meleeColor = Color.WHITE;
                    if (this.plugin.getMeleeHandHp() < 100) {
                        meleeColor = Color.RED;
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().leftColor(Color.RED).left("Melee Hand:").rightColor(meleeColor).right(meleeText).build());
                }
            } else {
                if (mageHand != null) {
                    Color mageColor = Color.WHITE;
                    String mageText = "";
                    if (mageHand.getHealthRatio() > 0 || this.plugin.getMageHandLastRatio() != 0 && this.plugin.getMageHandLastHealthScale() != 0) {
                        float floatRatioMage;
                        if (mageHand.getHealthRatio() > 0) {
                            this.plugin.setMageHandLastRatio(mageHand.getHealthRatio());
                            this.plugin.setMageHandLastHealthScale(mageHand.getHealthScale());
                        }
                        if ((floatRatioMage = (float)this.plugin.getMageHandLastRatio() / (float)this.plugin.getMageHandLastHealthScale() * 100.0f) <= 20.0f) {
                            mageColor = Color.RED;
                        }
                        mageText = Float.toString(floatRatioMage);
                        mageText = mageText.substring(0, mageText.indexOf("."));
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().leftColor(Color.CYAN).left("Mage Hand:").rightColor(mageColor).right(mageText + "%").build());
                }
                if (meleeHand != null) {
                    Color meleeColor = Color.WHITE;
                    String meleeText = "";
                    if (meleeHand.getHealthRatio() > 0 || this.plugin.getMeleeHandLastRatio() != 0 && this.plugin.getMeleeHandLastHealthScale() != 0) {
                        float floatRatioMelee;
                        if (this.plugin.getMeleeHand().getHealthRatio() > 0) {
                            this.plugin.setMeleeHandLastRatio(meleeHand.getHealthRatio());
                            this.plugin.setMeleeHandLastHealthScale(meleeHand.getHealthScale());
                        }
                        if ((floatRatioMelee = (float)this.plugin.getMeleeHandLastRatio() / (float)this.plugin.getMeleeHandLastHealthScale() * 100.0f) <= 20.0f) {
                            meleeColor = Color.RED;
                        }
                        meleeText = Float.toString(floatRatioMelee);
                        meleeText = meleeText.substring(0, meleeText.indexOf("."));
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().leftColor(Color.RED).left("Melee Hand:").rightColor(meleeColor).right(meleeText + "%").build());
                }
            }
        }
        return super.render(graphics);
    }
}

