/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class InstanceTimerOverlay
extends OverlayPanel {
    private final Client client;
    private final CoxAdditionsPlugin plugin;
    private final CoxAdditionsConfig config;

    @Inject
    public InstanceTimerOverlay(Client client, CoxAdditionsPlugin plugin, CoxAdditionsConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getPanelFont() == null) {
            this.plugin.loadFont(false);
        }
        this.panelComponent.getChildren().clear();
        if (this.config.instanceTimer() == CoxAdditionsConfig.instanceTimerMode.INFOBOX && this.plugin.isInstanceTimerRunning() && this.plugin.isInRaid()) {
            Color goodTick = new Color(37, 197, 79);
            Color badTick = new Color(224, 60, 49);
            graphics.setFont(this.plugin.getPanelFont());
            this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth("Tick:   ") + 15, 0));
            this.panelComponent.getChildren().add(LineComponent.builder().left("Tick: ").right(String.valueOf(this.plugin.getInstanceTimer())).rightColor(this.plugin.getInstanceTimer() == 0 ? goodTick : badTick).build());
        }
        return super.render(graphics);
    }
}

