/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.InstanceTemplates;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class CoxPrepOverlay
extends OverlayPanel {
    private final CoxAdditionsPlugin plugin;
    private final CoxAdditionsConfig config;

    @Inject
    private CoxPrepOverlay(CoxAdditionsPlugin plugin, CoxAdditionsConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getPanelFont() == null) {
            this.plugin.loadFont(false);
        }
        graphics.setFont(this.plugin.getPanelFont());
        List elems = this.panelComponent.getChildren();
        if (this.plugin.isInPrep()) {
            if (this.config.brews() + this.config.revites() + this.config.enhances() != 0) {
                elems.add(LineComponent.builder().leftColor(Color.WHITE).left("Buchu: ").rightColor(this.plugin.getTotalBuchus() >= this.config.brews() + this.config.revites() + this.config.enhances() ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalBuchus() + "/" + (this.config.brews() + this.config.revites() + this.config.enhances())).build());
                if (this.config.showPots()) {
                    if (this.config.brews() > 0) {
                        elems.add(LineComponent.builder().leftColor(Color.WHITE).left("    Brews: ").rightColor(this.plugin.getTotalBrews() >= this.config.brews() ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalBrews() + "/" + this.config.brews()).build());
                    }
                    if (this.config.revites() > 0) {
                        elems.add(LineComponent.builder().leftColor(Color.WHITE).left("    Revites: ").rightColor(this.plugin.getTotalRevites() >= this.config.revites() ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalRevites() + "/" + this.config.revites()).build());
                    }
                    if (this.config.enhances() > 0) {
                        elems.add(LineComponent.builder().leftColor(Color.WHITE).left("    Enhances: ").rightColor(this.plugin.getTotalEnhances() >= this.config.enhances() ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalEnhances() + "/" + this.config.enhances()).build());
                    }
                }
            }
            if (this.config.overloads() != 0) {
                elems.add(LineComponent.builder().leftColor(Color.WHITE).left("Golpar: ").rightColor(this.plugin.getTotalGolpar() >= this.config.overloads() * 3 ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalGolpar() + "/" + this.config.overloads() * 3).build());
                if (this.config.showPots()) {
                    elems.add(LineComponent.builder().leftColor(Color.WHITE).left("    Elders: ").rightColor(this.plugin.getTotalElders() >= this.config.overloads() ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalElders() + "/" + this.config.overloads()).build());
                    elems.add(LineComponent.builder().leftColor(Color.WHITE).left("    Twisteds: ").rightColor(this.plugin.getTotalTwisteds() >= this.config.overloads() ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalTwisteds() + "/" + this.config.overloads()).build());
                    elems.add(LineComponent.builder().leftColor(Color.WHITE).left("    Kodais: ").rightColor(this.plugin.getTotalKodais() >= this.config.overloads() ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalKodais() + "/" + this.config.overloads()).build());
                }
                elems.add(LineComponent.builder().leftColor(Color.WHITE).left("Noxifer: ").rightColor(this.plugin.getTotalNox() >= this.config.overloads() + this.config.extraNox() ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalNox() + "/" + (this.config.overloads() + this.config.extraNox())).build());
                if (this.config.showPots()) {
                    elems.add(LineComponent.builder().leftColor(Color.WHITE).left("    Overloads: ").rightColor(this.plugin.getTotalOverloads() >= this.config.overloads() ? Color.GREEN : Color.WHITE).right(this.plugin.getTotalOverloads() + "/" + this.config.overloads()).build());
                }
            }
        }
        if ((this.plugin.room() == InstanceTemplates.RAIDS_SCAVENGERS || this.plugin.room() == InstanceTemplates.RAIDS_SCAVENGERS2) && this.config.showSecondaries()) {
            if (this.config.brews() != 0 || this.config.overloads() != 0) {
                elems.add(LineComponent.builder().leftColor(Color.WHITE).left("Juice: ").rightColor(this.plugin.getPickedJuice() >= this.config.brews() + this.config.overloads() ? Color.GREEN : Color.WHITE).right(this.plugin.getPickedJuice() + "/" + (this.config.brews() + this.config.overloads())).build());
            }
            if (this.config.revites() != 0 || this.config.overloads() != 0) {
                elems.add(LineComponent.builder().leftColor(Color.WHITE).left("Shrooms: ").rightColor(this.plugin.getPickedShrooms() >= this.config.revites() + this.config.overloads() ? Color.GREEN : Color.WHITE).right(this.plugin.getPickedShrooms() + "/" + (this.config.revites() + this.config.overloads())).build());
            }
            if (this.config.enhances() != 0 || this.config.overloads() != 0) {
                elems.add(LineComponent.builder().leftColor(Color.WHITE).left("Cicely: ").rightColor(this.plugin.getPickedCicely() >= this.config.enhances() + this.config.overloads() ? Color.GREEN : Color.WHITE).right(this.plugin.getPickedCicely() + "/" + (this.config.enhances() + this.config.overloads())).build());
            }
        }
        return super.render(graphics);
    }
}

