/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;

public class CoxItemOverlay
extends WidgetItemOverlay {
    private final ItemManager itemManager;
    private final CoxAdditionsPlugin plugin;
    private final CoxAdditionsConfig config;

    @Inject
    public CoxItemOverlay(ItemManager itemManager, CoxAdditionsPlugin plugin, CoxAdditionsConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.showOnInterfaces(new int[]{271, 551});
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (this.plugin.isInRaid() && this.config.highlightChest() != CoxAdditionsConfig.HighlightChestMode.OFF && (!this.config.highlightChestItems().equals("") && this.plugin.getChestHighlightIdList().size() > 0 || !this.config.highlightChestItems2().equals("") && this.plugin.getChestHighlightIdList2().size() > 0)) {
            if (this.plugin.getChestHighlightIdList().contains(String.valueOf(itemId)) || this.itemNameInList(this.plugin.getChestHighlightIdList(), itemWidget)) {
                if (this.config.highlightChest() == CoxAdditionsConfig.HighlightChestMode.UNDERLINE) {
                    this.underlineItem(graphics, itemWidget, this.config.highlightChestItemsColor());
                } else if (this.config.highlightChest() == CoxAdditionsConfig.HighlightChestMode.OUTLINE) {
                    this.highlightItem(graphics, itemId, itemWidget, this.config.highlightChestItemsColor());
                }
            } else if (this.plugin.getChestHighlightIdList2().contains(String.valueOf(itemId)) || this.itemNameInList(this.plugin.getChestHighlightIdList2(), itemWidget)) {
                if (this.config.highlightChest() == CoxAdditionsConfig.HighlightChestMode.UNDERLINE) {
                    this.underlineItem(graphics, itemWidget, this.config.highlightChestItemsColor2());
                } else if (this.config.highlightChest() == CoxAdditionsConfig.HighlightChestMode.OUTLINE) {
                    this.highlightItem(graphics, itemId, itemWidget, this.config.highlightChestItemsColor2());
                }
            }
        }
    }

    private void highlightItem(Graphics2D graphics, int itemId, WidgetItem itemWidget, Color color) {
        Rectangle bounds = itemWidget.getCanvasBounds();
        BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), color);
        graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
    }

    private void underlineItem(Graphics2D graphics, WidgetItem itemWidget, Color color) {
        Rectangle bounds = itemWidget.getCanvasBounds();
        int heightOffSet = (int)bounds.getY() + (int)bounds.getHeight() + 2;
        graphics.setColor(color);
        graphics.drawLine((int)bounds.getX(), heightOffSet, (int)bounds.getX() + (int)bounds.getWidth(), heightOffSet);
    }

    private boolean itemNameInList(ArrayList<String> list, WidgetItem item) {
        String itemName = Text.removeTags((String)item.getWidget().getName().replace('\u00a0', ' ').trim());
        return list.stream().anyMatch(i -> WildcardMatcher.matches((String)i, (String)itemName) || i.equalsIgnoreCase(itemName));
    }
}

