/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InstanceTemplates;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class CoxHPOverlay
extends Overlay {
    private final Client client;
    private final CoxAdditionsPlugin plugin;
    private final CoxAdditionsConfig config;

    @Inject
    private CoxHPOverlay(Client client, CoxAdditionsPlugin plugin, CoxAdditionsConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getOverlayFont() == null) {
            this.plugin.loadFont(true);
        }
        if (this.plugin.isInRaid() && this.client.getLocalPlayer() != null) {
            NPC smallMutta;
            boolean solo;
            boolean bl = solo = this.client.getVarbitValue(5424) == 1;
            if (this.config.smallMuttaHp() && this.plugin.isSmallMuttaAlive() && !this.plugin.getSmallMutta().isDead() && this.plugin.room() == InstanceTemplates.RAIDS_MUTTADILES && ((smallMutta = this.plugin.getSmallMutta()).getHealthRatio() > 0 || this.plugin.getLastRatio() != 0 && this.plugin.getLastHealthScale() != 0)) {
                if (smallMutta.getHealthRatio() > 0) {
                    this.plugin.setLastRatio(smallMutta.getHealthRatio());
                    this.plugin.setLastHealthScale(smallMutta.getHealthScale());
                }
                this.drawHp(graphics, this.plugin.getSmallMutta(), this.plugin.getSmallMutta().getLogicalHeight() + 40, this.plugin.getLastRatio(), this.plugin.getLastHealthScale(), true);
            }
            if (this.config.iceDemonHp() && this.plugin.getIceDemon() != null && !this.plugin.isIceDemonActive() && this.plugin.room() == InstanceTemplates.RAIDS_ICE_DEMON) {
                if (solo) {
                    this.drawHp(graphics, this.plugin.getIceDemon(), this.plugin.getIceDemon().getLogicalHeight() + 40, this.plugin.getIceDemon().getHealthRatio(), this.plugin.getIceDemon().getHealthScale(), true);
                } else {
                    this.drawHp(graphics, this.plugin.getIceDemon(), this.plugin.getIceDemon().getLogicalHeight() + 40, this.plugin.getIceDemon().getHealthRatio(), 100, true);
                }
            }
            if (this.config.olmHandsHealth() == CoxAdditionsConfig.olmHandsHealthMode.OVERLAY && (this.plugin.getMageHand() != null || this.plugin.getMeleeHand() != null)) {
                NPC mageHand = this.plugin.getMageHand();
                NPC meleeHand = this.plugin.getMeleeHand();
                if (solo) {
                    if (mageHand != null && this.plugin.getMageHandHp() > 0) {
                        this.drawHp(graphics, mageHand, -75, this.plugin.getMageHandHp(), 100, false);
                    }
                    if (meleeHand != null && this.plugin.getMeleeHandHp() > 0) {
                        this.drawHp(graphics, meleeHand, -75, this.plugin.getMeleeHandHp(), 100, false);
                    }
                } else {
                    if (mageHand != null && (mageHand.getHealthRatio() > 0 || this.plugin.getMageHandLastRatio() != 0 && this.plugin.getMageHandLastHealthScale() != 0)) {
                        if (mageHand.getHealthRatio() > 0) {
                            this.plugin.setMageHandLastRatio(mageHand.getHealthRatio());
                            this.plugin.setMageHandLastHealthScale(mageHand.getHealthScale());
                        }
                        this.drawHp(graphics, mageHand, -75, this.plugin.getMageHandLastRatio(), this.plugin.getMageHandLastHealthScale(), true);
                    }
                    if (meleeHand != null && (meleeHand.getHealthRatio() > 0 || this.plugin.getMeleeHandLastRatio() != 0 && this.plugin.getMeleeHandLastHealthScale() != 0)) {
                        if (this.plugin.getMeleeHand().getHealthRatio() > 0) {
                            this.plugin.setMeleeHandLastRatio(meleeHand.getHealthRatio());
                            this.plugin.setMeleeHandLastHealthScale(meleeHand.getHealthScale());
                        }
                        this.drawHp(graphics, meleeHand, -75, this.plugin.getMeleeHandLastRatio(), this.plugin.getMeleeHandLastHealthScale(), true);
                    }
                }
            }
        }
        return null;
    }

    public Color getHPColor(float hpPercent) {
        hpPercent = Math.max(Math.min(100.0f, hpPercent), 0.0f);
        float rMod = 130.0f * hpPercent / 100.0f;
        float gMod = 235.0f * hpPercent / 100.0f;
        float bMod = 125.0f * hpPercent / 100.0f;
        int r = (int)Math.min(255.0f, 255.0f - rMod);
        int g = Math.min(255, (int)(0.0f + gMod));
        int b = Math.min(255, (int)(0.0f + bMod));
        return new Color(r, g, b);
    }

    private void drawHp(Graphics2D graphics, NPC npc, int offset, int ratio, int scale, boolean percent) {
        float health = percent ? (float)ratio / (float)scale * 100.0f : (float)ratio;
        Object text = Float.toString(health);
        text = percent ? ((String)text).substring(0, ((String)text).indexOf(".")) + "%" : ((String)text).substring(0, ((String)text).indexOf("."));
        Point point = npc.getCanvasTextLocation(graphics, (String)text, offset);
        if (point != null) {
            Font oldFont = graphics.getFont();
            graphics.setFont(this.plugin.getOverlayFont());
            this.drawTextBackground(graphics, point, (String)text);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)point, (String)text, (Color)(percent ? this.getHPColor(health) : this.getHPColor((float)ratio / 600.0f * 100.0f)));
            graphics.setFont(oldFont);
        }
    }

    private void drawTextBackground(Graphics2D graphics, Point textLoc, String text) {
        switch (this.config.overlayFontBackground()) {
            case OUTLINE: {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX(), textLoc.getY() + 1), (String)text, (Color)Color.BLACK);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX(), textLoc.getY() - 1), (String)text, (Color)Color.BLACK);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX() + 1, textLoc.getY()), (String)text, (Color)Color.BLACK);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX() - 1, textLoc.getY()), (String)text, (Color)Color.BLACK);
                break;
            }
            case SHADOW: {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX() + 1, textLoc.getY() + 1), (String)text, (Color)Color.BLACK);
                break;
            }
        }
    }
}

