/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions.overlay;

import com.coxadditions.ChestGroup;
import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.CoxAdditionsPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.InstanceTemplates;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;
import net.runelite.client.util.ColorUtil;

@Singleton
public class CoxAdditionsOverlay
extends Overlay {
    private final Client client;
    private final CoxAdditionsPlugin plugin;
    private final CoxAdditionsConfig config;
    private final ModelOutlineRenderer modelOutlineRenderer;
    private final Color NO_FILL = new Color(0, 0, 0, 0);

    @Inject
    private CoxAdditionsOverlay(Client client, CoxAdditionsPlugin plugin, CoxAdditionsConfig config, ModelOutlineRenderer modelOutlineRenderer) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.isInRaid()) {
            Point point;
            Object player;
            if (this.plugin.getOverlayFont() == null) {
                this.plugin.loadFont(true);
            }
            if (this.config.coxHerbTimer() != CoxAdditionsConfig.CoXHerbTimerMode.OFF && (this.plugin.getCoxHerb1() != null || this.plugin.getCoxHerb2() != null) && this.plugin.isInPrep()) {
                if (this.config.coxHerbTimer() == CoxAdditionsConfig.CoXHerbTimerMode.TEXT) {
                    Font oldFont;
                    Point pointShadow;
                    Point textLoc;
                    String text;
                    GameObject herb;
                    graphics.setFont(this.plugin.getOverlayFont());
                    if (this.plugin.getCoxHerb1() != null) {
                        herb = this.plugin.getCoxHerb1();
                        text = Integer.toString(this.plugin.getCoxHerbTimer1());
                        textLoc = herb.getCanvasTextLocation(graphics, text, 50);
                        pointShadow = new Point(textLoc.getX() + 1, textLoc.getY() + 1);
                        oldFont = graphics.getFont();
                        graphics.setFont(this.plugin.getOverlayFont());
                        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)pointShadow, (String)text, (Color)Color.BLACK);
                        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLoc, (String)text, (Color)this.config.coxHerbTimerColor());
                        graphics.setFont(oldFont);
                    }
                    if (this.plugin.getCoxHerb2() != null) {
                        herb = this.plugin.getCoxHerb2();
                        text = Integer.toString(this.plugin.getCoxHerbTimer2());
                        textLoc = herb.getCanvasTextLocation(graphics, text, 50);
                        pointShadow = new Point(textLoc.getX() + 1, textLoc.getY() + 1);
                        oldFont = graphics.getFont();
                        graphics.setFont(this.plugin.getOverlayFont());
                        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)pointShadow, (String)text, (Color)Color.BLACK);
                        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLoc, (String)text, (Color)this.config.coxHerbTimerColor());
                        graphics.setFont(oldFont);
                    }
                } else if (this.config.coxHerbTimer() == CoxAdditionsConfig.CoXHerbTimerMode.PIE) {
                    double progress;
                    int ticks;
                    Color colorFill;
                    ProgressPieComponent progressPie;
                    Point position;
                    if (this.plugin.getCoxHerb1() != null) {
                        position = this.plugin.getCoxHerb1().getCanvasLocation(100);
                        progressPie = new ProgressPieComponent();
                        progressPie.setDiameter(this.config.coxHerbTimerSize());
                        colorFill = new Color(this.config.coxHerbTimerColor().getRed(), this.config.coxHerbTimerColor().getGreen(), this.config.coxHerbTimerColor().getBlue(), 100);
                        progressPie.setFill(colorFill);
                        progressPie.setBorderColor(this.config.coxHerbTimerColor());
                        progressPie.setPosition(position);
                        ticks = 16 - this.plugin.getCoxHerbTimer1();
                        progress = 1.0 - (double)ticks / 16.0;
                        progressPie.setProgress(progress);
                        progressPie.render(graphics);
                    }
                    if (this.plugin.getCoxHerb2() != null) {
                        position = this.plugin.getCoxHerb2().getCanvasLocation(100);
                        progressPie = new ProgressPieComponent();
                        progressPie.setDiameter(this.config.coxHerbTimerSize());
                        colorFill = new Color(this.config.coxHerbTimerColor().getRed(), this.config.coxHerbTimerColor().getGreen(), this.config.coxHerbTimerColor().getBlue(), 100);
                        progressPie.setFill(colorFill);
                        progressPie.setBorderColor(this.config.coxHerbTimerColor());
                        progressPie.setPosition(position);
                        ticks = 16 - this.plugin.getCoxHerbTimer2();
                        progress = 1.0 - (double)ticks / 16.0;
                        progressPie.setProgress(progress);
                        progressPie.render(graphics);
                    }
                }
            }
            if (this.config.instanceTimer() == CoxAdditionsConfig.instanceTimerMode.OVERHEAD && this.plugin.isInstanceTimerRunning() && (player = this.client.getLocalPlayer()) != null && (point = player.getCanvasTextLocation(graphics, "#", player.getLogicalHeight() + 60)) != null) {
                Color goodTick = new Color(37, 197, 79);
                Color badTick = new Color(224, 60, 49);
                graphics.setFont(this.plugin.getOverlayFont());
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)point, (String)String.valueOf(this.plugin.getInstanceTimer()), (Color)(this.plugin.getInstanceTimer() == 0 ? goodTick : badTick));
            }
            if (!this.config.tlList().equals("")) {
                for (NPC npc : this.client.getNpcs()) {
                    if (npc.getName() == null || npc.getId() == 8203) continue;
                    String bossName = "";
                    bossName = npc.getName().toLowerCase().contains("tekton") ? "tekton" : (npc.getName().toLowerCase().contains("jewelled crab") ? "jewelled crab" : npc.getName().toLowerCase());
                    if (!this.plugin.getTlList().contains(bossName)) continue;
                    NPCComposition comp = npc.getComposition();
                    int size = comp.getSize();
                    LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)npc.getWorldLocation());
                    if (lp == null) continue;
                    lp = new LocalPoint(lp.getX() + size * 128 / 2 - 64, lp.getY() + size * 128 / 2 - 64);
                    Object tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp, (int)size);
                    switch (this.config.tileLines()) {
                        case REG: {
                            this.renderPoly(graphics, this.config.tlColor(), this.config.tlFillColor(), (Shape)tilePoly, this.config.tlThiCC());
                            break;
                        }
                        case DASH: {
                            this.renderPolygonDashed(graphics, this.config.tlColor(), this.config.tlFillColor(), (Shape)tilePoly, this.config.tlThiCC(), size);
                            break;
                        }
                        case CORNER: {
                            this.renderPolygonCorners(graphics, this.config.tlColor(), this.config.tlFillColor(), (Shape)tilePoly, this.config.tlThiCC());
                        }
                    }
                }
            }
            if (this.config.olmPhaseHighlight() && this.plugin.isOlmSpawned() && this.plugin.getOlmHead() != null) {
                Polygon tilePoly;
                NPCComposition comp = this.plugin.getOlmHead().getComposition();
                int size = comp.getSize();
                LocalPoint lp = this.plugin.getOlmHead().getLocalLocation();
                if (lp != null && (tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp, (int)size)) != null) {
                    Color color = this.config.olmHighlightColor();
                    Color fill = ColorUtil.colorWithAlpha((Color)this.config.olmHighlightColor(), (int)this.config.olmHighlightFill());
                    switch (this.plugin.getOlmPhase()) {
                        case "Crystal": {
                            color = ColorUtil.colorWithAlpha((Color)Color.MAGENTA, (int)this.config.olmHighlightColor().getAlpha());
                            fill = ColorUtil.colorWithAlpha((Color)Color.MAGENTA, (int)this.config.olmHighlightFill());
                            break;
                        }
                        case "Acid": {
                            color = ColorUtil.colorWithAlpha((Color)Color.GREEN, (int)this.config.olmHighlightColor().getAlpha());
                            fill = ColorUtil.colorWithAlpha((Color)Color.GREEN, (int)this.config.olmHighlightFill());
                            break;
                        }
                        case "Flame": {
                            color = ColorUtil.colorWithAlpha((Color)Color.RED, (int)this.config.olmHighlightColor().getAlpha());
                            fill = ColorUtil.colorWithAlpha((Color)Color.RED, (int)this.config.olmHighlightFill());
                        }
                    }
                    switch (this.config.olmLines()) {
                        case REG: {
                            this.renderPoly(graphics, color, fill, tilePoly, this.config.olmWidth());
                            break;
                        }
                        case DASH: {
                            this.renderPolygonDashed(graphics, color, fill, tilePoly, this.config.olmWidth(), size);
                            break;
                        }
                        case CORNER: {
                            this.renderPolygonCorners(graphics, color, fill, tilePoly, this.config.olmWidth());
                        }
                    }
                }
            }
            if (this.plugin.room() == InstanceTemplates.RAIDS_THIEVING && this.client.getLocalPlayer() != null && WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID() == 13140) {
                Tile[][][] tiles = this.client.getScene().getTiles();
                for (int x = 0; x < 104; ++x) {
                    block29: for (int y = 0; y < 104; ++y) {
                        Tile tile = tiles[this.client.getPlane()][x][y];
                        if (tile == null || tile.getGameObjects() == null) continue;
                        for (GameObject obj : tile.getGameObjects()) {
                            for (ChestGroup cg : ChestGroup.values()) {
                                if (obj == null || obj.getId() != 29742 || cg.getRegionX() != obj.getWorldLocation().getRegionX() || cg.getRegionY() != obj.getWorldLocation().getRegionY() || !(this.config.chestGroupsHighlight().contains((Object)CoxAdditionsConfig.HighlightChestGroups.CHEST_GROUPS_1) && cg.getGroup() < 5 || this.config.chestGroupsHighlight().contains((Object)CoxAdditionsConfig.HighlightChestGroups.CHEST_GROUPS_2) && cg.getGroup() > 4 && cg.getGroup() < 8) && (!this.config.chestGroupsHighlight().contains((Object)CoxAdditionsConfig.HighlightChestGroups.CHEST_GROUPS_3) || cg.getGroup() <= 7)) continue;
                                switch (this.config.chestGroupsHighlightStyle()) {
                                    case HULL: {
                                        Shape hull = obj.getConvexHull();
                                        if (hull == null) break;
                                        this.renderPoly(graphics, cg.getColor(), this.NO_FILL, hull, 2.0);
                                        break;
                                    }
                                    case OUTLINE: {
                                        this.modelOutlineRenderer.drawOutline((TileObject)obj, 2, cg.getColor(), 4);
                                        break;
                                    }
                                    case TILE: {
                                        Polygon tilePoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)obj.getLocalLocation());
                                        this.renderPoly(graphics, cg.getColor(), this.NO_FILL, tilePoly, 2.0);
                                        break;
                                    }
                                    case CORNERS: {
                                        Polygon cornerPoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)obj.getLocalLocation());
                                        this.renderPolygonCorners(graphics, cg.getColor(), this.NO_FILL, cornerPoly, 2.0);
                                        break;
                                    }
                                    case CLICKBOX: {
                                        Shape clickbox = obj.getClickbox();
                                        if (clickbox == null) break;
                                        this.renderPoly(graphics, cg.getColor(), this.NO_FILL, clickbox, 2.0);
                                    }
                                }
                                continue block29;
                            }
                        }
                    }
                }
            }
        } else if (this.config.ccWarning()) {
            GameObject obj;
            Tile tile;
            int sceneX = 1232 - this.client.getBaseX();
            int sceneY = 3573 - this.client.getBaseY();
            if (sceneX >= 0 && sceneY >= 0 && sceneX < 104 && sceneY < 104 && (tile = this.client.getScene().getTiles()[0][sceneX][sceneY]).getGameObjects()[0] != null && (obj = tile.getGameObjects()[0]).getId() == 29777) {
                Color color = null;
                if (this.client.getFriendsChatManager() == null) {
                    color = new Color(255, 0, 0, 50);
                } else if (this.client.getVarpValue(1427) == -1) {
                    color = new Color(200, 200, 0, 50);
                }
                Shape clickbox = obj.getClickbox();
                if (color != null && clickbox != null) {
                    Point mousePos = this.client.getMouseCanvasPosition();
                    if (mousePos != null && clickbox.contains(mousePos.getX(), mousePos.getY())) {
                        color = color.darker();
                    }
                    graphics.setColor(color);
                    graphics.fill(clickbox);
                    graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue()));
                    graphics.draw(clickbox);
                }
            }
        }
        return null;
    }

    private void renderPoly(Graphics2D graphics, Color color, Color fill, Shape polygon, double width) {
        if (polygon != null) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.config.antiAlias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke((float)width));
            graphics.draw(polygon);
            graphics.setColor(fill);
            graphics.fill(polygon);
        }
    }

    private void renderPolygonCorners(Graphics2D graphics, Color outlineColor, Color fillColor, Shape poly, double width) {
        if (poly instanceof Polygon) {
            Polygon p = (Polygon)poly;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.config.antiAlias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(outlineColor);
            graphics.setStroke(new BasicStroke((float)width));
            int divisor = 7;
            for (int i = 0; i < p.npoints; ++i) {
                int ptx = p.xpoints[i];
                int pty = p.ypoints[i];
                int prev = i - 1 < 0 ? 3 : i - 1;
                int next = i + 1 > 3 ? 0 : i + 1;
                int ptxN = (p.xpoints[next] - ptx) / divisor + ptx;
                int ptyN = (p.ypoints[next] - pty) / divisor + pty;
                int ptxP = (p.xpoints[prev] - ptx) / divisor + ptx;
                int ptyP = (p.ypoints[prev] - pty) / divisor + pty;
                graphics.drawLine(ptx, pty, ptxN, ptyN);
                graphics.drawLine(ptx, pty, ptxP, ptyP);
            }
            graphics.setColor(fillColor);
            graphics.fill(poly);
        }
    }

    private void renderPolygonDashed(Graphics2D graphics, Color outlineColor, Color fillColor, Shape poly, double width, int tiles) {
        if (poly instanceof Polygon) {
            Polygon p = (Polygon)poly;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.config.antiAlias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(outlineColor);
            graphics.setStroke(new BasicStroke((float)width));
            int divisor = 7 * tiles;
            for (int i = 0; i < p.npoints; ++i) {
                int ptx = p.xpoints[i];
                int pty = p.ypoints[i];
                int next = i + 1 > 3 ? 0 : i + 1;
                int ptxN = p.xpoints[next] - ptx;
                int ptyN = p.ypoints[next] - pty;
                float length = (float)Point2D.distance(ptx, pty, ptx + ptxN, pty + ptyN);
                float dashLength = length * 2.0f / (float)divisor;
                float spaceLength = length * 5.0f / (float)divisor;
                BasicStroke s = new BasicStroke((float)width, 2, 0, 10.0f, new float[]{dashLength, spaceLength}, dashLength / 2.0f);
                graphics.setStroke(s);
                graphics.drawLine(ptx, pty, ptx + ptxN, pty + ptyN);
            }
            graphics.setColor(fillColor);
            graphics.fill(poly);
        }
    }
}

