/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions;

import com.coxadditions.CoxAdditionsConfig;
import com.coxadditions.EnhanceInfobox;
import com.coxadditions.GrubsInfobox;
import com.coxadditions.RaidsPlayers;
import com.coxadditions.overlay.CoxAdditionsOverlay;
import com.coxadditions.overlay.CoxHPOverlay;
import com.coxadditions.overlay.CoxItemOverlay;
import com.coxadditions.overlay.CoxPrepOverlay;
import com.coxadditions.overlay.InstanceTimerOverlay;
import com.coxadditions.overlay.OlmHpPanelOverlay;
import com.coxadditions.overlay.OlmPhasePanel;
import com.coxadditions.overlay.OlmSideOverlay;
import com.coxadditions.overlay.RaidsPotsStatusOverlay;
import com.coxadditions.overlay.VangPotsOverlay;
import com.coxadditions.overlay.VanguardInfoBox;
import com.coxadditions.party.PartyGrubsUpdate;
import com.coxadditions.party.PartyOverloadUpdate;
import com.coxadditions.party.PartyRaidsPotsUpdate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InstanceTemplates;
import net.runelite.api.InventoryID;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.Projectile;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.events.UserPart;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="CoX Additions", description="Additional plugins for the Chambers of Xeric", tags={"xeric", "olm", "chambers", "cox", "buchus"})
public class CoxAdditionsPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(CoxAdditionsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private CoxAdditionsConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CoxAdditionsOverlay overlay;
    @Inject
    private OlmSideOverlay olmSideOverlay;
    @Inject
    private CoxItemOverlay itemOverlay;
    @Inject
    private InstanceTimerOverlay instanceTimerOverlay;
    @Inject
    private VanguardInfoBox vanguardInfobox;
    @Inject
    private CoxHPOverlay coxHPOverlay;
    @Inject
    private OlmHpPanelOverlay olmHpPanelOverlay;
    @Inject
    private VangPotsOverlay vangPotsOverlay;
    @Inject
    private OlmPhasePanel phasePanel;
    @Inject
    private CoxPrepOverlay prepOverlay;
    @Inject
    private RaidsPotsStatusOverlay raidsPotsStatusOverlay;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private KeyManager keyManager;
    @Inject
    private PartyService partyService;
    @Inject
    private WSClient wsClient;
    private final ArrayListMultimap<String, Integer> optionIndexes = ArrayListMultimap.create();
    private GameObject coxHerb1;
    private int coxHerbTimer1;
    private GameObject coxHerb2;
    private int coxHerbTimer2;
    private int totalBuchus = 0;
    private int totalGolpar = 0;
    private int totalNox = 0;
    private int inventoryBuchus = 0;
    private int inventoryGolpar = 0;
    private int inventoryNox = 0;
    private int totalBrews = 0;
    private int totalRevites = 0;
    private int totalEnhances = 0;
    private int totalElders = 0;
    private int totalTwisteds = 0;
    private int totalKodais = 0;
    private int totalOverloads = 0;
    private int inventoryBrews = 0;
    private int inventoryRevites = 0;
    private int inventoryEnhances = 0;
    private int inventoryElders = 0;
    private int inventoryTwisteds = 0;
    private int inventoryKodais = 0;
    private int inventoryOverloads = 0;
    private int pickedJuice = 0;
    private int pickedShrooms = 0;
    private int pickedCicely = 0;
    private boolean pickedHerb = false;
    private boolean potMade = false;
    private int totalGrubs = 0;
    private int previousGrubs = 0;
    private boolean inThieving = false;
    private boolean inPrep = false;
    private GrubsInfobox grubsInfobox;
    private boolean enhanceSipped;
    private int enhanceTicks = -1;
    private int totalEnhCycles = 0;
    private int maxEnhCycles = 0;
    private int enhRegenRate = 0;
    private final int enhVar = 5417;
    private EnhanceInfobox enhanceInfobox;
    private int overloadTicks = -1;
    private int totalOvlCycles = 0;
    private final int ovlVar = 5418;
    private final ArrayList<RaidsPlayers> playersInParty = new ArrayList();
    private int instanceTimer = 3;
    private boolean isInstanceTimerRunning = false;
    private LocalPoint olmTile = null;
    private String olmPhase = "";
    private NPC olmHead = null;
    private boolean olmSpawned = false;
    private NPC meleeHand;
    private NPC mageHand;
    private int meleeHandHp = 600;
    private int mageHandHp = 600;
    private int mageHandLastRatio = 100;
    private int mageHandLastHealthScale = 100;
    private int meleeHandLastRatio = 100;
    private int meleeHandLastHealthScale = 100;
    private final Set<Integer> orbIDs = ImmutableSet.of((Object)1341, (Object)1343, (Object)1345);
    private boolean smallMuttaAlive = false;
    private NPC smallMutta = null;
    private int lastRatio = 100;
    private int lastHealthScale = 100;
    private final List<String> tlList = new ArrayList<String>();
    private final List<String> bossList = Arrays.asList("tekton", "jewelled crab", "scavenger beast", "ice demon", "lizardman shaman", "vanguard", "vespula", "deathly ranger", "deathly mage", "vasa nistirio", "skeletal mystic", "muttadile");
    private final int MAGE = 7529;
    private final int RANGE = 7528;
    private final int MELEE = 7527;
    private final int DOWN = 7526;
    private final ArrayList<Integer> ids = new ArrayList();
    private NPC ranger;
    private NPC mager;
    private NPC meleer;
    private boolean inRaid;
    private boolean magerFound;
    private boolean rangerFound;
    private boolean meleeFound;
    private int mageHP = -1;
    private int rangeHP = -1;
    private int meleeHP = -1;
    private float percent;
    private boolean inVangs;
    private int overloadsDropped = 0;
    private NPC iceDemon = null;
    private boolean iceDemonActive = false;
    private final ArrayList<String> chestHighlightIdList = new ArrayList();
    private final ArrayList<String> chestHighlightIdList2 = new ArrayList();
    private boolean hotkeyHeld;
    Font overlayFont;
    Font panelFont;
    private final Predicate<MenuEntry> filterMenuEntries = entry -> {
        if (this.inRaid) {
            String option = Text.standardize((String)entry.getOption()).toLowerCase();
            if (this.config.leftClickLeave() && option.contains("leave") && entry.getType().getId() == 1007) {
                entry.setType(MenuAction.CC_OP);
            }
        }
        return true;
    };

    @Provides
    CoxAdditionsConfig provideConfig(ConfigManager configManager) {
        return (CoxAdditionsConfig)configManager.getConfig(CoxAdditionsConfig.class);
    }

    private void reset() {
        this.playersInParty.clear();
        this.coxHerb1 = null;
        this.coxHerbTimer1 = 16;
        this.coxHerb2 = null;
        this.coxHerbTimer2 = 16;
        this.totalBuchus = 0;
        this.totalGolpar = 0;
        this.totalNox = 0;
        this.inventoryBuchus = 0;
        this.inventoryGolpar = 0;
        this.inventoryNox = 0;
        this.totalBrews = 0;
        this.totalRevites = 0;
        this.totalEnhances = 0;
        this.totalElders = 0;
        this.totalTwisteds = 0;
        this.totalKodais = 0;
        this.totalOverloads = 0;
        this.inventoryBrews = 0;
        this.inventoryRevites = 0;
        this.inventoryEnhances = 0;
        this.inventoryElders = 0;
        this.inventoryTwisteds = 0;
        this.inventoryKodais = 0;
        this.inventoryOverloads = 0;
        this.pickedJuice = 0;
        this.pickedShrooms = 0;
        this.pickedCicely = 0;
        this.pickedHerb = false;
        this.potMade = false;
        this.totalGrubs = 0;
        this.previousGrubs = 0;
        this.inThieving = false;
        this.inPrep = false;
        this.olmTile = null;
        this.olmPhase = "";
        this.olmSpawned = false;
        this.olmHead = null;
        this.meleeHand = null;
        this.mageHand = null;
        this.meleeHandHp = 600;
        this.mageHandHp = 600;
        this.mageHandLastRatio = 100;
        this.mageHandLastHealthScale = 100;
        this.meleeHandLastRatio = 100;
        this.meleeHandLastHealthScale = 100;
        this.smallMuttaAlive = false;
        this.smallMutta = null;
        this.lastRatio = 100;
        this.lastHealthScale = 100;
        this.ids.add(7529);
        this.ids.add(7528);
        this.ids.add(7527);
        this.ids.add(7526);
        this.inRaid = false;
        this.inVangs = false;
        this.meleeFound = false;
        this.rangerFound = false;
        this.magerFound = false;
        this.iceDemon = null;
        this.iceDemonActive = false;
        this.overloadsDropped = 0;
        this.overlayFont = null;
        this.panelFont = null;
        if (this.enhanceInfobox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.enhanceInfobox);
            this.enhanceInfobox = null;
        }
        if (this.grubsInfobox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.grubsInfobox);
            this.grubsInfobox = null;
        }
    }

    protected void startUp() {
        this.reset();
        this.tlList.clear();
        for (String str : this.config.tlList().split(",")) {
            if (str.trim().equals("")) continue;
            this.tlList.add(str.trim().toLowerCase());
        }
        this.chestHighlightIdList.clear();
        for (String str : this.config.highlightChestItems().split(",")) {
            if (str.trim().equals("")) continue;
            try {
                this.chestHighlightIdList.add(str.trim());
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        this.chestHighlightIdList2.clear();
        for (String str : this.config.highlightChestItems2().split(",")) {
            if (str.trim().equals("")) continue;
            try {
                this.chestHighlightIdList2.add(str.trim());
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        this.enhanceSipped = false;
        this.enhanceTicks = -1;
        this.totalEnhCycles = 0;
        this.keyManager.registerKeyListener((KeyListener)this);
        this.wsClient.registerMessage(PartyOverloadUpdate.class);
        this.wsClient.registerMessage(PartyGrubsUpdate.class);
        this.wsClient.registerMessage(PartyRaidsPotsUpdate.class);
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.olmSideOverlay);
        this.overlayManager.add((Overlay)this.vanguardInfobox);
        this.overlayManager.add((Overlay)this.itemOverlay);
        this.overlayManager.add((Overlay)this.instanceTimerOverlay);
        this.overlayManager.add((Overlay)this.coxHPOverlay);
        this.overlayManager.add((Overlay)this.olmHpPanelOverlay);
        this.overlayManager.add((Overlay)this.vangPotsOverlay);
        this.overlayManager.add((Overlay)this.phasePanel);
        this.overlayManager.add((Overlay)this.prepOverlay);
        this.overlayManager.add((Overlay)this.raidsPotsStatusOverlay);
    }

    protected void shutDown() {
        this.reset();
        this.eventBus.unregister((Object)this);
        this.keyManager.unregisterKeyListener((KeyListener)this);
        this.wsClient.unregisterMessage(PartyOverloadUpdate.class);
        this.wsClient.unregisterMessage(PartyGrubsUpdate.class);
        this.wsClient.unregisterMessage(PartyRaidsPotsUpdate.class);
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.olmSideOverlay);
        this.overlayManager.remove((Overlay)this.vanguardInfobox);
        this.overlayManager.remove((Overlay)this.itemOverlay);
        this.overlayManager.remove((Overlay)this.instanceTimerOverlay);
        this.overlayManager.remove((Overlay)this.coxHPOverlay);
        this.overlayManager.remove((Overlay)this.olmHpPanelOverlay);
        this.overlayManager.remove((Overlay)this.vangPotsOverlay);
        this.overlayManager.remove((Overlay)this.phasePanel);
        this.overlayManager.remove((Overlay)this.prepOverlay);
        this.overlayManager.remove((Overlay)this.raidsPotsStatusOverlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (e.getGroup().equals("CoxAdditions")) {
            switch (e.getKey()) {
                case "tlList": {
                    this.tlList.clear();
                    for (String str : this.config.tlList().split(",")) {
                        if (str.trim().equals("")) continue;
                        this.tlList.add(str.trim().toLowerCase());
                    }
                    break;
                }
                case "highlightChestItems": {
                    this.chestHighlightIdList.clear();
                    for (String str : this.config.highlightChestItems().split(",")) {
                        if (str.trim().equals("")) continue;
                        try {
                            this.chestHighlightIdList.add(str.trim());
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    }
                    break;
                }
                case "highlightChestItems2": {
                    this.chestHighlightIdList2.clear();
                    for (String str : this.config.highlightChestItems2().split(",")) {
                        if (str.trim().equals("")) continue;
                        try {
                            this.chestHighlightIdList2.add(str.trim());
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    }
                    break;
                }
                case "detailedPrayerEnhance": {
                    if (this.config.detailedPrayerEnhance() == CoxAdditionsConfig.enhanceMode.OFF && this.enhanceInfobox != null) {
                        this.removeInfobox("Enhance");
                        break;
                    }
                    this.addInfobox("Enhance");
                    break;
                }
                case "grubsInfobox": {
                    if (this.config.grubsInfobox() == CoxAdditionsConfig.grubsMode.OFF && this.grubsInfobox != null) {
                        this.removeInfobox("Grubs");
                        break;
                    }
                    this.addInfobox("Grubs");
                    break;
                }
                case "overlayFontType": 
                case "overlayFontName": 
                case "overlayFontSize": 
                case "overlayFontWeight": 
                case "overlayFontBackground": {
                    this.loadFont(true);
                    break;
                }
                case "panelFontType": 
                case "panelFontName": 
                case "panelFontSize": 
                case "panelFontWeight": {
                    this.loadFont(false);
                }
            }
        }
    }

    @Subscribe
    private void onChatMessage(ChatMessage e) {
        String msg = Text.standardize((String)e.getMessageNode().getValue());
        if (msg.equalsIgnoreCase("you have been kicked from the channel.") || msg.contains("decided to start the raid without you. sorry.") || msg.equalsIgnoreCase("you are no longer eligible to lead the party.") || msg.equalsIgnoreCase("the raid has begun!")) {
            this.instanceTimer = 5;
            this.isInstanceTimerRunning = false;
        } else if (msg.equalsIgnoreCase("inviting party...") || msg.equalsIgnoreCase("your party has entered the dungeons! come and join them now.")) {
            this.instanceTimer = 5;
            this.isInstanceTimerRunning = true;
        } else if (msg.equalsIgnoreCase("the great olm is giving its all. this is its final stand.")) {
            this.mageHand = null;
            this.meleeHand = null;
        } else if (msg.equalsIgnoreCase("the great olm rises with the power of crystal.")) {
            this.olmPhase = "Crystal";
        } else if (msg.equalsIgnoreCase("the great olm rises with the power of acid.")) {
            this.olmPhase = "Acid";
        } else if (msg.equalsIgnoreCase("the great olm rises with the power of flame.")) {
            this.olmPhase = "Flame";
        }
    }

    @Subscribe
    private void onGameTick(GameTick e) {
        if (this.inRaid) {
            if (this.coxHerb1 != null || this.coxHerb2 != null) {
                if (this.coxHerb1 != null) {
                    if (this.coxHerbTimer1 != 0) {
                        --this.coxHerbTimer1;
                    } else {
                        this.coxHerb1 = null;
                    }
                }
                if (this.coxHerb2 != null) {
                    if (this.coxHerbTimer2 != 0) {
                        --this.coxHerbTimer2;
                    } else {
                        this.coxHerb2 = null;
                    }
                }
            }
            List npcs = this.client.getNpcs();
            this.inVangs = false;
            for (NPC npc : npcs) {
                if (!this.ids.contains(npc.getId())) continue;
                this.inVangs = true;
                int currentId = npc.getId();
                switch (currentId) {
                    case 7529: {
                        this.percent = (float)npc.getHealthRatio() / (float)npc.getHealthScale() * 100.0f;
                        this.mageHP = (int)this.percent;
                        this.mager = npc;
                        break;
                    }
                    case 7528: {
                        this.percent = (float)npc.getHealthRatio() / (float)npc.getHealthScale() * 100.0f;
                        this.rangeHP = (int)this.percent;
                        this.ranger = npc;
                        break;
                    }
                    case 7527: {
                        this.percent = (float)npc.getHealthRatio() / (float)npc.getHealthScale() * 100.0f;
                        this.meleeHP = (int)this.percent;
                        this.meleer = npc;
                        break;
                    }
                    case 7526: {
                        break;
                    }
                }
            }
            if (this.client.getVarbitValue(5417) > 0) {
                this.addInfobox("Enhance");
            } else if (this.client.getVarbitValue(5417) == 0) {
                this.removeInfobox("Enhance");
            }
            --this.enhanceTicks;
            --this.overloadTicks;
            if (this.client.getLocalPlayer() != null) {
                if (this.partyService.isInParty() && this.partyService.getLocalMember() != null) {
                    for (RaidsPlayers raider : this.playersInParty) {
                        if (raider.isOvlActive()) {
                            raider.updatePotStatus("OVL", raider.getOvlTicks() - 1);
                            if (raider.getOvlTicks() < 0) {
                                raider.setOvlActive(false);
                            }
                        }
                        if (!raider.isEnhActive()) continue;
                        raider.updatePotStatus("ENH", raider.getEnhTicks() - 1);
                        if (raider.getEnhTicks() >= 0) continue;
                        raider.setEnhActive(false);
                    }
                    this.playersInParty.removeIf(p -> !p.isEnhActive() && !p.isOvlActive());
                } else if (!this.partyService.isInParty() && !this.playersInParty.isEmpty()) {
                    this.playersInParty.clear();
                }
            }
            this.inPrep = this.room() == InstanceTemplates.RAIDS_FARMING || this.room() == InstanceTemplates.RAIDS_FARMING2;
            boolean bl = this.inThieving = this.room() == InstanceTemplates.RAIDS_THIEVING;
            if (this.config.grubsInfobox() == CoxAdditionsConfig.grubsMode.THIEVING && this.inThieving || this.config.grubsInfobox() == CoxAdditionsConfig.grubsMode.BOTH && (this.inThieving || this.inPrep)) {
                this.addInfobox("Grubs");
            } else {
                this.removeInfobox("Grubs");
            }
        }
        if (this.isInstanceTimerRunning) {
            --this.instanceTimer;
            if (this.instanceTimer < 0) {
                this.instanceTimer = 3;
            }
        }
    }

    public void sendPotStatusInfo(int ticks, String pot) {
        if (this.partyService.isInParty() && this.partyService.getLocalMember() != null) {
            this.partyService.send((PartyMessage)new PartyRaidsPotsUpdate(ticks, pot));
        }
    }

    private void addRaidersInParty(long memberID, String memberName, int ticks, String pot) {
        if (!memberName.equals("<unknown>")) {
            if (this.playersInParty.stream().noneMatch(p -> p.getId() == memberID && p.getPlayer().equals(memberName))) {
                RaidsPlayers raider = new RaidsPlayers(memberName, memberID);
                raider.updatePotStatus(pot, ticks);
                this.playersInParty.add(raider);
            } else {
                this.playersInParty.stream().filter(p -> p.getId() == memberID && p.getPlayer().equals(memberName)).findFirst().ifPresent(rp -> rp.updatePotStatus(pot, ticks));
            }
        }
    }

    @Subscribe
    public void onPartyRaidsPotsUpdate(PartyRaidsPotsUpdate e) {
        String name;
        if (this.partyService.getLocalMember().getMemberId() != e.getMemberId() && (name = this.partyService.getMemberById(e.getMemberId()).getDisplayName()) != null) {
            if (e.getTicks() == -73 && e.getPot().equals("DEAD")) {
                this.playersInParty.removeIf(p -> p.getId() == e.getMemberId());
            } else {
                this.addRaidersInParty(e.getMemberId(), name, e.getTicks(), e.getPot());
            }
        }
    }

    @Subscribe
    public void onUserPart(UserPart e) {
        this.playersInParty.removeIf(p -> p.getId() == e.getMemberId());
    }

    @Subscribe
    private void onGameObjectSpawned(GameObjectSpawned e) {
        GameObject obj = e.getGameObject();
        if (this.inRaid) {
            if (obj.getId() >= 29997 && obj.getId() <= 29999) {
                if (this.coxHerb1 == null) {
                    this.coxHerb1 = obj;
                    this.coxHerbTimer1 = 16;
                } else {
                    this.coxHerb2 = obj;
                    this.coxHerbTimer2 = 16;
                }
            } else if (obj.getId() >= 30000 && obj.getId() <= 30008) {
                if (this.coxHerb1 == null) {
                    this.coxHerb1 = obj;
                    this.coxHerbTimer1 = 16;
                } else {
                    this.coxHerb2 = obj;
                    this.coxHerbTimer2 = 16;
                }
            } else if (obj.getId() == 29745) {
                WorldPoint wp;
                Point p = e.getTile().getSceneLocation();
                int angle = obj.getOrientation() >> 9;
                int chestX = p.getX() + (angle == 1 ? -1 : (angle == 3 ? 1 : 0));
                int chestY = p.getY() + (angle == 0 ? -1 : (angle == 2 ? 1 : 0));
                if (this.client.getLocalPlayer() != null && (wp = this.client.getLocalPlayer().getWorldLocation()).getX() - this.client.getBaseX() == chestX && wp.getY() - this.client.getBaseY() == chestY) {
                    int grubs = this.client.getItemContainer(InventoryID.INVENTORY).count(20885);
                    int delta = grubs - this.previousGrubs;
                    this.totalGrubs += delta;
                    this.previousGrubs = grubs;
                    if (this.partyService.isInParty() && delta > 0) {
                        this.partyService.send((PartyMessage)new PartyGrubsUpdate(this.client.getLocalPlayer().getName(), this.client.getWorld(), delta));
                    }
                }
            }
        }
    }

    @Subscribe
    private void onGameObjectDespawned(GameObjectDespawned e) {
        GameObject obj = e.getGameObject();
        if (this.inRaid && (this.coxHerb1 != null || this.coxHerb2 != null) && obj.getId() >= 29997 && obj.getId() <= 30008) {
            if (this.coxHerb1 != null) {
                if (obj.getId() == this.coxHerb1.getId()) {
                    this.coxHerb1 = null;
                } else {
                    this.coxHerb2 = null;
                }
            } else {
                this.coxHerb2 = null;
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged e) {
        if (e.getActor().getName() != null && this.client.getLocalPlayer() != null && e.getActor().getName().equals(this.client.getLocalPlayer().getName()) && this.inRaid) {
            this.pickedHerb = e.getActor().getAnimation() == 2282;
            this.potMade = e.getActor().getAnimation() == 363;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged e) {
        if (this.inRaid) {
            int nox = e.getItemContainer().count(20901) + e.getItemContainer().count(20902);
            int golpar = e.getItemContainer().count(20904) + e.getItemContainer().count(20905);
            int buchus = e.getItemContainer().count(20907) + e.getItemContainer().count(20908);
            int brews = e.getItemContainer().count(20984);
            int revites = e.getItemContainer().count(20960);
            int enhances = e.getItemContainer().count(20972);
            int elders = e.getItemContainer().count(20924);
            int twisteds = e.getItemContainer().count(20936);
            int kodais = e.getItemContainer().count(20948);
            int overloads = e.getItemContainer().count(20996);
            int grubs = e.getItemContainer().count(20885);
            if (e.getContainerId() == 93) {
                if (this.pickedHerb) {
                    if (nox > this.inventoryNox) {
                        ++this.totalNox;
                    }
                    if (golpar > this.inventoryGolpar) {
                        ++this.totalGolpar;
                    }
                    if (buchus > this.inventoryBuchus) {
                        ++this.totalBuchus;
                    }
                }
                if (this.potMade) {
                    if (brews > this.inventoryBrews) {
                        ++this.totalBrews;
                    }
                    if (revites > this.inventoryRevites) {
                        ++this.totalRevites;
                    }
                    if (enhances > this.inventoryEnhances) {
                        ++this.totalEnhances;
                    }
                    if (elders > this.inventoryElders) {
                        ++this.totalElders;
                    }
                    if (twisteds > this.inventoryTwisteds) {
                        ++this.totalTwisteds;
                    }
                    if (kodais > this.inventoryKodais) {
                        ++this.totalKodais;
                    }
                    if (overloads > this.inventoryOverloads) {
                        ++this.totalOverloads;
                    }
                }
                this.inventoryNox = nox;
                this.inventoryGolpar = golpar;
                this.inventoryBuchus = buchus;
                this.inventoryBrews = brews;
                this.inventoryRevites = revites;
                this.inventoryEnhances = enhances;
                this.inventoryElders = elders;
                this.inventoryTwisteds = twisteds;
                this.inventoryKodais = kodais;
                this.inventoryOverloads = overloads;
                this.pickedJuice = e.getItemContainer().count(20911);
                this.pickedShrooms = e.getItemContainer().count(20910);
                this.pickedCicely = e.getItemContainer().count(20912);
                this.previousGrubs = grubs;
            }
        }
    }

    @Subscribe
    public void onPartyGrubsUpdate(PartyGrubsUpdate e) {
        Player localPlayer = this.client.getLocalPlayer();
        String player = e.getPlayer();
        int world = e.getWorld();
        int grubs = e.getGrubs();
        if (localPlayer.getName() != null && !localPlayer.getName().equals(player) && this.client.getWorld() == world) {
            this.totalGrubs += grubs;
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated e) {
        if (this.inRaid && e.getGraphicsObject().getId() == 188) {
            this.iceDemonActive = true;
        }
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned e) {
        if (this.inRaid && e.getNpc() != null) {
            NPC npc = e.getNpc();
            int id = npc.getId();
            String name = npc.getName();
            switch (id) {
                case 7552: 
                case 7555: {
                    this.meleeHand = npc;
                    break;
                }
                case 7550: 
                case 7553: {
                    this.mageHand = npc;
                    break;
                }
                case 7584: {
                    this.iceDemon = npc;
                    break;
                }
                case 7562: {
                    this.smallMuttaAlive = true;
                    this.smallMutta = npc;
                }
            }
            if (name != null && name.equalsIgnoreCase("great olm")) {
                this.olmHead = npc;
                this.olmSpawned = true;
                if (id == 7551) {
                    this.olmTile = npc.getLocalLocation();
                } else if (id == 7554) {
                    this.olmTile = null;
                }
            }
        }
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned e) {
        if (this.inRaid) {
            NPC npc = e.getNpc();
            int id = npc.getId();
            String name = npc.getName();
            switch (id) {
                case 7552: 
                case 7555: {
                    this.meleeHand = null;
                    if (!npc.isDead()) break;
                    if (this.mageHand == null) {
                        this.olmPhase = "";
                    }
                    this.meleeHandHp = 600;
                    this.meleeHandLastHealthScale = 100;
                    this.meleeHandLastRatio = 100;
                    break;
                }
                case 7550: 
                case 7553: {
                    this.mageHand = null;
                    if (!npc.isDead()) break;
                    if (this.meleeHand == null) {
                        this.olmPhase = "";
                    }
                    this.mageHandHp = 600;
                    this.mageHandLastHealthScale = 100;
                    this.mageHandLastRatio = 100;
                    break;
                }
                case 7584: {
                    this.iceDemon = null;
                    break;
                }
                case 7562: {
                    this.smallMuttaAlive = false;
                    this.smallMutta = null;
                    this.lastHealthScale = 0;
                    this.lastRatio = 0;
                }
            }
            if (name != null && name.equalsIgnoreCase("great olm")) {
                this.olmHead = null;
                this.olmSpawned = false;
                if (id == 7551) {
                    this.olmTile = null;
                }
                if (npc.isDead()) {
                    this.olmPhase = "";
                }
            }
        }
    }

    @Subscribe
    private void onNpcChanged(NpcChanged e) {
        NPC npc;
        int id;
        if (this.inRaid && (id = (npc = e.getNpc()).getId()) == 7554) {
            this.olmTile = null;
        }
    }

    @Subscribe
    private void onActorDeath(ActorDeath e) {
        if (this.inRaid) {
            if (e.getActor() instanceof NPC) {
                NPC npc = (NPC)e.getActor();
                if (npc.getName() != null) {
                    if (npc.getName().toLowerCase().contains("great olm (left claw)")) {
                        this.meleeHand = null;
                        this.meleeHandHp = 600;
                        this.meleeHandLastHealthScale = 100;
                        this.meleeHandLastRatio = 100;
                    } else if (npc.getName().toLowerCase().contains("great olm (right claw)")) {
                        this.mageHand = null;
                        this.mageHandHp = 600;
                        this.mageHandLastHealthScale = 100;
                        this.mageHandLastRatio = 100;
                    }
                }
            } else if (e.getActor() instanceof Player && e.getActor().getName() != null && e.getActor().getName().equals(this.client.getLocalPlayer().getName())) {
                this.sendPotStatusInfo(-73, "DEAD");
            }
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived e) {
        if (e.getNpc().getName() != null && e.getNpc().getName().equalsIgnoreCase("vanguard") && this.inRaid && this.client.getLocalPlayer() != null) {
            for (ItemStack item : e.getItems()) {
                if (item.getId() != 20996) continue;
                if (this.partyService.isInParty()) {
                    this.partyService.send((PartyMessage)new PartyOverloadUpdate(this.client.getLocalPlayer().getName(), this.client.getWorld()));
                    continue;
                }
                this.sendVanguardMessage(this.client.getLocalPlayer().getName(), this.client.getWorld());
            }
        }
    }

    @Subscribe
    public void onPartyOverloadUpdate(PartyOverloadUpdate e) {
        this.sendVanguardMessage(e.getPlayer(), e.getWorld());
    }

    public void sendVanguardMessage(String player, int world) {
        this.clientThread.invoke(() -> {
            if (world == this.client.getWorld()) {
                ++this.overloadsDropped;
                if (this.config.overloadChatMessage()) {
                    String msg = player + " has received: <col=ff0000>1</col> x <col=ff0000>Overload (+)(4)</col>.";
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", msg, null);
                }
            }
        });
    }

    private void swapMenuEntry(int index, MenuEntry menuEntry) {
        String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
        String target = Text.removeTags((String)menuEntry.getTarget()).toLowerCase();
        if (this.inRaid) {
            if (this.config.swapCoXKeystone() && target.equals("keystone crystal") && option.equals("use")) {
                this.swap("drop", option, target, index, false);
            }
            if (this.config.hotkeySwapSmash() && target.contains("jewelled crab") && option.contains("attack") && this.hotkeyHeld) {
                this.swap("smash", option, target, index);
            }
            if (this.config.hotkeySwapBank() && target.contains("storage unit") && this.hotkeyHeld && option.contains("shared")) {
                this.swap("private", option, target, index);
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick e) {
        if (this.client.getGameState() == GameState.LOGGED_IN && !this.client.isMenuOpen()) {
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            int idx = 0;
            this.optionIndexes.clear();
            for (MenuEntry entry : menuEntries) {
                String option = Text.removeTags((String)entry.getOption()).toLowerCase();
                this.optionIndexes.put((Object)option, (Object)idx++);
            }
            idx = 0;
            for (MenuEntry entry : menuEntries) {
                this.swapMenuEntry(idx++, entry);
            }
        }
        this.client.setMenuEntries(this.updateMenuEntries(this.client.getMenuEntries()));
    }

    public int getMaxEnhanceCycles() {
        return (int)Math.floor((float)(this.client.getRealSkillLevel(Skill.PRAYER) / 2) + 31.0f);
    }

    public int getEnhanceRegenRate() {
        return (int)Math.floor(500.0f / (float)this.getMaxEnhanceCycles());
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        boolean bl = this.inRaid = this.client.getVarbitValue(5432) == 1;
        if (this.inRaid) {
            if (this.client.getVarbitValue(5417) > 0 && this.totalEnhCycles == 0 || this.client.getVarbitValue(5417) != this.totalEnhCycles) {
                this.maxEnhCycles = this.getMaxEnhanceCycles();
                this.enhRegenRate = this.getEnhanceRegenRate();
                this.totalEnhCycles = this.client.getVarbitValue(5417);
                this.enhanceTicks = this.client.getVarbitValue(5417) * this.getEnhanceRegenRate();
                this.addInfobox("Enhance");
                this.sendPotStatusInfo(this.enhanceTicks, "ENH");
            } else if (this.client.getVarbitValue(5418) > 0 && this.totalOvlCycles == 0 || this.client.getVarbitValue(5418) != this.totalOvlCycles) {
                this.totalOvlCycles = this.client.getVarbitValue(5418);
                this.overloadTicks = this.client.getVarbitValue(5418) * 25;
                this.sendPotStatusInfo(this.overloadTicks, "OVL");
            } else if (this.client.getVarpValue(1683) == 7555) {
                this.meleeHandHp = this.client.getVarbitValue(6099);
            } else if (this.client.getVarpValue(1683) == 7553) {
                this.mageHandHp = this.client.getVarbitValue(6099);
            }
        } else {
            this.playersInParty.clear();
            this.meleeHand = null;
            this.mageHand = null;
            this.meleeHandHp = 600;
            this.mageHandHp = 600;
            this.mageHandLastRatio = 100;
            this.mageHandLastHealthScale = 100;
            this.meleeHandLastRatio = 100;
            this.meleeHandLastHealthScale = 100;
            this.smallMuttaAlive = false;
            this.lastRatio = 100;
            this.lastHealthScale = 100;
            this.smallMutta = null;
            this.coxHerb1 = null;
            this.coxHerbTimer1 = 16;
            this.coxHerb2 = null;
            this.coxHerbTimer2 = 16;
            this.totalBuchus = 0;
            this.totalGolpar = 0;
            this.totalNox = 0;
            this.inventoryBuchus = 0;
            this.inventoryGolpar = 0;
            this.inventoryNox = 0;
            this.totalBrews = 0;
            this.totalRevites = 0;
            this.totalEnhances = 0;
            this.totalElders = 0;
            this.totalTwisteds = 0;
            this.totalKodais = 0;
            this.totalOverloads = 0;
            this.inventoryBrews = 0;
            this.inventoryRevites = 0;
            this.inventoryEnhances = 0;
            this.inventoryElders = 0;
            this.inventoryTwisteds = 0;
            this.inventoryKodais = 0;
            this.inventoryOverloads = 0;
            this.pickedJuice = 0;
            this.pickedShrooms = 0;
            this.pickedCicely = 0;
            this.pickedHerb = false;
            this.potMade = false;
            this.totalGrubs = 0;
            this.previousGrubs = 0;
            this.inThieving = false;
            this.inPrep = false;
            if (this.grubsInfobox != null) {
                this.infoBoxManager.removeInfoBox((InfoBox)this.grubsInfobox);
                this.grubsInfobox = null;
            }
            this.inVangs = false;
            this.meleeFound = false;
            this.rangerFound = false;
            this.magerFound = false;
            this.iceDemon = null;
            this.iceDemonActive = false;
            this.overloadsDropped = 0;
            this.enhanceSipped = false;
            this.enhanceTicks = -1;
            this.totalEnhCycles = 0;
            this.maxEnhCycles = 0;
            this.enhRegenRate = 0;
            if (this.enhanceInfobox != null) {
                this.infoBoxManager.removeInfoBox((InfoBox)this.enhanceInfobox);
                this.enhanceInfobox = null;
            }
        }
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        if (this.inRaid) {
            Projectile p = projectileMoved.getProjectile();
            if (this.config.replaceOrbs() && this.orbIDs.contains(p.getId())) {
                int newID = -1;
                switch (p.getId()) {
                    case 1341: {
                        newID = 2208;
                        break;
                    }
                    case 1343: {
                        newID = 2206;
                        break;
                    }
                    case 1345: {
                        newID = 2204;
                    }
                }
                if (newID != -1) {
                    Projectile orb = this.client.createProjectile(newID, p.getFloor(), p.getX1(), p.getY1(), p.getHeight(), p.getStartCycle(), p.getEndCycle(), p.getSlope(), p.getStartHeight(), p.getEndHeight(), p.getInteracting(), p.getTarget().getX(), p.getTarget().getY());
                    this.client.getProjectiles().addLast((Object)orb);
                    p.setEndCycle(0);
                }
            }
        }
    }

    private void swap(String optionA, String optionB, String target, int index) {
        this.swap(optionA, optionB, target, index, true);
    }

    private void swapContains(String optionA, String optionB, String target, int index) {
        this.swap(optionA, optionB, target, index, false);
    }

    private void swap(String optionA, String optionB, String target, int index, boolean strict) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int thisIndex = this.findIndex(menuEntries, index, optionB, target, strict);
        int optionIdx = target.contains("*") ? this.findIndex(menuEntries, thisIndex, optionA, target.replace("*", ""), strict) : this.findIndex(menuEntries, thisIndex, optionA, target, strict);
        if (thisIndex >= 0 && optionIdx >= 0) {
            this.swap(this.optionIndexes, menuEntries, optionIdx, thisIndex);
        }
    }

    private int findIndex(MenuEntry[] entries, int limit, String option, String target, boolean strict) {
        if (strict) {
            List indexes = this.optionIndexes.get((Object)option);
            for (int i = indexes.size() - 1; i >= 0; --i) {
                int idx = (Integer)indexes.get(i);
                MenuEntry entry = entries[idx];
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (idx > limit || !entryTarget.equals(target)) continue;
                return idx;
            }
        } else {
            for (int i = limit; i >= 0; --i) {
                MenuEntry entry = entries[i];
                String entryOption = Text.removeTags((String)entry.getOption()).toLowerCase();
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (!entryOption.contains(option.toLowerCase()) || !entryTarget.equals(target)) continue;
                return i;
            }
        }
        return -1;
    }

    private void swap(ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int index1, int index2) {
        MenuEntry entry2;
        MenuEntry entry1 = entries[index1];
        entries[index1] = entry2 = entries[index2];
        entries[index2] = entry1;
        if (entry1.isItemOp() && entry1.getType() == MenuAction.CC_OP_LOW_PRIORITY) {
            entry1.setType(MenuAction.CC_OP);
        }
        if (entry2.isItemOp() && entry2.getType() == MenuAction.CC_OP_LOW_PRIORITY) {
            entry2.setType(MenuAction.CC_OP);
        }
        this.client.setMenuEntries(entries);
        optionIndexes.clear();
        int idx = 0;
        for (MenuEntry menuEntry : entries) {
            String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
            optionIndexes.put((Object)option, (Object)idx++);
        }
    }

    private MenuEntry[] updateMenuEntries(MenuEntry[] menuEntries) {
        return (MenuEntry[])Arrays.stream(menuEntries).filter(this.filterMenuEntries).sorted((o1, o2) -> 0).toArray(MenuEntry[]::new);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.config.hotkey().matches(e)) {
            this.hotkeyHeld = true;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.config.hotkey().matches(e)) {
            this.hotkeyHeld = false;
        }
    }

    public void addInfobox(String infobox) {
        switch (infobox) {
            case "Enhance": {
                this.enhanceSipped = true;
                if (this.enhanceInfobox != null || this.config.detailedPrayerEnhance() == CoxAdditionsConfig.enhanceMode.OFF) break;
                this.enhanceInfobox = new EnhanceInfobox(this.client, this, this.config);
                int img = 20972;
                this.enhanceInfobox.setImage((BufferedImage)this.itemManager.getImage(img));
                this.infoBoxManager.addInfoBox((InfoBox)this.enhanceInfobox);
                break;
            }
            case "Grubs": {
                if (this.grubsInfobox != null || this.config.grubsInfobox() == CoxAdditionsConfig.grubsMode.OFF || (this.config.grubsInfobox() != CoxAdditionsConfig.grubsMode.THIEVING || !this.inThieving) && (this.config.grubsInfobox() != CoxAdditionsConfig.grubsMode.BOTH || !this.inThieving && !this.inPrep)) break;
                this.grubsInfobox = new GrubsInfobox(this.client, this, this.config);
                int img = 20885;
                this.grubsInfobox.setImage((BufferedImage)this.itemManager.getImage(img));
                this.infoBoxManager.addInfoBox((InfoBox)this.grubsInfobox);
            }
        }
    }

    public void removeInfobox(String infobox) {
        switch (infobox) {
            case "Enhance": {
                this.totalEnhCycles = 0;
                this.enhanceSipped = false;
                this.infoBoxManager.removeInfoBox((InfoBox)this.enhanceInfobox);
                this.enhanceInfobox = null;
                break;
            }
            case "Grubs": {
                this.infoBoxManager.removeInfoBox((InfoBox)this.grubsInfobox);
                this.grubsInfobox = null;
            }
        }
    }

    private InstanceTemplates getCurrentRoom(int x, int y, int z) {
        if (this.client.getGameState() == GameState.LOGGED_IN && this.inRaid) {
            int chunkData = this.client.getInstanceTemplateChunks()[z][x / 8][y / 8];
            return InstanceTemplates.findMatch((int)chunkData);
        }
        return null;
    }

    public InstanceTemplates room() {
        return this.getCurrentRoom(this.client.getLocalPlayer().getLocalLocation().getSceneX(), this.client.getLocalPlayer().getLocalLocation().getSceneY(), this.client.getPlane());
    }

    public void loadFont(boolean overlay) {
        if (overlay) {
            switch (this.config.overlayFontType()) {
                case SMALL: {
                    this.overlayFont = FontManager.getRunescapeSmallFont();
                    break;
                }
                case REGULAR: {
                    this.overlayFont = FontManager.getRunescapeFont();
                    break;
                }
                case BOLD: {
                    this.overlayFont = FontManager.getRunescapeBoldFont();
                    break;
                }
                case CUSTOM: {
                    if (this.config.overlayFontName().equals("")) break;
                    this.overlayFont = new Font(this.config.overlayFontName(), this.config.overlayFontWeight().getWeight(), this.config.overlayFontSize());
                }
            }
        } else {
            switch (this.config.panelFontType()) {
                case SMALL: {
                    this.panelFont = FontManager.getRunescapeSmallFont();
                    break;
                }
                case REGULAR: {
                    this.panelFont = FontManager.getRunescapeFont();
                    break;
                }
                case BOLD: {
                    this.panelFont = FontManager.getRunescapeBoldFont();
                    break;
                }
                case CUSTOM: {
                    if (this.config.panelFontName().equals("")) break;
                    this.panelFont = new Font(this.config.panelFontName(), this.config.panelFontWeight().getWeight(), this.config.panelFontSize());
                }
            }
        }
    }

    public ArrayListMultimap<String, Integer> getOptionIndexes() {
        return this.optionIndexes;
    }

    public GameObject getCoxHerb1() {
        return this.coxHerb1;
    }

    public int getCoxHerbTimer1() {
        return this.coxHerbTimer1;
    }

    public GameObject getCoxHerb2() {
        return this.coxHerb2;
    }

    public int getCoxHerbTimer2() {
        return this.coxHerbTimer2;
    }

    public int getTotalBuchus() {
        return this.totalBuchus;
    }

    public int getTotalGolpar() {
        return this.totalGolpar;
    }

    public int getTotalNox() {
        return this.totalNox;
    }

    public int getInventoryBuchus() {
        return this.inventoryBuchus;
    }

    public int getInventoryGolpar() {
        return this.inventoryGolpar;
    }

    public int getInventoryNox() {
        return this.inventoryNox;
    }

    public int getTotalBrews() {
        return this.totalBrews;
    }

    public int getTotalRevites() {
        return this.totalRevites;
    }

    public int getTotalEnhances() {
        return this.totalEnhances;
    }

    public int getTotalElders() {
        return this.totalElders;
    }

    public int getTotalTwisteds() {
        return this.totalTwisteds;
    }

    public int getTotalKodais() {
        return this.totalKodais;
    }

    public int getTotalOverloads() {
        return this.totalOverloads;
    }

    public int getInventoryBrews() {
        return this.inventoryBrews;
    }

    public int getInventoryRevites() {
        return this.inventoryRevites;
    }

    public int getInventoryEnhances() {
        return this.inventoryEnhances;
    }

    public int getInventoryElders() {
        return this.inventoryElders;
    }

    public int getInventoryTwisteds() {
        return this.inventoryTwisteds;
    }

    public int getInventoryKodais() {
        return this.inventoryKodais;
    }

    public int getInventoryOverloads() {
        return this.inventoryOverloads;
    }

    public int getPickedJuice() {
        return this.pickedJuice;
    }

    public int getPickedShrooms() {
        return this.pickedShrooms;
    }

    public int getPickedCicely() {
        return this.pickedCicely;
    }

    public boolean isPickedHerb() {
        return this.pickedHerb;
    }

    public boolean isPotMade() {
        return this.potMade;
    }

    public int getTotalGrubs() {
        return this.totalGrubs;
    }

    public int getPreviousGrubs() {
        return this.previousGrubs;
    }

    public boolean isInThieving() {
        return this.inThieving;
    }

    public boolean isInPrep() {
        return this.inPrep;
    }

    public GrubsInfobox getGrubsInfobox() {
        return this.grubsInfobox;
    }

    public boolean isEnhanceSipped() {
        return this.enhanceSipped;
    }

    public int getEnhanceTicks() {
        return this.enhanceTicks;
    }

    public int getTotalEnhCycles() {
        return this.totalEnhCycles;
    }

    public int getMaxEnhCycles() {
        return this.maxEnhCycles;
    }

    public int getEnhRegenRate() {
        return this.enhRegenRate;
    }

    public int getEnhVar() {
        return this.enhVar;
    }

    public EnhanceInfobox getEnhanceInfobox() {
        return this.enhanceInfobox;
    }

    public int getOverloadTicks() {
        return this.overloadTicks;
    }

    public int getTotalOvlCycles() {
        return this.totalOvlCycles;
    }

    public int getOvlVar() {
        return this.ovlVar;
    }

    public ArrayList<RaidsPlayers> getPlayersInParty() {
        return this.playersInParty;
    }

    public int getInstanceTimer() {
        return this.instanceTimer;
    }

    public boolean isInstanceTimerRunning() {
        return this.isInstanceTimerRunning;
    }

    public LocalPoint getOlmTile() {
        return this.olmTile;
    }

    public String getOlmPhase() {
        return this.olmPhase;
    }

    public NPC getOlmHead() {
        return this.olmHead;
    }

    public boolean isOlmSpawned() {
        return this.olmSpawned;
    }

    public NPC getMeleeHand() {
        return this.meleeHand;
    }

    public NPC getMageHand() {
        return this.mageHand;
    }

    public int getMeleeHandHp() {
        return this.meleeHandHp;
    }

    public int getMageHandHp() {
        return this.mageHandHp;
    }

    public int getMageHandLastRatio() {
        return this.mageHandLastRatio;
    }

    public void setMageHandLastRatio(int mageHandLastRatio) {
        this.mageHandLastRatio = mageHandLastRatio;
    }

    public int getMageHandLastHealthScale() {
        return this.mageHandLastHealthScale;
    }

    public void setMageHandLastHealthScale(int mageHandLastHealthScale) {
        this.mageHandLastHealthScale = mageHandLastHealthScale;
    }

    public int getMeleeHandLastRatio() {
        return this.meleeHandLastRatio;
    }

    public void setMeleeHandLastRatio(int meleeHandLastRatio) {
        this.meleeHandLastRatio = meleeHandLastRatio;
    }

    public int getMeleeHandLastHealthScale() {
        return this.meleeHandLastHealthScale;
    }

    public void setMeleeHandLastHealthScale(int meleeHandLastHealthScale) {
        this.meleeHandLastHealthScale = meleeHandLastHealthScale;
    }

    public Set<Integer> getOrbIDs() {
        return this.orbIDs;
    }

    public boolean isSmallMuttaAlive() {
        return this.smallMuttaAlive;
    }

    public NPC getSmallMutta() {
        return this.smallMutta;
    }

    public int getLastRatio() {
        return this.lastRatio;
    }

    public void setLastRatio(int lastRatio) {
        this.lastRatio = lastRatio;
    }

    public int getLastHealthScale() {
        return this.lastHealthScale;
    }

    public void setLastHealthScale(int lastHealthScale) {
        this.lastHealthScale = lastHealthScale;
    }

    public List<String> getTlList() {
        return this.tlList;
    }

    public List<String> getBossList() {
        return this.bossList;
    }

    public int getMAGE() {
        return this.MAGE;
    }

    public int getRANGE() {
        return this.RANGE;
    }

    public int getMELEE() {
        return this.MELEE;
    }

    public int getDOWN() {
        return this.DOWN;
    }

    public ArrayList<Integer> getIds() {
        return this.ids;
    }

    public NPC getRanger() {
        return this.ranger;
    }

    public NPC getMager() {
        return this.mager;
    }

    public NPC getMeleer() {
        return this.meleer;
    }

    public boolean isInRaid() {
        return this.inRaid;
    }

    public boolean isMagerFound() {
        return this.magerFound;
    }

    public boolean isRangerFound() {
        return this.rangerFound;
    }

    public boolean isMeleeFound() {
        return this.meleeFound;
    }

    public int getMageHP() {
        return this.mageHP;
    }

    public int getRangeHP() {
        return this.rangeHP;
    }

    public int getMeleeHP() {
        return this.meleeHP;
    }

    public float getPercent() {
        return this.percent;
    }

    public boolean isInVangs() {
        return this.inVangs;
    }

    public int getOverloadsDropped() {
        return this.overloadsDropped;
    }

    public NPC getIceDemon() {
        return this.iceDemon;
    }

    public boolean isIceDemonActive() {
        return this.iceDemonActive;
    }

    public ArrayList<String> getChestHighlightIdList() {
        return this.chestHighlightIdList;
    }

    public ArrayList<String> getChestHighlightIdList2() {
        return this.chestHighlightIdList2;
    }

    public boolean isHotkeyHeld() {
        return this.hotkeyHeld;
    }

    public Font getOverlayFont() {
        return this.overlayFont;
    }

    public Font getPanelFont() {
        return this.panelFont;
    }
}

