/*
 * Decompiled with CFR 0.152.
 */
package com.coxadditions;

import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.Range;

@ConfigGroup(value="CoxAdditions")
public interface CoxAdditionsConfig
extends Config {
    @ConfigSection(name="Olm", description="Olm Plugins", position=0, closedByDefault=true)
    public static final String olmSection = "olm";
    @ConfigSection(name="Rooms", description="Cox Room Options", position=1, closedByDefault=true)
    public static final String roomSection = "rooms";
    @ConfigSection(name="Prep", description="Cox Prep Options", position=2, closedByDefault=true)
    public static final String prepSection = "prep";
    @ConfigSection(name="Font", description="Font Options", position=3, closedByDefault=true)
    public static final String fontSection = "font";

    @ConfigItem(name="Olm Side Highlight", keyName="olmSide", description="Highlights a tile indicating which side olm will spawn on - disappears when he pops up", position=0, section="olm")
    default public olmSideMode olmSide() {
        return olmSideMode.CENTER_TILE;
    }

    @ConfigItem(name="Olm Side Color Mode", keyName="olmSideColorMode", description="Color = Olm Side Color, Phase = Color of the Olm phase (final phase is Olm Side Color)", position=1, section="olm")
    default public olmSideColorMode olmSideColorMode() {
        return olmSideColorMode.COLOR;
    }

    @Alpha
    @ConfigItem(name="Olm Side Color", keyName="olmSideColor", description="Configures the color of the Olm side highlight", position=2, section="olm")
    default public Color olmSideColor() {
        return Color.RED;
    }

    @ConfigItem(name="Olm Hands Health", keyName="olmHandsHealth", description="Puts an overlay on Olm's hands showing their current HP", position=3, section="olm")
    default public olmHandsHealthMode olmHandsHealth() {
        return olmHandsHealthMode.OFF;
    }

    @ConfigItem(name="Replace Olm Orbs", keyName="replaceOrbs", description="Replaces Olm orbs with Warden attacks.", position=4, section="olm")
    default public boolean replaceOrbs() {
        return false;
    }

    @ConfigItem(name="\u2014\u2014\u2014\u2014\u2014\u2014 Phase \u2014\u2014\u2014\u2014\u2014\u2014", keyName="olm divider", description="", position=5, section="olm")
    public void olmDivider();

    @ConfigItem(name="Olm Phase Highlight", keyName="olmPhaseHighlight", description="Highlights Olm head the color of the phase indicated in the chat box (Red = Flame, Green = Acid, Purple = Crystal)", position=6, section="olm")
    default public boolean olmPhaseHighlight() {
        return false;
    }

    @ConfigItem(name="Show Phase Panel", keyName="olmPhasePanel", description="Displays Olm phase in an infobox", position=7, section="olm")
    default public boolean olmPhasePanel() {
        return false;
    }

    @Alpha
    @ConfigItem(name="Final Phase Color", keyName="olmHighlightColor", description="Configures the color of the Olm phase highlight", position=8, section="olm")
    default public Color olmHighlightColor() {
        return Color.CYAN;
    }

    @Range(max=255)
    @ConfigItem(name="Olm Phase Fill Opacity", keyName="olmHighlightFill", description="Highlight fill opacity for Olm phase highlight", position=9, section="olm")
    default public int olmHighlightFill() {
        return 30;
    }

    @Range(min=1, max=5)
    @ConfigItem(name="Olm Outline Width", keyName="olmThiCC", description="Outline width for Olm phase highlight", position=10, section="olm")
    default public double olmWidth() {
        return 2.0;
    }

    @ConfigItem(name="Olm Line Type", keyName="olmLines", description="Sets the tile outline to regular, dashed, or corners only for Olm", position=11, section="olm")
    default public lineType olmLines() {
        return lineType.REG;
    }

    @ConfigItem(name="Instance Timer", keyName="instanceTimer", description="Instance timer for starting a raid.", position=0, section="rooms")
    default public instanceTimerMode instanceTimer() {
        return instanceTimerMode.OVERHEAD;
    }

    @ConfigItem(name="Left Click Leave CC", keyName="leftClickLeave", description="Left click leave corp simulator", position=1, section="rooms")
    default public boolean leftClickLeave() {
        return false;
    }

    @ConfigItem(name="CC Warning", keyName="ccWarning", description="Highlights the entrance to CoX. Red = not in a CC, Yellow = in a CC, but no party made.", position=2, section="rooms")
    default public boolean ccWarning() {
        return false;
    }

    @ConfigItem(name="Hotkey", keyName="hotkey", description="Configures the hotkey used for hotkey configs in Cox Additions", position=3, section="rooms")
    default public Keybind hotkey() {
        return new Keybind(17, 128);
    }

    @ConfigItem(name="Hotkey Swap Private Chest", keyName="hotkeySwapBank", description="Switches your CoX chest from shared to private when holding the hotkey", position=4, section="rooms")
    default public boolean hotkeySwapBank() {
        return false;
    }

    @ConfigItem(name="Prayer Enh. Timer", keyName="detailedPrayerEnhance", description="Displays a detailed prayer enhance timer in CoX", position=5, section="rooms")
    default public enhanceMode detailedPrayerEnhance() {
        return enhanceMode.OFF;
    }

    @ConfigItem(name="Raids Pots Status Overlay", keyName="raidsPotsStatusOverlay", description="Displays how many overload and enhance ticks each player has left. Must be in party to see other players", position=6, section="rooms")
    default public boolean raidsPotsStatusOverlay() {
        return false;
    }

    @ConfigItem(name="Pots Height", keyName="raidsPotsHeight", description="The height at which to display the Raids Pots Status Overlay", position=7, section="rooms")
    default public RaidsPotsLoc raidsPotsHeight() {
        return RaidsPotsLoc.CENTER;
    }

    @ConfigItem(name="Raids Pots Icon Size", keyName="raidsPotsIconSize", description="Changes the size of the raids pots icon", position=8, section="rooms")
    default public int raidsPotsIconSize() {
        return 15;
    }

    @ConfigItem(name="Anti-Aliasing", keyName="antiAlias", description="Turns on anti-aliasing for all overlays. Makes them smoother.", position=9, section="rooms")
    default public boolean antiAlias() {
        return true;
    }

    @ConfigItem(name="\u2014\u2014\u2014\u2014\u2014\u2014 True Tile \u2014\u2014\u2014\u2014\u2014\u2014", keyName="room divider", description="", position=10, section="rooms")
    public void roomDivider();

    @ConfigItem(name="True Location List", keyName="tlList", description="NPC's in this list will be highlighted with true location. ONLY works with Cox bosses", position=11, section="rooms")
    default public String tlList() {
        return "";
    }

    @Range(min=1, max=5)
    @ConfigItem(name="True Location Width", keyName="tlThiCC", description="Outline width for true location highlight", position=12, section="rooms")
    default public double tlThiCC() {
        return 2.0;
    }

    @Alpha
    @ConfigItem(name="True Location Color", keyName="tlColor", description="Highlight color for true location", position=13, section="rooms")
    default public Color tlColor() {
        return new Color(207, 138, 253, 255);
    }

    @Alpha
    @ConfigItem(name="True Location Fill Color", keyName="tlFillColor", description="Fill color for true location", position=14, section="rooms")
    default public Color tlFillColor() {
        return new Color(207, 138, 253, 30);
    }

    @ConfigItem(name="True Tile Line Type", keyName="tileLines", description="Sets the true tile outline to regular, dashed, or corners only", position=15, section="rooms")
    default public lineType tileLines() {
        return lineType.REG;
    }

    @ConfigItem(name="\u2014\u2014\u2014\u2014\u2014\u2014 Puzzle Rooms \u2014\u2014\u2014\u2014\u2014\u2014", keyName="puzzle divider", description="", position=16, section="rooms")
    public void puzzleDivider();

    @ConfigItem(keyName="chestGroupsHighlight", name="Highlight Grub Chests", description="CoX CM ONLY - Highlights groups of 4 chests", position=17, section="rooms")
    default public Set<HighlightChestGroups> chestGroupsHighlight() {
        return Collections.emptySet();
    }

    @ConfigItem(keyName="chestGroupsHighlightStyle", name="Chest Highlight Style", description="Selects the highlight style for 'Highlight Grub Chests'", position=18, section="rooms")
    default public GrubChestStyle chestGroupsHighlightStyle() {
        return GrubChestStyle.HULL;
    }

    @ConfigItem(keyName="grubsInfobox", name="Grubs Counter", description="Displays an infobox showing the total amount of cavern grubs collected. Works with party", position=19, section="rooms")
    default public grubsMode grubsInfobox() {
        return grubsMode.OFF;
    }

    @ConfigItem(keyName="grubsAmount", name="Grubs Amount", description="Set to the amount of grubs you/your team want to collect. The cavern grub counter's text will turn green when this number is reached.", position=20, section="rooms")
    default public int grubsAmount() {
        return 30;
    }

    @ConfigItem(name="Hotkey Swap Smash", keyName="hotkeySwapSmash", description="Switches attack and smash when holding the hotkey", position=21, section="rooms")
    default public boolean hotkeySwapSmash() {
        return false;
    }

    @ConfigItem(keyName="iceDemonHp", name="Ice Demon HP", description="Displays Ice Demon HP percent while lighting kindling", position=22, section="rooms")
    default public boolean iceDemonHp() {
        return true;
    }

    @ConfigItem(keyName="swapCoXKeystone", name="Left Click Drop Keystone", description="swaps use with drop for the keystone crystal at tightrope", position=23, section="rooms")
    default public boolean swapCoXKeystone() {
        return false;
    }

    @ConfigItem(name="\u2014\u2014\u2014\u2014\u2014\u2014 Combat Rooms \u2014\u2014\u2014\u2014\u2014\u2014", keyName="combat divider", description="", position=24, section="rooms")
    public void combatDivider();

    @ConfigItem(name="Small Muttadile HP", keyName="smallMuttaHp", description="Displays the health percentage of small Muttadile while meat tree is alive", position=25, section="rooms")
    default public boolean smallMuttaHp() {
        return true;
    }

    @ConfigItem(name="Vanguard HP Infobox", keyName="vangInfobox", description="Displays the hp left on each vanguard", position=26, section="rooms")
    default public boolean vangInfobox() {
        return true;
    }

    @ConfigItem(keyName="showPanel", name="Vanguard Overloads Overlay", description="Shows how many Overloads have been received from Vanguards. Works with party.", position=27, section="rooms")
    default public boolean showPanel() {
        return true;
    }

    @ConfigItem(keyName="overloadChatMessage", name="Overload Dropped Chat Message", description="Prints a chat message when a player receives an Overload from Vanguards. Works with party.", position=28, section="rooms")
    default public boolean overloadChatMessage() {
        return true;
    }

    @ConfigItem(name="CoX Herb Timer", keyName="coxHerbTimer", description="Displays a timer for herb growth", position=1, section="prep")
    default public CoXHerbTimerMode coxHerbTimer() {
        return CoXHerbTimerMode.OFF;
    }

    @Alpha
    @ConfigItem(name="CoX Herb Timer Color", keyName="coxHerbTimerColor", description="Sets color of CoX herb timer", position=2, section="prep")
    default public Color coxHerbTimerColor() {
        return Color.YELLOW;
    }

    @Range(min=10, max=30)
    @ConfigItem(name="CoX Herb Timer Size", keyName="coxHerbTimerSize", description="Sets the size of the CoX herb timer", position=3, section="prep")
    default public int coxHerbTimerSize() {
        return 20;
    }

    @ConfigItem(name="\u2014\u2014\u2014\u2014\u2014\u2014 Prep \u2014\u2014\u2014\u2014\u2014\u2014", keyName="prep divider", description="", position=4, section="prep")
    public void prepDivider();

    @Range(min=0)
    @ConfigItem(keyName="brews", name="Xeric's Aids", description="How many Xeric's Aids your team wants to make", position=5, section="prep")
    default public int brews() {
        return 0;
    }

    @Range(min=0)
    @ConfigItem(keyName="revites", name="Revites", description="How many Revites your team wants to make", position=6, section="prep")
    default public int revites() {
        return 0;
    }

    @Range(min=0)
    @ConfigItem(keyName="enhances", name="Prayer Enhances", description="How many Prayer Enhances your team wants to make", position=7, section="prep")
    default public int enhances() {
        return 0;
    }

    @Range(min=0)
    @ConfigItem(keyName="overloads", name="Overloads", description="How many Overloads your team wants to make", position=8, section="prep")
    default public int overloads() {
        return 0;
    }

    @Range(min=0)
    @ConfigItem(keyName="extraNox", name="Extra Nox", description="How many extra Noxifer you want to pick", position=9, section="prep")
    default public int extraNox() {
        return 0;
    }

    @ConfigItem(keyName="showSecondaries", name="Show Secondaries", description="Toggle whether or not to show secondaries overlay in scavs", position=10, section="prep")
    default public boolean showSecondaries() {
        return false;
    }

    @ConfigItem(keyName="showPots", name="Show Pots Made", description="Toggle whether or not to show how many pots you have made in prep", position=11, section="prep")
    default public boolean showPots() {
        return false;
    }

    @ConfigItem(name="\u2014\u2014\u2014\u2014\u2014\u2014 Chest \u2014\u2014\u2014\u2014\u2014\u2014", keyName="chest divider", description="", position=12, section="prep")
    public void bankDivider();

    @ConfigItem(name="Highlight Chest Mode", keyName="highlightChest", description="Highlight items in your private chest based off the lists", position=13, section="prep")
    default public HighlightChestMode highlightChest() {
        return HighlightChestMode.OFF;
    }

    @ConfigItem(name="Highlight Private Chest Items 1", keyName="highlightChestItems", description="Highlights items in the list in the storage chest. Can be names or ids.", position=14, section="prep")
    default public String highlightChestItems() {
        return "";
    }

    @Alpha
    @ConfigItem(name="Chest Items Color 1", keyName="highlightChestItemsColor", description="Sets color of highlight chest items", position=15, section="prep")
    default public Color highlightChestItemsColor() {
        return Color.WHITE;
    }

    @ConfigItem(name="Highlight Private Chest Items 2", keyName="highlightChestItems2", description="Highlights items in the list in the storage chest. Can be names or ids.", position=16, section="prep")
    default public String highlightChestItems2() {
        return "";
    }

    @Alpha
    @ConfigItem(name="Chest Items Color 2", keyName="highlightChestItemsColor2", description="Sets color of highlight chest items", position=17, section="prep")
    default public Color highlightChestItemsColor2() {
        return Color.WHITE;
    }

    @ConfigItem(name="Overlay Font Type", keyName="overlayFontType", description="", position=0, section="font")
    default public FontType overlayFontType() {
        return FontType.BOLD;
    }

    @ConfigItem(name="Overlay Font Name", keyName="overlayFontName", description="Custom font override for overlays", position=1, section="font")
    default public String overlayFontName() {
        return "";
    }

    @ConfigItem(name="Overlay Font Size", keyName="overlayFontSize", description="", position=2, section="font")
    default public int overlayFontSize() {
        return 11;
    }

    @ConfigItem(name="Overlay Font Weight", keyName="overlayFontWeight", description="Sets the custom font weight for overlays", position=3, section="font")
    default public FontWeight overlayFontWeight() {
        return FontWeight.PLAIN;
    }

    @ConfigItem(name="Overlay Font Background", keyName="overlayFontBackground", description="Puts an outline, shadow, or nothing behind font overlays", position=4, section="font")
    default public background overlayFontBackground() {
        return background.SHADOW;
    }

    @ConfigItem(name="\u2014\u2014\u2014\u2014\u2014\u2014 Panel \u2014\u2014\u2014\u2014\u2014\u2014", keyName="panel divider", description="", position=5, section="font")
    public void panelDivider();

    @ConfigItem(name="Panel Font Type", keyName="panelFontType", description="", position=6, section="font")
    default public FontType panelFontType() {
        return FontType.REGULAR;
    }

    @ConfigItem(name="Panel Font Name", keyName="panelFontName", description="Custom font override for panels/infoboxes", position=7, section="font")
    default public String panelFontName() {
        return "";
    }

    @ConfigItem(name="Panel Font Size", keyName="panelFontSize", description="", position=8, section="font")
    default public int panelFontSize() {
        return 11;
    }

    @ConfigItem(name="Panel Font Weight", keyName="panelFontWeight", description="Sets the custom font weight for panels/infoboxes", position=9, section="font")
    default public FontWeight panelFontWeight() {
        return FontWeight.PLAIN;
    }

    public static enum background {
        OFF("None"),
        SHADOW("Shadow"),
        OUTLINE("Outline");

        private final String group;

        public String toString() {
            return this.group;
        }

        private background(String group) {
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }
    }

    public static enum FontWeight {
        PLAIN(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        private final int weight;

        private FontWeight(int i) {
            this.weight = i;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    public static enum FontType {
        SMALL("RS Small"),
        REGULAR("RS Regular"),
        BOLD("RS Bold"),
        CUSTOM("Custom");

        private final String name;

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        private FontType(String name) {
            this.name = name;
        }
    }

    public static enum RaidsPotsLoc {
        PRAYER("Above Prayer Icon"),
        HEAD("Head of Player"),
        CENTER("Center of Player"),
        FEET("Bottom of Player");

        private final String location;

        public String toString() {
            return this.location;
        }

        private RaidsPotsLoc(String location) {
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }
    }

    public static enum lineType {
        REG("Regular"),
        DASH("Dashed"),
        CORNER("Corners");

        private final String group;

        public String toString() {
            return this.group;
        }

        private lineType(String group) {
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }
    }

    public static enum grubsMode {
        OFF("Off"),
        THIEVING("Thieving"),
        BOTH("Thieving/Prep");

        private final String name;

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        private grubsMode(String name) {
            this.name = name;
        }
    }

    public static enum HighlightChestGroups {
        CHEST_GROUPS_1("Groups 1-4"),
        CHEST_GROUPS_2("Groups 5-7"),
        CHEST_GROUPS_3("Groups 8-10");

        private final String group;

        public String toString() {
            return this.group;
        }

        private HighlightChestGroups(String group) {
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }
    }

    public static enum GrubChestStyle {
        HULL,
        OUTLINE,
        TILE,
        CLICKBOX,
        CORNERS;

    }

    public static enum olmHandsHealthMode {
        OFF,
        INFOBOX,
        OVERLAY;

    }

    public static enum olmSideColorMode {
        COLOR,
        PHASE;

    }

    public static enum olmSideMode {
        OFF,
        CENTER_TILE,
        SIZE;

    }

    public static enum enhanceMode {
        OFF,
        TICKS,
        REGEN_CYCLE;

    }

    public static enum instanceTimerMode {
        OFF,
        OVERHEAD,
        INFOBOX;

    }

    public static enum HighlightChestMode {
        OFF,
        UNDERLINE,
        OUTLINE;

    }

    public static enum CoXHerbTimerMode {
        OFF,
        TEXT,
        PIE;

    }
}

