/*
 * Decompiled with CFR 0.152.
 */
package com.irc.core;

import com.google.common.base.Strings;
import com.irc.core.IrcListener;
import com.irc.core.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.StringConcatFactory;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRCClient
extends Thread
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(IRCClient.class);
    private static final String HOST = "irc.swiftirc.net";
    private static final String ident = "runelite";
    private static final int PORT = 6697;
    private static final int READ_TIMEOUT = 120000;
    private static final int PING_TIMEOUT = 60000;
    private final IrcListener ircListener;
    private String username;
    private final String channel;
    private final String password;
    private final String delimiter;
    private Socket socket;
    private BufferedReader in;
    private Writer out;
    private long last;
    private boolean pingSent;

    public IRCClient(IrcListener ircListener, String username, String channel, String password, String delimiter) {
        this.setName("IRC");
        this.ircListener = ircListener;
        this.username = username;
        this.channel = channel;
        this.password = password;
        this.delimiter = delimiter;
    }

    @Override
    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ex) {
            log.warn("error closing socket", (Throwable)ex);
        }
        this.in = null;
        this.out = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SocketFactory socketFactory = SSLSocketFactory.getDefault();
            this.socket = socketFactory.createSocket(HOST, 6697);
            this.socket.setSoTimeout(120000);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.UTF_8));
            this.out = new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            log.warn("unable to setup irc client", (Throwable)ex);
            return;
        }
        try {
            String line;
            this.register(this.username);
            while ((line = this.read()) != null) {
                log.debug("<- {}", (Object)line);
                if ((line.startsWith(":fiery.ca.us.SwiftIRC.net 001") || line.startsWith(":tardis.en.uk.SwiftIRC.net 001")) && line.contains("Welcome to the SwiftIRC IRC Network")) {
                    if (!Strings.isNullOrEmpty((String)this.password)) {
                        this.nickservID();
                        IRCClient.sleep(500L);
                    }
                    this.join(this.channel);
                } else if (line.split(" ")[1].equals("433")) {
                    this.ircListener.notice(Message.parse(line).getTags(), "Nick already in use. Please choose a new one.");
                }
                this.last = System.currentTimeMillis();
                this.pingSent = false;
                Message message = Message.parse(line);
                switch (message.getCommand()) {
                    case "PING": {
                        this.send("PONG", message.getArguments()[0]);
                        break;
                    }
                    case "PRIVMSG": {
                        this.ircListener.privmsg(message.getTags(), message.getArguments()[1]);
                        break;
                    }
                    case "NOTICE": {
                        this.ircListener.notice(message.getTags(), message.getArguments()[1]);
                        break;
                    }
                    case "ROOMSTATE": {
                        this.ircListener.roomstate(message.getTags());
                        break;
                    }
                    case "USERNOTICE": {
                        this.ircListener.usernotice(message.getTags(), message.getArguments().length > 0 ? message.getArguments()[0] : null);
                        break;
                    }
                    case "NICK": {
                        String nick = message.getArguments()[0];
                        this.ircListener.nick(message.getTags(), nick);
                    }
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            log.debug("error in irc client", (Throwable)ex);
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                log.warn(null, (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public void pingCheck() {
        if (this.out == null) {
            return;
        }
        if (!this.pingSent && System.currentTimeMillis() - this.last >= 60000L) {
            try {
                this.ping("swiftirc");
                this.pingSent = true;
            }
            catch (IOException e) {
                log.debug("Ping failure, disconnecting.", (Throwable)e);
                this.close();
            }
        } else if (this.pingSent) {
            log.debug("Ping timeout, disconnecting.");
            this.close();
        }
    }

    private void register(String username) throws IOException {
        this.send("NICK", username);
        String[] stringArray = new String[4];
        stringArray[0] = ident;
        stringArray[1] = "3";
        stringArray[2] = "*";
        stringArray[3] = username;
        this.send("USER", stringArray);
    }

    private void nickservID() throws IOException {
        this.nickserv("identify " + this.password);
    }

    private void join(String channel) throws IOException {
        this.send("JOIN", channel);
    }

    private void ping(String destination) throws IOException {
        this.send("PING", destination);
    }

    public void privmsg(String message) throws IOException {
        this.send("PRIVMSG", this.channel, message);
    }

    public void actionMsg(String message) throws IOException {
        this.send("PRIVMSG", new String[]{this.channel, StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001\u0002", "\u0001ACTION ", "\u0001"}, (String)message)});
    }

    public void notice(String message) throws IOException {
        this.send(message, new String[0]);
    }

    public void privateMsg(String message) throws IOException {
        String[] split = message.split(" ", 2);
        this.send("PRIVMSG", split[0], split[1]);
    }

    public void nickserv(String message) throws IOException {
        this.send("PRIVMSG", "NickServ", message);
    }

    public void chanserv(String message) throws IOException {
        this.send("PRIVMSG", "ChanServ", message);
    }

    public void botserv(String message) throws IOException {
        this.send("PRIVMSG", "BotServ", message);
    }

    public void hostserv(String message) throws IOException {
        this.send("PRIVMSG", "HostServ", message);
    }

    public void nick(String nick) throws IOException {
        this.send("NICK", nick);
        this.username = nick;
    }

    public void topic(String channel) throws IOException {
        this.send("TOPIC", channel);
    }

    public void umode(String modes) throws IOException {
        this.send("umode2", modes);
    }

    public void mode(String modes) throws IOException {
        this.send("mode", modes);
    }

    private void send(String command, String ... args) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(command);
        for (int i = 0; i < args.length; ++i) {
            stringBuilder.append(' ');
            if (i + 1 == args.length) {
                stringBuilder.append(':');
            }
            stringBuilder.append(args[i]);
        }
        log.debug("-> {}", (Object)stringBuilder.toString());
        stringBuilder.append("\r\n");
        this.out.write(stringBuilder.toString());
        this.out.flush();
    }

    private String read() throws IOException {
        int len;
        String line = this.in.readLine();
        if (line == null) {
            return null;
        }
        for (len = line.length(); len > 0 && (line.charAt(len - 1) == '\r' || line.charAt(len - 1) == '\n'); --len) {
        }
        return line.substring(0, len);
    }

    public String getUsername() {
        return this.username;
    }
}

