/*
 * Decompiled with CFR 0.152.
 */
package com.irc;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import com.irc.IrcConfig;
import com.irc.IrcPanel;
import com.irc.core.IRCClient;
import com.irc.core.IrcListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="IRC", description="Integrates IRC with the OSRS chatbox", enabledByDefault=false)
public class IrcPlugin
extends Plugin
implements IrcListener {
    private static final Logger log = LoggerFactory.getLogger(IrcPlugin.class);
    @Inject
    private IrcConfig ircConfig;
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientToolbar clientToolbar;
    private IrcPanel panel;
    private NavigationButton uiButton;
    private IRCClient IRCClient;

    protected void startUp() {
        this.connect();
        this.startIrcPanel();
    }

    protected void shutDown() {
        if (this.IRCClient != null) {
            this.IRCClient.close();
            this.IRCClient = null;
        }
        this.stopIrcPanel();
    }

    @Provides
    IrcConfig provideConfig(ConfigManager configManager) {
        return (IrcConfig)configManager.getConfig(IrcConfig.class);
    }

    private synchronized void connect() {
        if (this.IRCClient != null) {
            log.debug("Terminating IRC client {}", (Object)this.IRCClient);
            this.IRCClient.close();
            this.IRCClient = null;
        }
        if (!Strings.isNullOrEmpty((String)this.ircConfig.username())) {
            Object channel;
            if (Strings.isNullOrEmpty((String)this.ircConfig.channel())) {
                channel = "#rshelp";
            } else {
                channel = this.ircConfig.channel().toLowerCase();
                if (!((String)channel).startsWith("#")) {
                    channel = "#" + (String)channel;
                }
                if (((String)channel).contains(",")) {
                    channel = ((String)channel).split(",")[0];
                }
            }
            log.debug("Connecting to IRC as {}", (Object)this.ircConfig.username());
            this.IRCClient = new IRCClient(this, this.ircConfig.username(), (String)channel, this.ircConfig.password(), this.ircConfig.delimiter());
            this.IRCClient.start();
        }
    }

    @Schedule(period=30L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void checkClient() {
        if (this.IRCClient != null) {
            if (this.IRCClient.isConnected()) {
                this.IRCClient.pingCheck();
            }
            if (!this.IRCClient.isConnected()) {
                log.debug("Reconnecting...");
                this.connect();
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("irc")) {
            return;
        }
        this.connect();
    }

    private void addChatMessage(String sender, String message) {
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(message).build();
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHAT).sender("IRC").name(sender).runeLiteFormattedMessage(this.stripColors(chatMessage)).timestamp((int)(System.currentTimeMillis() / 1000L)).build());
        }
        IrcPanel.message(this.formatMessage(sender + ": " + message));
    }

    private String stripColors(String message) {
        return message.replaceAll("\u0003([0-9]{1,2})?|\u0015", "");
    }

    private String formatMessage(String message) {
        return StringEscapeUtils.escapeHtml4((String)message).replaceAll("[\u000f\u0003]([^0-9]|$)", "</font>$1").replaceAll("\u000310([^\u0003\u000f]+)", "<font color=\"darkcyan\">$1</font>").replaceAll("\u000311([^\u0003\u000f]+)", "<font color=\"cyan\">$1</font>").replaceAll("\u000312([^\u0003\u000f]+)", "<font color=\"blue\">$1</font>").replaceAll("\u000313([^\u0003\u000f]+)", "<font color=\"pink\">$1</font>").replaceAll("\u000314([^\u0003\u000f]+)", "<font color=\"grey\">$1</font>").replaceAll("\u000315([^\u0003\u000f]+)", "<font color=\"lightgrey`\">$1</font>").replaceAll("\u00030?1([^\u0003\u000f]+)", "<font color=\"black\">$1</font>").replaceAll("\u00030?2([^\u0003\u000f]+)", "<font color=\"darkblue\">$1</font>").replaceAll("\u00030?3([^\u0003\u000f]+)", "<font color=\"green\">$1</font>").replaceAll("\u00030?4([^\u0003\u000f]+)", "<font color=\"red\">$1</font>").replaceAll("\u00030?5([^\u0003\u000f]+)", "<font color=\"brown\">$1</font>").replaceAll("\u00030?6([^\u0003\u000f]+)", "<font color=\"purple\">$1</font>").replaceAll("\u00030?7([^\u0003\u000f]+)", "<font color=\"orange\">$1</font>").replaceAll("\u00030?8([^\u0003\u000f]+)", "<font color=\"yellow\">$1</font>").replaceAll("\u00030?9([^\u0003\u000f]+)", "<font color=\"chartreuse\">$1</font>").replaceAll("\u000300?([^\u0003\u000f]+)", "<font color=\"white\">$1</font>");
    }

    @Override
    public void privmsg(Map<String, String> tags, String message) {
        String displayName = tags.get("display-name");
        if (message.startsWith("\u0001")) {
            message = message.replaceAll("\u0001(ACTION)?", "");
            this.addChatMessage("* " + displayName, message);
        } else {
            this.addChatMessage(displayName, message);
        }
    }

    @Override
    public void notice(Map<String, String> tags, String message) {
        String displayName = "(notice) " + tags.get("display-name");
        this.addChatMessage(displayName, message);
    }

    @Override
    public void roomstate(Map<String, String> tags) {
        log.debug("Room state: {}", tags);
    }

    @Override
    public void usernotice(Map<String, String> tags, String message) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        String sysmsg = tags.get("system-msg");
        this.addChatMessage("[System]", sysmsg);
    }

    @Override
    public void nick(Map<String, String> tags, String nick) {
        this.addChatMessage("* Nick change", tags.get("display-name") + " is now known as " + nick);
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent scriptCallbackEvent) {
        String delimiter;
        if (!"chatDefaultReturn".equals(scriptCallbackEvent.getEventName())) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackCount = this.client.getIntStackSize();
        String message = this.client.getVarcStrValue(335);
        if (message.startsWith((delimiter = this.ircConfig.delimiter()) + delimiter)) {
            if ((message = message.substring(2)).isEmpty() || this.IRCClient == null) {
                return;
            }
            intStack[intStackCount - 3] = 1;
            try {
                if (message.length() > 3) {
                    String trimmed = message.substring(3);
                    if (message.startsWith("ns ")) {
                        this.IRCClient.nickserv(trimmed);
                    } else if (message.startsWith("cs ")) {
                        this.IRCClient.chanserv(trimmed);
                    } else if (message.startsWith("bs ")) {
                        this.IRCClient.botserv(trimmed);
                    } else if (message.startsWith("hs ")) {
                        this.IRCClient.hostserv(trimmed);
                    } else if (message.startsWith("notice ")) {
                        String[] split = message.split(" ", 3);
                        if (split.length > 2) {
                            this.IRCClient.notice(message);
                            this.addChatMessage("(notice) -> " + split[1], split[2]);
                        }
                    } else if (message.startsWith("msg ")) {
                        String msg = trimmed.substring(1);
                        String[] split = msg.split(" ", 2);
                        if (split.length > 1) {
                            this.IRCClient.privateMsg(trimmed.substring(1));
                            this.addChatMessage("(pm) -> " + split[0], split[1]);
                        }
                    } else if (message.startsWith("me ")) {
                        this.IRCClient.actionMsg(trimmed);
                        this.addChatMessage("* " + this.ircConfig.username(), trimmed);
                    } else if (message.startsWith("mode ")) {
                        this.IRCClient.mode(trimmed.substring(2));
                    } else if (message.startsWith("umode ")) {
                        this.IRCClient.umode(trimmed.substring(3));
                    } else if (message.startsWith("topic")) {
                        String channel = trimmed.substring(2);
                        if (channel.length() == 0 || channel == " ") {
                            channel = this.ircConfig.channel();
                        }
                        this.IRCClient.topic(channel);
                    } else if (message.startsWith("nick ")) {
                        this.IRCClient.nick(trimmed.substring(2));
                    } else if (message.startsWith("clear")) {
                        IrcPanel.clearLogs();
                    }
                }
            }
            catch (IOException e) {
                log.warn("failed to send message", (Throwable)e);
            }
            return;
        }
        if (message.startsWith(this.ircConfig.delimiter())) {
            if ((message = message.substring(1)).isEmpty() || this.IRCClient == null) {
                return;
            }
            intStack[intStackCount - 3] = 1;
            try {
                this.IRCClient.privmsg(message);
                this.addChatMessage(this.IRCClient.getUsername(), message);
            }
            catch (IOException e) {
                log.warn("failed to send message", (Throwable)e);
            }
        }
    }

    private void startIrcPanel() {
        BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"icon.png");
        this.panel = (IrcPanel)((Object)this.injector.getInstance(IrcPanel.class));
        this.panel.init();
        this.uiButton = NavigationButton.builder().tooltip("SwiftIRC").icon(icon).priority(10).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.uiButton);
    }

    private void stopIrcPanel() {
        this.panel.removeAll();
        this.clientToolbar.removeNavigation(this.uiButton);
    }
}

