/*
 * Decompiled with CFR 0.152.
 */
package com.foo;

import com.foo.EasyArceuusRunecraftingConfig;
import com.foo.EasyArceuusRunecraftingPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TintOverlay
extends OverlayPanel {
    private static final Logger log = LoggerFactory.getLogger(TintOverlay.class);
    private final Client client;
    private final EasyArceuusRunecraftingPlugin plugin;
    private final EasyArceuusRunecraftingConfig config;

    @Inject
    private TintOverlay(Client client, EasyArceuusRunecraftingPlugin plugin, EasyArceuusRunecraftingConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.INVENTORY);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isPlayerInArea()) {
            return null;
        }
        if (this.plugin.isIdle()) {
            if (this.config.idleTint()) {
                this.tintWithColor(graphics, this.plugin.currentidleTintColor());
            }
        } else if (this.config.activeTint()) {
            this.tintWithColor(graphics, this.config.activeTintColor());
        }
        return null;
    }

    private void tintWithColor(Graphics2D graphics, Color color) {
        if (this.plugin.isDisableTintForLevel()) {
            return;
        }
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.client.getCanvasWidth(), this.client.getCanvasHeight());
    }
}

