/*
 * Decompiled with CFR 0.152.
 */
package com.foo;

import com.foo.EasyArceuusRunecraftingConfig;
import com.foo.EasyArceuusRunecraftingPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextActionOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(NextActionOverlay.class);
    private final Client client;
    private final EasyArceuusRunecraftingPlugin plugin;
    private final EasyArceuusRunecraftingConfig config;

    @Inject
    private NextActionOverlay(Client client, EasyArceuusRunecraftingPlugin plugin, EasyArceuusRunecraftingConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isPlayerInArea()) {
            return null;
        }
        switch (this.plugin.getNextOtherClick()) {
            case 1: {
                this.highlightWorldPoints(graphics, 1720, 3854, 5, 5);
                break;
            }
            case 2: {
                this.highlightWorldPoints(graphics, 1751, 3873, 5, 5);
                break;
            }
            case 3: {
                Widget runOrb = this.client.getWidget(WidgetInfo.MINIMAP_TOGGLE_RUN_ORB);
                if (runOrb == null) break;
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)runOrb.getBounds(), (Color)this.plugin.currentHighlightColor(), (Color)this.plugin.currentHighlightColor(), (Stroke)new BasicStroke());
                break;
            }
            case 4: {
                this.highlightWorldPoints(graphics, 1764, 3895, 4, 4);
                break;
            }
            case 5: {
                this.highlightWorldPoints(graphics, 1808, 3890, 4, 4);
                break;
            }
            case 6: {
                this.highlightWorldPoints(graphics, 1826, 3874, 4, 4);
                break;
            }
            default: {
                this.renderNextAction(graphics, this.plugin.getNextActionClick());
            }
        }
        return null;
    }

    private void highlightWorldPoints(Graphics2D graphics, int SWX, int SWY, int w, int h) {
        WorldPoint ploc = this.client.getLocalPlayer().getWorldLocation();
        WorldPoint origin = ploc.dx(-1 * ploc.getX()).dy(-1 * ploc.getY());
        WorldPoint SWP = origin.dx(SWX).dy(SWY);
        for (int dx = 0; dx < w; ++dx) {
            for (int dy = 0; dy < h; ++dy) {
                this.highlightWorldPoint(graphics, SWP.dx(dx).dy(dy));
            }
        }
    }

    private void highlightWorldPoint(Graphics2D graphics, WorldPoint wp) {
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)wp);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return;
        }
        Color color = this.plugin.currentHighlightColor();
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color, (Color)color, (Stroke)new BasicStroke(1.0f));
    }

    private void renderNextAction(Graphics2D graphics, TileObject tileObject) {
        if (tileObject != null && this.config.actionEnabled()) {
            Shape clickbox = tileObject.getClickbox();
            Point mousePosition = this.client.getMouseCanvasPosition();
            Color color = this.plugin.currentHighlightColor();
            OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)clickbox, (Point)mousePosition, (Color)color, (Color)color, (Color)color);
        }
    }
}

