/*
 * Decompiled with CFR 0.152.
 */
package com.foo;

import com.foo.EasyArceuusRunecraftingConfig;
import com.foo.NextActionOverlay;
import com.foo.NextItemOverlay;
import com.foo.TintOverlay;
import com.google.inject.Provides;
import java.awt.Color;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Easy Arceuus Runecrafting")
public class EasyArceuusRunecraftingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EasyArceuusRunecraftingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private EasyArceuusRunecraftingConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NextActionOverlay nextActionOverlay;
    @Inject
    private NextItemOverlay nextItemOverlay;
    @Inject
    private TintOverlay tintOverlay;
    private TileObject nextActionClick;
    private int nextItemClick;
    private int nextOtherClick;
    private Instant lastActive = Instant.now();
    private boolean playerInArea;
    private boolean inventoryFull;
    private boolean heldEssenceDense;
    private boolean heldEssenceDark;
    private boolean heldEssenceFragments;
    private boolean heldOnlyInactiveBloodEssence;
    private boolean heldMaxEssenceFragments = false;
    private boolean idle = true;
    private boolean disableTintForLevel = false;
    private static final Set<Integer> chunks = new HashSet<Integer>(Arrays.asList(6460, 6716, 6972, 7228, 6715, 6971));
    private static final int RUNESTONE_SOUTH_ID = 10796;
    private static final int RUNESTONE_NORTH_ID = 8981;
    private TileObject runestoneSouth;
    private TileObject runestoneNorth;
    private TileObject altarDark;
    private TileObject altarBlood;
    private TileObject altarSoul;
    private TileObject shortcut73;
    private TileObject shortcut69;
    private TileObject shortcut52Inner;
    private TileObject shortcut52Outer;
    private TileObject shortcut49;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.nextActionOverlay);
        this.overlayManager.add((Overlay)this.nextItemOverlay);
        this.overlayManager.add((Overlay)this.tintOverlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("easyarceuusrunecrafting")) {
            // empty if block
        }
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.nextActionOverlay);
        this.overlayManager.remove((Overlay)this.nextItemOverlay);
        this.overlayManager.remove((Overlay)this.tintOverlay);
        this.runestoneNorth = null;
        this.runestoneSouth = null;
        this.altarDark = null;
        this.altarBlood = null;
        this.altarSoul = null;
        this.shortcut73 = null;
        this.shortcut69 = null;
        this.shortcut52Outer = null;
        this.shortcut52Inner = null;
        this.shortcut49 = null;
        this.nextItemClick = -2;
        this.nextOtherClick = 0;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState gameState = event.getGameState();
        switch (gameState) {
            case LOADING: {
                this.runestoneNorth = null;
                this.runestoneSouth = null;
                this.altarDark = null;
                this.altarBlood = null;
                this.altarSoul = null;
                this.shortcut73 = null;
                this.shortcut69 = null;
                this.shortcut52Outer = null;
                this.shortcut52Inner = null;
                this.shortcut49 = null;
                this.nextActionClick = null;
                break;
            }
        }
    }

    @Provides
    EasyArceuusRunecraftingConfig provideConfig(ConfigManager configManager) {
        return (EasyArceuusRunecraftingConfig)configManager.getConfig(EasyArceuusRunecraftingConfig.class);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (!this.playerInArea) {
            return;
        }
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.INVENTORY)) {
            Item[] items = event.getItemContainer().getItems();
            if (this.client.getWidget(WidgetInfo.BANK_CONTAINER) == null) {
                boolean hasEssenceDense = false;
                boolean hasEssenceDark = false;
                boolean hasEssenceFragments = false;
                boolean hasBloodEssenceInactive = false;
                boolean hasBloodEssenceActive = false;
                boolean hasSpace = false;
                block8: for (Item i : items) {
                    switch (i.getId()) {
                        case 13445: {
                            hasEssenceDense = true;
                            continue block8;
                        }
                        case 13446: {
                            hasEssenceDark = true;
                            continue block8;
                        }
                        case 7938: {
                            hasEssenceFragments = true;
                            continue block8;
                        }
                        case 26390: {
                            hasBloodEssenceInactive = true;
                            continue block8;
                        }
                        case 26392: {
                            hasBloodEssenceActive = true;
                            continue block8;
                        }
                        case -1: {
                            hasSpace = true;
                        }
                    }
                }
                this.heldEssenceDense = hasEssenceDense;
                this.heldEssenceDark = hasEssenceDark;
                this.heldEssenceFragments = hasEssenceFragments;
                this.heldOnlyInactiveBloodEssence = hasBloodEssenceInactive && !hasBloodEssenceActive;
                boolean bl = this.inventoryFull = !hasSpace;
                if (items.length < 28) {
                    hasSpace = true;
                }
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.onTileObject(null, (TileObject)event.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.onTileObject((TileObject)event.getGameObject(), null);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.onTileObject(null, (TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.onTileObject((TileObject)event.getGroundObject(), null);
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.onTileObject(null, (TileObject)event.getWallObject());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        this.onTileObject((TileObject)event.getWallObject(), null);
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.onTileObject(null, (TileObject)event.getDecorativeObject());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        this.onTileObject((TileObject)event.getDecorativeObject(), null);
    }

    private void onTileObject(TileObject oldObject, TileObject newObject) {
        if (!this.playerInArea) {
            return;
        }
        int id = oldObject == null ? newObject.getId() : oldObject.getId();
        switch (id) {
            case 10796: {
                this.runestoneSouth = newObject;
                break;
            }
            case 8981: {
                this.runestoneNorth = newObject;
                break;
            }
            case 27979: {
                this.altarDark = newObject;
                break;
            }
            case 27978: {
                this.altarBlood = newObject;
                break;
            }
            case 27980: {
                this.altarSoul = newObject;
                break;
            }
            case 27984: {
                this.shortcut73 = newObject;
                break;
            }
            case 34741: {
                this.shortcut69 = newObject;
                break;
            }
            case 27987: {
                this.shortcut52Outer = newObject;
                break;
            }
            case 27988: {
                this.shortcut52Inner = newObject;
                break;
            }
            case 27990: {
                this.shortcut49 = newObject;
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick tick) {
        if (!this.playerInArea) {
            return;
        }
        Player localPlayer = this.client.getLocalPlayer();
        int idlePose = localPlayer.getIdlePoseAnimation();
        int pose = localPlayer.getPoseAnimation();
        int animation = localPlayer.getAnimation();
        if (animation != -1 || pose != idlePose) {
            this.lastActive = Instant.now();
            this.idle = false;
            return;
        }
        Duration alarmDelay = Duration.ofMillis(300L);
        this.idle = Instant.now().compareTo(this.lastActive.plus(alarmDelay)) >= 0;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.checkPlayerInArea()) {
            this.disableTintForLevel = this.client.getWidget(WidgetInfo.LEVEL_UP_LEVEL) != null;
            this.findNextAction();
        }
    }

    private boolean checkPlayerInArea() {
        this.playerInArea = chunks.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID());
        return this.playerInArea;
    }

    private void findNextAction() {
        boolean runEnabled;
        this.nextItemClick = -2;
        this.nextOtherClick = 0;
        this.nextActionClick = null;
        if (!this.idle) {
            return;
        }
        WorldPoint ploc = this.client.getLocalPlayer().getWorldLocation();
        boolean bl = runEnabled = this.client.getVarpValue(173) == 1;
        if (!runEnabled && this.config.suggestRun() && this.client.getEnergy() > 5000 && this.client.getWidget(WidgetInfo.MINIMAP_TOGGLE_RUN_ORB) != null) {
            this.nextOtherClick = 3;
            return;
        }
        if (this.heldOnlyInactiveBloodEssence) {
            this.nextItemClick = 26390;
            return;
        }
        if (this.inventoryFull) {
            if (this.heldEssenceDense) {
                this.nextDarkAltar(ploc);
            } else if (this.heldEssenceDark) {
                if (this.heldEssenceFragments) {
                    this.nextRuneAltar(ploc);
                } else {
                    this.nextChiseling();
                }
            }
        } else if (this.heldEssenceDark) {
            if (this.heldMaxEssenceFragments) {
                this.nextRuneAltar(ploc);
            } else {
                this.nextChiseling();
            }
        } else if (this.heldEssenceFragments && this.playerNearbyTo(ploc, this.altarChosen(), 15)) {
            this.nextActionClick = this.altarChosen();
        } else {
            this.nextMining(ploc);
        }
    }

    private TileObject altarChosen() {
        if (this.config.whichRunes().isBlood()) {
            return this.altarBlood;
        }
        return this.altarSoul;
    }

    private boolean playerNearbyTo(WorldPoint ploc, TileObject object, int maxDistance) {
        if (object == null) {
            return false;
        }
        return ploc.distanceTo(object.getWorldLocation()) <= maxDistance;
    }

    private void nextChiseling() {
        Widget selected = this.client.getSelectedWidget();
        int id = selected == null ? 0 : selected.getItemId();
        switch (id) {
            case 1755: {
                this.nextItemClick = 13446;
                break;
            }
            default: {
                this.nextItemClick = 1755;
            }
        }
    }

    private void nextDarkAltar(WorldPoint ploc) {
        if (ploc.getX() < 1753 && ploc.getY() > 3867 || ploc.getX() < 1770 && ploc.getY() > 3872) {
            this.nextActionClick = this.altarDark;
        } else if (this.client.getBoostedSkillLevel(Skill.AGILITY) >= 69) {
            this.nextActionClick = this.shortcut69;
        } else if (this.client.getBoostedSkillLevel(Skill.AGILITY) >= 52 && ploc.getX() < 1770) {
            this.nextActionClick = this.shortcut52Inner;
        } else {
            this.nextOtherClick = 2;
        }
    }

    private void nextRuneAltar(WorldPoint ploc) {
        if (this.config.whichRunes().isBlood()) {
            if ((ploc.getX() < 1720 || ploc.getY() > 3867) && ploc.getY() >= 3836) {
                this.nextOtherClick = 1;
            } else {
                this.nextActionClick = this.altarBlood;
            }
        } else {
            this.nextActionClick = this.altarSoul;
        }
    }

    private void nextMining(WorldPoint ploc) {
        if (ploc.getX() < 1743 && ploc.getY() < 3860) {
            if (this.client.getBoostedSkillLevel(Skill.AGILITY) >= 73) {
                this.nextActionClick = this.shortcut73;
            } else {
                this.nextOtherClick = 2;
            }
        } else if (ploc.getX() > 1789 || ploc.getY() > 3883) {
            this.nextActionClick = this.shortcut49;
        } else if (ploc.getX() < 1753 && ploc.getY() > 3867 || ploc.getX() < 1768 && ploc.getY() > 3872) {
            if (ploc.getX() < 1740) {
                this.nextOtherClick = 2;
            } else if (this.client.getBoostedSkillLevel(Skill.AGILITY) >= 69) {
                this.nextActionClick = this.shortcut69;
            } else if (this.client.getBoostedSkillLevel(Skill.AGILITY) >= 52) {
                this.nextActionClick = this.shortcut52Outer;
            } else {
                this.chooseRunestone(ploc);
            }
        } else {
            this.chooseRunestone(ploc);
        }
    }

    private void chooseRunestone(WorldPoint ploc) {
        boolean runestoneSouthDense;
        boolean runestoneNorthDense = this.client.getVarbitValue(4927) == 0;
        boolean bl = runestoneSouthDense = this.client.getVarbitValue(4928) == 0;
        if (runestoneNorthDense && runestoneSouthDense) {
            this.nextActionClick = this.playerNearbyTo(ploc, this.runestoneNorth, 4) ? this.runestoneNorth : this.runestoneSouth;
        } else if (runestoneSouthDense) {
            this.nextActionClick = this.runestoneSouth;
        } else if (runestoneNorthDense) {
            this.nextActionClick = this.runestoneNorth;
        }
    }

    public Color currentHighlightColor() {
        int ms_in_cycle;
        if (this.config.actionFlash() && (ms_in_cycle = (int)(System.currentTimeMillis() % (long)(this.config.actionColor1Time() + this.config.actionColor2Time()))) >= this.config.actionColor1Time()) {
            return this.config.actionColor2();
        }
        return this.config.actionColor();
    }

    public Color currentidleTintColor() {
        int ms_in_cycle;
        if (this.config.idleTintFlash() && (ms_in_cycle = (int)(System.currentTimeMillis() % (long)(this.config.idleTintColor1Time() + this.config.idleTintColor2Time()))) >= this.config.idleTintColor1Time()) {
            return this.config.idleTintColor2();
        }
        return this.config.idleTintColor();
    }

    TileObject getNextActionClick() {
        return this.nextActionClick;
    }

    int getNextItemClick() {
        return this.nextItemClick;
    }

    int getNextOtherClick() {
        return this.nextOtherClick;
    }

    boolean isPlayerInArea() {
        return this.playerInArea;
    }

    boolean isIdle() {
        return this.idle;
    }

    boolean isDisableTintForLevel() {
        return this.disableTintForLevel;
    }
}

